<%
/*
 *	Name				:	EgAddUDTestJson.jsp
 *	Purpose				:	IC - Test - Add New Test
 *	CreationDate		:	01/10/2001
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.TestBean" %>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray "%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	JSONObject hiddens = new JSONObject();
	rootJSON.put("success","true");

	boolean isDouble=EgDbInfo.doubleByteEnabled;
	//skm
	String[] testTypes = EgAggregateInfo.allowedTestTypes();
	EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
	String[] strTests = threshConfig.getAllTests();
	List listOfTests = Arrays.asList(strTests);
	Collections.sort(listOfTests);
	//skm
	String typeValue = request.getParameter("typeValue");
	String test = request.getParameter("test");
	String testType = request.getParameter("testtype");
	String port = request.getParameter("port");
	String type = request.getParameter("type");
	String added = request.getParameter("added");

	String testname = request.getParameter("testname"); //skm

	String[] dbTypes = new String[]{"Oracle","MsSql","Sybase","MySql","PostGres","DB2","SAP HANA","MariaDB"};
	JSONArray dbTypesArr = new JSONArray();
	JSONObject obj = new JSONObject();
	for (int d=0; d<dbTypes.length; d++)
	{
		obj = new JSONObject();
		String tmp = "admin.ic."+dbTypes[d];
		obj.put("displayField",_mapping.getTextDescription(tmp));
		obj.put("valueField",dbTypes[d]);
		dbTypesArr.add(obj);
	}
	rootJSON.put("dbTypes",dbTypesArr);
	rootJSON.put("dbTypeSelected",dbTypes[0]);

	test = (test != null)?test:"";
	testname = (testname != null)?testname:"";

	String portBased = "No";
	String isInternal = "";
	String isExternal = "";
	String isPortBased = "";
	String isNoPortBased = "";

	/* when test type is aggregate, test should be port based and NULL*/
	/* code starts */
	String hideNo = request.getParameter("hideNo");
	hideNo = hideNo != null && hideNo.equals("Yes")? "disabled":"dontdisable";
	/* code ends */
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(test == null)
		test = "";
	if(port == null)
	{
		isPortBased = "checked";
	}
	else if(port.equals("Yes"))
	{
		portBased = "Yes";
		isPortBased = "checked";
		isNoPortBased = "";
	}
	else
	{
		isNoPortBased = "checked";
		portBased = "No";
	}

	if(type == null || type.equals("Internal"))
		isInternal = "checked";
	else if(type.equals("External"))
		isExternal = "checked";

	
	String [] tmpTestTypes = new String[testTypes.length];
	for(int i=0; i<testTypes.length; i++)
		if(testTypes[i].equals(testType))
			tmpTestTypes[i] = "selected";
		else
			tmpTestTypes[i] = "";

	JSONArray testTypeList = new JSONArray();
	for(int i=0; i<testTypes.length; i++)
	{
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic."+testTypes[i]));
		obj.put("valueField",testTypes[i]);
		testTypeList.add(obj);
		if (tmpTestTypes[i].equals("selected"))
		{
			rootJSON.put("testTypeSelected",testTypes[i]);
		}
	}
	rootJSON.put("testTypes",testTypeList);

	JSONArray typeList = new JSONArray();
	JSONObject typeObj = new JSONObject();
	typeObj.put("displayField",_mapping.getTextDescription("admin.ic.Performance"));
	typeObj.put("valueField","Performance");
	typeList.add(typeObj);
	typeObj.put("displayField",_mapping.getTextDescription("admin.ic.Configuration"));
	typeObj.put("valueField","Configuration");
	typeList.add(typeObj);
	rootJSON.put("types",typeList);
	rootJSON.put("typeSelected","Performance");


	if (testType == null || testType.trim().equals(""))
	{
		rootJSON.put("testTypeSelected",testTypes[0]);
	}
	
	//skm
	String [] tmpTestNames = new String[strTests.length];
	for(int i=0; i<strTests.length; i++)
		if(strTests[i].equals(testname))
			tmpTestNames[i] = "selected";
		else
			tmpTestNames[i] = "";
	//skm
	
	TestBean testBean = new TestBean();
	String dbType = testBean.getDbType(test);

	ArrayList tests = testBean.getUDTests();

	//Check whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJSON.put("isConfigSupported",isConfigSupported);

	ArrayList aListTests = testBean.getNonDupUDTests();

	String strDuplicateTest = request.getParameter("duplicateTest");
	String strDupYes = "";
	String strDupNo = "";
	if (strDuplicateTest == null || strDuplicateTest.equals("") || strDuplicateTest.equals("false"))
	{
		strDupNo = "checked";
	}
	else
	{
		strDupYes = "checked";
	}

	String strTestToBeDuplicated = request.getParameter("testToBeDuplicated");
	if (strTestToBeDuplicated == null || strTestToBeDuplicated.equals("-1"))
	{
		strTestToBeDuplicated = "";
	}

	String tempTestType = "";
	if (strTestToBeDuplicated.length() > 0)
	{
		tempTestType = testBean.getTestType(strTestToBeDuplicated);
	}

	rootJSON.put("showTestAddPage",false);
	rootJSON.put("showParamAddPage",false);
	if(added == null || added.length() == 0)
	{
		rootJSON.put("showTestAddPage",true);
		rootJSON.put("test",test);

		rootJSON.put("showDuplicate",false);
		rootJSON.put("duplicateYes",false);
		rootJSON.put("duplicateNo",false);
		if (tests != null && tests.size() > 0)
		{
			rootJSON.put("showDuplicate",true);
			if (strDupYes.equals("checked"))
			rootJSON.put("duplicateYes",true);
			else if(strDupNo.equals("checked"))
			rootJSON.put("duplicateNo",true);
		}

		if (aListTests != null && aListTests.size() > 0)
		{
			IniFile iniUdtests = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_udtests.ini");

			JSONArray dupTestList = new JSONArray();
			obj = new JSONObject();
			obj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test"));
			obj.put("valueField","-1");
			dupTestList.add(obj);
			rootJSON.put("selectedDupeTest","-1");
			for(int i=0; i<aListTests.size(); i++)
			{
				String strTest = (String)aListTests.get(i);
				String typeValue1 = iniUdtests.getValue("TEST_TYPE",strTest);
				obj = new JSONObject();
				obj.put("displayField",strTest);
				obj.put("valueField",strTest);
				if (strTest.equals(strTestToBeDuplicated))
				{
					rootJSON.put("selectedDupeTest",strTest);
				}
				if(typeValue1.equalsIgnoreCase(testType))
				{
					dupTestList.add(obj);
				}
			}
			rootJSON.put("dupTestList",dupTestList);
			rootJSON.put("testTypeAsLabel",false);
			if (strTestToBeDuplicated.length() > 0)
			{
				rootJSON.put("testTypeAsLabel",true);
				rootJSON.put("testType",tempTestType);
			}
		}
		else
		{
			rootJSON.put("showExecution",true);
			rootJSON.put("internalSelected",false);
			rootJSON.put("externalSelected",false);
			if (isInternal.equals("checked"))
			{
				rootJSON.put("internalSelected",true);
			}
			else if(isExternal.equals("checked"))
			{
				rootJSON.put("externalSelected",true);
			}
			rootJSON.put("showPort",true);
			rootJSON.put("portYesSelected",false);
			rootJSON.put("portNoSelected",false);
			if (isPortBased.equals("checked"))
			{
				rootJSON.put("portYesSelected",true);
			}
			else if(isNoPortBased.equals("checked"))
			{
				rootJSON.put("portNoSelected",true);
			}
			rootJSON.put("showOSType",false);
			rootJSON.put("showDBType",false);
			if(testType != null && testType.equals("Script/Batch File")) 
			{
				rootJSON.put("showOSType",true);
			}
			else if(testType != null && testType.equalsIgnoreCase("Sql Query"))
			{
				rootJSON.put("showDBType",true);
			}
		}
	}
	else
	{
		rootJSON.put("showParamAddPage",true);
		rootJSON.put("test",test);
		rootJSON.put("testType",testType);
		rootJSON.put("execution",type);
		rootJSON.put("portBased",portBased);
		rootJSON.put("type",typeValue);
	}
	hiddens.put("add","test");
	if(test != null)
	{
		Hashtable ht = testBean.getTestParam(test);
		boolean isSnmp  = (testBean.getTestType(test)).equals("Snmp")?true:false;
		String value="";
		if(ht != null || ht.size() != 0)
		{  
			Enumeration enum1 = ht.keys();
			Vector veckey = new Vector();
			Vector vecvalue = new Vector();;
			int count = 0;
			boolean pipeflag=false;
			while(enum1.hasMoreElements())
			{
				veckey = (Vector) enum1.nextElement();
				vecvalue = (Vector) ht.get(veckey);
			}
			JSONArray paramList = new JSONArray();
			for(int i=0;i<vecvalue.size();i++)
			{
				value=(String)vecvalue.get(i);
				if(value.indexOf("|")!=-1)// modified to read # as ,
				{ 
					value=StringUtils.replace(value, '|', ',');
					count++;
				}
				if (isSnmp && !(veckey.get(i).equals("snmpPort") || veckey.get(i).equals("snmpCommunity") || veckey.get(i).equals("snmpversion")))
				{
					continue;
				}
				obj = new JSONObject();
				obj.put("paramName",veckey.get(i).toString());
				obj.put("paramValue",value);
				String modifyURL = "EgModifyParamsJson.jsp?test="+test+"&testtype="+testType+"&param="+veckey.get(i).toString()+"&value="+value;
				obj.put("modifyURL",modifyURL);
				
				if(testType != null)
				{
					String tmpParam = (String)veckey.get(i);
					if(testType.equalsIgnoreCase("Snmp"))
					{
						obj.put("hideDelete",true);
					}
					else if(testType.equalsIgnoreCase("JMX") && (tmpParam.equals("Jmx_Remote_Port") || tmpParam.equals("Jndi_Name") || tmpParam.equals("user") || tmpParam.equals("password")))
					{
						obj.put("hideDelete",true);
					}
					else if(testType.equalsIgnoreCase("SQL Query") && (tmpParam.equals("user") || tmpParam.equals("password") || tmpParam.equals("dbhost") || tmpParam.equals("dbport")))
					{
						obj.put("hideDelete",true);
					}
					else
					{
						obj.put("hideDelete",false);
						String deleteURL = "EgconfigtestparampJson.jsp?mod=delParam&test="+test+"&param="+tmpParam+"&dbtype="+dbType +"&testtype="+testType;
						obj.put("deleteURL",deleteURL);
					}
				}
				
				/*if(testType != null && (!testType.equalsIgnoreCase("Snmp") && (!veckey.get(i).equals("Jmx_Remote_Port") && !veckey.get(i).equals("Jndi_Name") && !veckey.get(i).equals("user") && !veckey.get(i).equals("password") && !veckey.get(i).equals("dbhost") && !veckey.get(i).equals("dbport")&& !veckey.get(i).equals("Charset"))))
				{
					 obj.put("hideDelete",false);
					 String deleteURL = "EgconfigtestparampJson.jsp?mod=delParam&test="+test+"&param="+veckey.get(i).toString()+"&dbtype="+dbType +"&testtype="+testType;
					 obj.put("deleteURL",deleteURL);
				}
				else
				{
					 obj.put("hideDelete",true);
				}*/
				paramList.add(obj);
			}
			rootJSON.put("paramList",paramList);
		}
	}

	String s_added = request.getParameter("added");
	rootJSON.put("showNewTetsParams",false);
	if(s_added != null && s_added.equals("done"))	
	{
		if(testType != null && !testType.equalsIgnoreCase("Snmp"))
		{
			rootJSON.put("showNewTetsParams",true);
			hiddens.put("add","param");
			hiddens.put("test",test);
			hiddens.put("port",port);
			hiddens.put("type",type);
			hiddens.put("testtype",testType);
			hiddens.put("dbType",dbType);
		}
	}
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>
<%
//	if(request.getQueryString()!=null)
//	session.setAttribute("adminLastAccessedURL","/final/admin/EgAddUDTest.jsp?"+request.getQueryString());
//	else session.setAttribute("adminLastAccessedURL","/final/admin/EgAddUDTest.jsp");
%>