<%
/**
 *	File name       :	EgconfigextagentspJson.jsp
 *	Purpose         :	Process page for EgConfigExtAgentsJson.jsp
 */
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.IniHelper" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.UnmanagedAgentsInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.admin.ExternalAgent"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="trans1" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="servicer" scope="page" class="egurkha.ServiceBean"/>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	List v_eghosts = new Vector();
	List v_newagenthosts = new Vector();
	List v_eagent_hosts = new Vector();
	StringTokenizer str_token = null;
	boolean b_setvalue = false;
	boolean b_check = true;
	EgExternalInfo externalInfo = new EgExternalInfo("manager");

	String s_eghosts = request.getParameter("fmanage");
	String existingAgents = request.getParameter("existingAgents");
	String s_newagenthosts = request.getParameter("funmanage");
	String s_eagent = request.getParameter("eagent");

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","External Agent Configuration");
	auditLogThread.setValue("Activity","Assign External Agents");

	ArrayList lostComponentsList = null;
	String lostComponents[] = null;
	lostComponents = StringUtils.getTokens(s_eghosts,",");
	if(lostComponents != null && lostComponents.length>0)
		lostComponentsList = new ArrayList(Arrays.asList(lostComponents));	
	else
		lostComponentsList = new ArrayList();

	ArrayList lostList = new ArrayList();
	for (int r=0; r<lostComponentsList.size(); r++)
	{
		String me = (String) lostComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!lostList.contains(me))
			lostList.add(me);
	}

	ArrayList newList = new ArrayList();
	ArrayList newlyAddedComponentsList = null;
	String newlyAddedComponents[] = null;
	newlyAddedComponents = StringUtils.getTokens(s_newagenthosts,",");
	if(newlyAddedComponents != null && newlyAddedComponents.length>0)
		newlyAddedComponentsList = new ArrayList(Arrays.asList(newlyAddedComponents));	
	else
		newlyAddedComponentsList = new ArrayList();
	for (int r=0; r<newlyAddedComponentsList.size(); r++)
	{
		String me = (String) newlyAddedComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!newList.contains(me))
			newList.add(me);
	}
	/*
	 *	To prevent all external agents from being disassociated for a component.
	 *	New Variables to incorporate the changes !!!
	 */
	List v_tmp = new Vector();

	if(s_eghosts != null && !s_eghosts.equals(""))
	{
		String[] tokens = StringUtils.getTokens(s_eghosts, EgConstants.COMMA);
		v_eghosts.addAll(Arrays.asList(tokens));
	}

	if(s_newagenthosts != null && !s_newagenthosts.equals(""))
	{
		String[] tokens = StringUtils.getTokens(s_newagenthosts, EgConstants.COMMA);
		v_newagenthosts.addAll(Arrays.asList(tokens));
	}

	ArrayList aggCompNick = new ArrayList();
	Vector aggTypes = new EgAggregateInfo("manager").getAggregateTypes();
	if(aggTypes != null)
	{
		EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
		for(int j=0;j<aggTypes.size();j++)
		{
			String[] aggComps = egDiscInfo.getAllServersOfType((String)aggTypes.get(j));
			if(aggComps !=null)
			{
				for(int i=0;i<aggComps.length;i++)
				{
					String aggregateComponent = aggComps[i];
					String aggregateComponentNick=aggregateComponent.substring(0,aggregateComponent.lastIndexOf(":"));
					int colonIdx = aggregateComponentNick.indexOf(":");
					String aggregatecomponentType = aggregateComponentNick.substring(0,colonIdx);
					aggregateComponentNick = aggregateComponentNick.substring(colonIdx+1);
					if(!aggCompNick.contains(aggregateComponentNick))
					{
						aggCompNick.add(aggregateComponentNick);
					}
				}
			}
		}
	}

	//trans.createFile("eg_external.ini","save");
	//trans1.createFile("eg_testinfo.ini","save");
	trans.createSyncFile("eg_external.ini","save");
	trans1.createSyncFile("eg_testinfo.ini","save");
	boolean transSave = false;
	boolean trans1Save = false;
	String[] s_eagent_hosts = trans.getVariables("Test_Mapping_Section");
	v_eagent_hosts.addAll(Arrays.asList(s_eagent_hosts));

	/*
	 *	Adding new hosts to the external agent.
	 */
	for(int j=0;j < v_newagenthosts.size();j++)
	{
		String s_tmp = (String)v_newagenthosts.get(j);
		if(v_eagent_hosts.indexOf(s_tmp) > -1)
		{
			String s_val = trans.getStrValue("Test_Mapping_Section", s_tmp);
			str_token = new StringTokenizer(s_val, EgConstants.COMMA);
			while(str_token.hasMoreTokens())
			{
				String str_tmp = str_token.nextToken().trim();
				String[] disablesInfos=trans1.getVariables(str_tmp);
				for (int l=0;l<disablesInfos.length;l++)
				{
					String disInfo=disablesInfos[l];
					if (disInfo.indexOf(":"+s_tmp+"#")>-1  || disInfo.indexOf(":"+s_tmp+":") >-1)
					{
						
						String value=trans1.getStrValue(str_tmp, disInfo);
						trans1.setValue(s_eagent,disInfo,value);
						trans1Save = true;
					}
					//trans.setValue("Test_Mapping_Section",s_tmp,s_val);
				}
			}
			if (s_val.indexOf(EgConstants.COMMA) > -1
				&& (s_val.indexOf(s_eagent+EgConstants.COMMA) > -1
					|| s_val.startsWith(s_eagent+EgConstants.COMMA)
					|| s_val.endsWith(s_eagent)))
			{
				continue;
			}
			else if(s_val.equals(s_eagent))
			{
				continue;
			}
			else
			{
				if(aggCompNick.contains(s_tmp))
				{
					s_val = s_eagent;
				}
				else
				{
					s_val = s_val + EgConstants.COMMA + s_eagent;
				}
				b_setvalue = trans.setValue("Test_Mapping_Section",s_tmp,s_val);
				transSave = true;
			}
		}
		else
		{

			b_setvalue = trans.setValue("Test_Mapping_Section",s_tmp,s_eagent);
			transSave = true;
		}
	}

	/*
	 *	Removing  existing  hosts from  the external agent.
	 */
	for(int j=0;j < v_eghosts.size();j++)
	{
		String s_new_val = "";
		String s_tmp = (String)v_eghosts.get(j);
		
		if (v_eagent_hosts.indexOf(s_tmp) > -1)
		{
			String s_val = trans.getStrValue("Test_Mapping_Section", s_tmp);
			String str_tmp = "";
			str_token = new StringTokenizer(s_val, EgConstants.COMMA);
			while(str_token.hasMoreTokens())
			{
				str_tmp = str_token.nextToken().trim();
				String[] disablesInfos=trans1.getVariables(s_eagent);
				for (int l=0;l<disablesInfos.length;l++)
				{
					String disInfo=disablesInfos[l];
					if (disInfo.indexOf(":"+s_tmp+"#")>-1  || disInfo.indexOf(":"+s_tmp+":") >-1)
					{
						trans1.deleteSpecValue(s_eagent,disInfo);
						trans1Save = true;
					}
				}
				if(str_tmp.equals(s_eagent))
				{
					if(s_val.indexOf(EgConstants.COMMA) > -1)
					{
						StringTokenizer str1_token = new StringTokenizer(s_val,EgConstants.COMMA);
						while(str1_token.hasMoreTokens())
						{
							String str_temp = str1_token.nextToken();
							if(s_eagent.equals(str_temp))
							{
								continue;
							}
							else
							{
								s_new_val = s_new_val + EgConstants.COMMA +  str_temp;
							}
						}

						if(s_new_val.startsWith(EgConstants.COMMA))
						{
							s_new_val = s_new_val.substring(1);
						}

						trans.setValue("Test_Mapping_Section", s_tmp, s_new_val);
						transSave = true;
					}
					else
					{
						b_check = false;
						v_tmp.add(v_eghosts.get(j));
					}
				}
			}
		}
		else
		{
			continue;
		}
	}

	if (transSave)
	{
		trans.saveFile();
	}
	if (trans1Save)
	{
		trans1.saveFile();
	}
	trans.releaseInstance();
	trans1.releaseInstance();

	if(v_tmp.size() == 0)
	{
		IniFile agentsIniW = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		List iniEntries  = new ArrayList();
		for (int a=0;a < v_newagenthosts.size(); a++)
		{
			String hostName = (String)v_newagenthosts.get(a);
			// Fix starts to retain the test configuration details while changing the external agent
			String[] extisingAgentsList = externalInfo.getExternalAgentsForHost(hostName);
			String anyOneExternalAgent = extisingAgentsList[0];
			String[] vars = agentsIniW.getVariables(anyOneExternalAgent);
			for (int b=0; b < vars.length; b++)
			{
				String variable = vars[b];
				if (variable.indexOf(":"+hostName+":") > -1 || variable.endsWith(":"+hostName))
				{
					String value = agentsIniW.getValue(anyOneExternalAgent,variable);
					if (value.startsWith("-manual"))
					{
						iniEntries.add(new IniHelper(s_eagent,variable,value));
					}
				}
			}
			// Fix ends
		}
		if (iniEntries.size() > 0)
		{
			//IniFile agentsIniW = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
			//IniFile agentsIniW = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
			for(int i=0; i < iniEntries.size(); i++)
			{
				IniHelper iniHlpr = (IniHelper)iniEntries.get(i);
				String sub = iniHlpr.getSubject();
				String var = iniHlpr.getVariable();
				String val = iniHlpr.getValue();
				agentsIniW.setValue(sub,var,val);
			}
			agentsIniW.saveFile();
			//EgConfigFilesSync.releaseInstance(agentsIniW);
		}
		EgConfigFilesSync.releaseInstance(agentsIniW);	
		//trans.saveFile();
		//trans1.saveFile();

		UpdateAndTransmitTrendInfo trendInfo = new UpdateAndTransmitTrendInfo();
		Vector param = new Vector();
		param.add("Egconfigextagentsp");
		param.add(s_eagent);
		param.add(v_eghosts);
		trendInfo.removeAgentForTarget(param);

		boolean done = false;
		boolean isAssociated = false;
		boolean isDisassociated = false;
		if (lostList.size() > 0)
		{
			for (int i=0; i<lostList.size(); i++)
			{ 
				String me = (String) lostList.get(i);
				if (v_tmp.contains(me))
					continue;
				auditLogThread.setCurrentValue("Disassociated Host(s)",me);
				done = true;
				isDisassociated = true;
			}
		}
		if (newList.size() > 0)
		{
			isAssociated = true;
			//ErUserData erUser;
			for (int i=0; i<newList.size(); i++)
			{ 
				//erUser = new ErUserData(orgUser,false);
				auditLogThread.setCurrentValue("Associated Host(s)",(String)newList.get(i));
				done = true;
			}
		}

		if(isAssociated && isDisassociated)
			auditLogThread.setValue("Description","Hosts have been associated and disassociated for external agent " + s_eagent);
		else if(isAssociated)
			auditLogThread.setValue("Description","Hosts have been associated for external agent " + s_eagent);
		else if(isDisassociated)
			auditLogThread.setValue("Description","Hosts have been disassociated from external agent " + s_eagent);

		if (done)
			auditLogThread.sendItToDB();
		/* code for auditlog ends */

		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		servicer.stopDiscovery();
		servicer.startDiscovery("1");
		EgConfigFilesSync.releaseInstance(infraIni);

		rootJson.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.test.ASSIGN - EXTERNAL AGENTS"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.test.The external agent")+" "+"'"+s_eagent+"'"+" "+_mapping.getTextDescription("admin.test.has been assigned successfully")+".");
		rootJson.put("result",resultMsg);

		UnmanagedAgentsInfo unmanagedagent = new UnmanagedAgentsInfo();
		String eagentIp = externalInfo.getIpForAgent(s_eagent);
		unmanagedagent.updateAgentDetail(eagentIp);

		//adding external agent to the sub-org and users
		if (isAssociated)
		{
			EgUuidInfo uuidInfo = new EgUuidInfo();
			ExternalAgent externalAgent = new ExternalAgent();
			EgUserElementsInfo elemInfo = new EgUserElementsInfo();
			EgCertUsage certUsage = new EgCertUsage();
			String user_id = _user.getLoginID();
			String superOrgName = (!uuidInfo.isSuperOrg(user_id)) ? uuidInfo.getSuperOU(user_id) : user_id;
			String eg_uuid = EgConfigInfo.egMgrConfigDir + "eg_uuid.ini";
			IniFile uuidIniObj = new IniFile(eg_uuid);
			ArrayList limAdminUsersList = certUsage.getAllLimitedCompAccessUsers(true);
			ArrayList defOrgDefUsersList = User.getDefaultUsers();
			TreeSet allSubOrgsAndUsers = uuidInfo.getAllUsersUnderOrg(superOrgName);
			allSubOrgsAndUsers.removeAll(defOrgDefUsersList);
			ErUserData erUser;
			if (allSubOrgsAndUsers != null)
			{
				Iterator itr = allSubOrgsAndUsers.iterator();
				while (itr.hasNext())
				{
					String orgUser = (String)itr.next();
					if (!limAdminUsersList.contains(orgUser))
					{
						continue;
					}
					erUser = new ErUserData(orgUser,false);
					Vector nickList = erUser.getAllUserComponents(1);
					if (checkContainsAnyNicks(nickList,newList))
					{
						//have to check whether it has this ext or not
						ArrayList userExtAgnts = elemInfo.getExternalAgentsForUser(orgUser);
						if (userExtAgnts.contains(s_eagent))//if present then skip otherwise add to the user_elements table for the sub-org
						{
							continue;
						}
						if (externalAgent.checkLicenseForExtAgent(orgUser,s_eagent))
						{
							elemInfo.updateUserElements(orgUser,"ExternalAgent",s_eagent);
						}
					}
				}
			}
		}
	}
	else
	{
		Vector sess_vec = new Vector();
		
		Vector compVal = new Vector();
		for (int k=0; k<v_tmp.size(); k++)
		{
			String agents = (String)v_tmp.get(k);			
			compVal.add(agents);
			String seperator = ",";
			if(k+1 == v_tmp.size())  seperator = "";
			sess_vec.addElement(agents+seperator);
		}

		String sess_vecStr = compVal.toString();
		sess_vecStr = sess_vecStr.substring(1,sess_vecStr.length()-1);

		rootJson.put("requestStatus","failed");
		JSONObject errorMsg = new JSONObject();
		errorMsg.put("title",_mapping.getTextDescription("admin.common.External Agents Configuration"));
		errorMsg.put("message1",_mapping.getTextDescription("admin.common.The following host(s) should be associated with atleast one external agent")+".'"+sess_vecStr+"'");
		rootJson.put("error",errorMsg);
	}
	rootJson.put("success","true");
	//System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
%>

<%!
	public boolean checkContainsAnyNicks(Vector nickList, ArrayList newList)
	{
		boolean result = false;
		if (nickList == null || newList == null)
		{
			return result;
		}
		nickList = getRefinedNicks(nickList);
		for (int i=0; i<newList.size(); i++)
		{
			String agentNick = newList.get(i).toString().trim();
			if (!nickList.contains(agentNick))
			{
				continue;
			}
			else
			{
				result = true;
				break;
			}
		}
		return result;
	}

	public Vector getRefinedNicks(Vector nickList)
	{
		Vector result = new Vector();
		if(nickList != null)
		{
			for(int n=0; n<nickList.size(); n++)
			{
				String nickName = (String)nickList.get(n);
				int pos = nickName.indexOf(":");
				if(pos > 0)
				{
					nickName = nickName.substring(0,pos);
				}
				if(!result.contains(nickName))
				{
					result.add(nickName);
				}
			}
		}
		return result;
	}
%>



