<%
/*******************************************************************************
*	Name			:EgUserReportsJSON.jsp
*	Purpose			:JSON page to handle default reports
*	Version			:6.0
*	CreationDate	:27/06/2013
*	Author			:Abdul Khader M
*******************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "egurkha.ConfigSiteBean" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	JSONObject testExistsJson = new JSONObject();
	JSONObject rootAppJson = new JSONObject();
	JSONObject rootSummaryJson = new JSONObject();
	JSONObject measuresJson = new JSONObject();
	JSONObject buttonJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONArray usersArrayJson = new JSONArray();
	JSONArray compTypeArrayJson = new JSONArray();
	JSONArray compArrayJson = new JSONArray();
	JSONArray reportTypesJson = new JSONArray();
	JSONArray testsArrayJson = new JSONArray();
	JSONArray serverTestsArrayJson = new JSONArray();
	JSONArray siteTestsArrayJson = new JSONArray();
	JSONArray descriptorsArrayJson = new JSONArray();
	JSONArray allMeasuresArrayJson = new JSONArray();
	JSONArray assocMeasuresArrayJson = new JSONArray();
	JSONArray disAssocMeasuresArrayJson = new JSONArray();
	JSONArray allRealMeasuresArrayJson = new JSONArray();
	JSONArray assocRealMeasuresArrayJson = new JSONArray();
	JSONArray disAssocRealMeasuresArrayJson = new JSONArray();
	JSONArray assocInfoArrayJson = new JSONArray();
	JSONArray disAssocInfoArrayJson = new JSONArray();
	JSONArray summaryArrayJson = new JSONArray();
	JSONArray applyToSummaryJson = new JSONArray();
	JSONArray mappedTestNameArray = new JSONArray();

	JSONArray selectedUser = new JSONArray();
	JSONArray testSelected = new JSONArray();
	JSONArray serverTestSelected = new JSONArray();
	JSONArray reportTypeSelected = new JSONArray();
	JSONArray compTypeSelected = new JSONArray();
	JSONArray compSelected = new JSONArray();
	JSONArray siteSelected = new JSONArray();

	ConfigSiteBean SiteBean = new ConfigSiteBean();
%>
<%
	String colon=":";
	if(SiteBean.rcat())
	{
		UserRegistry registry1 = UserRegistry.getInstance();
		User user = registry1.getUser(session.getId());
		IniUI iniUI = IniUI.getInstance();

		//user language
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);

		EgThresholdInfo et = new EgThresholdInfo("manager");
		EgReportInfo rep = new EgReportInfo("manager");
		EgConfigInfo econ= new EgConfigInfo("manager");
		EgDiscInfo ed = new EgDiscInfo("manager");
		EgSpecsInfo espec = new EgSpecsInfo("manager");
		EgTesterInfo testerInfo=new EgTesterInfo("manager");
		//ErUserData erdata = new ErUserData("supermonitor",true);

		ErInfo erinfo = new ErInfo();
		String fname = econ.getReportConfigFile();
		IniFile irep = new IniFile(fname);
		String tests[];
		String dmeasures[];
		String infos[];
		String testName="";
		String cattype = "";
		String cattypeT = "";
		String secType ="";
		String graphType = "";
		String comType = "";
		String comName="";
		String siteType="";
		String userType="";
		String serverTests[];

		ErUserData erdata =null;

		ArrayList a_infos = new ArrayList();
		Vector v;

		String testselect="";
		String mselect="";
		String sselect="";
		String serverselect="";
		String comselect = "";

		boolean serverlist=false;
		boolean sitelist = false;
		String serverType="";
		String previousAssociatedMeasures = null;
%>
<%
		IniFile userMappingIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
		if(request.getParameter("catType")!=null)
			cattype=request.getParameter("catType");
		if(request.getParameter("graphType")!=null)
			graphType=request.getParameter("graphType");
		if(request.getParameter("secType")!=null)
			secType =request.getParameter("secType");
		if(request.getParameter("tname")!=null)
			testName = request.getParameter("tname");

		if(request.getParameter("serverType")!=null)
			serverType = request.getParameter("serverType");
		if(request.getParameter("comType")!=null)
			comType = request.getParameter("comType");
		if(request.getParameter("comName")!=null)
			comName = request.getParameter("comName");
		if(request.getParameter("siteType")!=null)
			siteType = request.getParameter("siteType");
		if(request.getParameter("userType")!=null)
			userType = request.getParameter("userType");

		String test_name = "";
		test_name = _mapping.getTestDescription(testName);
		String secTypeI="";
		String cattypeVar = "";
		String graphTypeI="";
		if(request.getParameter("graphTypeI")!=null)
			graphTypeI = request.getParameter("graphTypeI");
		if(cattype != null)
		{
			if(graphTypeI !=null && graphTypeI != "")
			{
				cattypeVar = cattype+":"+graphTypeI;
			}
			else
			{
				if(cattype.startsWith("Application"))
				{
					if(graphType !=null && graphType !="" && serverType!=null && serverType !="" && userType!=null)
						cattypeVar = cattype+":"+serverType+":"+graphType+":"+userType;
				}
				else if(cattype.startsWith("Site"))
				{
					if(graphType !=null && graphType !="" && userType !=null && userType !="")
						cattypeVar = cattype+":"+graphType+":"+userType;
				}
				else
				{
					if(graphType !=null && graphType !="" && userType!=null && userType !="")
					{
						cattypeVar = cattype+":"+graphType+":"+userType;
					}
				}
			}
		}

		//Getting values from and displaying in the category order
		if(secType != null && secType !="")
		secTypeI=secType.toUpperCase()+"_REPORTS";

		Vector avar=new Vector();

		if(cattype != null)
		{
			String var[]=irep.getVariables(secTypeI);
			
			if(var!=null && var.length!=0)
			{
				for(int i=0;i<var.length;i++)
				{
					//for application category var= Application:<server type>:<graphtype>
					StringTokenizer st = new StringTokenizer(var[i],":");
					if(var[i].equals(cattypeVar))//startsWith(cattypeVar))
					{
						avar.addElement(var[i]);
						avar.addElement(irep.getValue(secTypeI,var[i]));
					}
				}
			}//var if
		}//cattype null check
		irep = null;

		if(cattype != null)
		{
			if(cattype.startsWith("Application"))
				serverlist = true;
		}
%>
<%
		session.setAttribute("egPageDesc","EgUserReports.jsp");
%>
<%
		// To select the User
		boolean b_status1=true;
		EgDbAdapterUI egDbU=null;
		String str_conn="";
		ResultSet rs=null;
		Vector v_user = new Vector();
		egDbU = EgDbAdapterTypeUI.getObject();
		try
		{
			str_conn = egDbU.setConnection();
			String s_qry = "SELECT user_id FROM user_info WHERE user_type NOT IN('AlarmViewer','SuperAlarmViewer') and user_id not in ('admin')";
			if(str_conn.equals("CONNECTED"))
			{
				b_status1 = egDbU.getState();
				rs = egDbU.SelectExec(s_qry);
				while(rs.next())
				{
					String user_id = rs.getString("user_id");
					if(!user_id.equalsIgnoreCase(User.SUPERMONITOR) && !user_id.equalsIgnoreCase(User.EGSM) && !user_id.equalsIgnoreCase("egenterprise"))
						v_user.addElement(user_id);
				}
			}
			egDbU.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDbU);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			if(!str_conn.equals("CONNECTED"))
			{
				out.println("Could not establish connection");
			}
			else
			{
				if(!b_status1)
				{
					out.println("An unknown error occured while fetching");
				}
				egDbU.releaseConnection(true);
				EgDbAdapterTypeUI.releaseObject(egDbU);
			}
		}
		String userselect="";
%>
<%
		if(v_user != null)
		{
			String displayUser = "";
			for(int vv=0;vv<v_user.size();vv++)
			{
				String tempuser =(String)v_user.get(vv);
				displayUser = tempuser;
				String temp_Usr = userMappingIni.getValue("DBUSER_USER_MAP",tempuser);
				if (temp_Usr != null && temp_Usr.length() > 0)
				{
					displayUser = temp_Usr;
				}

				if (tempuser.indexOf("/Grp/") != -1)
				{
					String grpDelimiter = "/Grp/";
					int idx = tempuser.indexOf(grpDelimiter);
					String str_uname_A = tempuser.substring(0,idx);
					int nextIdx = idx + grpDelimiter.length();
					String str_uname_B = tempuser.substring(nextIdx);
					//tempuser = str_uname_A + "/" + str_uname_B + " (Group)";

					idx = displayUser.indexOf(grpDelimiter);
					str_uname_A = displayUser.substring(0,idx);
					nextIdx = idx + grpDelimiter.length();
					str_uname_B = displayUser.substring(nextIdx);
					displayUser = str_uname_A + "/" + str_uname_B + " (Group)";
				}
				else if (tempuser.startsWith("samlsso/"))
				{
					String tmp = tempuser;
					int idx = tmp.indexOf("/");
					displayUser = tmp.substring(idx+1);
					displayUser = displayUser + " (SAML)";
				}

				if(userType!=null && userType !="")
				{
					JSONObject jselectUsersObj = new JSONObject();
					if(tempuser.equals(userType))
					{
						//jselectUsersObj.put("valueField",tempuser);
						//jselectUsersObj.put("displayField",displayUser);
						userselect="selected";
						selectedUser.add(tempuser);
					}
					else
						userselect="";
				}

				displayUser = StringUtils.replace(displayUser,"<","&lt;");
				displayUser = StringUtils.replace(displayUser,">","&gt;");

				JSONObject jUsersObj = new JSONObject();

				if (vv == 0)
				{
					jUsersObj.put("valueField","Select the user");
					jUsersObj.put("displayField","Select the user");
					usersArrayJson.add(jUsersObj);
				}
				jUsersObj.put("valueField",tempuser);
				jUsersObj.put("displayField",displayUser);
				usersArrayJson.add(jUsersObj);

				rootJson.put("displayUser",displayUser);
				rootJson.put("tempUser",tempuser);
				rootJson.put("userselect",userselect);
%>
<%
			}//for loop for user
		}//v_user null check
%>
<%
		// To Select Category type
		String netselect ="";
		String sysselect ="";
		String appselect ="";
		String siteselect = "";
		if(cattype != null)
		{
			if(cattype.startsWith("Network"))
				netselect = "checked";
			if(cattype.startsWith("System"))
				sysselect = "checked";
			if(cattype.startsWith("Application"))
				appselect = "checked";
			if(cattype.startsWith("Site"))
			{
				siteselect = "checked";
				sitelist = true;
			}
		}
		rootJson.put("cattype",cattype);
		rootJson.put("netselect",netselect);
		rootJson.put("sysselect",sysselect);
		rootJson.put("appselect",appselect);
		rootJson.put("siteselect",siteselect);
		rootJson.put("sitelist",sitelist);
%>
<%
		// To choose report type
		rootJson.put("serverlist",serverlist);
		rootJson.put("cattype",cattype);
		rootJson.put("userType",userType);
		if(!serverlist)
		{
%>
<%
			if(graphType!=null && graphType!="")
			{
				if(graphType.equals("Measure"))
				{
					mselect="selected";
					sselect="";
				}
				else
				{
					mselect="";
					sselect="selected";
				}
				if(graphType.equals("MeasureSummary"))
				{
					mselect="selected";
					sselect="selected";
				}
				reportTypeSelected.add(graphType);
			}
			// To choose graph type
			rootJson.put("graphType",graphType);
			rootJson.put("mselect",mselect);
			rootJson.put("sselect",sselect);
%>
<%
			// To choose test name
			if(sitelist)
			{
				rootJson.put("testName",testName);
				rootJson.put("secType",secType);
				rootJson.put("siteType",siteType);
%>
<%
				JSONObject jsiteTestsObj = new JSONObject();
				String website="",websitetran="";
				if(testName!=null)
				{
					if(testName.equals("WebSiteTest"))
					{
						website = "selected";
						siteSelected.add(testName);
					}
					if(testName.equals("WebSiteTransactionTest"))
					{
						websitetran = "selected";
						siteSelected.add(testName);
					}
				}
				String anyTestStr = "admin.reports.Select any test";
				String anyTest = mappingInfo.getTextDescription(anyTestStr);
				jsiteTestsObj.put("displayField",anyTest);
				jsiteTestsObj.put("valueField","Select any test");
				//jsiteTestsObj.put("valueField","WebSiteTest");
				siteTestsArrayJson.add(jsiteTestsObj);
				String siteTestDescr = mappingInfo.getTestDescription("WebSiteTest");
				jsiteTestsObj.put("displayField",siteTestDescr);
				jsiteTestsObj.put("valueField","WebSiteTest");
				//jsiteTestsObj.put("valueField","WebSiteTest");
				siteTestsArrayJson.add(jsiteTestsObj);
				siteTestDescr = mappingInfo.getTestDescription("WebSiteTransactionTest");
				jsiteTestsObj.put("displayField",siteTestDescr);
				jsiteTestsObj.put("valueField","WebSiteTransactionTest");
				//jsiteTestsObj.put("valueField","WebSiteTransactionTest");
				siteTestsArrayJson.add(jsiteTestsObj);
				rootJson.put("website",website);
				rootJson.put("websitetran",websitetran);

%>
<%
			}
			else
			{
				rootJson.put("cattype",cattype);
				rootJson.put("comType",comType);
				rootJson.put("comName",comName);
%>
<%
				boolean checked=false;
				//all test display starts 
				Vector v_alltests = new Vector();
				tests=et.getAllTests();
				tests = espec.getManagedCompTestList(tests);
				for(int tt=0;tt<tests.length;tt++)
					v_alltests.addElement(tests[tt]);

				//remove config tests
				TestBean testBean = new TestBean(true);
				ArrayList configTests = testBean.getAllConfigTests();
				v_alltests.removeAll(configTests);

				ArrayList aListDesktopAgentTestNames = testerInfo.getDesktopAgentTestNames();
				v_alltests.removeAll(aListDesktopAgentTestNames);
				//Collections.sort(v_alltests);
				//all test display ends 
				v_alltests = new Vector(sorter.getSortedTestList(v_alltests));
				rootJson.put("alltests",v_alltests);
				for(int i=0;i<v_alltests.size();i++)
				{
					JSONObject jtestsObj = new JSONObject();
					EgName name = (EgName)v_alltests.get(i);
					String tmpVal = name.getActualName();
					String tmpDis = name.getLocalName();
					rootJson.put("tmpVal",tmpVal);
					rootJson.put("tmpDis",tmpDis);
					rootJson.put("testName",testName);
					//String tn =(String)v_alltests.get(i);

					if (i == 0)
					{
						jtestsObj.put("valueField","Select the test");
						jtestsObj.put("displayField","Select the test");
						testsArrayJson.add(jtestsObj);
					}
					if(testName!=null)
					{
						if(testName.equals(tmpVal))
						{
							testselect = "selected";
							testSelected.add(testName);
						}
						else
							testselect ="";
					}
					rootJson.put("testselect",testselect);
					//rootJson.put("espec_inTest",espec);
					jtestsObj.put("valueField",tmpVal);
					jtestsObj.put("displayField",tmpDis);
					testsArrayJson.add(jtestsObj);
					if(!espec.isPortRelevantForTest(tmpVal))
					{
%>
<%
					}
					
				}//for loop ends here for test
%>
<%
			}//else of site list if
%>
<%
		}//serverlist if not check
%>
<%
		// To select options for Application category types
		rootAppJson.put("serverlist",serverlist);
		if(serverlist)
		{
%>
<%
			if(graphType!=null && graphType!="")
			{
				if(graphType.equals("Measure"))
				{
					mselect="selected";
					sselect="";
				}
				else
				{
					mselect="";
					sselect="selected";
				}
				if(graphType.equals("MeasureSummary"))
				{
					mselect="selected";
					sselect="selected";
				}
			}
			rootAppJson.put("graphType_applicationType",graphType);
			rootAppJson.put("mselect_applicationType",mselect);
			rootAppJson.put("sselect_applicationType",sselect);
			rootAppJson.put("cattype",cattype);
			rootAppJson.put("secType",secType);
			rootAppJson.put("userType",userType);
%>
<%
			// To select the component type for application category type
			rootAppJson.put("erdataObj",erdata);
			erdata = new ErUserData(userType,false);
			if(erdata!=null)
			{
				Vector v_server = new Vector();
				Vector v_comp = new Vector();
				v_comp = erdata.getAllUserComponents(0);
				rootAppJson.put("v_compObj",v_comp);
				if(v_comp != null)
				{
					for(int vc=0;vc<v_comp.size();vc++)
					{
						String tempvcom = (String)v_comp.get(vc);
						rootAppJson.put("tempvcom",tempvcom);
						//if(tempvcom.indexOf("server")!=-1 || tempvcom.indexOf("Server")!=-1 || tempvcom.indexOf("Citrix")!=-1)
						if(!v_server.contains(tempvcom))
						{
							v_server.addElement(tempvcom);
						}
						rootAppJson.put("v_serverObj",v_server);
					}
				}
				//String appser[] = ed.getServerTypes();
				//for(int as=0;as<appser.length;as++)
				ArrayList serverList = new ArrayList();
				String astemp="";
				if(v_server != null)
				{
					//Collections.sort(v_server);
					serverList = sorter.getSortedCompTypeList(v_server);
					rootAppJson.put("sortedServerList",serverList);
					for(int as=0;as<serverList.size();as++)
					{
						String tmpVal = "";
						String tmpDis = "";
						if(serverType != null)
						{
							EgName nameObj = (EgName)serverList.get(as);
							tmpVal = nameObj.getActualName();
							tmpDis = nameObj.getLocalName();
							rootAppJson.put("aServertmpVal",tmpVal);
							rootAppJson.put("aServertmpDis",tmpDis);
							//astemp =(String)v_server.get(as);
							JSONObject jCompTypeObj = new JSONObject();
							//String compType = (String)v_server.get(vs);
							if (as == 0)
							{
								jCompTypeObj.put("valueField","Select any component type");
								jCompTypeObj.put("displayField","Select any component type");
								compTypeArrayJson.add(jCompTypeObj);
							}
							jCompTypeObj.put("valueField",tmpVal);
							jCompTypeObj.put("displayField",tmpDis);
							compTypeArrayJson.add(jCompTypeObj);
							if(serverType != null && serverType.equals(tmpVal))
							{
								compTypeSelected.add(tmpVal);

%>
<%
							}
							else
							{
%>
<%
							}
						}
					}
				}//v_server null check
			}//erdata null check if
			rootAppJson.put("serverType",serverType);
%>
<%
			// To select component for application category type
			if(erdata !=null)
			{
				Vector v_com = erdata.getAllUserComponents(0);
				Vector v_discom = erdata.getAllUserComponents(2);
				if(v_com !=null && v_discom !=null)
				{
					Vector v_appcom = new Vector();
					if(!serverType.equals(""))
					{
						for(int st=0;st<v_discom.size();st++)
						{
							String temp =(String)v_discom.get(st);
							if(serverType.equals(temp.substring(0,temp.indexOf(":"))))
								v_appcom.addElement(temp);
						}
					}
					Collections.sort(v_appcom,String.CASE_INSENSITIVE_ORDER);
					for(int com =0 ;com<v_appcom.size();com++)
					{
						String tempcom = (String) v_appcom.get(com);
						String optext=tempcom.substring(tempcom.indexOf(":")+1,tempcom.length());
						if (optext.lastIndexOf(":NULL")>0)
						{
							optext = optext.substring(0,optext.indexOf(":NULL"));
						}
						String optval = tempcom.substring(0,tempcom.indexOf(":"));
						if(comName.equals(optext))
						{
							comselect = "selected";
							compSelected.add(optext);
						}
						else
							comselect = "";

						JSONObject jCompObj = new JSONObject();
						if (com == 0)
						{
							jCompObj.put("valueField","Select any component");
							jCompObj.put("displayField","Select any component");
							compArrayJson.add(jCompObj);
						}
						jCompObj.put("valueField",optval);
						jCompObj.put("displayField",optext);
						compArrayJson.add(jCompObj);

						rootAppJson.put("optval_applicationType",optval);
						rootAppJson.put("optext_applicationType",optext);
						rootAppJson.put("comselect_applicationType",comselect);
%>
<%
					}
				}//v_com and v_discom null check if
			}//erdata null check if
			rootAppJson.put("comName",comName);
%>
<%
			// To select the test for application category type
			rootAppJson.put("comType",comType);
			if(!comType.equals(""))
			{
				Vector v_complayers = erinfo.getLayersForCompType(comType);
				rootAppJson.put("v_complayers_AppType",v_complayers);
				Vector v_serverTests = new Vector();
				Vector v_serverTestsT = new Vector();
				if(v_complayers != null)
				{
					for(int ll=0;ll<v_complayers.size();ll++)
					{
						if(erdata != null)
							v_serverTestsT = erdata.getTests(comType,(String)v_complayers.get(ll));
						for(int ii=0;ii<v_serverTestsT.size();ii++)
						{
							if(!v_serverTests.contains(v_serverTestsT.get(ii)))
								v_serverTests.addElement(v_serverTestsT.get(ii));
						}
					}
				}
				v_serverTestsT=null;
				if(v_serverTests != null)
				{
					//remove config tests
					TestBean testBean = new TestBean(true);
					ArrayList configTests = testBean.getAllConfigTests();
					v_serverTests.removeAll(configTests);
					Collections.sort(v_serverTests);
					rootAppJson.put("v_serverTests_AppType",v_serverTests);
					for(int i=0;i<v_serverTests.size();i++)
					{
						JSONObject jTestsObj = new JSONObject();
						String sername =(String)v_serverTests.get(i);
						rootAppJson.put("sername_AppType",sername);
						if(!sername.equalsIgnoreCase("WebsiteTest") &&!sername.equalsIgnoreCase("WebsiteTransactionTest"))
						{
							if(testName !=null && testName !="")
							{
								if(testName.equals(sername))
								{
									testselect = "selected";
									serverTestSelected.add(sername);
								}
								else
									testselect = "";
							}
							if (i == 0)
							{
								jTestsObj.put("valueField","Select the test");
								jTestsObj.put("displayField","Select the test");
								serverTestsArrayJson.add(jTestsObj);
							}
							String localNameForJson = mappingInfo.getTestDescription(sername);
							jTestsObj.put("displayField",localNameForJson);
							jTestsObj.put("valueField",sername);
							serverTestsArrayJson.add(jTestsObj);
							rootAppJson.put("testName_AppType",testName);
							rootAppJson.put("testselect_AppType",testselect);
%>
<%
						}//fileter for web site and web tran test
					}//for loop ends here for test
				}//v_serverTests null check if
			}//comtype null check if
%>
<%
		}//if serverlist
%>
<%
		// Code to add summary details for user reports
		Hashtable reports = new Hashtable();
		ArrayList aListTests = new ArrayList();
		rootSummaryJson.put("avar",avar);
		if(avar != null && avar.size() != 0)
		{
%>
<%
			for(int j=0;j<avar.size();j=j+2)
			{
				String variable=(String)avar.elementAt(j);
				rootSummaryJson.put("variable",variable);
				applyToSummaryJson.add(variable);
				String value=(String)avar.elementAt(j+1);
				rootSummaryJson.put("value",value);
				applyToSummaryJson.add(value);
				StringTokenizer dis = new StringTokenizer(value,",");
				value="";
				int valtok = dis.countTokens();
				rootSummaryJson.put("valtok",valtok);
				while(dis.hasMoreTokens())
				{
					for(int k=1;k<=valtok;k++)
					{
						// for test
						ArrayList mesList = new ArrayList();
						String temp = (String)dis.nextToken();
						String test = temp.substring(0,temp.indexOf(":"));
						String mes = temp.substring(temp.indexOf(":")+1);
						mes = mappingInfo.getMeasureDescription(test,mes);
						test = mappingInfo.getTestDescription(test);

						rootSummaryJson.put("mes",mes);
						rootSummaryJson.put("test",test);
						if(reports.containsKey(test))
						{
							ArrayList aTemp = (ArrayList)reports.get(test);
							aTemp.add(mes);
							//reports.put(test,aTemp);
						}
						else
						{
							mesList.add(mes);
							reports.put(test,mesList);
							aListTests.add(test);
						}
						// end test

						rootSummaryJson.put("mesList",mesList);
						rootSummaryJson.put("reports",reports);
						rootSummaryJson.put("aListTests",aListTests);

						/*
						if(k%2==0)
						{
							String temp = (String)dis.nextToken();
							String test = temp.substring(0,temp.indexOf(":"));
							String mes = temp.substring(temp.indexOf(":")+1);
							mes = mappingInfo.getMeasureDescription(test,mes);
							test = mappingInfo.getTestDescription(test);
							value+=test+":"+mes+"<br>";
						}
						else
						{
							if(k==valtok)
							{
								String temp = (String)dis.nextToken();
								String test = temp.substring(0,temp.indexOf(":"));
								String mes = temp.substring(temp.indexOf(":")+1);
								mes = mappingInfo.getMeasureDescription(test,mes);
								test = mappingInfo.getTestDescription(test);
								value+=test+":"+mes;
							}
							else
							{
								String temp = (String)dis.nextToken();
								String test = temp.substring(0,temp.indexOf(":"));
								String mes = temp.substring(temp.indexOf(":")+1);
								mes = mappingInfo.getMeasureDescription(test,mes);
								test = mappingInfo.getTestDescription(test);
								value+=test+":"+mes+",";
							}
						}*/
					}// end of for loop
				}
				String type="";
				if(cattype !=null)
				{
					if(serverlist)
						type = cattype+" "+"-"+graphType;
					else
					{
						if(cattype.equals("Site"))
							type = "Service-"+graphType;
						else
							type = cattype +"-"+graphType;
					}
				}
				rootSummaryJson.put("type",type);
				//for components
				String comNameTitle="";
				if(cattype.equals("Application"))
				{
					if(userType !=null && serverType !=null)
						comNameTitle = userType+" "+mappingInfo.getComponentTypeDescription(serverType);
				}
				else if(cattype.equals("Site"))
				{
					if(userType !=null && userType !="")
					comNameTitle = userType;
				}
				else
				{
					if(userType!=null && userType!="")
						comNameTitle = userType;
				}

				if (comNameTitle != null && comNameTitle.indexOf("(Group)") != -1)
				{
					int idx = comNameTitle.indexOf("/");
					int nextIdx = comNameTitle.indexOf("(Group)");
					String strtempuname = comNameTitle.substring(0,idx);
					strtempuname = strtempuname + "/Grp/";
					String strtempuname_A = comNameTitle.substring(idx + 1 ,nextIdx);
					comNameTitle = strtempuname + strtempuname_A;
					comNameTitle = comNameTitle.trim();
				}
				rootSummaryJson.put("comNameTitle",comNameTitle);

				String temp_Usr = userMappingIni.getValue("DBUSER_USER_MAP",comNameTitle);
				rootSummaryJson.put("temp_Usr",temp_Usr);

				if (temp_Usr != null && temp_Usr.length() > 0)
				{
					comNameTitle = temp_Usr;
					if (comNameTitle.indexOf("/Grp/") != -1)
					{
						String grpDelimiter = "/Grp/";
						int idx = comNameTitle.indexOf(grpDelimiter);
						String str_uname_A = comNameTitle.substring(0,idx);
						int nextIdx = idx + grpDelimiter.length();
						String str_uname_B = comNameTitle.substring(nextIdx);
						comNameTitle = str_uname_A + "/" + str_uname_B + " (Group)";
					}
				}

				if (comNameTitle.indexOf("/Grp/") != -1)
				{
					String grpDelimiter = "/Grp/";
					int idx = comNameTitle.indexOf(grpDelimiter);
					String str_uname_A = comNameTitle.substring(0,idx);
					int nextIdx = idx + grpDelimiter.length();
					String str_uname_B = comNameTitle.substring(nextIdx);
					comNameTitle = str_uname_A + "/" + str_uname_B + " (Group)";
				}
				else if (comNameTitle.startsWith("samlsso/"))
				{
					String tmp = comNameTitle;
					int idx = tmp.indexOf("/");
					comNameTitle = tmp.substring(idx+1);
					comNameTitle = comNameTitle + " (SAML)";
				}

				rootSummaryJson.put("comNameTitle",comNameTitle);
				rootSummaryJson.put("variable",variable);
				rootSummaryJson.put("userType",userType);
				rootSummaryJson.put("cattype",cattype);
				rootSummaryJson.put("graphType",graphType);
				rootSummaryJson.put("serverType",serverType);
				rootSummaryJson.put("comName",comName);
				rootSummaryJson.put("comType",comType);
				rootSummaryJson.put("siteType",siteType);

				String title ="Following are the selections for "+comNameTitle+" "+type+" reports :";
				String applyToSummary="";
				String hval="";
				String applink="";
				if(graphType.equalsIgnoreCase("Measure"))
				{
					applyToSummary="Apply To Summary";
					hval="Eguserreportsp.jsp?varMeas="+EgURLEncoder.encode(variable,"UTF-8")+"&applytosum=true"+"&users="+EgURLEncoder.encode(userType,"UTF-8")+"&catType="+cattype+"&reportType="+graphType+"&secType=User&servers="+serverType+"&comName="+comName+"&component="+comType+"&siteType="+siteType;
					applink = "<a href='"+hval+"' onMouseOver='appsum.src=imgon8.src' onMouseOut='appsum.src=imgoff8.src'><img src=imgon8.src border=0 name = appsum ></a>";
				}
				rootSummaryJson.put("title",title);
				rootSummaryJson.put("applyToSummary",applyToSummary);
				rootSummaryJson.put("hval",hval);
				rootSummaryJson.put("applink",applink);

				/*if(value.indexOf("|")!=-1)
					value=value.replace('|',',');*/

				//coding for length restriction in a line 
				String val1="";
				/*
				if(value.indexOf("<br>")>0)
				{
					while(value.indexOf("<br>")>0)
					{
						int idx = value.indexOf("<br>");
						String e = value.substring(0,value.indexOf("<br>"));//st.nextToken();
						if(e.length() > 87)
							e= e.substring(0,87)+"<br>"+e.substring(87,e.length());
						value = value.substring(idx+4,value.length());
						val1+=e+"<br>";
					}
					val1 += value;
					value = val1;
				}
				else
				{
					if(value.length() > 87)
						value= value.substring(0,87)+"<br>"+value.substring(87,value.length());
				}
				*/
				//length restriction code ends
%>
<%
				if(graphType.equalsIgnoreCase("Measure"))
				{
%>
<%
				}
%>
<%
				Collections.sort(aListTests,String.CASE_INSENSITIVE_ORDER);
				rootSummaryJson.put("aListTests",aListTests);
				for (int i=0; i<aListTests.size(); i++)
				{
					JSONObject summaryObj = new JSONObject();
					String testKey = (String)aListTests.get(i);
					rootSummaryJson.put("testKey",testKey);
					ArrayList aListTmp = (ArrayList)reports.get(testKey);
					rootSummaryJson.put("aListTmp",aListTmp);
					String strValue = aListTmp.toString();
					strValue = strValue.substring(1,strValue.length()-1);
					String allMeasuresWithComma = "";
					String allMeasures = "";
					StringTokenizer st = new StringTokenizer(strValue,",");
					while (st.hasMoreTokens())
					{
						String aToken = st.nextToken();
						if (aToken != null && aToken.length() > 1)
						{
							allMeasuresWithComma = allMeasuresWithComma + aToken + ",";
						}
					}

					if (allMeasuresWithComma != null && allMeasuresWithComma.trim().length() > 0)
					{
						allMeasures = allMeasuresWithComma.substring(0,allMeasuresWithComma.length()-1);
					}
					if (allMeasures != null && allMeasures.trim().length() > 0)
					{
						summaryObj.put("Test",testKey);
						summaryObj.put("Measures",strValue);
						rootSummaryJson.put("strValue",strValue);
						summaryArrayJson.add(summaryObj);
					}
%>
<%
				}
%>
<%
			}
%>
<%
		}
		avar.removeAllElements();
%>
<%
		// Code to add associated measures and disassociated measures
		//Check the existence of test in ini
		//get the test vector from ini using the method
		boolean testexists=false;
		String cattypeTMI ="";
		String graphTypeTMI="";

		if(cattype != null)
		{
			cattypeTMI = cattype;
			if(cattype.startsWith("Application"))
			{
				if(comName !=null && !comName.equals("") && graphType !=null && !graphType.equals("") && serverType!=null && !serverType.equals(""))
					graphTypeTMI=serverType+":"+graphType+":"+userType;
			}
			else
			{
				if(graphType != null && !graphType.equals("") && userType !=null && !userType.equals(""))
					graphTypeTMI = graphType +":"+userType;
			}
		}
		measuresJson.put("graphTypeTMI",graphTypeTMI);
		measuresJson.put("cattypeTMI",cattypeTMI);
		measuresJson.put("secTypeI",secTypeI);

		Vector v_test=rep.getTests(cattypeTMI,secTypeI,graphTypeTMI);
		Vector av_measures = new Vector();
		Vector dv_measures = new Vector();
		measuresJson.put("v_test",v_test);
		measuresJson.put("testName",testName);

		//Populating associated measures of a selected test
		testExistsJson.put("testexists","false");
		if(testName!=null && testName !="")
		{
			if(v_test.contains(testName))
			{
				String initname =(String)v_test.elementAt(v_test.indexOf(testName));
				testexists = true;
				testExistsJson.put("testexists","true");
				//populating its asso measures and infos
				av_measures=rep.getMeasures(secTypeI,cattypeTMI,graphTypeTMI,initname);
				for (int j=0; j < av_measures.size(); j++)
				{
					JSONObject avMeasureObj = new JSONObject();
					String assocMeasString = (String) av_measures.get(j);
					String localName = mappingInfo.getMeasureDescription(testName,assocMeasString);
					if (assocMeasString != null && assocMeasString.trim().length() > 0)
					{
						avMeasureObj.put("displayField",localName);
						avMeasureObj.put("valueField",assocMeasString);
						assocRealMeasuresArrayJson.add(avMeasureObj);
						allRealMeasuresArrayJson.add(avMeasureObj);
					}
				}
				//av_infos=rep.getInfos(secTypeI,cattype,graphType,testName+":"+v_measures.elementAt(0));
				measuresJson.put("initname",initname);
				measuresJson.put("testexists",testexists);
				measuresJson.put("av_measures",av_measures);
			}
			//Populating disassociated measures of a selected test
			dmeasures=et.getMeasurementsForTest(testName);
			measuresJson.put("dmeasures",dmeasures);
			if(dmeasures !=null && dmeasures.length >0)
			{
				for(int j=0;j<dmeasures.length;j++)
				{
					if(!av_measures.contains(dmeasures[j]))
					{
						JSONObject dvMeasureObj = new JSONObject();
						String adMeasure = (String) dmeasures[j];
						String localName = mappingInfo.getMeasureDescription(testName,adMeasure);
						if (adMeasure != null && adMeasure.trim().length() > 0)
						{
							dvMeasureObj.put("displayField",localName);
							dvMeasureObj.put("valueField",adMeasure);
							disAssocRealMeasuresArrayJson.add(adMeasure);
							allRealMeasuresArrayJson.add(dvMeasureObj);
						}

						dv_measures.addElement(dmeasures[j]);
					}
				}
			}//dmeasures null check
			measuresJson.put("dv_measures",dv_measures);
		}//if testName equals null
%>
<%
		boolean optexist=false;
		if(av_measures!=null && av_measures.size()!=0)
		{
			for( int i=0;i<av_measures.size();i++)
			{
				/* code for auditlog starts */
				if(previousAssociatedMeasures==null)
					previousAssociatedMeasures = (String) av_measures.elementAt(i);
				else
					previousAssociatedMeasures += "," + (String) av_measures.elementAt(i);
				/* code for auditlog ends */
%>
<%
				measuresJson.put("previousAssociatedMeasures",previousAssociatedMeasures);
				optexist=true;
			}
		}
%>
<%
		if(dv_measures!=null && dv_measures.size()!=0)
		{
			for( int i=0;i<dv_measures.size();i++)
			{
%>
<%
			}
		}
%>
<%
	buttonJson.put("serverlist",serverlist);
	buttonJson.put("testexists",testexists);
	buttonJson.put("test_name",test_name);
%>
<%
	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
		//response.sendRedirect("EgErrors.jsp");
%>
<%
	}
%>
<%
if(request.getQueryString()!=null)
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgUserReports.jsp?"+request.getQueryString());
}
else
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgUserReports.jsp");
}
rootJson.put("rootAppJson",rootAppJson);
rootJson.put("rootSummaryJson",rootSummaryJson);
rootJson.put("usersArrayJson",usersArrayJson);
rootJson.put("testsArrayJson",testsArrayJson);
rootJson.put("serverTestsArrayJson",serverTestsArrayJson);
rootJson.put("siteTestsArrayJson",siteTestsArrayJson);
rootJson.put("testSelected",testSelected);
rootJson.put("selectedUser",selectedUser);
rootJson.put("siteSelected",siteSelected);
rootJson.put("testExistsJson",testExistsJson);

rootJson.put("reportTypeSelected",reportTypeSelected);
rootJson.put("summaryArrayJson",summaryArrayJson);
rootJson.put("applyToSummaryJson",applyToSummaryJson);
rootJson.put("assocRealMeasuresArrayJson",assocRealMeasuresArrayJson);
rootJson.put("disAssocRealMeasuresArrayJson",disAssocRealMeasuresArrayJson);
rootJson.put("allRealMeasuresArrayJson",allRealMeasuresArrayJson);

rootJson.put("compTypeArrayJson",compTypeArrayJson);
rootJson.put("compArrayJson",compArrayJson);
rootJson.put("compTypeSelected",compTypeSelected);
rootJson.put("compSelected",compSelected);
rootJson.put("serverTestSelected",serverTestSelected);

out.println(rootJson);
%>



