<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %> 
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<html>
<head>
	<meta charset="utf-8">
	<title>Delete and Upload MIB files</title>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<!-- Application folder -->
	<script src="SnmpUploadMIB/app/app.js"></script>
	<egui:skin ui="admin"/>
</head>
<body>
<script language="javascript">
var csrfToken = '<%=strCsrfToken%>';
var pageDesc = '<egui:intnl description="EgUploadMIB.jsp"/>';
var pageName = '<egui:intnl text="admin.title.Delete and Upload MIB files"/>';

var publicJson = '';
var componentRawData = '';

var fileexten = '<egui:intnl text="admin.common.Upload MIB file extensions should be either *txt or *mib or *my"/>';
var nofileselect = "<egui:intnl text='admin.common.Please choose the file by clicking the browse button'/>";
var doubleByteAlert = '<egui:intnl text="admin.common.File name is not allowed in DBL(Chinese,Korean,Japanese)"/>';
var overWriteAlert = '<egui:intnl text="admin.common.already exists"/>.<egui:intnl text="Do you want to overwrite?"/>';
var noDeleteMibFileAlert = '<egui:intnl text="admin.mib.Please select the MIB file to be deleted"/>';
var deleteConfirmAlert ='<egui:intnl text="admin.mib.Are you sure you want to delete"/>';
var deleteMultipleConfirmAlert ='<egui:intnl text="admin.user.Are you sure you want to delete the selected items?"/>';
var noMIBUploadMsg ='<egui:intnl text="admin.mib.No MIB files available"/>';
var alert1 ='<egui:intnl text="admin.mib.SNMP MIB has been deleted successfully"/>';
var alert3 ='<egui:intnl text="admin.mib.SNMP MIBs have been deleted successfully"/>';
var alert2 ='<egui:intnl text="admin.mib.Request has been processed successfully"/>';
var titleMsg ='<egui:intnl text="admin.mib.Files to be uploaded"/>';
var emptyMsg ='<egui:intnl text="admin.mib.Select a MIB file to upload"/>';
var toolTipMsg ='<egui:intnl text="admin.mib.Click here to upload MIB files"/>';
var label1 ='<egui:intnl text="admin.mib.Upload MIB Files"/>';
var label2 ='<egui:intnl text="admin.mib.MIB name"/>';
var label3 ='<egui:intnl text="admin.mib.Delete"/>';
var label4 ='<egui:intnl text="admin.mib.Delete Selected"/>';
var label5 ='<egui:intnl text="admin.mib.Upload"/>';
var NoMibFileConfigure ='<egui:intnl text="admin.mib.No MIB files have been uploaded"/>';
var NoMibFileSearch ='<egui:intnl text="admin.mib.No MIB files found for your current search"/>';

var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
var errorTitle = '<egui:intnl text="admin.user.Error"/>';

Ext.onReady(function(){
	Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

	Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
		else
		{
			if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
			{
				Ext.Msg.show({
					title : errorTitle,
					msg : requestTimeOut,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
			else
			{
				console.log(response.responseText);
				Ext.Msg.show({
					title : errorTitle,
					msg : probsErrorMessage,
					buttons : Ext.Msg.OK,
					icon : 'iconError'
				});
			}
		}
	});
});
</script>
</body>
</html>
<%
if(request.getQueryString()!=null)
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp?"+request.getQueryString());
}
else
{
	session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp");
}
%>



