<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>

<%
/*
*	Processing page for RabbitMQ node in Discovery tree.
*	ini File : eg_services.ini, subject : [RabbitMQ_Cluster]
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String rabbitMQ = "RabbitMQ_Cluster";

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovery");

	String ipLabel = "RabbitMQ Cluster identity (IP or Host name)";
	String sslLabel = "Use SSL to connect to RabbitMQ Cluster";
	String webPortLabel = "Web Port";
	String discoverLabel = "Discover RabbitMQ hosts using this RabbitMQ Cluster";
	String userLabel = "Username to connect to RabbitMQ Cluster";
	String pwdLabel = "Password for the user";

	String from = request.getParameter("from");
	String ip = request.getParameter("ip");
	String ssl = request.getParameter("ssl");
	String webport = request.getParameter("webport");
	String discover = request.getParameter("discover");
	String user = request.getParameter("user");
	String pwd = request.getParameter("pwd");

	rootJson.put("success","false");

	if(from != null && from.equalsIgnoreCase("Add"))
	{
		auditLogThread.setValue("Activity","Add RabbitMQ host discovery");
		if(ip != null && ip.length() > 0)
		{
			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";
			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover + "#" + webport;
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(rabbitMQ,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setCurrentValue("00~~"+ipLabel,ip);
			auditLogThread.setCurrentValue("01~~"+sslLabel,ssl);
			auditLogThread.setCurrentValue("02~~"+webPortLabel,webport);
			auditLogThread.setCurrentValue("03~~"+discoverLabel,discover);
			auditLogThread.setCurrentValue("04~~"+userLabel,user);
			auditLogThread.setCurrentValue("05~~"+pwdLabel,"*****");

			auditLogThread.setValue("Description","RabbitMQ Cluster preferences have been added successfully");
			auditLogThread.sendItToDB();

			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || discovery.equalsIgnoreCase("yes")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("12",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}
			rootJson.put("success","true");
		}
	}
	else if(from != null && from.equalsIgnoreCase("Modify"))
	{
		auditLogThread.setValue("Activity","Modify RabbitMQ host discovery");
		if(ip != null && ip.length() > 0)
		{
			String $_ssl = request.getParameter("$_ssl");
			String $_webport = request.getParameter("$_webport");
			String $_discover = request.getParameter("$_discover");
			String $_user = request.getParameter("$_user");
			String $_pwd = request.getParameter("$_pwd");

			boolean setAudit = false;
			boolean updateAgents = false;

			if($_ssl != null && !$_ssl.equalsIgnoreCase(ssl))
			{
				auditLogThread.setPreviousValue("00~~"+sslLabel,$_ssl);
				auditLogThread.setCurrentValue("00~~"+sslLabel,ssl);
				setAudit = true;
				updateAgents = true;
			}

			if($_webport != null && !$_webport.equalsIgnoreCase(webport))
			{
				auditLogThread.setPreviousValue("01~~"+webPortLabel,$_webport);
				auditLogThread.setCurrentValue("01~~"+webPortLabel,webport);
				setAudit = true;
				updateAgents = true;
			}

			if($_discover != null && !$_discover.equalsIgnoreCase(discover))
			{
				auditLogThread.setPreviousValue("02~~"+discoverLabel,$_discover);
				auditLogThread.setCurrentValue("02~~"+discoverLabel,discover);
				setAudit = true;
			}

			if($_user != null && !$_user.equalsIgnoreCase(user))
			{
				auditLogThread.setPreviousValue("03~~"+userLabel,$_user);
				auditLogThread.setCurrentValue("03~~"+userLabel,user);
				setAudit = true;
				updateAgents= true;
			}

			if($_pwd != null && !$_pwd.equalsIgnoreCase(pwd))
			{
				auditLogThread.setPreviousValue("04~~"+pwdLabel,"*****");
				auditLogThread.setCurrentValue("04~~"+pwdLabel,"********");
				setAudit = true;
				updateAgents = true;
			}

			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";

			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover + "#" + webport;

			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(rabbitMQ,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setValue("Description","RabbitMQ Cluster for "+ip+" preferences have been modified successfully");
			auditLogThread.sendItToDB();

			if(updateAgents)
			{
				boolean managedState = false;
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIniObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				DiscBean.stopDiscovery();
				IniFile agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
				String[] rabbitMQComps = discInfo.getAllServersOfType(rabbitMQ);
				for (int i = 0; i < rabbitMQComps.length; i++)
				{
					String rabbitMQComp = rabbitMQComps[i];
					if(rabbitMQComp.startsWith("Format") || rabbitMQComp.startsWith("#"))
						continue;
					String rabbitMQCompVal[] = discInfo.getFieldValuesForServer(rabbitMQ,rabbitMQComp);
					ArrayList rabbitMQCompValList = new ArrayList();
					for (int j = 0; j < rabbitMQCompVal.length; j++)
					{
						rabbitMQCompValList.add(rabbitMQCompVal[j].toLowerCase());
					}
					if(rabbitMQCompValList.contains(ip.toLowerCase()))
					{
						EgExternalInfo externalInfo = new EgExternalInfo("manager");
						String comp = rabbitMQComp.substring(rabbitMQComp.indexOf(":")+1);
						comp = comp.substring(0,comp.indexOf(":"));
						List agents = externalInfo.getAgentsForHost(comp);
						if(agents != null)
						{							
							for(int k = 0; k < agents.size(); k++)
							{
								String agent = (String) agents.get(k);
								String[] agentTests = agentIni.getVariables(agent);
								if(agentTests != null)
								{
									for(int l = 0; l < agentTests.length; l++)
									{
										String testNameVar = agentTests[l];
										String testValue = agentIni.getValue(agent,testNameVar);

										if(testValue.indexOf("-RabbitMQ_Node_user") > -1)
										{
											String host = testValue.substring(testValue.indexOf("-host")+5).trim();
											host = host.substring(0,host.indexOf("-RabbitMQ_Node_user")).trim();
											String testVarLower = testNameVar.toLowerCase();

											if(testVarLower.indexOf(":"+ip.toLowerCase()+":") > 0 ||
												testVarLower.endsWith(":"+ip.toLowerCase()) ||
												host.equalsIgnoreCase(ip))
											{
												int unLen = "-RabbitMQ_Node_user".length();
												if(testValue.indexOf("-RabbitMQ_Node_user") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-RabbitMQ_Node_user")+unLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-RabbitMQ_Node_user")+unLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+user+" "+value2;
												}

												int pwdLen = "-RabbitMQ_Node_password".length();
												if(testValue.indexOf("-RabbitMQ_Node_password") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-RabbitMQ_Node_password")+pwdLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-RabbitMQ_Node_password")+pwdLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+pwd+" "+value2;
												}

												int sslLen = "-ssl".length();
												if(testValue.indexOf("-ssl") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-ssl")+sslLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-ssl")+sslLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													ssl = (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True"))? "true" :"false";
													testValue = value1+" "+ssl+" "+value2;
												}

												int webportLen = "-webPort".length();
												if(testValue.indexOf("-webPort") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-webPort")+webportLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-webPort")+webportLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+webport+" "+value2;
												}
												agentIni.setValue(agent,testNameVar,testValue);
											}
										}
									}
								}
							}							
						}
					}
				}
				agentIni.saveFile();
				EgConfigFilesSync.releaseInstance(agentIni);
				DiscBean.startDiscovery("1");
				EgConfigFilesSync.releaseInstance(infraIniObj);
			}


			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || discovery.equalsIgnoreCase("yes")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("12",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}
			rootJson.put("success","true");
		}
	}
	else if(from != null && from.equalsIgnoreCase("deleteRabbitMQ"))
	{
		auditLogThread.setValue("Activity","Delete RabbitMQ host discovery");
		boolean success = false;
		boolean managedState = false;
		String rabbitMQIPs = request.getParameter("rabbitMQIPs");
		if(rabbitMQIPs != null && rabbitMQIPs.length() > 0)
		{
			IniFile discFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

			StringTokenizer st = new StringTokenizer(rabbitMQIPs,",");
			while(st.hasMoreTokens())
			{
				String rabbitMQIP = st.nextToken();
				services.deleteValue(rabbitMQ,rabbitMQIP);
				auditLogThread.setCurrentValue("Deleted XMS IP/Host",rabbitMQIP);
				success = true;
			}
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			if(success)
			{
				auditLogThread.setCurrentValue("ColumnName","Deleted RabbitMQ");
				auditLogThread.setValue("Description","The RabbitMQ IP/Hosts have been deleted");
				auditLogThread.sendItToDB();

				rootJson.put("requestStatus","success");
				JSONObject resultMsg = new JSONObject();
				resultMsg.put("title",_mapping.getTextDescription("admin.discovery.RabbitMQ Host Settings"));
				resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.RabbitMQ preference(s) deleted successfully"));
				rootJson.put("result",resultMsg);
			}
			else
			{
				rootJson.put("requestStatus","failed");
				JSONObject errorObj = new JSONObject();
				errorObj.put("title",_mapping.getTextDescription("admin.discovery.RabbitMQ Host Settings"));
				errorObj.put("message1",_mapping.getTextDescription("admin.discovery.Error in RabbitMQ preference(s) deletion"));
				rootJson.put("errors",errorObj);
			}
		}
	}

	out.println(rootJson.toString());

%>

