<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "java.io.*" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootObj = new JSONObject();
	rootObj.put("success","true");
	JSONObject errorObj = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	/* code for auditlog starts */
	boolean auditFlag = false;
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovery");
	/* code for auditlog ends */

	String from = request.getParameter("from");
	if(from == null)
		from = "";
	
	String containerconfig = "eg_containerizedapps.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(from.equals("containerizedApps"))
	{
		JSONObject resultMsg = new JSONObject();
		String selectedNodeID = request.getParameter("selectedNodeID");			

		if(selectedNodeID.equalsIgnoreCase("containerizedPorts") || selectedNodeID.equalsIgnoreCase("containerTCP"))
		{
			ArrayList newList = null;
			ArrayList oldList = new ArrayList();
			String newPortVal = request.getParameter("Ports");
			String oldPortVal = request.getParameter("$_Ports");
			String delim = ":,";
			
			auditLogThread.setValue("Activity","Port settings");
			auditLogThread.setValue("Description","Port preferences for containerized applications discovery have been updated successfully");
			
			if(newPortVal != null && newPortVal.length()>0 && oldPortVal != null && oldPortVal.length()>0)
			{
				if(newPortVal.endsWith(":"))
				{
					newPortVal = newPortVal.substring(0,newPortVal.length()-1);
				}
				if(oldPortVal.endsWith(":"))
				{
					oldPortVal = oldPortVal.substring(0,oldPortVal.length()-1);
				}
				String newPortValues[] = StringUtils.getTrimmedTokens(newPortVal, delim);
				String oldPortValues[] = StringUtils.getTrimmedTokens(oldPortVal, delim);
				newList = new ArrayList(Arrays.asList(newPortValues));
				oldList = new ArrayList(Arrays.asList(oldPortValues));
				Collections.sort(newList);
				Collections.sort(oldList);
				
				for(int i=0;i<oldList.size();i++)
				{
					String previousValue = (String)oldList.get(i);
					int $Index = previousValue.indexOf("$");
					ArrayList labelList = new ArrayList();
					String label = previousValue.substring(0,$Index);
					labelList.add(label);
					labelList = sorter.getSortedCompTypeList(labelList);
					EgName tmpObj = (EgName)labelList.get(0);
					String tmpDisp = tmpObj.getLocalName();
					String value = previousValue.substring($Index+1);
					if(value !=null && value.trim().length()>0)
					{
						value = value.trim();
						auditLogThread.setPreviousValue(tmpDisp,value);
						String tmp = (String)newList.get(i);//newPortValues[i];
						if(tmp !=null && tmp.trim().length()>0)
						{
							tmp = tmp.trim();
							int $Pos = tmp.indexOf("$");
							String server_label = tmp.substring(0,$Pos);
							String server_val = tmp.substring($Pos+1);
							if(label.equals(server_label))
							{
								auditLogThread.setCurrentValue(tmpDisp,server_val);
							}
						}
					}
				}
			}
			if(newList != null)
			{
				if(newList.removeAll(oldList))
				{
					if(newList.size()>0)
					{
						//auditFlag = true;
					}
				}
				if(newList.size()>0)
				{
					ArrayList srvrsList = new ArrayList();
					String allPorts = request.getParameter("Ports");
					if(allPorts.endsWith(":")) allPorts = allPorts.substring(0,allPorts.length()-1);
					String[] newportvals = StringUtils.getTrimmedTokens(allPorts, delim);						

					for(int i=0; i<newportvals.length; i++)
					{
						String newportVal = newportvals[i].trim();
						if(newportVal != null)
						{
							int index = newportVal.indexOf('$');
							String server = newportVal.substring(0,index);
							String portVal = newportVal.substring(index+1);
						//	if(portVal.indexOf(",")>=0)
							//{
							//	portVal = portVal.replace(',',':');
							//}
							newportvals[i] = portVal;
							srvrsList.add(server);
						}
					}
					
					String[] servers = (String[])srvrsList.toArray(new String[0]);
					IniFile contrConfigWr = EgConfigFilesSync.getInstance(s_iniFile_dir + containerconfig,true);
					for(int i=0;i<servers.length;i++)
					{
						String value = contrConfigWr.getValue("CONTAINER-ENV_PORTS",servers[i]);
						if (value != null && value.trim().length() > 0) 
						{
							contrConfigWr.setValue("CONTAINER-ENV_PORTS",servers[i],newportvals[i]);
						}		
					}	
					contrConfigWr.saveFile(true);
					EgConfigFilesSync.releaseInstance(contrConfigWr);	
				}
			}
			resultMsg.put("title",_mapping.getTextDescription("admin.discovery.TCP Ports Settings"));
			auditLogThread.sendItToDB();
		}
		if(selectedNodeID.equalsIgnoreCase("containerizedAutoManage") || selectedNodeID.equalsIgnoreCase("containerAutomanage"))
		{
			auditLogThread.setValue("Activity","Containerized Applications");
			auditLogThread.setValue("Description","Auto-manage containerized applications settings in discovery have been updated successfully");
			
			String automanage = request.getParameter("autoManage");
			String previousAutomanage = request.getParameter("$_AutoManage");
			if (automanage == null) automanage = "No";
				
			auditLogThread.setPreviousValue("Discover automanage components",previousAutomanage);
			auditLogThread.setCurrentValue("Discover automanage components",automanage);				
				
			IniFile contrConfigWr = EgConfigFilesSync.getInstance(s_iniFile_dir + containerconfig,true);	
			contrConfigWr.setValue("CONTAINER-ENV_DISCOVERY_SETTINGS","Automanage",automanage);
			contrConfigWr.saveFile();
			EgConfigFilesSync.releaseInstance(contrConfigWr);
				
			resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Auto-Manage Settings"));
			auditLogThread.sendItToDB();
		}
			
		rootObj.put("requestStatus","success");
		resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Preferences have been changed"));
		rootObj.put("result",resultMsg);
		out.println(rootObj.toString());
		return;
	}
	else if (from.equals("configureComponentWindow"))
	{
		auditLogThread.setValue("Activity","Containerized Applications");
		auditLogThread.setValue("Description","Containerized applications settings for discovery have been changed");
		
		IniFile contrWr = new IniFile(s_iniFile_dir + containerconfig);
		String[] prevDiscSrvrsContainer = contrWr.getVariables("CONTAINER-ENV_AUTODISCOVERY_COMPONENT_TYPES");
		String[] prevAutomanageSrvrsContainer = contrWr.getVariables("CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES");
			
		String serversContainer = request.getParameter("c_types");
		StringTokenizer srvTokens = new StringTokenizer(serversContainer,",");
		ArrayList serverList = new ArrayList();
		while(srvTokens.hasMoreTokens())
		{
			serverList.add((String)srvTokens.nextToken());
		}			
			
		String [] serverkArr = (String[])serverList.toArray(new String[0]);
		setContainerServertypes(serverkArr);			

		/* code for audit log starts*/			
		ArrayList prevDiscSrvsList = new ArrayList();
		ArrayList currentDiscSrvsList = new ArrayList(Arrays.asList(serverkArr));
		ArrayList prevAutomanageList = new ArrayList();//Arrays.asList(prevAutomanageSrvrsContainer)

		if (prevDiscSrvrsContainer.length > 0)
		{
			for(int n=0; n<prevDiscSrvrsContainer.length; n++)
			{
				String prevServr = contrWr.getValue("CONTAINER-ENV_AUTODISCOVERY_COMPONENT_TYPES",prevDiscSrvrsContainer[n]);
				if(prevServr.equalsIgnoreCase("false"))
				{
					continue;
				}
				else
				{
					prevDiscSrvsList.add(prevDiscSrvrsContainer[n]);
				}
			}
		}
		if (prevAutomanageSrvrsContainer.length > 0)
		{
			for(int n=0; n<prevAutomanageSrvrsContainer.length; n++)
			{
				String prevAutoManageServr = contrWr.getValue("CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES",prevAutomanageSrvrsContainer[n]);
				if (prevAutoManageServr.equalsIgnoreCase("false"))
				{
					continue;
				}
				else
				{
					prevAutomanageList.add(prevAutomanageSrvrsContainer[n]);
				}
			}
		}
		prevDiscSrvsList = sorter.getSortedCompTypeList(prevDiscSrvsList);
		currentDiscSrvsList = sorter.getSortedCompTypeList(currentDiscSrvsList);
		prevAutomanageList = sorter.getSortedCompTypeList(prevAutomanageList);
		int len = prevDiscSrvsList.size();
		int len2 = currentDiscSrvsList.size();
		int len3 = prevAutomanageList.size();
		String prevDiscSrvrs = "";
		String currentDiscSrvrs = "";
		String prevAutomanageSrvrs = "";
		if (len > 0)
		{
			for(int k=0; k<len; k++){
				EgName nameObj = (EgName)prevDiscSrvsList.get(k);
				String tmpDis = nameObj.getLocalName();
				if (k == (len-1))
					prevDiscSrvrs += tmpDis;
				else
					prevDiscSrvrs += tmpDis + ",";
			}
		}
		if (len2 > 0)
		{
			for(int m=0; m<len2; m++){
				EgName nameObj2 = (EgName)currentDiscSrvsList.get(m);
				String tmpDis2 = nameObj2.getLocalName();
				if (m== (len2-1))
					currentDiscSrvrs += tmpDis2;
				else
					currentDiscSrvrs += tmpDis2 + ",";
			}
		}
		if (len3 > 0)
		{
			for(int n=0; n<len3; n++){
				EgName nameObj3 = (EgName)prevAutomanageList.get(n);
				String tmpDis3 = nameObj3.getLocalName();
				if (n == (len3-1))
					prevAutomanageSrvrs += tmpDis3;
				else
					prevAutomanageSrvrs += tmpDis3 + ",";
			}
		}
		auditLogThread.setPreviousValue("Component types chosen for discovery",prevDiscSrvrs);
		auditLogThread.setCurrentValue("Component types chosen for discovery",currentDiscSrvrs);
		auditLogThread.setPreviousValue("Component types to be automatically managed",prevAutomanageSrvrs);
		auditLogThread.setCurrentValue("Component types to be automatically managed",currentDiscSrvrs);
		/* code for audit log ends*/

		rootObj.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Manager Discovery"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Preferences have been changed"));
		rootObj.put("result",resultMsg);
		auditLogThread.sendItToDB();
		out.println(rootObj.toString());
		return;
	}
	else if (from.equals("configureComponentWindow2"))
	{
		auditLogThread.setValue("Activity","Containerized Applications");
		auditLogThread.setValue("Description","Containerized applications settings for discovery have been changed");			
			
		ArrayList prevAutomanageList = new ArrayList();			
		IniFile contnrFile = new IniFile(s_iniFile_dir + containerconfig);
		String[] prevAutomanageSrvrsContainer = contnrFile.getVariables("CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES");
		for(int i=0; i<prevAutomanageSrvrsContainer.length; i++)
		{
			String AutoServer = (String)prevAutomanageSrvrsContainer[i];
			String autoManageServVal = contnrFile.getValue("CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES",AutoServer);
			if(autoManageServVal.equalsIgnoreCase("true") || autoManageServVal.equalsIgnoreCase("yes")) 
			{
				prevAutomanageList.add(AutoServer);
			}	
		}
			
		String automanageSrvrsContainer = request.getParameter("c_types2");
		StringTokenizer srvTokens = new StringTokenizer(automanageSrvrsContainer,",");
		ArrayList serverList = new ArrayList();
		while(srvTokens.hasMoreTokens())
		{
			serverList.add((String)srvTokens.nextToken());
		}
			
		String [] serverkArr = (String[])serverList.toArray(new String[0]);			
		setContainerServerTypesForAutomanage(serverkArr);
			
		/* code for audit log starts*/			
		ArrayList currentAutomanageList = new ArrayList(Arrays.asList(serverkArr));			
		prevAutomanageList = sorter.getSortedCompTypeList(prevAutomanageList);
		currentAutomanageList = sorter.getSortedCompTypeList(currentAutomanageList);
		int len = prevAutomanageList.size();
		int len2 = currentAutomanageList.size();
		String prevAutomanageSrvrs = "";
		String currentAutomanageSrvrs = "";
		if (len > 0)
		{
			for(int k=0; k<len; k++){
				EgName nameObj = (EgName)prevAutomanageList.get(k);
				String tmpDis = nameObj.getLocalName();
				if (k == (len-1))
					prevAutomanageSrvrs += tmpDis;
				else
					prevAutomanageSrvrs += tmpDis + ",";
			}
		}
		if (len2 > 0)
		{
			for(int m=0; m<len2; m++){
				EgName nameObj2 = (EgName)currentAutomanageList.get(m);
				String tmpDis2 = nameObj2.getLocalName();
				if (m== (len2-1))
					currentAutomanageSrvrs += tmpDis2;
				else
					currentAutomanageSrvrs += tmpDis2 + ",";
			}
		}
		auditLogThread.setPreviousValue("Component types to be automatically managed",prevAutomanageSrvrs);
		auditLogThread.setCurrentValue("Component types to be automatically managed",currentAutomanageSrvrs);
		/* code for audit log ends*/

		rootObj.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Manager Discovery"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.Preferences have been changed"));
		rootObj.put("result",resultMsg);
		auditLogThread.sendItToDB();
		out.println(rootObj.toString());
		return;
	}
	
%>
<%!
public void setContainerServerTypesForAutomanage(String[] automanageSrvrsList)
{
	String containerconfigFile = "eg_containerizedapps.ini";
	String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	String autoManageVar = "CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES";

	IniFile contnrWr = EgConfigFilesSync.getInstance(iniFile_dir + containerconfigFile,true);
	String[] existingSrvrs = contnrWr.getVariables(autoManageVar);
	
	if (existingSrvrs == null || existingSrvrs.length == 0)
	{
		int len = automanageSrvrsList.length;
		if (len > 0)
		{
			for (int i=0; i<len ; i++)
			{				
				contnrWr.setValue(autoManageVar, automanageSrvrsList[i], "true");
			}
		}
	}
	else
	{
		Vector oldList = new Vector(Arrays.asList(existingSrvrs));
		ArrayList unManageList = new ArrayList(Arrays.asList(existingSrvrs));
		ArrayList manageList = new ArrayList(Arrays.asList(automanageSrvrsList));
		unManageList.removeAll(manageList);
		String[] unManageServertypes = (String[])unManageList.toArray(new String[unManageList.size()]);
		contnrWr.deleteValues(autoManageVar, oldList);
		
		for (int i=0; i<automanageSrvrsList.length; i++)
		{
			String autoManageServer = (String)automanageSrvrsList[i];			
			contnrWr.setValue(autoManageVar, automanageSrvrsList[i], "true");
		}
		for (int j=0; j<unManageServertypes.length; j++)
		{
			String autoUnManageServer = (String)unManageServertypes[j];			
			contnrWr.setValue(autoManageVar, unManageServertypes[j], "false");
		}
	}
	contnrWr.saveFile();
	EgConfigFilesSync.releaseInstance(contnrWr);
}

public void setContainerServertypes(String[]  newservertypes)
{
	String containerconfigFile = "eg_containerizedapps.ini";
	String iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile contnrWr1 = EgConfigFilesSync.getInstance(iniFile_dir + containerconfigFile,true);
	String autoManageVar = "CONTAINER-ENV_AUTOMANAGE_COMPONENT_TYPES";
	String autoDiscoveryVar = "CONTAINER-ENV_AUTODISCOVERY_COMPONENT_TYPES";
	String[] existingSrvrs1 = contnrWr1.getVariables(autoDiscoveryVar);
	
	Vector oldList = new Vector(Arrays.asList(existingSrvrs1));
	ArrayList unManageList = new ArrayList(Arrays.asList(existingSrvrs1));
	ArrayList manageList = new ArrayList(Arrays.asList(newservertypes));
	unManageList.removeAll(manageList);
	String[] unManageServertypes = (String[])unManageList.toArray(new String[unManageList.size()]);
	contnrWr1.deleteValues(autoDiscoveryVar, oldList);
	
	String[] automanageTypes = contnrWr1.getVariables(autoManageVar);
	ArrayList automanageList = new ArrayList(Arrays.asList(automanageTypes));	
	
	for (int i=0; i<newservertypes.length; i++)
	{
		String autoManageServer = (String)newservertypes[i];			
		contnrWr1.setValue(autoDiscoveryVar, autoManageServer, "true");
		if(!automanageList.contains(autoManageServer))
		{
			contnrWr1.setValue(autoManageVar, autoManageServer, "false");
		}
	}
	for (int j=0; j<unManageServertypes.length; j++)
	{
		String autoUnManageServer = (String)unManageServertypes[j];			
		contnrWr1.setValue(autoDiscoveryVar, autoUnManageServer, "false");
		if(unManageList.contains(autoUnManageServer))
		{
			contnrWr1.deleteValue(autoManageVar, autoUnManageServer);
		}
	}	
	contnrWr1.saveFile();
	EgConfigFilesSync.releaseInstance(contnrWr1);
}
%>