<%
/*********************************************************************************************************
*	Name				:	EgLogoutA.jsp
*	Purpose				:	This code logs out the egurkha admin from the system
*	Version				:	eG 3.0
*	Creation Date		:	27/06/2000
*	Last Modified Date	:	27/11/2002	-	Sandhya	-	To display Manager IP in the title bar
*							12/11/2003	-	Williams		-	Server Time works now!!!
*							21/11/2003		Williams		-	Added EgAdminOperations.jsp as the HomePage
*	Author				:	BalaMurugan. V / John Williams
********************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.EgUserRole" %>
<%@ page import="com.egurkha.admin.AdminOperations" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%@ page import="com.egurkha.admin.UpdateTestPeriod"%>
<%@ page import="com.egurkha.admin.EgTestSpecification" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini");
	String idpLogoutStr = iniFile.getValue("SAML_SSO","IDP_LOGOUT");
	boolean isLogoutUrlConfigured = false;
	if (com.egurkha.util.StringUtils.isNull(idpLogoutStr))
	{
		idpLogoutStr = "no";
	}

	UserRegistry reg = UserRegistry.getInstance();
	Map sessGrpUser = reg.getLoggedInGroupUsers();

	User t_user = reg.getUser(sessionID);
	EgUserRole object = t_user.getUserRole();
	String userName=t_user.getLoginID();
	String sess_user = (String)sessGrpUser.get(sessionID);

	if (userName != null && userName.indexOf("/Grp/") != -1)
	{
		String domainDispName = userName.substring(0,userName.indexOf("/Grp/"));

		if (sess_user != null && !sess_user.startsWith(domainDispName.trim()))
		{
			userName = sess_user;
		}
	}

	boolean isLocal = true;
	if (userName.indexOf("/")>-1)
	{
		isLocal = false;
	}

	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	if (isCMEnabled)
	{
		isCMEnabled = object.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String show = "normalTest";
	if(isCMEnabled)
	{
		show = "both";
	}

	long perm = EgUserPermission.AGENT_TEST_CONFIG;
	boolean permission  = object.hasAdminRole(perm);
	String userid=request.getParameter("userid");
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
//	EgRoleInfo ri = new EgRoleInfo(session.getId());
	
	String fromIDP = request.getParameter("fromidp");
	if (fromIDP == null || fromIDP.length() == 0)
	{
		fromIDP = "false";
	}

	String fromTab = request.getParameter("fromTab");
	if (fromTab == null || fromTab.length() == 0)
	{
		fromTab = "admin";
	}

	IniFile ini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String tempStr = ini.getValue("MISC_ARGS","ShowUnConfigTestsOnSignout");
	boolean showUnconfigTests = true;
	if (tempStr != null && (tempStr.trim().equalsIgnoreCase("no") || tempStr.trim().equalsIgnoreCase("false")))
	{
		showUnconfigTests = false;
	}
	if (showUnconfigTests && permission && !EgInstallInfo.isSuperManager && fromTab.equalsIgnoreCase("admin"))
	{
		//AdminOperations ao=new AdminOperations(ri.getAllServers());
		//String[] str = ao.getUnconfiguredTests();
		String[] str = null;//ao.getUnconfiguredTests();

		List listComponents = ri.getAllServers();
		int unConfiguredTestsCount = 0;
		if (listComponents != null && listComponents.size() > 0)
		{
			EgTestSpecification egTestSpecification = new EgTestSpecification(ri.getAllServers());
			TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
			//unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount(); //Bug: It counts _cf tests for no-config users too.
			// To find any unconfigured tests exist for this user.
			if (tmapUnConfigTests != null)
			{
				Iterator tmapIt = tmapUnConfigTests.keySet().iterator();
				while(tmapIt.hasNext())
				{
					String compType = (String)tmapIt.next();
					TreeMap compMap = (TreeMap)tmapUnConfigTests.get(compType);
					Iterator compMapIt = compMap.keySet().iterator();
					while(compMapIt.hasNext())
					{
						String comp = (String)compMapIt.next();
						ArrayList testsList = (ArrayList)compMap.get(comp);
						ArrayList perfTests = (ArrayList)testsList.get(0);
						ArrayList confTests = new ArrayList();
						if (testsList.size() > 1 && isCMEnabled)
						{
							confTests =(ArrayList) testsList.get(1);
						}
						unConfiguredTestsCount += perfTests.size() + confTests.size();
						if (unConfiguredTestsCount > 0)
						{
							break;
						}
					}
					if (unConfiguredTestsCount > 0)
					{
							break;
					}
				}
			}
		}

		boolean hasAdminTab=true;
		if(EgInstallInfo.isClusterSupported)
		{
			EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
			if(mi != null && !mi.isPrimaryManager())
			{
				hasAdminTab=false;
			}
		}

		String s_check = request.getParameter("proceed");
		//this is for old signout page
		if(false && (s_check == null || s_check == ""))
		{
%>
			<jsp:useBean id="TestConfig" scope="page" class="egurkha.TestsNotConfigured"/>
<%
			if(str[0] !=null && str[0].length() >0 || new UpdateTestPeriod().getAggregateTestsWithoutRecommendedTestPeriod().size()>0)
			{
				if(userid!=null && userid.equalsIgnoreCase("true"))
				{
					String pageFwd = "../admin/EgUnconfigTests.jsp?from=logout&target=main&show="+show;
%>
					<jsp:forward page='<%=pageFwd%>'/>
<%
				}
			}
		}

		boolean hasUnConfiguredTests = false;
		if (hasAdminTab)
		{
			if (unConfiguredTestsCount > 0)
			{
				hasUnConfiguredTests = true;
			}
			else
			{
				if (EgInstallInfo.isAggregationSupported())
				{
					boolean hasAggregateComponent = false;
					for (int i=0;i<listComponents.size();i++)
					{
						String strComponent = (String)listComponents.get(i);
						String strCompType = strComponent.substring(0,strComponent.indexOf(":"));
						if (strCompType.startsWith("Agg_"))
						{
							hasAggregateComponent = true;
							break;
						}
					}

					if (hasAggregateComponent)
					{
						UpdateTestPeriod tempUpdateTestPeriod = new UpdateTestPeriod();
						Vector vecAgg = tempUpdateTestPeriod.getAggregateTestsWithoutRecommendedTestPeriod();
						if (vecAgg.size() > 0)
						{
							hasUnConfiguredTests = true;
						}
					}
				}
			}
		}
		String reqFrom = (String)session.getAttribute("clsTrial");
		if (reqFrom != null && reqFrom.equalsIgnoreCase("yes"))
		{
			hasUnConfiguredTests = false;
		}
		
		if(hasUnConfiguredTests)
		{
			String fromPage = request.getParameter("fromPage");
			if (fromPage != null && fromPage.equalsIgnoreCase("proceedingSignout"))
			{
				if(userid!=null && userid.equalsIgnoreCase("true"))
				{
					String strForward = "../admin/EgUnconfiguredTestsSummary.jsp?fromPage=proceedingSignout";
%>
					<jsp:forward page='<%=strForward%>'/>
<%
				}
			}
		}
	}

	String scriptUserName = userName;
	if (userName.indexOf("\\") != -1)
	{
		scriptUserName = findAndReplaceString(scriptUserName,"\\","\\\\");
	}

	if (!com.egurkha.util.StringUtils.isNull(userName) && userName.startsWith("samlsso/"))
	{
		String displayUser = userName.substring(userName.indexOf("/")+1);
		displayUser = displayUser.substring(0,displayUser.indexOf("/"));
		String logoutURLStr = iniFile.getValue(displayUser,"logoutURL");
		if (!com.egurkha.util.StringUtils.isNull(logoutURLStr) && !logoutURLStr.equalsIgnoreCase("none"))
		{
			isLogoutUrlConfigured = true;
		}

	}
	// This is used to check the Internet availability
	session.removeAttribute("isInternetAvailable");

	// This is used to user click on logout button
	session.setAttribute("clickLogoutButton",Boolean.toString(true));

%>
<html>
<head>
<title>
</title>
<meta charset="utf-8">
<egui:skin ui="admin"/>
<script type="text/javascript" src="../extjs/ext-all.js"></script>

<!-- Fancy Scroll-->
<script src="/final/jquery/jquery.js"></script>
<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
<style type="text/css">
body { 
	/*font-family: "Lucida Grande","Lucida Sans Unicode","Lucida Sans","DejaVu Sans","Bitstream Vera Sans","Liberation Sans",Verdana,"Verdana Ref",sans-serif !important;*/
	color: black !important;
	background: #363333!important;
	border-color: transparent !important;
	border-width: 0 !important;
}

td.tdborder_ad {
	padding:4px;
}

#cell_border1 { 
	padding:3px;
}

b {
	font-weight:bold;
}
</style>

<script language="javascript">
 var fromIDP = '<%=fromIDP%>';
 var user = '<%=scriptUserName%>';
 var idpLogoutStr = '<%=idpLogoutStr%>';
 var isLogoutUrlConfigured = '<%=isLogoutUrlConfigured%>';

$(window).ready(function () 
{
	if (fromIDP != null && fromIDP == 'false')
	{
		if (user.indexOf('samlsso/') != -1 && idpLogoutStr.toLowerCase() == 'yes')
		{
			if (isLogoutUrlConfigured != null && isLogoutUrlConfigured == 'true')
			{
				var urlStr = "/final/idplgt?user="+user;
				postCustomFormSubmit(urlStr);
			}
			else
			{
<%
				session.setAttribute("userNameStr",userName);
				session.setAttribute("isLocalStr", Boolean.toString(isLocal));
%>
				var urlStr = "/final/logout";
				postCustomFormSubmit(urlStr);
			}
		}
		else if ('<%=fromTab%>' != null && '<%=fromTab%>' == "DemoScenarios")
		{
<%
			session.setAttribute("userNameStr",userName);
			session.setAttribute("isLocalStr", Boolean.toString(isLocal));
			session.setAttribute("fromTab", "DemoScenarios");
%>
			var urlStr = "/final/logout";
			postCustomFormSubmit(urlStr);
		}
		else
		{
<%
			session.setAttribute("userNameStr",userName);
			session.setAttribute("isLocalStr", Boolean.toString(isLocal));
%>
			var urlStr = "/final/logout";
			postCustomFormSubmit(urlStr);
		}
	}
	else if ('<%=fromTab%>' != null && '<%=fromTab%>' == "DemoScenarios")
	{
<%
			session.setAttribute("userNameStr",userName);
			session.setAttribute("isLocalStr", Boolean.toString(isLocal));
			session.setAttribute("fromTab", "DemoScenarios");
%>
		var urlStr = "/final/logout";
		postCustomFormSubmit(urlStr);
	}
	else
	{
<%
		session.setAttribute("userNameStr",userName);
		session.setAttribute("isLocalStr", Boolean.toString(isLocal));
%>
		var urlStr = "/final/logout";
		postCustomFormSubmit(urlStr);
	}
});

	function postCustomFormSubmit(QString)
	{
		var url = '';
		var params = '';
		var len = QString.indexOf('?');
		if (len > -1)
		{
			url = QString.substring(0,len);
			params = QString.substring(len+1);
		}
		else
		{
			url = QString;
		}

		var strArr = params.split('&');

		var form = document.createElement('form');
		form.setAttribute('method', 'post');
		form.setAttribute('action', url);

		if (len > -1)
		{
			for (var i=0; i<strArr.length; i++)
			{
				var name = '';
				var value = '';
				var paramValue = strArr[i];
				var paramLen = paramValue.indexOf('=');
				if (paramLen > -1)
				{
					name = paramValue.substring(0,paramLen);
					value = paramValue.substring(paramLen+1);
				}
				if (strArr.hasOwnProperty(i))
				{
					var hiddenField = document.createElement('input');
					hiddenField.setAttribute('type', 'hidden');
					hiddenField.setAttribute('name', name);
					hiddenField.setAttribute('value', value);

					form.appendChild(hiddenField);
				}
			}
		}
		else
		{
			var hiddenField = document.createElement('input');
			hiddenField.setAttribute('type', 'hidden');
			hiddenField.setAttribute('name', 'dummy');
			hiddenField.setAttribute('value', 'dummy');

			form.appendChild(hiddenField);
		}
		document.body.appendChild(form);
		form.submit();
	}
</script>
</head>
<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"><div class="x-mask-loading" style="position:relative">Loading...</div></div>
</body>
</html>


<%!
	protected String findAndReplaceString(String s,String s_search,String s_replace)
	{
		StringBuffer sb_tmp = new StringBuffer();
		while(s.indexOf(s_search) > -1)
		{
			sb_tmp.append(s.substring(0,s.indexOf(s_search)) + s_replace);
			s = s.substring(s.indexOf(s_search) + s_search.length(),s.length());
		}
		if(s.length() > 0)
			sb_tmp.append(s);
		return sb_tmp.toString();
	}
%>




