<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgAPMInfo"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String strCompType = request.getParameter("componentType");
	String strTestName = request.getParameter("testName");
	String strTestType = request.getParameter("testType");
	
	if(StringUtils.isNull(strCompType))
	{
		strCompType = "";
	}
	if(StringUtils.isNull(strTestName))
	{
		strTestName = "";
	}
	if(StringUtils.isNull(strTestType))
	{
		strTestType = "";
	}

	//Rhev required codes
	String uiFile = "eg_services.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile testIniFile = new IniFile(s_iniFile_dir + uiFile,true);
	String sub = "RHEV";
	String[] allRhevs = testIniFile.getVariables(sub);

	int len=allRhevs.length;

	List ex_rhevList = new ArrayList();
	String strex_rhevList = "";
	if (allRhevs != null && allRhevs.length > 0)
	{
		ex_rhevList = Arrays.asList(allRhevs);
		strex_rhevList = ex_rhevList.toString();
		strex_rhevList = strex_rhevList.substring(1,strex_rhevList.length()-1);
	}

	String fromPage_HelpPage = request.getParameter("fromPage_HelpPage");
	if (fromPage_HelpPage != null)
	{
		session.setAttribute("fromPage_HelpPage",fromPage_HelpPage);
		session.setAttribute("cType_HelpPage",request.getParameter("cType_HelpPage"));
		session.setAttribute("tName_HelpPage",request.getParameter("tName_HelpPage"));
	}
	//Rhev end codes

	//Vc required codes
	String subVc = "VIRTUAL_CENTER";
	String[] allVCs = testIniFile.getVariables(subVc);
	int lenVc=allVCs.length;

	List ex_vcList = new ArrayList();
	String strex_vcList = "";
	if (allVCs != null && allVCs.length > 0)
	{
		ex_vcList = Arrays.asList(allVCs);
		strex_vcList = ex_vcList.toString();
		strex_vcList = strex_vcList.substring(1,strex_vcList.length()-1);
	}
	//Vc end codes

	//Hmc required codes
	String subHmc = "HMC";
	String[] allHMCs = testIniFile.getVariables(subHmc);
	int lenHmc=allHMCs.length;

	List ex_hmcList = new ArrayList();
	String strex_hmcList = "";
	if (allHMCs != null && allHMCs.length > 0)
	{
		ex_hmcList = Arrays.asList(allHMCs);
		strex_hmcList = ex_hmcList.toString();
		strex_hmcList = strex_hmcList.substring(1,strex_hmcList.length()-1);
	}
	//Hmc end codes

	//Nut required codes
	String subNut = "NUTANIX";
	String[] allNuts = testIniFile.getVariables(subNut);
	int lenNut=allNuts.length;
	List ex_nutList = new ArrayList();
	String strex_nutList = "";
	if (allNuts != null && lenNut > 0)
	{
		ex_nutList = Arrays.asList(allNuts);
		strex_nutList = ex_nutList.toString();
		strex_nutList = strex_nutList.substring(1,strex_nutList.length()-1);
	}
	//Nut end codes


	//XMS IP required codes
	String subXMS = "EMC_XtremIO_4x";
	String[] allXMSIPs = testIniFile.getVariables(subXMS);
	int lenXMSIP=allXMSIPs.length;

	List ex_xmsIPStr = new ArrayList();
	String strex_xmsIPList = "";
	if (allXMSIPs != null && allXMSIPs.length > 0)
	{
		ex_xmsIPStr = Arrays.asList(allXMSIPs);
		strex_xmsIPList = ex_xmsIPStr.toString();
		strex_xmsIPList = strex_xmsIPList.substring(1,strex_xmsIPList.length()-1);
	}
	//XMS IP end codes 


	boolean isAPMTest = false;
	if(strTestName != null)
	{
		EgAPMInfo apm = new EgAPMInfo("manager");
		isAPMTest = apm.isAPMTest(strTestName);
	}
	boolean isDoubleByteEnabled = com.eg.EgDbInfo.doubleByteEnabled;

%>
<html>
<head>
	<meta charset="utf-8">
	<title>AGENTS - TESTS - DEFAULT CONFIGURATION</title>
	<egui:skin ui="admin"/>

	<style type="text/css">
	.img_addShift{
		background-image : url('/final/admin/eg_images/plus.gif');background-repeat : no-repeat;
	}

	.img_removeShift{
		background-image : url('/final/admin/eg_images/minus.gif');background-repeat : no-repeat;
	}

	.disabled-mycomponent {
		opacity: .5;
	}

	</style>

</head>
<body>
	<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
		<div class="x-mask-loading" style="position:relative">
			Loading...
		</div>
	</div>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

<script language="javascript">

	// for IE support startsWith and endsWith function overrides
	if (!String.prototype.startsWith) 
	{
		String.prototype.startsWith = function (searchString, position) {
			position = position || 0;
			 return this.substr(position, searchString.length) === searchString;
		};
	}

	if (!String.prototype.endsWith)
	{
		String.prototype.endsWith = function(search, this_len) {
			if (this_len === undefined || this_len > this.length) {
				this_len = this.length;
			}
			return this.substring(this_len - search.length, this_len) === search;
		};
	}

	var csrfToken = '<%=strCsrfToken%>';
	var pageName = 'DEFAULT TEST CONFIGURATION';
	var polCreationPageName = '<egui:intnl text= "admin.test.Add policy" />';
	var pageDesc = '<egui:intnl description="EgConfigureDefaultTestParams.jsp"/>';
	var vcPageName = '<egui:intnl text= "admin.test.VCENTER DETAILS" />';
	var hmcPageName = '<egui:intnl text= "admin.test.HMC DETAILS" />';
	var rhevPageName = '<egui:intnl text= "admin.test.RHEV MANAGER DETAILS" />';
	var configUserPageName = '<egui:intnl text= "admin.test.CONFIGURE USER" />';
	var credUrlPageName = '<egui:intnl text= "admin.test.CONFIGURE CRED URL" />';
	var namePatternPageName = '<egui:intnl text= "admin.test.CONFIGURE NAME PATTERN" />';
	var winsharePageName = '<egui:intnl text= "admin.test.CONFIGURE WINDOW SHARED" />';
	var runtimePageName = '<egui:intnl text= "admin.test.RUNTIME PATTERN" />';
	var publicJson = '';
	var compType = '<%=strCompType%>';
	var testName = '<%=strTestName%>';
	var testType = '<%=strTestType%>';
	var isAPMTest = '<%=isAPMTest%>';
	var insideView = '';
	var snmpCommunityTextValues = '';
	var snmpUserContextValues = '';
	var snmpUserTextValues = '';
	var snmpPortextValues = '';
	var existingParams = '';
	var tickedParams = '';
	var redirectURL = '';
	var enableConfTestSize = '';
	var excludeTestsURL = '';
	var includeTestsURL = '';
	var newDomainValue = '';
	var newAdminUserValue = '';
	var newUserValue = '';
	var newPatternValue = '';
	var newNameValue = '';
	var newThresholdValue = '';
	var changedDomainValue = '';
	var changedAdminUserValue = '';
	var changedUserValue = '';
	var changedNameValue = '';
	var changedPatternValue = '';
	var changedThresholdValue = '';
	var plusButtonClicked = 'false';
	var polCreationJson = '';
	var jsonVal = '';
	var deletedRecords = '';
	var isFirstFilterCombo = false;
	var availPolicies = new Array();

	var alertMsg1 = '<egui:intnl text= "admin.test.Please choose a test" />';
	var alertMsg2 = '<egui:intnl text= "admin.test.You cannot configure multiple tests"/>'+'.&nbsp;'+'<egui:intnl text="admin.test.Please choose one"/>'+'.';
	var alertMsg3 = '<egui:intnl text="admin.test.The following test(s) cannot be excluded as these tests are required for validating named user counts for eG licensing"/>'+'.&nbsp;'+'<egui:intnl text="admin.test.Test name(s)"/>'+": ";
	var alertMsg4 = '<egui:intnl text="admin.test.Please choose a parameter" />';
	var alertMsg5 = '<egui:intnl text="admin.test.Please choose component(s) to be configured"/>';
	var alertMsg6 = '<egui:intnl text="admin.test.Please choose a component"/>';
	var alertMsg7 = '<egui:intnl text="admin.test.Please use the encircled"/>';
	var alertMsg8 = "<egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.";
	var alertMsg9 = "<egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>"+".";
	var alertMsg10 = "<egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>"+".";
	var alertMsg11 = '<egui:intnl text="admin.test.Policy"/>';
	var alertMsg12 = '<egui:intnl text="admin.test.is associated with a component"/>';
	var alertMsg13 = '<egui:intnl text="admin.test.Are you sure you want to delete this policy"/>';
	var alertMsg14 = '<egui:intnl text="admin.test.Are you sure you want to delete the policy"/>';
	var alertMsg15 = '<egui:intnl text="admin.test.Please enter the value for POLICY NAME"/>';
	var alertMsg16 = "<egui:intnl text='admin.test.Policy name should not contain special characters other than \'-\', \'*\', \'_\''/>";
	var alertMsg17 = "<egui:intnl text='admin.test.First or Last character should not be \'-\' in policy name'/>";
	var alertMsg18 = "<egui:intnl text='admin.test.Please enter the value for event sources to be included'/>";
	var alertMsg19 = "<egui:intnl text='admin.test.Please enter the value for event sources to be excluded'/>";
	var alertMsg20 = "<egui:intnl text='admin.test.Event sources to be included should not start or end with comma'/>";
	var alertMsg21 = "<egui:intnl text='admin.test.Event sources to be excluded should not start or end with comma'/>";
	var alertMsg22 = "<egui:intnl text='admin.test.Event sources to be included should not contain consecutive commas'/>";
	var alertMsg23 = "<egui:intnl text='admin.test.Event sources to be excluded should not contain consecutive commas'/>";
	
	var alertMsg24 = "<egui:intnl text='admin.test.Please enter the value for event IDS to be included'/>";
	var alertMsg25 = "<egui:intnl text='admin.test.Please enter the value for event IDS to be excluded'/>";
	var alertMsg26 = "<egui:intnl text='admin.test.Event IDS to be included should not start or end with comma'/>";
	var alertMsg27 = "<egui:intnl text='admin.test.Event IDS to be excluded should not start or end with comma'/>";
	var alertMsg28 = "<egui:intnl text='admin.test.Only numerals are allowed in event IDS to be excluded'/>";
	var alertMsg29 = "<egui:intnl text='admin.test.Only numerals are allowed in event IDS to be included'/>";
	var alertMsg30 = "<egui:intnl text='admin.test.Event IDS to be included should not contain consecutive commas'/>";
	var alertMsg31 = "<egui:intnl text='admin.test.Event IDS to be excluded should not contain consecutive commas'/>";
	
	var alertMsg32 = "<egui:intnl text='admin.test.Please enter the value for event descriptions to be included'/>";
	var alertMsg33 = "<egui:intnl text='admin.test.Please enter the value for event users to be included'/>";
	var alertMsg34 = "<egui:intnl text='admin.test.Please enter the value for event descriptions to be excluded'/>";
	var alertMsg35 = "<egui:intnl text='admin.test.Please enter the value for event users to be excluded'/>";
	var alertMsg36 = "<egui:intnl text='admin.test.Event descriptions to be included should not start or end with comma'/>";
	var alertMsg37 = "<egui:intnl text='admin.test.Event descriptions to be excluded should not start or end with comma'/>"
	var alertMsg38 = "<egui:intnl text='admin.test.Event users to be included should not start or end with comma'/>";
	var alertMsg39 = "<egui:intnl text='admin.test.Event users to be excluded should not start or end with comma'/>"
	var alertMsg40 = "<egui:intnl text='admin.test.Event descriptions to be included should not contain consecutive commas'/>";
	var alertMsg41 = "<egui:intnl text='admin.test.Event users to be included should not contain consecutive commas'/>";
	var alertMsg42 = "<egui:intnl text='admin.test.Event descriptions to be excluded should not contain consecutive commas'/>";
	var alertMsg43 = "<egui:intnl text='admin.test.Event users to be excluded should not contain consecutive commas'/>";
	var alertMsg44 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event sources to be included'/>";
	var alertMsg45 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event sources to be excluded'/>";
	var alertMsg46 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event descriptions to be included'/>";
	var alertMsg47 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event users to be included'/>";
	var alertMsg48 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event descriptions to be excluded'/>";
	var alertMsg49 = "<egui:intnl text='admin.test.\'all\' keyword should not be part of comma separated event users to be excluded'/>";
	var alertMsg50 = "<egui:intnl text='admin.test.Event sources to be included should contain \'all\' in lowercase'/>";
	var alertMsg51 = "<egui:intnl text='admin.test.Event descriptions to be included should contain \'all\' in lowercase'/>";
	var alertMsg52 = "<egui:intnl text='admin.test.Event users to be included should contain \'all\' in lowercase'/>";
	var alertMsg53 = "<egui:intnl text='admin.test.Event sources to be excluded should not contain \'all\''/>";
	var alertMsg54 = "<egui:intnl text='admin.test.Event descriptions to be excluded should not contain \'all\''/>";
	var alertMsg55 = "<egui:intnl text='admin.test.Event users to be excluded should not contain \'all\''/>";
	var alertMsg56 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event sources to be included'/>";
	var alertMsg57 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event sources to be excluded'/>"
	var alertMsg58 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event descriptions to be included'/>";
	var alertMsg59 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event users to be included'/>";
	var alertMsg60 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event descriptions to be excluded'/>";
	var alertMsg61 = "<egui:intnl text='admin.test.\'none\' keyword should not be part of comma separated event users to be excluded'/>";
	var alertMsg62 = "<egui:intnl text='admin.test.Event sources to be included should not contain \'none\''/>";
	var alertMsg63 = "<egui:intnl text='admin.test.Event descriptions to be included should not contain \'none\''/>";
	var alertMsg64 = "<egui:intnl text='admin.test.Event users to be included should not contain \'none\''/>";
	var alertMsg65 = "<egui:intnl text='admin.test.Event sources to be excluded should contain \'none\' in lowercase'/>";
	var alertMsg66 = "<egui:intnl text='admin.test.Event descriptions to be excluded should contain \'none\' in lowercase'/>";
	var alertMsg67 = "<egui:intnl text='admin.test.Event users to be excluded should contain \'none\' in lowercase'/>";
	var alertMsg68 = '<egui:intnl text="admin.test.Policy name already exists"/>';
	var alertMsg69 = "<egui:intnl text='admin.test.button adjacent to the URL text box or the \'Click here\' link above the test parameters to configure URL and credentials'/>.";
	var alertMsg70 = '<egui:intnl text="admin.test.Are you sure you want to delete the selected item(s)"/>'+'?';
	var alertMsg71 = '<egui:intnl text="admin.test.Please select policies for deletion"/>';
	var alertMsg72 = '<egui:intnl text="admin.test.Event policy has been added successfully"/>';
	var alertMsg73 = '<egui:intnl text="admin.test.Event policy has been modified successfully"/>';
	var alertMsg78 = '<egui:intnl text="admin.test.Test has been configured successfully"/>';
	var alertMsg79 = '<egui:intnl text="admin.test.Username already exists"/>';

	var label1 = '<egui:intnl text="admin.test.Apply"/>';
	var label2 = '<egui:intnl text="admin.test.Url"/>';
	var label3 = '<egui:intnl text="admin.test.POLICY NAME"/>';
	var label4 = '<egui:intnl text="admin.test.EVENT SOURCES"/>';
	var label5 = '<egui:intnl text="admin.test.EVENT IDS"/>';
	var label6 = '<egui:intnl text="admin.test.Modify"/>';
	var label8 = '<egui:intnl text="admin.test.View"/>';
	var label9 = '<egui:intnl text="admin.test.Delete"/>';
	var label7 = '<egui:intnl text="admin.test.EVENT DESCRIPTIONS"/>';
	var label10 = '<egui:intnl text="admin.test.Enable/Disable Performance Tests"/>';
	var label11 = '<egui:intnl text="admin.test.Component type"/>';
	var label12 = '<egui:intnl text="admin.test.Test type"/>';
	var label13 = '<egui:intnl text="admin.test.Test name"/>';
	var label14 = '<egui:intnl text="admin.test.Add New Policy"/>';
	var label15 = '<egui:intnl text="admin.test.EVENT POLICY"/>';
	var label16 = '<egui:intnl text="admin.test.Configure users"/>';
	var label17 = '<egui:intnl text="admin.test.Configure URL patterns"/>';
	var label18 = '<egui:intnl text="admin.test.Configure OS patterns"/>';
	var label19 = '<egui:intnl text="admin.test.Configure URL and credentials"/>';
	var label20 = '<egui:intnl text="admin.test.View"/>'+'/'+'<egui:intnl text="admin.test.Configure shared folders for monitoring"/>';
	var label21 = '<egui:intnl text="admin.test.Add"/>'+'/'+'<egui:intnl text="admin.test.Modify Policy Filters"/>';
	var label36 = '<egui:intnl text="admin.common.Performance"/>';
	var label37 = '<egui:intnl text="admin.common.Configuration"/>';

	//View Policy
	var noPolicyFound = '<egui:intnl text="admin.alarm.No policy found for your current search"/>';
	var policyTitle = '<egui:intnl text="admin.alarm.ADD/MODIFY EVENT POLICY"/>';

	var confirmMsg1 = '<egui:intnl text="admin.test.Do you want to continue with this configuration" />'+'?';
	var testViews = '';

	var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
	var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
	var errorTitle = '<egui:intnl text="admin.user.Error"/>';

	//Rhev starts
	var rhevTitle = '<egui:intnl text="admin.discovery.ADD RHEV MANAGER DETAILS"/>';
	var rhevIPLabel = '<egui:intnl text="admin.discovery.RHEV Manager identity (IP or Host name)"/>';
	var rhevSSLLabel = '<egui:intnl text="admin.discovery.Use SSL to connect to RHEV Manager"/>';
	var rhevMgrPortLabel = '<egui:intnl text="admin.discovery.Manager Port"/>';
	var rhevDiscLabel = '<egui:intnl text="admin.discovery.Discover RHEV Hypervisors using this RHEV manager"/>';
	var rhevUnmeLabel = '<egui:intnl text="admin.discovery.Username to connect to RHEV manager"/>';
	var rhevPwdLabel = '<egui:intnl text="admin.discovery.Password for user"/>';
	var rhevCPwdLabel = '<egui:intnl text="admin.discovery.Confirm password for user"/>';
	var rhevDnmeLabel = '<egui:intnl text="admin.discovery.Domain name for the RHEV Manager"/>';
	var existRhev = '<egui:intnl text="admin.discovery.Already exists,add another RHEV Manager"/>';
	var enterRhev = '<egui:intnl text="admin.discovery.Please enter the RHEV manager IP or valid Host Name"/>';
	var enterUsrId = '<egui:intnl text="admin.discovery.Please enter the user id"/>';
	var enterPwd = '<egui:intnl text="admin.discovery.Please enter the password"/>';
	var PwdNotContainPipe = "<egui:intnl text='admin.test.Password data should not contain pipe'/>";
	var enterCnfPwd= '<egui:intnl text="admin.discovery.Please enter the confirm password"/>';
	var matchPwd= '<egui:intnl text="admin.discovery.Passwords do not match"/>';
	var PortBlank= '<egui:intnl text="admin.discovery.Blank values are not allowed"/>';
	var CommaPrt = '<egui:intnl text="admin.discovery.Please enter a port number"/>';
	var validPrt = '<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>';
	var specialCharacterPrt = '<egui:intnl text="admin.discovery.Special characters not allowed"/>';
	var len = '<%=len%>';
	var strex_rhevList = '<%=strex_rhevList%>';
	var ex_rhevStr = strex_rhevList.split(",");

	//Vc starts
	var vcTitle = '<egui:intnl text="admin.discovery.ADD vCENTER DETAILS"/>';
	var vcIdLabel = '<egui:intnl text="admin.discovery.vCenter Identity (IP or Host name)"/>';
	var vcSSlLabel = '<egui:intnl text="admin.discovery.Use ssl to connect to vCenter"/>';
	var vcwebLabel = '<egui:intnl text="admin.discovery.Web Port"/>';
	var vcDiscoverLabel = '<egui:intnl text="admin.discovery.Discover esx hosts using this vCenter"/>';
	var vcUnmeLabel = '<egui:intnl text="admin.discovery.Username to connect to vCenter"/>';
	var vcPwdLabel = '<egui:intnl text="admin.discovery.Password for user"/>';
	var vcCPwdLabel = '<egui:intnl text="admin.discovery.Confirm password for user"/>';
	var existVc = '<egui:intnl text="admin.discovery.Already exists,add another VC"/>';
	var enterVc = '<egui:intnl text="admin.discovery.Please enter the virtual center IP or valid Username"/>';
	var lenVc = '<%=lenVc%>';
	var strex_vcList = '<%=strex_vcList%>';
	var ex_vcStr = strex_vcList.split(",");

	//Hmc starts
	var hmcTitle = '<egui:intnl text="admin.discovery.ADD HMC DETAILS"/>';
	var hmcIPLabel = '<egui:intnl text="admin.discovery.IP address of Hardware management console"/>';
	var hmcHnmeLabel = '<egui:intnl text="admin.discovery.Host Name of Hardware management console"/>';
	var hmcSSLLabel = '<egui:intnl text="admin.discovery.Use SSL to connect to HMC"/>';
	var hmcDiscLabel = '<egui:intnl text="admin.discovery.Discover pSeries servers using this HMC"/>';
	var hmcUnmeLabel = '<egui:intnl text="admin.discovery.Username to connect to HMC"/>(i.<egui:intnl text="admin.discovery.e hscroot"/>)';

	var hmcPwdLabel = '<egui:intnl text="admin.discovery.Password for user"/>';
	var hmcCPwdLabel = '<egui:intnl text="admin.discovery.Confirm password for user"/>';
	var existHmc = '<egui:intnl text="admin.discovery.Already exists,add another HMC"/>';
	var enterHmcIP = '<egui:intnl text="admin.discovery.Please enter the IP address"/>';
	var enterHmcHstName = '<egui:intnl text="admin.discovery.Please enter the host name"/>';
	var enterHmcUsr = '<egui:intnl text="admin.discovery.Please enter the host name"/>';
	var lenHmc = '<%=lenHmc%>';
	var strex_hmcList = '<%=strex_hmcList%>';
	var ex_hmcStr = strex_hmcList.split(",");

	//VmgUsers.jsp
	var vmgTitle = '<egui:intnl text="admin.test.CONFIGURATION OF MULTIPLE USERS"/>';
	var Domain = '<egui:intnl text="admin.test.Domain"/>';
	var AdminUser = '<egui:intnl text="admin.test.Admin User"/>';
	var AdminPwd = '<egui:intnl text="admin.test.Admin Password"/>';
	var AdminConfPwd = '<egui:intnl text="admin.test.Confirm Password"/>';
	var Update = '<egui:intnl text="admin.common.Update"/>';
	var Clear = '<egui:intnl text="admin.common.Clear"/>';
	var noVmgUsers = '<egui:intnl text="admin.common.Please configure users by clicking the Add button"/>';
	var inputs = 2;
	var totalInputs = 16;
	var isVmg = 'false';
	var limitedLevel = '<egui:intnl text="admin.user.limited level, upto level 15"/>';

	//Nuta starts
	var alertNutTitle = '<egui:intnl text="admin.discovery.NUTANIX PRISM DETAILS"/>';
	var nutTitle = '<egui:intnl text="admin.discovery.ADD NUTANIX PRISM DETAILS"/>';
	var nutIdLabel = '<egui:intnl text="admin.discovery.Nutanix Prism identity (IP or Host Name)"/>';
	var nutSSlLabel = '<egui:intnl text="admin.discovery.Use ssl to connect to Nutanix Prism"/>';
	var nutwebLabel = '<egui:intnl text="admin.discovery.Web Port"/>';
	var nutDiscoverLabel = '<egui:intnl text="admin.discovery.Discover Nutanix Acropolis or vSphere hosts"/>';
	var nutUnmeLabel = '<egui:intnl text="admin.discovery.Username to connect to Nutanix Prism"/>';
	var nutPwdLabel = '<egui:intnl text="admin.discovery.Password for user"/>';
	var nutCPwdLabel = '<egui:intnl text="admin.discovery.Confirm password for user"/>';
	var existNut = '<egui:intnl text="admin.discovery.Already exists,add another Nutanix Prism"/>';
	var enterNut = '<egui:intnl text="admin.discovery.Please enter the nutanix prism IP or valid Username"/>';
	var lenNut = '<%=lenNut%>';
	var strex_nutList = '<%=strex_nutList%>';
	var ex_nutStr = strex_nutList.split(",");
	//Nuta ends

	//EgConfigureMultipleUser.jsp
	var multiUserTitle = '<egui:intnl text="admin.test.CONFIGURATION OF MULTIPLE USERS"/>';
	var alertMultiTitle = '<egui:intnl text="admin.test.CONFIGURE MULTIPLE USERS"/>';
	var User = '<egui:intnl text="admin.test.User"/>';
	var PasswordLbl = '<egui:intnl text="admin.test.Password"/>';
	var CnfPassLbl = '<egui:intnl text="admin.test.Confirm Password"/>';
	var inputsmulti = 2;
	var Domain = '<egui:intnl text="admin.test.Domain"/>';
	var noMultiUsr = '<egui:intnl text="admin.test.Please configure multiple users by clicking the Add button"/>';
	var ismulti = 'false';

	//For EgConfigureUrlAndCredentials.jsp
	var urlTitle = '<egui:intnl text="admin.common.CONFIGURATION OF URL PATTERNS"/>';
	var urlLbl = '<egui:intnl text="admin.common.URL"/>';
	var urlUnmeLbl = '<egui:intnl text="admin.common.Username"/>';
	var urlPwdLbl = '<egui:intnl text="admin.common.Password"/>';
	var urlContentLbl = '<egui:intnl text="admin.common.Content"/>';
	var urlEncodeLbl = '<egui:intnl text="admin.common.Encoding"/>';
	var urlPrivateLbl = '<egui:intnl text="admin.common.Private Key File Path"/>';
	var addmore_lbl = '<egui:intnl text="admin.common.Add More"/>';
	var Name = '<egui:intnl text="admin.test.Name"/>';
	var Threshold_Value = '<egui:intnl text="admin.test.Threshold_Value"/>';
	var deleteBckMsg = '<egui:intnl text="admin.mail.Configuration settings will be removed"/>. <egui:intnl text="admin.mail.Do you want to proceed?"/>';
	var iscred = 'false';
	var enterUsr = '<egui:intnl text="admin.test.Please enter the user name"/>';
	var enterPwd = '<egui:intnl text="admin.test.Please enter the password"/>';
	var PwdNotPipe = "<egui:intnl text='admin.test.Password data should not contain pipe and comma' />";
	var enterValidPath = "<egui:intnl text='admin.test.Please enter a valid path' />";
	var enterFilePath = "<egui:intnl text='admin.test.Please enter the file path' />";
	var noUrlCred = "<egui:intnl text='admin.test.Please configure URL and credentials by clicking the Add button' />";
	var urlSystemPropsTitleLbl = '<egui:intnl text="admin.common.System Properties"/>';
	var urlSystemKeyLbl = '<egui:intnl text="admin.common.Property"/>';
	var urlSystemValLbl = '<egui:intnl text="admin.common.Value"/>';
	var enterSystemPropKey = '<egui:intnl text="admin.user.Please enter value for system property"/>';
	var enterSystemPropValue = '<egui:intnl text="admin.user.Please enter value for system property value"/>';
	var totalSystemProperties = 5;
	var limitedSysPropsMsg = '<egui:intnl text="admin.test.You cannot add more than" />'+' '+totalSystemProperties+' '+'<egui:intnl text="admin.test.system properties"/>';

	// For EgConfigureNamePattern.jsp
	var inputsUrlNme = 2;
	var confNameTitle = '<egui:intnl text="admin.test.CONFIGURATION OF URL PATTERNS"/>';
	var Pattern = '<egui:intnl text="admin.test.Pattern"/>';
	var enterName = '<egui:intnl text="admin.tests.Please enter the name"/>';
	var enterPattern = '<egui:intnl text="admin.tests.Please enter the patern"/>';
	var enterThresh = '<egui:intnl text="admin.user.Please enter the threshold value"/>';
	var nonamePatrn = '<egui:intnl text="admin.user.Please configure URL patterns by clicking the Add button"/>';
	var inputsCredUrl = 2;
	var noWinConfig = 'false';
	var isNamePtn = 'false';

	//For EgConfigureWinSharedFolders.jsp
	var inputWinShared = 2;
	var winTitle = '<egui:intnl text="admin.test.CONFIGURATION OF WINDOWS SHARES"/>';
	var dispWinLbl = '<egui:intnl text="admin.test.Display Name"/>';
	var shrWinLbl = '<egui:intnl text="admin.test.Share Name"/>';
	var dmnWinLbl = '<egui:intnl text="admin.test.Domain Name"/>';
	var unmeWinLbl = '<egui:intnl text="admin.test.Username"/>';
	var duplicateDisp = '<egui:intnl text="admin.test.Duplicate display name is not allowed"/>';
	var enterValidDisp = '<egui:intnl text="admin.test.Please enter a valid display name"/>';
	var enterDisp = '<egui:intnl text="admin.test.Please enter the display name"/>';
	var enterValidShare = '<egui:intnl text="admin.test.Please enter a valid share name"/>';
	var enterShare = '<egui:intnl text="admin.test.Please enter the share name"/>';
	var enterDomain = '<egui:intnl text="admin.test.Please enter the domain name"/>';
	var enter2FAToken = '<egui:intnl text="admin.test.Please enter the 2FA code"/>';
	var duplicateNtAlwd = '<egui:intnl text="admin.user.Duplicate name is not allowed"/>';
	var validName = '<egui:intnl text="admin.user.Please enter a valid name"/>';
	var validUrl = '<egui:intnl text="admin.user.Please enter a valid URL"/>';
	var enterUrl = '<egui:intnl text="admin.user.Please enter the URL"/>';
	var enterContent = '<egui:intnl text="admin.user.Please enter value for content"/>';
	var enterEncoding = '<egui:intnl text="admin.user.Please enter value for encoding"/>';
	var entName = '<egui:intnl text="admin.tests.Please enter the name"/>';
	var noWinShrd = '<egui:intnl text="admin.tests.Please configure windows shared folders by clicking the Add button"/>';
	var donotSpecifyKey = '<egui:intnl text="admin.tests.Please do not specify the eG keywords for parameter value"/>';

	//For EgConfigureWsdlAndUrlCredentials.jsp
	var wsdlTitle = '<egui:intnl text="admin.test.CONFIGURATION OF WEBSERVICE URL"/>';
	var noWsdlUrl = '<egui:intnl text="admin.test.Please configure webservice url and credentials by clicking the Add button at the top right corner"/>';
	var inputsWsdlUrl = 2;
	var noWsdl = 'false';

	//For Runtime 
	var runinputs = 0;  //Pattern Process
	var runTitle = '<egui:intnl text="admin.runtime.OS SPECIFIC PATTERN CONFIGURATION"/>';
	var patrnFor2000 = '<egui:intnl text="admin.runtime.Please provide the pattern for Windows2000"/>';
	var patrnFor2003 = '<egui:intnl text="admin.runtime.Please provide the pattern for Windows2003"/>';
	var patrnForNT = '<egui:intnl text="admin.runtime.Please provide the pattern for WindowsNT"/>';
	var patrnFor2008 = '<egui:intnl text="admin.runtime.Please provide the pattern for Windows2008"/>';
	var patrnForLinux = '<egui:intnl text="admin.runtime.Please provide the pattern for Linux"/>';
	var patrnForSolaris = '<egui:intnl text="admin.runtime.Please provide the pattern for Solaris"/>';
	var patrnForAIX = '<egui:intnl text="admin.runtime.Please provide the pattern for AIX"/>';
	var patrnForHPUX = '<egui:intnl text="admin.runtime.Please provide the pattern for HPUX"/>';
	var patrn = '<egui:intnl text="admin.runtime.Please provide the pattern"/>';

	var validpatrnFor2000 = '<egui:intnl text="admin.runtime.Please provide the valid pattern for Windows2000"/>';
	var validpatrnFor2003 = '<egui:intnl text="admin.runtime.Please provide the valid pattern for Windows2003"/>';
	var validpatrnForNT = '<egui:intnl text="admin.runtime.Please provide the valid pattern for WindowsNT"/>';
	var validpatrnFor2008 = '<egui:intnl text="admin.runtime.Please provide the valid pattern for Windows2008"/>';
	var validpatrnForLinux = '<egui:intnl text="admin.runtime.Please provide the valid pattern for Linux"/>';
	var validpatrnForSolaris = '<egui:intnl text="admin.runtime.Please provide the valid pattern for Solaris"/>';
	var validpatrnForAIX = '<egui:intnl text="admin.runtime.Please provide the valid pattern for AIX"/>';
	var validpatrnForHPUX = '<egui:intnl text="admin.runtime.Please provide the valid pattern for HPUX"/>';
	var validpatrn = '<egui:intnl text="admin.runtime.Please provide the valid pattern"/>';

	var emptyspacespatrn2000 = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in Windows2000 pattern"/>';
	var emptyspacespatrn2003 = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in Windows2003 pattern"/>';
	var emptyspacespatrnNT = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in WindowsNT pattern"/>';
	var emptyspacespatrn2008 = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in Windows2008 pattern"/>';
	var emptyspacespatrnLinux = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in Linux pattern"/>';
	var emptyspacespatrnSolaris = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in Solaris pattern"/>';
	var emptyspacespatrnAIX = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in AIX pattern"/>';
	var emptyspacespatrnHPUX = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in HPUX pattern"/>';
	var emptyspacespatrn = '<egui:intnl text="admin.runtime.Empty spaces are not allowed in pattern"/>';

	var specialchrpatrn2000 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2000 pattern"/>';
	var specialchrpatrn2003 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2003 pattern"/>';
	var specialchrpatrnNT = '<egui:intnl text="admin.runtime.Special characters are not allowed in WindowsNT pattern"/>';
	var specialchrpatrn2008 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2008 pattern"/>';
	var specialchrpatrnLinux = '<egui:intnl text="admin.runtime.Special characters are not allowed in Linux pattern"/>';
	var specialchrpatrnSolaris = '<egui:intnl text="admin.runtime.Special characters are not allowed in Solaris pattern"/>';
	var specialchrpatrnAIX = '<egui:intnl text="admin.runtime.Special characters are not allowed in AIX pattern"/>';
	var specialchrpatrnHPUX = '<egui:intnl text="admin.runtime.Special characters are not allowed in HPUX pattern"/>';
	var specialchrpatrn = '<egui:intnl text="admin.runtime.Special characters are not allowed in pattern"/>';

 //Service name
	var servFor2000 = '<egui:intnl text="admin.runtime.Please provide the service name for Windows2000"/>';
	var servFor2003 = '<egui:intnl text="admin.runtime.Please provide the service name for Windows2003"/>';
	var servForNT = '<egui:intnl text="admin.runtime.Please provide the service name for WindowsNT"/>';
	var servFor2008 = '<egui:intnl text="admin.runtime.Please provide the service name for Windows2008"/>';
	var servForLinux = '<egui:intnl text="admin.runtime.Please provide the service name for Linux"/>';
	var servForSolaris = '<egui:intnl text="admin.runtime.Please provide the service name for Solaris"/>';
	var servForAIX = '<egui:intnl text="admin.runtime.Please provide the service name for AIX"/>';
	var servForHPUX = '<egui:intnl text="admin.runtime.Please provide the service name for HPUX"/>';
	var serv = '<egui:intnl text="admin.runtime.Please provide the service name"/>';

	var validservFor2000 = '<egui:intnl text="admin.runtime.Please provide the valid service name for Windows2000"/>';
	var validservFor2003 = '<egui:intnl text="admin.runtime.Please provide the valid service name for Windows2003"/>';
	var validservForNT = '<egui:intnl text="admin.runtime.Please provide the valid service name for WindowsNT"/>';
	var validservFor2008 = '<egui:intnl text="admin.runtime.Please provide the valid service name for Windows2008"/>';
	var validservForLinux = '<egui:intnl text="admin.runtime.Please provide the valid service name for Linux"/>';
	var validservForSolaris = '<egui:intnl text="admin.runtime.Please provide the valid service name for Solaris"/>';
	var validservForAIX = '<egui:intnl text="admin.runtime.Please provide the valid service name for AIX"/>';
	var validservForHPUX = '<egui:intnl text="admin.runtime.Please provide the valid service name for HPUX"/>';
	var validserv = '<egui:intnl text="admin.runtime.Please provide the valid service name"/>';

	var specialchrserv2000 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2000 service name"/>';
	var specialchrserv2003 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2003 service name"/>';
	var specialchrservNT = '<egui:intnl text="admin.runtime.Special characters are not allowed in WindowsNT service name"/>';
	var specialchrserv2008 = '<egui:intnl text="admin.runtime.Special characters are not allowed in Windows2008 service name"/>';
	var specialchrservLinux = '<egui:intnl text="admin.runtime.Special characters are not allowed in Linux service name"/>';
	var specialchrservSolaris = '<egui:intnl text="admin.runtime.Special characters are not allowed in Solaris service name"/>';
	var specialchrservAIX = '<egui:intnl text="admin.runtime.Special characters are not allowed in AIX service name"/>';
	var specialchrservHPUX = '<egui:intnl text="admin.runtime.Special characters are not allowed in HPUX service name"/>';
	var specialchrserv = '<egui:intnl text="admin.runtime.Special characters are not allowed in service name"/>';

	//Data.jsp 
	var enterNamecolonVal = '<egui:intnl text="admin.test.Please enter url in this format urlName:urlValue"/>';
	var enterDiffName = '<egui:intnl text="admin.test.Please enter different name"/>';

	//ViewPolicy.jsp
	var polCreationTitle = '<egui:intnl text="admin.common.Add/Modify policy"/>';
	var modifyPolicyTitle = '<egui:intnl text="admin.alarm.MODIFY POLICY"/>';
	var viewPolicyTitle = '<egui:intnl text="admin.alarm.VIEW POLICY"/>';

	//TestConfiguration.jsp
	var defaultTestTitle = '<egui:intnl text="admin.test.DEFAULT TEST CONFIGURATION" />';


	//Configure Published Resource
	var multiSrcTitle = '<egui:intnl text="admin.test.CONFIGURATION OF PUBLISHED RESOURCES"/>';
	var User = '<egui:intnl text="admin.test.User"/>';
	var PasswordLbl = '<egui:intnl text="admin.test.Password"/>';
	var CnfPassLbl = '<egui:intnl text="admin.test.Confirm password"/>';
	var inputsmultisrc = 2;
	var Domain = '<egui:intnl text="admin.test.Domain"/>';
	var NoPublishedResource = '<egui:intnl text="admin.test.Please configure published resources by clicking the Add button"/>';
	var alertMsgSrcTitle = '<egui:intnl text="admin.common.PUBLISHED RESOURCES"/>';
	var enterPubRsrc = '<egui:intnl text="admin.test.Please enter the published resources"/>';
	var pubResourceToolTip = '<egui:intnl text="admin.test.Configure published resources"/>';

	var inputResource = 1;
	var enterFolderName = '<egui:intnl text="admin.test.Please enter the Tab name or enter none"/>.';
	var enterResourceName = '<egui:intnl text="admin.test.Please enter the application/desktop name"/>.';
	var validResourceName = '<egui:intnl text="admin.test.Please enter the valid application/desktop name"/>.';
	var enterwinTitle = '<egui:intnl text="admin.test.Please enter the window title or enter none"/>.';
	var multiResourceTitle = '<egui:intnl text="admin.test.CONFIGURE PUBLISHED RESOURCES"/>';

	var inputsRule = 2;
	var inputsIncPatt = 2;
	var totalIncPatt = 8;

	var rulePageTitle = '<egui:intnl text="admin.test.CONFIGURE RULES" />';
	var ruleNameLbl = '<egui:intnl text="admin.test.Rule Name" />';
	var faceLbl = '<egui:intnl text="admin.test.Facility Filter" />';
	var filterHostLbl = '<egui:intnl text="admin.test.Host Filter" />';
	var levelLbl = '<egui:intnl text="admin.test.Level Filter" />';
	var incPattLbl = '<egui:intnl text="admin.test.Include Keywords Filter" />';
	var filterLogLbl = '<egui:intnl text="admin.test.Filter Logic" />';
	var execPattLbl = '<egui:intnl text="admin.test.Exclude Keywords" />';
	var noRuleNameFilters = '<egui:intnl text="admin.test.Please configure rules by clicking the Add button" />';
	var _desccheckspecial = '<egui:intnl text="admin.test.Special characters are not allowed" />';
	var enterRuleName = '<egui:intnl text="admin.tests.Please enter the rule name"/>';
	var enterFacility = '<egui:intnl text="admin.tests.Please enter the facility"/>';
	var enterFilterLogic = '<egui:intnl text="admin.tests.Please enter the filter logic"/>';
	var enterFilterHost = '<egui:intnl text="admin.tests.Please enter the filter host"/>';
	var enterExecPattern = '<egui:intnl text="admin.tests.Please enter the exclude pattern"/>';
	var enterIncPattern = '<egui:intnl text="admin.tests.Please enter the include pattern"/>';
	var enterLevel = '<egui:intnl text="admin.tests.Please enter the Level"/>';
	var ruleNameToolTip = '<egui:intnl text="admin.group.Configure rules" />';
	var limitedIncludePatterns = '<egui:intnl text="admin.test.You cannot add more than" />'+' '+totalIncPatt+' '+'<egui:intnl text="admin.test.keywords filter"/>';
	var filterLogicPatternMsg = '<egui:intnl text="admin.test.Filter logic is not valid"/>';
	var enterFilterLogicMsg1 =  '<egui:intnl text="admin.test.Your filter must use parentheses around successive AND and OR expressions"/>';
	var duplicateRuleName =  '<egui:intnl text="admin.user.Duplicate rule name is not allowed"/>';
	var repeatedKeywords =  '<egui:intnl text="admin.user.Include and Exclude keywords cannot be same"/>';
	var validValue='<egui:intnl text="admin.user.Please enter a valid value"/>';
	var deleteFilterMsg='<egui:intnl text="admin.user.The filter logic references a deleted filter"/>';

	//XMS IP starts
	var alertXMSTitle = '<egui:intnl text="admin.discovery.XMS Preferences"/>';
	var XMSTitle = '<egui:intnl text="admin.discovery.ADD XMS IP DETAILS"/>';
	var xmsIdLabel = '<egui:intnl text="admin.discovery.XMS identity (IP or Host name)"/>';
	var xmsSSlLabel = '<egui:intnl text="admin.discovery.Use SSL to connect to XMS"/>';
	var xmsDiscoverLabel = '<egui:intnl text="admin.discovery.Discover EMC XtremIO hosts using this XMS"/>';
	var xmsUnmeLabel = '<egui:intnl text="admin.discovery.Username to connect to XMS"/>';
	var xmsPwdLabel = '<egui:intnl text="admin.discovery.Password for user"/>';
	var xmsCPwdLabel = '<egui:intnl text="admin.discovery.Confirm password for user"/>';
	var existXMSIP = '<egui:intnl text="admin.discovery.Already exists,add another XMS Identity"/>';
	var enterXMSIP = '<egui:intnl text="admin.discovery.Please enter the XMS IP or valid Username"/>';
	var lenXMSIP = '<%=lenXMSIP%>';
	var strex_xmsIPList = '<%=strex_xmsIPList%>';
	var ex_xmsIPStr = strex_xmsIPList.split(",");
	//XMS IP ends

	// Exchange site configuration
	var ExchangeTitle = '<egui:intnl text="admin.discovery.Email and Password"/>';
	var tootipExchange = '<egui:intnl text="admin.discovery.Configure Email and Password"/>';
	var mailIDDBL = '<egui:intnl text="admin.user.E-mail ID is not allowed in DBL(Chinese,Korean,Japanese)"/>';
	var mailRcv_valid = '<egui:intnl text="admin.mail.Please enter a valid email id"/>';
	var mail_valid = '<egui:intnl text="admin.mail.Multiple Email IDs are not allowed"/>';
	var duplicateMailId =  '<egui:intnl text="admin.user.Duplicate email IDs name is not allowed"/>';
	var NoEmailsConfigured =  '<egui:intnl text="admin.user.Please configure email and password by clicking the Add button"/>';

	// System Properties configuration
	var SysPropTitle = '<egui:intnl text="admin.test.System Properties Configuration"/>';
	var tootipProperty = '<egui:intnl text="admin.test.Configure system properties"/>';
	var sysPropLbl = '<egui:intnl text="admin.test.System Properties"/>';
	var NoPropConfigured =  '<egui:intnl text="admin.test.Please configure system properties by clicking the Add button"/>';

	//Configure AWS Logon simulator
	var registrationCode = '<egui:intnl text="admin.test.Registration code"/>';
	var enterRegcode = '<egui:intnl text="admin.test.Please enter the registration code"/>';

	//Horizon cloud POD multi user support
	var userNameLbl = '<egui:intnl text="admin.common.User name"/>';
	var domNameLbl = '<egui:intnl text="admin.common.Domain name"/>';
	var serNameLbl = '<egui:intnl text="admin.common.Connection server name"/>';
	var enterServname = '<egui:intnl text="admin.discovery.Please enter the connection server name"/>';
	var serverNameToolTip = '<egui:intnl text="admin.test.Configure connection server name"/>';
	var noConnectionServers = '<egui:intnl text="admin.test.Please configure connection servers by clicking the Add button"/>';
	var multiServersTitle = '<egui:intnl text="admin.test.CONFIGURATION OF CONNECTION SERVERS"/>';

	// alerts for performance rating tests
	var alert1 = '<egui:intnl text="admin.common.Critical in minimum values is not valid"/>';
	var alert2 = '<egui:intnl text="admin.common.Major in minimum values is not valid"/>';
	var alert3 = '<egui:intnl text="admin.common.Minor in minimum values is not valid"/>';
	var alert4 = '<egui:intnl text="admin.common.Critical in maximum values is not valid"/>';
	var alert5 = '<egui:intnl text="admin.common.Major in maximum values is not valid"/>';
	var alert6 = '<egui:intnl text="admin.common.Minor in maximum values is not valid"/>';
	var alert7 = '<egui:intnl text="admin.common.Integer part of critical value in minimum values cannot contain more than ten digits"/>';
	var alert8 = '<egui:intnl text="admin.common.Integer part of major value in minimum values cannot contain more than ten digits"/>';
	var alert9 = '<egui:intnl text="admin.common.Integer part of minor value in minimum values cannot contain more than ten digits"/>';
	var alert10 = '<egui:intnl text="admin.common.Integer part of critical value in maximum values cannot contain more than ten digits"/>';
	var alert11 = '<egui:intnl text="admin.common.Integer part of major value in maximum values cannot contain more than ten digits"/>';
	var alert12 = '<egui:intnl text="admin.common.Integer part of minor value in maximum values cannot contain more than ten digits"/>';
	var alert13 = '<egui:intnl text="admin.common.Fractional part of critical value in minimum values cannot contain more than four digits"/>';
	var alert14 = '<egui:intnl text="admin.common.Fractional part of major value in minimum values cannot contain more than four digits"/>';
	var alert15 = '<egui:intnl text="admin.common.Fractional part of minor value in minimum values cannot contain more than four digits"/>';
	var alert16 = '<egui:intnl text="admin.common.Fractional part of critical value in maximum values cannot contain more than four digits"/>';
	var alert17 = '<egui:intnl text="admin.common.Fractional part of major value in maximum values cannot contain more than four digits"/>';
	var alert18 = '<egui:intnl text="admin.common.Fractional part of minor value in maximum values cannot contain more than four digits"/>';
	var alert19 = '<egui:intnl text="admin.common.Critical value in minimum values cannot be negative"/>';
	var alert20 = '<egui:intnl text="admin.common.Major value in minimum values cannot be negative"/>';
	var alert21 = '<egui:intnl text="admin.common.Minor value in minimum values cannot be negative"/>';
	var alert22 = '<egui:intnl text="admin.common.Critical value in maximum values cannot be negative"/>';
	var alert23 = '<egui:intnl text="admin.common.Major value in maximum values cannot be negative"/>';
	var alert24 = '<egui:intnl text="admin.common.Minor value in maximum values cannot be negative"/>';
	var alert25 = '<egui:intnl text="admin.common.Minimum values are not in ascending order"/>';
	var alert26 = '<egui:intnl text="admin.common.Maximum values are not in descending order"/>';
	var alert27 = '<egui:intnl text ="admin.common.Rating is based on minimum and maximum values"/>'+'.\n<egui:intnl text="admin.ic.Please update either minimum values or maximum values without none"/>';
	var alert28 = '<egui:intnl text="admin.common.Minimum values cannot contain space"/>';
	var alert29 = '<egui:intnl text="admin.common.Maximum values cannot contain space"/>';
	var alert30 = '<egui:intnl text="admin.common.Minimum values cannot be -1"/>';
	var alert31 = '<egui:intnl text="admin.common.Maximum values cannot be -1"/>';
	var alert32 = '<egui:intnl text="admin.common.Minimum values are invalid"/>';
	var alert33 = '<egui:intnl text="admin.common.Maximum values are invalid"/>';
	var maxThreshAlert = '<egui:intnl text="admin.threshold.Maximum values representing Critical/Major/Minor should be in descending order"/>';
	var minThreshAlert = '<egui:intnl text="admin.threshold.Minimum values representing Critical/Major/Minor should be in ascending order"/>';
	var minimumValuesAlert = '<egui:intnl text="admin.threshold.Minimum values are not in the \\'Critical/Major/Minor\\' format"/>';
	var maximumValuesAlert = '<egui:intnl text="admin.threshold.Maximum values are not in the \\'Critical/Major/Minor\\' format"/>';
	var minMaxLabel = '<egui:intnl text="admin.user.MINIMUM AND MAXIMUM VALUES"/>';

	var patternErrorMsg3 = '<egui:intnl text="admin.test.Process name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>';
	var serviceErrMsg1 = '<egui:intnl text="admin.test.Service name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>';
	
	var BTNamingSegmentCount = 2;
	var inputsRule = 2;
	var rulePageTitle = '<egui:intnl text="admin.test.CONFIGURE RULES" />';
	var btnRules = '<egui:intnl text="admin.test.BUSINESS TRANSACTION NAMING RULES" />';
	var ruleNameLbl = '<egui:intnl text="admin.test.Rule Name" />';
	var noRuleNameFilters = '<egui:intnl text="admin.test.Please configure rules by clicking the Add button" />';
	var addNewRuleLabel = '<egui:intnl text="admin.common.Add New Rule"/>';
	var btRuleGridPageDesc = '<egui:intnl text= "admin.test.Business Transaction Naming - Rule List" />';
	var btRulePageDesc = '<egui:intnl text= "admin.test.Business Transaction Naming - Rule Creation" />';
	var noBTRules = '<egui:intnl text="admin.test.There are no specific Business Transaction Naming Rules configured for this component"/>';
	var noBTRulesSelected = '<egui:intnl text="admin.test.There are no Business Transaction Naming Rules selected for deletion"/>';
	var businessTransNamingTitle = '<egui:intnl text="admin.test.Business Transaction Naming"/>';
	var btRulesGridTitle = '<div>'+btRuleGridPageDesc+'</div>';
	var btRuleTitle = '<div>'+btRulePageDesc+'</div>';
	var deleteSelectedLabel = '<egui:intnl text="admin.test.Delete Selected"/>';
	var deleteRuleLabel = '<egui:intnl text="admin.test.Delete Rule"/>';
	var editRuleLabel = '<egui:intnl text="admin.test.Edit Rule"/>';
	var confirmDeleteRule = '<egui:intnl text="admin.test.Are you sure you want to delete the rule?"/>';
	var onlyNumber = '<egui:intnl text="admin.test.Field Value can only be a Number"/>';
	var onlypositive = '<egui:intnl text="admin.test.Field Value can not be less than 1 "/>';

	var strDoubleByteMgr ='<%=isDoubleByteEnabled%>';
	var isDoubleByteMgr = false;
	if (!Ext.isEmpty(strDoubleByteMgr) && strDoubleByteMgr.toLowerCase() == 'true')
	{
		isDoubleByteMgr = true;
	}

	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

		Ext.Ajax.on('requestexception', function (conn, response, options) {
			var errorStr = response.responseText;
			if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
			{
				if (errorStr.indexOf("user-session-invalid") != -1)
				{
					callWindow(1);
				}
				else if (errorStr.indexOf("user-deleted") != -1)
				{
					callWindow(2);
				}
				else if (errorStr.indexOf("user-timedout") != -1)
				{
					callWindow(3);
				}
			}
			else
			{
				if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
				{
					Ext.Msg.show({
						title : errorTitle,
						msg : requestTimeOut,
						buttons : Ext.Msg.OK,
						icon : 'iconError'
					});
				}
				else
				{
					console.log(response.responseText);
					Ext.Msg.show({
						title : errorTitle,
						msg : probsErrorMessage,
						buttons : Ext.Msg.OK,
						icon : 'iconError'
					});
				}
			}
		});
	});
	</script>
	
	<script language="JavaScript" src="eg_scripts/validate.js"></script>
	<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
	<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
	<script language="javascript" src="/final/admin/eg_scripts/eg_testparamsvalidate.js"></script>
	<script language="javascript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script language="JavaScript1.2" src="/final/scripts/screen_display.js"></script>
	<script language="JavaScript" src="eg_scripts/eg_validate.js"></script>
	<script language="JavaScript" src="/final/scripts/utilities/EncodeDecodeParams.js"></script>

	<!-- Application folder -->
	<script type="text/javascript" src="DefaultTestConfiguration/app/app.js"></script>

</body>
</html>



