<%
/**
 *  File name       :	EgConfigRemoteAgents.jsp
 *  Purpose         :   To configure hosts to Remote agents. 
 *  Version         :   3.0
 *  Creation Date	:   18/10/2003
 *  Author          : 	Babu S
 *	Modified		:	13/07/2004	Arun	Displays hosts that have to be configured for agentless
 *											monitoring. Uses EgExternalInfo.getAgentlessInfos()
 *						16/07/2004	Arun	Warns the user while removing the last host being monitored.
 *	Design Changes	:	Jaiwin
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui="admin"/>
<script language="JavaScript">

function listselect()
{
	var thisForm = document.RemoteAgents;
	var eagent = thisForm.eagents.options[thisForm.eagents.selectedIndex].value;
	var pageFrom = "";
	if (thisForm.from != null && thisForm.from != 'undefined')
	{
		pageFrom = thisForm.from.value;
	}
	if(eagent != "-1")
	{
		window.location.href = "EgConfigRemoteAgents.jsp?eagent=" +encodeURI(eagent)+"&from="+pageFrom;
	}
	else
	{
		window.location.href = "EgConfigRemoteAgents.jsp?eagent=null&from="+pageFrom;
	}
}

var manunmanage = false;
var toManage = new Array();
var toUnmanage = new Array();

function populate()
{
	var fagenthosts = new Array();
	var feghosts = new Array();
	var thisForm = document.RemoteAgents;
	var agenthostslen = thisForm.agenthosts.options.length;
	var eghostslen = thisForm.eghosts.options.length;
	var eghostslst = thisForm.eghosts;
	var agenthostslst = thisForm.agenthosts;
	var eagent = thisForm.eagents.options[thisForm.eagents.selectedIndex].value;

	if(eagent == "-1")
	{
		alert('<egui:intnl text="admin.test.Please choose a remote agent"/>');
		return;
	}
	for(var z = 0 ; z < agenthostslen ; z++)
	{
		if(agenthostslst.options[z].value == null)
		{
				continue;
		}
		else
		{
			fagenthosts[z] = agenthostslst.options[z].value;
		}
	}

	for(var y = 0 ; y < eghostslen; y++)
	{
		if(eghostslst.options[y].value == null)
		{
				continue;
		}
		else
		{
			feghosts[y] = eghostslst.options[y].value;
		}
	}

	//thisForm.fmanage.value = feghosts;
	//alert(thisForm.fmanage.value);
	thisForm.funmanage.value = fagenthosts;
	//alert(thisForm.funmanage.value);

	thisForm.fmanage.value = toManage;
	thisForm.funmanage.value = toUnmanage;

	//alert("Manage :"+thisForm.fmanage.value);
	//alert("UnManage :"+thisForm.funmanage.value);
	if(feghosts != "" || fagenthosts != "")
	{
		//if (isNetscape()) targetObj = document.updateImg;
		//if (isIE()) targetObj = updateImg.style;
		//targetObj.visibility = "hidden";
		thisForm.up.disabled=true;
		thisForm.up.value='<egui:intnl text="admin.common.Updating"/>...';

		thisForm.submit();
	}
}


function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}

function isIE() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for IE ver 4+. 
   if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
   return false;
}



function addtounmanage()
{
//	alert("To complete configuration of agentless monitoring, the required information must be entered in the ADD/MODIFY page");
	var thisForm = document.RemoteAgents;
	var serverselected = "false";
	manunmanage = true;

	//getting list size
	var j = thisForm.agenthosts.options.length;

	//gettin list vars
	var list = thisForm.eghosts;
	var mlist = thisForm.agenthosts;
	for(var i = 0 ; i < list.options.length ; i++)
	{
		//browsing through to find selected items
		if(list.options[i].selected == true)
		{
			serverselected = "true";
			var txt=list.options[i].text;
			var val=list.options[i].value;
			var flag = 0;
			//to check if it already exists
			for(k = 0; k < mlist.options.length; k++)
			{
				if(val == mlist.options[k].value)
				{
					flag = 1;
				}
			}

			//addin the new name
			if(flag == 0)
			{
				mlist.options[j++] = new Option (txt,val) ;
				var tempFlag = false;
				for(a=0;a<toUnmanage.length;a++)
				{
					if(toUnmanage[a] == val)
						tempFlag = true;
				}
				if(!tempFlag)
					toUnmanage[toUnmanage.length] = val;
				for(q=0;q<toManage.length;q++)
				{
					if(toManage[q] == val)
					{
						for(w=q;w<toManage.length;w++)
						{
							toManage[q] = toManage[q+1];
						}
						toManage.length = toManage.length - 1;
					}
				}
			}
		}
	}

	for(var i = thisForm.eghosts.options.length; i > 0 ; i--)
	{
		if(thisForm.eghosts.options[i-1].selected == true )
		thisForm.eghosts.options[i-1] = null;
	}

	if(serverselected == "false")
	{
		alert('<egui:intnl text="admin.remote.No managed hosts selected"/>');
	}
	else
	{
		thisForm.up.disabled = false;
	}
}

function addtomanage(count)
{
	var proceed = "true";
	if (count == 1)
	{
		if (!confirm('<egui:intnl text="admin.remote.The agent will not perform monitoring on any host after disassociation"/>. <egui:intnl text="admin.remote.Continue"/>?'))
		{
			proceed = "false";
		}
	}

	if (proceed == "true")
	{
		var thisForm = document.RemoteAgents;
		var serverselected = "false";
		manunmanage = true;

		//getting list size
		var j = thisForm.eghosts.options.length;

		//gettin list vars
		var list = thisForm.agenthosts;
		var mlist = thisForm.eghosts;
		for(var i=0; i< list.options.length ; i++)
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				serverselected = "true";
				var txt = list.options[i].text;
				var val = list.options[i].value;
				var flag = 0;
				//to check if it already exists
				for(k = 0; k<mlist.options.length; k++)
				{
					if(val == mlist.options[k].value)
					{
						flag = 1;
					}
				}
				//addin the new name
				if(flag == 0)
				{
					mlist.options[j++] = new Option (txt,val) ;
					var tempFlag = false;
					for(a=0;a<toManage.length;a++)
					{
						if(toManage[a] == val)
							tempFlag = true;
					}
					if(!tempFlag)
						toManage[toManage.length] = val;

					//alert("Temp :"+tempFlag);
					//alert("Value :"+val);
					
					for(q=0;q<toUnmanage.length;q++)
					{
						if(toUnmanage[q] == val)
						{
							for(w=q;w<toUnmanage.length;w++)
							{
								toUnmanage[q] = toUnmanage[q+1];
							}
							toUnmanage.length = toUnmanage.length - 1;
						}
					}
				}
			}
		}

		for(var i = thisForm.agenthosts.options.length; i > 0 ; i--)
		{
			if(thisForm.agenthosts.options[i-1].selected == true )
				thisForm.agenthosts.options[i-1] = null;
		}
		if(serverselected == "false")
		{
			alert('<egui:intnl text="admin.remote.No remote agent hosts selected"/>');
		}
	}
}
</script>
</head>

<%
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] s_eagent_servers = extInfo.getRemoteComponents();

	Vector v_managed_servers = new Vector();
	List finalServers = new LinkedList();
	Vector v_eagent_servers = new Vector();
	String s_tmp = "";
	String s_val = "";
	String s_eagent = request.getParameter("eagent");
	if(!s_eagent.equals("null"))
	{
		if (s_eagent_servers != null)
		{
			for(int i=0;i < s_eagent_servers.length;i++)
			{
				s_tmp = s_eagent_servers[i];
				s_val = extInfo.getRemoteAgentForHost(s_tmp);

				if (s_val.indexOf(",") > -1 
					&& (s_val.indexOf(s_eagent+",") > -1 
						|| s_val.startsWith(s_eagent+",") 
						|| s_val.endsWith(s_eagent)))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else if(s_val.equals(s_eagent))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else
				{
					continue;
				}
			}
		}

		/* need to find out the servers which have agentless enabled */
		if (s_eagent_servers != null)
		{
			for (int k=0; k<s_eagent_servers.length; k++)
			{
				if (!finalServers.contains(s_eagent_servers[k]))
						finalServers.add(s_eagent_servers[k]);
			}
		}

		for(int k=0;k < v_eagent_servers.size();k++)
		{
			if(finalServers.contains(v_eagent_servers.elementAt(k)))
			{
				int index1 = finalServers.indexOf(v_eagent_servers.elementAt(k));
				finalServers.remove(index1);
			}
		}
	}
	String reqFrom = request.getParameter("from");
	reqFrom = (reqFrom != null)?reqFrom:"";
%>

<body style="overflow:auto" topmargin="0" leftmargin="0" marginwidth="0" marginheight="0">
<form name="RemoteAgents" method="post" action="Egconfigremoteagentsp.jsp" style="margin:0px;padding:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
<%
	if (reqFrom.equalsIgnoreCase("AgentStatus"))
	{
%>
	<jsp:include page="listSearch.jsp?title=ASSIGN - REMOTE AGENTS&leftString=Add User&backButton=true&subtitle=false"/>
	<input type="hidden" name="from" value="<%=reqFrom%>"/>
<%
	}
	else
	{
%>	
	<jsp:include page="listSearch.jsp?title=ASSIGN - REMOTE AGENTS&leftString=Add User&backButton=false&subtitle=false"/>
<%
	}
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
<%
	List v = new LinkedList();
	if (s_eagent_servers != null)
	{
		for (int a=0; a<s_eagent_servers.length; a++)
		{
			String info = extInfo.getAgentlessInfos(s_eagent_servers[a]);
			if (StringUtils.isNull(info) || (info.startsWith("None,") && info.endsWith(",None")))
			{
				v.add(s_eagent_servers[a]);
			}
		}
	}

	int count = v.size();
	if(count > 0)
	{
%>
			<table align="center" cellspacing="3" cellpadding="2" width="85%" border="0">
				<tr>
					<td id="eg_warninghead" width="100%" colspan="4">
						<table align="center" width="100%" cellspacing="0" cellpadding="2" border="0">
							<tr >
								<td><img src="eg_images/eg_warning.gif" height="20" hspace="3" vspace="0" border="0"></td>
								<td id="eg_warninghead" width="100%" ><egui:intnl text="admin.remote.The following components have not been configured for agentless monitoring"/>:</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
<%
		int no_of_cells = 4;
		int dummycells=0;
		int perWidth = 25;
		if(count <= no_of_cells) 
		{
			dummycells = no_of_cells - count;
			perWidth=100/v.size();
		}
		else
		{
			dummycells = no_of_cells - (count % no_of_cells);
		}

		for (int i=0; i<count; i++)
		{
			if (i % no_of_cells==0)
			{
%>
				</tr>
				<tr>
<%
			}

			String host = (String)v.get(i);
			if (i == count-1)
			{
				if (dummycells == 3) 
				{
%>
					<td width="<%=perWidth%>%" id="eg_subcontentbg" colspan="4">&nbsp;<%= host%></td>
<%
				}
				else if(dummycells==2)
				{
%>
					<td width="<%=perWidth%>%" id="eg_subcontentbg" colspan="3">&nbsp;<%= host%></td>
<%
				}
				else if(dummycells==1)
				{
%>
					<td width="<%=perWidth%>%" id="eg_subcontentbg" colspan="2">&nbsp;<%= host%></td>
<%
				}
				else
				{
%>
					<td width="<%=perWidth%>%" id="eg_subcontentbg">&nbsp;<%= host%></td>
<%
				}
			}
			else
			{
%>
					<td width="<%=perWidth%>%" id="eg_subcontentbg">&nbsp;<%= host%></td>
<%
			}
		}
%>
				<tr>
					<td id="eg_warninghead" width="100%" height="22" colspan="4"><p align="center"><egui:intnl text="admin.remote.Immediately go to"/> <a href="EgDispServer.jsp?qctr=0"><b><egui:intnl text="admin.remote.ADD / MODIFY"/></b></a> <egui:intnl text="admin.remote.and configure the remote agents of these components"/>.</p></td>
				</tr>
			</table>
			<br>
<%
	}
%>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" id="eg_subcontentbg">
<%
	String[] s_eagents = extInfo.getAllRemoteAgents();
	if (s_eagents != null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
	}
	else
	{
		s_eagents = new String[0];
	}

	if(s_eagents.length==0)
	{
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" class="eg_subhead" colspan="3" align="center" height="20"><egui:intnl text="admin.remote.No Remote Agents currently available"/></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
	}
	else
	{
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td  align='center' valign='middle' height='25' id="form_border">&nbsp;</td>	
					<td id="form_border" colspan="5" align="center">
						<table border="0" cellspacing="0" cellpadding="0" bordercolor="cyan" width="100%" align="center">
							<tr>
								<td width="100%">
									<table align="center" border="0" cellspacing="0" cellpadding="0" bordercolor="magenta">
										<tr>
											<td nowrap><egui:intnl text="admin.remote.Remote agent"/>&nbsp;&nbsp;:&nbsp;&nbsp;</td>
								<td width="60%"  id="eg_subcontentbg" align="left" >
												<select name='eagents' onchange='JavaScript:listselect()'>
													<option value = "-1"><egui:intnl text="admin.remote.List of remote agents"/></option>
<%
		for(int i=0;i < s_eagents.length;i++)
		{
			if(s_eagents[i].equals(s_eagent))
			{
				out.println("<option value=" + s_eagents[i] + " SELECTED>" + s_eagents[i] + "</option>");
			}
			else
			{
				out.println("<option value=" + s_eagents[i] + " >" + s_eagents[i] + "</option>");
			}
		}
%>
												</select>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align='center' valign='middle' class="form_spacing">&nbsp;</td>

					<td width="45%" class="form_spacing">
						<table align="center" cellspacing="0" cellpadding="0" border="0" id="cell_border1">
							<tr>
<%
		if(s_eagent.equals("null"))
		{
%>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-top-width:0px;width:320px;"><strong><egui:intnl text="admin.remote.HOSTS MANAGED"/></strong></td>
<%
		}
		else
		{
%>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-top-width:0px;width:320px;"><strong><egui:intnl text="admin.remote.HOSTS MANAGED BY THIS AGENT"/> </strong></td>
<%
		}
%>
							</tr>
							<tr>
								<td id="eg_subcontentbg" align="center" valign="top">
									<select name="agenthosts" size="25" multiple width="330" style="width:330px;margin:0px;">
<%
		String existingAgents = "";
		int hostsCount = v_eagent_servers.size();
		if (hostsCount > 0)
		{
			Collections.sort(v_eagent_servers,String.CASE_INSENSITIVE_ORDER);
			for(int j=0; j<hostsCount; j++)
			{
				String str_temp = (String)v_eagent_servers.get(j);
				out.println("<option value=" + str_temp + ">" + str_temp + "</option>");
				existingAgents += str_temp + ",";
			}
			if(existingAgents.indexOf(",")!=-1)
			{
				existingAgents = existingAgents.substring(0,existingAgents.lastIndexOf(","));
%>
					<input type="hidden" name="existingAgents" value="<%=existingAgents%>">
<%
			}
		}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
					<td width="10%" align="center" valign="middle" id="eg_subcontentbg" >
					<input type="button" value='&lsaquo;&lsaquo;  <egui:intnl text="admin.thresdhold.Associate"/>' class="eg_lightbutton" onClick="JavaScript:addtounmanage()" name="unman" style="width: 100px; letter-spacing:0px;">
					</td>
					<td width="45%" class="form_spacing">
						<table align="center" cellspacing="0" cellpadding="0" border="0" id="cell_border1">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-top-width:0px;width:320px;"><strong><egui:intnl text="admin.remote.OTHER HOSTS"/></strong></td>
							</tr>
							<tr>
								<td id="eg_subcontentbg" align="center" valign="top" >
								<select name="eghosts" size="25" multiple width="330" style="width:330px;margin:0px;">
<%
		if(finalServers.size() > 0)
		{
			Collections.sort(finalServers,String.CASE_INSENSITIVE_ORDER);
			for(int x=0;x < finalServers.size();x++)
			{
				out.println("<option value=" + finalServers.get(x) + ">" + finalServers.get(x) + "</option>");
			}
		}
%>
								</select>
								</td>
							</tr>
						</table>
					</td>
					<td  align='center' valign='middle' id="form_spacing" class="form_spacing">&nbsp;</td>
				</tr>
				<input type="hidden" name="fassociate" value="">
				<input type="hidden" name="fdissociate" value="">
				<input type="hidden" name="fmanage" value="">
				<input type="hidden" name="funmanage" value="">
				<input type="hidden" name="eagent" value="<%=s_eagent%>">
				<tr>
					<td align='center' valign='middle' >&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3">
					<img src="/final/admin/eg_images/spacer.gif" height="6" border="0" ></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
				</tr>
			</table>
			<table>
				<tr>
					<td>&nbsp;
					</td>
				</tr>
				<tr>
					<td><input type="button" value='<egui:intnl text="admin.remote.Update"/>' class="eg_back" onClick="javascript:populate();" name="up" disabled style="width: 80px;">
					</td>
				</tr>
			</table>
<%
      }
%>
		</td>
	</tr>
</table>
</form>
</body>
</html>
<%
	v_eagent_servers.removeAllElements();
	finalServers.clear();
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigRemoteAgents.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigRemoteAgents.jsp?eagent=null");
%>
<!-- existig stuffs -->



