<%
/**
 *  Name        :	EgConfigInclude.jsp
 *  Purpose     :   Configure Test Topology
 *  Version     :   0.1
 *  Created		:   3/10/2000
 *	Modified	:
 *			22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also used by 
 *									the JSP to send the server type. Change the query parameter to 
 *									typeOfServer to remove ambiguity.
			30/08/2001	sandhya		to stop discovery before deleting from eg_disable.ini and 
									to start discovery after deleting from eg_disable.ini.
 *			05:06:2001	Bala		accomodated changes in ServiceBean	
 *			16:05:2001	Bala		added explicit stop discovery 
 *			15/11/2000	Modified by Bala & Sandhya
 *	Author		:	Sridevi.T
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgAgentInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgUtils" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="sBean" scope="page" class="egurkha.ServiceBean"/>

<%
	String strCheck = request.getParameter("t_name");
	String str_comp_type = request.getParameter("comptype");
	String serverName = request.getParameter("comptype");
	String componentsForInclusion = request.getParameter("ComponentsForInclusion");

	int serverFlag = 0;
	int tokCount = 0;

	String strTok = "";
	StringTokenizer tok = null;

	//to add a test whose server+hostname is excluded in eg_disable.ini
	//prgBean.createFile("eg_disable.ini", "save");	

	/* before deleting from eg_disable.ini, stop discovery */
	sBean.stopDiscovery();
	StringTokenizer st = new StringTokenizer(componentsForInclusion,",");
	prgBean.createSyncFile("eg_disable.ini", "save");
	while (st.hasMoreTokens())
	{
		String finalStr = "";
		String str_host_name = st.nextToken();
		if ((str_host_name.equals("")) || (str_host_name.equals(" ")))
			continue;

		String subTestParam = str_comp_type;
		String stringTemp = subTestParam + ":" + str_host_name;

		String strVal = prgBean.getStrValue(subTestParam, stringTemp);
		if(strCheck.equals(strVal))
		{
			prgBean.deleteValues(subTestParam,stringTemp);
		}
		else if(strVal.indexOf(strCheck)>=0 && (!strVal.equals("")))
		{
			tok = new StringTokenizer(strVal,",");
			tokCount = tok.countTokens();
			for(int m=0; m<tokCount; m++)
			{
				strTok = (tok.nextToken()).trim();
				if(strTok.equals(strCheck)==false)
				{
					finalStr = finalStr + strTok + ",";
				}
			}


			finalStr = finalStr.substring(0, finalStr.lastIndexOf(","));
			prgBean.setValues(subTestParam,stringTemp,finalStr);
		}
	}
	prgBean.saveFile();
	prgBean.releaseInstance();
	/* end of code for update button click */

	/* after deleting from eg_disable.ini, start discovery */
	String step = "1";
	sBean.startDiscovery(step,true);
	
	String ur = "EgConfigTest.jsp?t_name="+strCheck+"&qctr=1&rctr=0&compname=undefined&comptype=" +str_comp_type+ "&typeOfServer=" + serverName;

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Test Configuration");
	auditLogThread.setCurrentValue("Test Name",request.getParameter("t_name"));
	auditLogThread.setCurrentValue("Component Type",request.getParameter("comptype"));

	String hostNames = request.getParameter("ComponentsForInclusion");
	String hostNamesArray[] = null;
	if(hostNames != null && !hostNames.equals("null"))
	{
		StringTokenizer tokens = new StringTokenizer(hostNames,",");
		while(tokens.hasMoreTokens())
		{
			String token = tokens.nextToken().toString();
			int index = token.indexOf(":");
			if(index != -1)
				auditLogThread.setCurrentValue("Included Component(s)",token.substring(0,index));
			else
				auditLogThread.setCurrentValue("Included Component(s)",token);
		}
	}
	auditLogThread.setValue("Description","Component(s) have been included for test configuration");
	auditLogThread.sendItToDB();
	/* code for auditlog endss */

	/* For aggregate test frequency setting starts */
	if(EgInstallInfo.isAggSupported)
	{
		//IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
		IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");

		EgDiscInfo discInfo = new EgDiscInfo("manager");
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		EgAgentInfo agentInfo = new EgAgentInfo("manager");
		EgExternalInfo extInfo = new EgExternalInfo("manager");
		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");

		ArrayList managedComps =  discInfo.getAllManagedNames(true);
		ArrayList availTests = new ArrayList();

		String aggregateTestName = null;
		String arr[] = discInfo.getServerTypes();
		String test_name = request.getParameter("t_name");
		String server_type = request.getParameter("comptype");
		String component_name = request.getParameter("ComponentsForInclusion");
		String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");
		String allAggServerTypes[] = aggIni.getVariables("COMPONENT_TYPE_MAPPING");

		boolean hasAggTest = false;
		boolean hasAggServerType = false;
		boolean isAggregate = aggInfo.isAggregateTest(test_name) && server_type.startsWith("Agg_");

		if(!EgUtils.isNull((Object) allAggServerTypes))
		{
			for(int m=0;m<allAggServerTypes.length;m++)
			{
				String aggregatedServers = aggIni.getValue("COMPONENT_TYPE_MAPPING",allAggServerTypes[m]);
				if(aggregatedServers != null && !aggregatedServers.equals(""))
				{
					StringTokenizer stc = new StringTokenizer(aggregatedServers, ",");
					while(stc.hasMoreTokens())
					{
						String thisToken = stc.nextToken();
						if(thisToken.equals(server_type))
						{
							hasAggServerType = true;
						}
					}
				}
			}
		}

		if(!EgUtils.isNull((Object) test_name) && !EgUtils.isNull((Object) allAggTests))
		{
			for(int m=0;m<allAggTests.length;m++)
			{
				if(aggIni.getValue("AGGREGATE_TEST",allAggTests[m]).equals(test_name))
				{
					availTests.add(allAggTests[m]);
					aggregateTestName = allAggTests[m];
					hasAggTest = true;
				}
			}
		}

		ArrayList componentList = new ArrayList();
		if(component_name.startsWith(","))
			component_name = component_name.substring(1);
		componentList.addAll(Arrays.asList(StringUtils.getTokens(component_name,",")));
		IniFile agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
		if(component_name !=null && test_name != null && hasAggTest && server_type !=null && hasAggServerType)
		{
			String str="";
			for(int i=0;i<componentList.size();i++)
			{
				String componame = server_type +":"+ (String) componentList.get(i);
				String compoType = componame.substring(0,componame.indexOf(":"));
				String compName = componame.substring(componame.indexOf(":")+1);
				String nickName = compName.substring(0, compName.indexOf(":"));
				int minTestPeriod = -1;

				List agentNames = extInfo.getAgentsFor(test_name, compoType, nickName);
				for(int idx=0;idx<agentNames.size();idx++)
				{
					String s_temp="";
					String testParams ="";
					String cSubject = (String) agentNames.get(idx);

					String specificPattern_A = test_name + ":" + compoType + ":" + compName;
					String specificPattern_B = test_name + ":" + compoType + ":" + compName.substring(0,compName.indexOf(":"));
					String defaultPattern_A = test_name + "::" + compName;
					String defaultPattern_B = test_name + "::" + compName.substring(0,compName.indexOf(":"));

					List aListTempVariables = Arrays.asList(agentIni.getVariables(cSubject));
					if (aListTempVariables.contains(specificPattern_A))
					{
						s_temp = specificPattern_A;
					}
					else if (aListTempVariables.contains(specificPattern_B))
					{
						s_temp = specificPattern_B;
					}
					else if (aListTempVariables.contains(defaultPattern_A))
					{
						s_temp = defaultPattern_A;
					}
					else if (aListTempVariables.contains(defaultPattern_B))
					{
						s_temp = defaultPattern_B;
					}

					if (s_temp.equalsIgnoreCase("")) continue;

					testParams = agentIni.getValue(cSubject, s_temp);
					if(testParams.length()>0)
					{
						String timePeriod = testParams.substring(testParams.lastIndexOf(EgConstants.COMMA)+1).trim();
						int testFreq = Integer.parseInt(timePeriod);
						if(testFreq>minTestPeriod)
						{
							str = testParams;
							minTestPeriod = testFreq;
						}
					}
				}
			}

			if(!EgUtils.isNull((Object) str))
			{
				String testFreq = str.substring(str.lastIndexOf(EgConstants.COMMA)+1).trim();
				IniFile  extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
				String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");
				String aggCompName = null;
				String aggNickName = null;
				String egComp = server_type + ":" + (String) componentList.get(0);
				Vector aggCompWithType = new Vector();
				if(!EgUtils.isNull((Object) variables))
				{
					for(int a=0;a<variables.length;a++)
					{
						String aggCompAndType = variables[a].substring(0,variables[a].indexOf("#"));
						String assoCompAndType = variables[a].substring(variables[a].indexOf("#")+1);
						if(assoCompAndType.startsWith(egComp))
						{
							aggCompWithType.add(aggCompAndType);
						}
					}
					if(!EgUtils.isNull((Object) aggCompWithType))
					{
						for (int b=0;b<aggCompWithType.size();b++)
						{
							String thisName = (String)aggCompWithType.get(b);
							if(!managedComps.contains(thisName))
								continue;
							String thisType = thisName.substring(0,thisName.indexOf(":"));
							aggCompName = thisName.substring(thisName.indexOf(":")+1);
							aggNickName = aggCompName.substring(0,aggCompName.indexOf(":"));
							String extAgentName = extIni.getValue("Test_Mapping_Section", aggNickName);
							if(!EgUtils.isNull((Object) extAgentName))
							{
								String[] extAgents = StringUtils.getTokens(extAgentName, ",");
								if(!EgUtils.isNull((Object)extAgents))
								{
									for(int i=0;i<extAgents.length;i++)
									{
										String thisAgent = (String)extAgents[i];
										if(!EgUtils.isNull((Object)thisAgent))
										{
											Iterator itr = availTests.iterator();
											while(itr.hasNext())
											{
												String variable = "";
												String testParams = "";
												aggregateTestName = (String) itr.next();
												boolean portRel = egSpecs.isPortRelevantForTest(aggregateTestName);

												if(portRel)
												{
													if(thisType.endsWith("_ex"))
														variable = aggregateTestName+":"+thisType+":"+aggCompName;
													else
														variable = aggregateTestName+"::"+aggCompName;
													testParams = agentIni.getValue(thisAgent,variable);
												}
												else
												{
													variable = aggregateTestName+"::"+aggNickName;
													testParams = agentIni.getValue(thisAgent,variable);
												}

												if (testParams==null || testParams.trim().length()==0)
												{
													continue;
												}

												String oldFreq = testParams.substring(testParams.lastIndexOf(EgConstants.COMMA)+1).trim();

												if (Integer.parseInt(oldFreq) < Integer.parseInt(testFreq))
												{
													testParams = "-manual," + testParams.substring(testParams.indexOf(EgConstants.COMMA)+1,testParams.lastIndexOf(EgConstants.COMMA))+", "+testFreq;
												}
												agentIni.setValue(thisAgent,variable,testParams);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else if(isAggregate)
		{
			int maxFreq = 5;
			for(int i=0;i<componentList.size();i++)
			{
				String thisComponent = (String)componentList.get(i);
				List assComps = aggInfo.getAssociatedComponents(server_type+":"+thisComponent, true);
				for(int j=0;j<assComps.size();j++)
				{
					String testName = aggInfo.getTestName(test_name);
					String egServerName = (String)assComps.get(j);
					String testFreq = "";
					if(egServerName != null && !egServerName.equals(""))
					{
						testFreq = agentInfo.getTestFrequency(egServerName, testName);
						int thisFreq = 5;
						if(testFreq != null && !testFreq.equals(""))
							thisFreq = Integer.parseInt(testFreq);
						if(thisFreq > maxFreq)
							maxFreq = thisFreq;
					}
				}
				String aggAgent = aggInfo.getAgentForAggComponent(thisComponent.substring(0, thisComponent.lastIndexOf(":")));
				String thisParam = agentIni.getValue(aggAgent ,test_name+"::"+thisComponent);
				String mode = thisParam.substring(0, thisParam.indexOf(EgConstants.COMMA)).trim();
				String oldFreq = thisParam.substring(thisParam.lastIndexOf(EgConstants.COMMA)+1).trim();
				if(mode.equals("-auto"))
					thisParam = "-manual,"+thisParam.substring(thisParam.indexOf(EgConstants.COMMA)+1);
				if(oldFreq != null && !oldFreq.equals(""))
				{
					if(maxFreq > Integer.parseInt(oldFreq))
					{
						thisParam = thisParam.substring(0,thisParam.lastIndexOf(EgConstants.COMMA))+", "+maxFreq;
						agentIni.setValue(aggAgent ,test_name+"::"+thisComponent, thisParam);
					}
				}
				else
				{
					thisParam = thisParam.substring(0,thisParam.lastIndexOf(EgConstants.COMMA))+", "+maxFreq;
					agentIni.setValue(aggAgent ,test_name+"::"+thisComponent, thisParam);
				}
			}
		}
		agentIni.saveFile();
		EgConfigFilesSync.releaseInstance(agentIni);
	}
	/* For aggregate test frequency setting ends */
%>

	<jsp:forward page="<%=ur%>" />



