<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgURLEncoder" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<html>
<head>
<egui:skin ui="admin"/>
<META HTTP-EQUIV="expires" CONTENT="0">
</head>

<%
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String strComponentType = request.getParameter("comptype");
	String strComponentName = request.getParameter("compname");
	String strTestName = request.getParameter("test");
	String from = request.getParameter("from");
	String descriptorName = request.getParameter("descName");
	String isRefine = request.getParameter("isRefine");
	String comeFrom = request.getParameter("comeFrom");
	boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(strTestName);
	String displayComponentName = "";
	if (strComponentName.indexOf(":NULL") > -1)
	{
		displayComponentName = strComponentName.substring(0,strComponentName.indexOf(":"));
	}
	else
	{
		displayComponentName = strComponentName;
	}

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] componentsList = null;
	ArrayList aListExpectedComponents = (ArrayList) session.getAttribute("aListExpectedComponents");
	if(aListExpectedComponents != null && aListExpectedComponents.contains(strComponentName))
	{
		aListExpectedComponents.remove(strComponentName);
	}
	//remove the component from the aListExpectedComponents whose test is excluded - starts
	ArrayList excludeComponents  = new ArrayList();
	prgBean.createFile("eg_disable.ini");
	if (isPortRelevantForTest)
	{
		String[] variables = prgBean.getVariables(strComponentType);
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String pattern = tempComp;
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue(strComponentType,pattern);
				if (value.indexOf(strTestName) > -1)
				{
					excludeComponents.add(tempComp);
				}
			}
		}
	}
	else
	{
		String[] variables = prgBean.getVariables("Default_server");
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String strCompName = tempComp.substring(0,tempComp.indexOf(":"));
			String pattern = "Default_server:"+strCompName;
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue("Default_server",pattern);
				if (value.indexOf(strTestName) > -1)
				{
					excludeComponents.add(tempComp);
				}
			}
		}
	}

	if(excludeComponents != null && excludeComponents.size() > 0)
	{
		aListExpectedComponents.removeAll(excludeComponents);
	}

	if(aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
	{
		List tempList = new ArrayList();
		for(int a=0;a<aListExpectedComponents.size();a++)
		{
			String strExpectComp = (String) aListExpectedComponents.get(a);
			String fullCompName = strComponentType+":"+strExpectComp;
			tempList.add(fullCompName);
		}
		aListExpectedComponents = new ArrayList(tempList);
	}
	//remove the component from the aListExpectedComponents whose test is excluded - ends

	//For Zones, Services, Segments and Components - Start
	String ea_criteria = request.getParameter("ea_criteria");
	if (ea_criteria == null)
	{
		ea_criteria = "Component";
	}
	String ea_criteriaPrevious = request.getParameter("ea_criteriaPrevious");
	String ea_userOption = request.getParameter("ea_userOption");
	if (ea_criteria != null && 
		ea_criteriaPrevious != null && 
		!ea_criteriaPrevious.equals(ea_criteria))
	{
		ea_userOption = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	EgGroupInfo egGroupInfo = new EgGroupInfo();
	EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();
	Vector vecUserOptions = null;
	ArrayList aListAssociatedComponents = new ArrayList();
	if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Zone"))
	{
		List zoneList = _user.getZones();
		//To fetch all components from user associated zones
		ArrayList aListComponentsFromZone = new ArrayList();
		if (zoneList != null && !zoneList.isEmpty())
		{
			vecUserOptions = new Vector(zoneList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strZone = (String)vecUserOptions.get(i);
				ArrayList aListCompsUnderZone = egGroupInfo.getAllComponentsUnderZone(strZone,true);
				aListComponentsFromZone.addAll(aListCompsUnderZone);
				for (int j=0;j<aListCompsUnderZone.size();j++)
				{
					String compUnderZone = (String)aListCompsUnderZone.get(j);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						vecTemp.add(strZone);
						break;
					}
				}
			}
			vecUserOptions = vecTemp;
		}

		if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
		{
			boolean defaultZoneExists = false;
			for (int i=0;i<aListExpectedComponents.size();i++)
			{
				String component = (String)aListExpectedComponents.get(i);
				if (!aListComponentsFromZone.contains(component))
				{
					defaultZoneExists = true;
					break;
				}
			}

			if (defaultZoneExists)
			{
				vecUserOptions.add(0,"--Default--");
			}
		}
		else
		{
			if (aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
			{
				vecUserOptions = new Vector();
				vecUserOptions.add("--Default--");
			}
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			if (!ea_userOption.equalsIgnoreCase("--Default--"))
			{
				ArrayList aListCompsUnderChosenZone = egGroupInfo.getAllComponentsUnderZone(ea_userOption,true);
				for (int i=0;i<aListCompsUnderChosenZone.size();i++)
				{
					String compUnderZone = (String)aListCompsUnderChosenZone.get(i);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						aListAssociatedComponents.add(compUnderZone);
					}
				}
			}
			else
			{
				aListAssociatedComponents = new ArrayList();
				for (int i=0;i<aListExpectedComponents.size();i++)
				{
					String userComponent = (String)aListExpectedComponents.get(i);
					int index = aListComponentsFromZone.indexOf(userComponent);
					if (index == -1)
					{
						aListAssociatedComponents.add(userComponent);
					}
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Service"))
	{
		List serviceList = new ArrayList();
		serviceList.addAll(_user.getServices());
		ArrayList aListSites = new ArrayList();
		aListSites.addAll(_user.getSites());
		aListSites.removeAll(serviceList);
		serviceList.addAll(aListSites);
		if (serviceList != null && !serviceList.isEmpty())
		{
			vecUserOptions = new Vector(serviceList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strService = (String)vecUserOptions.get(i);
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(strService);
				for (int j=0;j<vecServiceComponents.size();j++)
				{
					String compUnderService = (String)vecServiceComponents.get(j);
					int index = aListExpectedComponents.indexOf(compUnderService);
					if (index != -1)
					{
						vecTemp.add(strService);
						break;
					}
				}
			}
			vecUserOptions = vecTemp;
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ea_userOption);
			for (int i=0;i<vecServiceComponents.size();i++)
			{
				String compUnderService = (String)vecServiceComponents.get(i);
				int index = aListExpectedComponents.indexOf(compUnderService);
				if (index != -1)
				{
					aListAssociatedComponents.add(compUnderService);
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Segment"))
	{
		List segmentList = _user.getSegments();
		if (segmentList != null && !segmentList.isEmpty())
		{
			vecUserOptions = new Vector(segmentList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strSegment = (String)vecUserOptions.get(i);
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(strSegment,2);
				for (int j=0;j<vecSegmentComponents.size();j++)
				{
					String compUnderSegment = (String)vecSegmentComponents.get(j);
					int index = aListExpectedComponents.indexOf(compUnderSegment);
					if (index != -1)
					{
						vecTemp.add(strSegment);
						break;
					}
				}
			}
			vecUserOptions = vecTemp;
		}
		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ea_userOption,2);
			for (int i=0;i<vecSegmentComponents.size();i++)
			{
				String compUnderSegment = (String)vecSegmentComponents.get(i);
				int index = aListExpectedComponents.indexOf(compUnderSegment);
				if (index != -1)
				{
					aListAssociatedComponents.add(compUnderSegment);
				}
			}
		}
	}

	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase("Component"))
	{
		aListExpectedComponents = aListAssociatedComponents;
	}
	//For Zones, Services, Segments and Components - End

%>
<body style="overflow:auto" id="space6">
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">
function applyToComponent()
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;

	if (unmanagedComponentList.selectedIndex == -1)
	{
		alert(_valcomponent);
		return;
	}

	for (var i=0; i<unmanagedComponentLen; i++)
	{
		if (unmanagedComponentList.options[i].selected == true)
		{
			var compTxt = unmanagedComponentList.options[i].text;
			var compVal = unmanagedComponentList.options[i].value;
			managedComponentList.options[managedComponentLen++] = new Option(compTxt,compVal);
		}
	}

	for (var i = unmanagedComponentLen; i>0; i--)
	{
		if(unmanagedComponentList.options[i-1].selected == true)
		{
			unmanagedComponentList.options[i-1] = null;
		}
	}
}

function manageCompToUnmanageComp()
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;

	if (managedComponentList.selectedIndex == -1)
	{
		alert(_valcomponent);
		return;
	}

	for (var i=0; i<managedComponentLen; i++)
	{
		if (managedComponentList.options[i].selected == true)
		{
			var compTxt = managedComponentList.options[i].text;
			var compVal = managedComponentList.options[i].value;
			unmanagedComponentList.options[unmanagedComponentLen++] = new Option(compTxt,compVal);
		}
	}

	for (var i = managedComponentLen; i>0; i--)
	{
		if(managedComponentList.options[i-1].selected == true)
		{
			managedComponentList.options[i-1] = null;
		}
	}
}

function getDetails()
{
	var thisForm = document.list;
	thisForm.action = "../admin/EgApplyThresholdsToOtherComponents.jsp";
	thisForm.submit();
}

function updateThresholds(operation)
{
	xmlhttp = null;
	var thisForm = document.list;
	var compType = thisForm.comptype.value;
	var compName = thisForm.compname.value;
	var test = thisForm.test.value;
	var descName = thisForm.descName.value;
	var managedComponentLen = thisForm.managed.options.length;
	var selectedComponents = "";

	if (managedComponentLen==0 && parametersSelected)
	{
		alert('<egui:intnl text="admin.test.Please choose component(s) to be configured"/>');
		return;
	}
	var managedComponentList = thisForm.managed;
	for (var i=0; i<managedComponentLen; i++)
	{
			var compVal = managedComponentList.options[i].value;
			if (selectedComponents!="")
			{
				selectedComponents = selectedComponents + ",";
			}
			selectedComponents = selectedComponents + compVal;
	}

	if (window.XMLHttpRequest)
	{
		xmlhttp=new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	if (xmlhttp != null)
	{
		var params = "componentType="+encodeURI(compType)+"&componentName="+encodeURI(selectedComponents)+"&testName="+encodeURIComponent(test)+"&descriptorName="+encodeURIComponent(descName)+"&from=specificTest&isApply=true&operation="+operation+"&parentComp="+encodeURIComponent(compName);
		var url = "/final/admin/EgApplySpecificThresholdsForAllComps.jsp";
		xmlhttp.onreadystatechange = state_Change3;
		xmlhttp.open('POST',url,true);
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.send(params);
	}
	else
	{
		alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
	}
}

function state_Change3()
{
	var thisForm = document.list;
	if (xmlhttp.readyState == 4)
	{
		try
		{
			if (xmlhttp.status == 200)
			{
				var url = "EgConfigureThresholdsResult.jsp?comptype=<%=EgURLEncoder.encode(strComponentType,"UTF-8")%>&compname=<%=EgURLEncoder.encode(strComponentName,"UTF-8")%>&test=<%=EgURLEncoder.encode(strTestName,"UTF-8")%>&isRefine=<%=isRefine%>&descName="+"<%=EgURLEncoder.encode(descriptorName,"UTF-8")%>&from=specificTest";
				window.location.href = url;
			}
		}
		catch (error)
		{
			alert(error);
		}
	}
}
</script>
<form name="list" method="post" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=ALERT - THRESHOLDS - APPLY CONFIGURATION&subtitle=false&backButton=true"/>
	<tr>
		<td align="center">
			<table width="85%" cellpadding="4" cellspacing="0" border="0" valign="top" class="linesquare2">
				<tr>
					<td class="linebg">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
<%								if(!StringUtils.isNull(descriptorName))
								{
%>
									<td align="left"><strong><egui:intnl text="admin.test.Specific thresholds for the"/>&nbsp;'<%=descriptorName%>'&nbsp;descriptor of the&nbsp;'<%=_mapping.getTestDescription(strTestName)%>'&nbsp;test<strong></td>
									<td align="right"><strong>Component&nbsp;:</strong>&nbsp;<%=displayComponentName%>&nbsp;(<egui:intnl type="<%=strComponentType%>"/>)</td>

<%
								}
								else
								{
%>
									<td align="left"><strong><egui:intnl text="admin.test.Specific thresholds for the"/>&nbsp;'<%=_mapping.getTestDescription(strTestName)%>'&nbsp;test<strong></td>
									<td align="right"><strong>Component&nbsp;:</strong>&nbsp;<%=displayComponentName%>&nbsp;(<egui:intnl type="<%=strComponentType%>"/>)</td>
									
<%
								}
%>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr><td class="eg_blankspace" height="10px">&nbsp;</td></tr>

	<tr>
		<td style="padding:0px">
			<table align="center" cellspacing="0" cellpadding="4" border="0" width="85%" class="linesquare2">
				<tr><td class="linebg" colspan="3"><strong><egui:intnl text="admin.test.Components"/></strong></td></tr>
				<tr><td class="eg_blankspace" height="2px" colspan="3">&nbsp;</td></tr>

				<!-- new panel start here -->
				<tr>
					<td id="padding2" style="padding-bottom:0px" colspan="3">
						<table align="center" cellspacing="0" cellpadding="4" width="98%" border="0" id="top table" style="table-layout:fixed" class="linebg2">
							<col width="55"><col width="10"><col width="170">
							<col width="80"><col width="10"><col width="420">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ea_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ea_criteria != null && strCriteria.equals(ea_criteria))
			{
				selected = "selected";
			}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
		}
	}
	else
	{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase(criterias[3]) && !ea_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ea_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ea_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ea_userOption != null && strUserOption.equals(ea_userOption))
				{
					selected = "selected";
				}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
			}
		}
		else
		{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new panel end here -->

				<tr><td class="eg_blankspace" height="2px" colspan="3">&nbsp;</td></tr>
				<tr>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.server.components to be configured"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="managed" size="11" multiple width="320" style="width:320px;"></select>
								</td>
							</tr>
						</table>
					</td>
					<td width="10%" align="center" valign="middle"  style="padding:0px">
						<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" onClick="javascript:applyToComponent();" name="man" style="width: 85px; letter-spacing: 0px;"><br><br><br>
						<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:manageCompToUnmanageComp();" name="unman" style="width: 85px; letter-spacing: 0px;">
					</td>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.server.Existing components"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="unmanaged" size="11" multiple width="320" style="width:320px;">
<%
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String strComponent = (String)aListExpectedComponents.get(i);
			strComponent = strComponent.substring(strComponent.indexOf(":")+1,strComponent.length());
			String str = strComponent;
			if (str.indexOf(":NULL") > -1)
			{
				str = str.substring(0,str.indexOf(":"));
			}
%>
										<option value="<%=strComponent%>"><%=str%></option>
<%
		}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
			</table>
		</td>
	</tr>
	<tr><td class="eg_blankspace" height="6px">&nbsp;</td></tr>
	<tr>
		<td width="100%" align="center">
			<input type="button" value='<egui:intnl text="admin.test.Apply"/>' onClick="javascript:updateThresholds('updateThresholds');" class="eg_back">
			<input type="hidden" name="selectedParameters" value="">
			<input type="hidden" name="selectedComponents" value="">
			<input type="hidden" name="comptype" value="<%=strComponentType%>">
			<input type="hidden" name="compname" value="<%=strComponentName%>">
			<input type="hidden" name="test" value="<%=strTestName%>">
			<input type="hidden" name="descName" value="<%=descriptorName%>">
			<input type="hidden" name="requestFrom" value="EgApplyThresholdsToOtherComponents.jsp">
			<input type="hidden" name="ea_criteriaPrevious" value="<%=ea_criteria%>">
		</td>
	</tr>
</table>
</form>
</body>
</html>



