<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.ServerBean"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "net.sf.json.*"%>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="port" scope="page" class="egurkha.ServiceBean"/>

<%
	JSONObject rootObj = new JSONObject();
	JSONObject generalSettings = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	String from=request.getParameter("from");
	String selectedCompDetails = request.getParameter("selectedCompDetails");
	
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgDiscInfo egDisc = new EgDiscInfo("manager");
	
	if (from.equalsIgnoreCase("commonSettings"))
	{
		IniFile infraPtr = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		String DiscOptions = request.getParameter("DiscOptions");
		String serverDisplay = request.getParameter("ServerDisplay");
		String loadCount = request.getParameter("LoadCount");

		port.createAdmin();
		DiscBean.createAdmin();

		// server category - start
		JSONObject serverCategory = new JSONObject();
		JSONArray serverCategoryArr = new JSONArray();
		generalSettings.put("isAllSelected",DiscOptions);

		serverCategory.put("displayField",_mapping.getTextDescription("admin.discovery.ALL"));
		serverCategory.put("valueField","all");
		serverCategoryArr.add(serverCategory);

		ArrayList serverGrps = getAllServerGroups();
		for(int i=0; i<serverGrps.size(); i++)
		{
			serverCategory = new JSONObject();
			String tmpServerGrp = (String)serverGrps.get(i);
			serverCategory.put("valueField",tmpServerGrp);
			serverCategory.put("displayField",_mapping.getTextDescription("admin.category."+tmpServerGrp));
			serverCategoryArr.add(serverCategory);
		}
		generalSettings.put("serverCategoryArr",serverCategoryArr);
		// server category - end
		
		ArrayList serverList = new ArrayList();
		ArrayList serverDisplayList = new ArrayList();
		ArrayList compList = new ArrayList();
		ArrayList manageSrvrListShow = new ArrayList();

		if (selectedCompDetails != null && selectedCompDetails.length() > 0)
		{
			StringTokenizer str = new StringTokenizer(selectedCompDetails,",");
			while (str.hasMoreTokens())
			{
				String tmp = str.nextToken();
				if (!compList.contains(tmp))
				{
					compList.add(tmp);
				}
			}
		}

		String[] server_manage_types = null;
		if (serverDisplay != null && serverDisplay != "")
		{
			StringTokenizer serverDisplayTkns = new StringTokenizer(serverDisplay, ",");
			while(serverDisplayTkns.hasMoreElements())
			{
				String serverDisplayTkn = (String)serverDisplayTkns.nextToken();
				serverDisplayList.add(serverDisplayTkn);
			}
			server_manage_types = (String[])serverDisplayList.toArray(new String[0]);
		}

		if(DiscOptions==null || DiscOptions.length()==0) DiscOptions = "all";
		String categoryOptions="";
		StringBuffer categoryBuff = new StringBuffer();
		StringTokenizer stz = new StringTokenizer(DiscOptions,",");
		while(stz.hasMoreTokens())
		{
			String tok = stz.nextToken();
			if(tok.equalsIgnoreCase("all"))
			{
				DiscOptions = "all";
				break;
			}
		}
		if(DiscOptions.equalsIgnoreCase("all"))
		{
			String[] categVar = infraPtr.getSubjects();
			if(categVar!=null && categVar.length>0)
			{
				for(int i=0;i<categVar.length;i++)
				{
					String var = (String)categVar[i];
					categoryBuff.append(var);
					categoryBuff.append(",");
				}
			}
			categoryBuff.append("OTHERS");
			categoryOptions = categoryBuff.toString();
		}
		else 
		{
			categoryOptions = DiscOptions;
		}
		
		String[] servertypes = egDisc.getComponentTypes();
		for(int i=0; i<servertypes.length; i++)
		{
			if (!servertypes[i].equals("Site_servers"))
			{
				serverList.add(servertypes[i]);
			}
		}
		if(DiscOptions!=null && DiscOptions.equalsIgnoreCase("all"))
		{
			if (server_manage_types != null)
			{
				for (int i=0;i<server_manage_types.length;i++)
				{
					if (serverList.contains(server_manage_types[i])  && !manageSrvrListShow.contains(server_manage_types[i]))
					{
						manageSrvrListShow.add(server_manage_types[i]);
					}
				}
			}
		}
		serverList = sorter.getSortedCompTypeList(serverList);
		
		if(DiscOptions!=null && !DiscOptions.equalsIgnoreCase("all"))
		{
			DiscOptions = DiscOptions.trim();
			ArrayList serversGrpList = new ArrayList();
			if (DiscOptions.equalsIgnoreCase("Others"))
			{
				serversGrpList = getOtherServers();
			}
			else if (DiscOptions.equalsIgnoreCase("CUSTOM COMPONENTS"))
			{
				serversGrpList = getAllUserDefinedServers();
			}
			else
			{
				serversGrpList = getCategorizedComponents(DiscOptions);
			}

			if (server_manage_types != null)
			{
				for (int i=0;i<server_manage_types.length;i++)
				{
					if (serversGrpList.contains(server_manage_types[i]) && !manageSrvrListShow.contains(server_manage_types[i]))
					{
						manageSrvrListShow.add(server_manage_types[i]);
					}
				}
			}
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
		
		JSONArray tmpList = new JSONArray();
		JSONObject tmpObject = new JSONObject();
		JSONObject availSrvrObj = new JSONObject();
		JSONArray discSrvrArray = new JSONArray();
		int colCount = 0;

		compList = sorter.getSortedCompTypeList(compList);

		for (int i = 0;i<compList.size();i++)
		{
			colCount++;
			EgName nameObj = (EgName)compList.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			availSrvrObj.put("displayField",tmpDis);
			availSrvrObj.put("valueField",tmpVal);
			discSrvrArray.add(availSrvrObj);
			
			if (colCount == 3)
			{
				tmpObject.put("col_"+colCount , tmpDis);
				tmpObject.put("valueField_"+colCount , tmpVal);
				tmpList.add(tmpObject);
				tmpObject = new JSONObject();
				colCount = 0;
			}
			else
			{
				tmpObject.put("col_"+colCount , tmpDis);
				tmpObject.put("valueField_"+colCount , tmpVal);
			}
		}
		if (colCount == 1)
		{
			tmpObject.put("col_2","");
			tmpObject.put("col_3","");
			tmpObject.put("valueField_2" , "");
			tmpObject.put("valueField_3" , "");
			tmpList.add(tmpObject);
		}
		if (colCount == 2)
		{
			tmpObject.put("col_3","");
			tmpObject.put("valueField_3" , "");
			tmpList.add(tmpObject);
		}

		generalSettings.put("configuredServersList",tmpList);
		generalSettings.put("configuredServersCount",compList.size());

		int count = 0;
		JSONArray serverTypesArr = new JSONArray();
		for (int i=0;i<serverList.size();i++)
		{
			JSONObject tmServer = new JSONObject();
			EgName tmpServer = (EgName)serverList.get(i);
			String actualName = (String)tmpServer.getActualName();
			String displayName = (String)tmpServer.getLocalName();
			tmServer.put("displayField",displayName);
			tmServer.put("valueField",actualName);
			serverTypesArr.add(tmServer);
		}
		
		JSONArray selectedSrvrTypesArr = new JSONArray();
		if (serverDisplay != null && serverDisplay != "")
		{
			manageSrvrListShow = sorter.getSortedCompTypeList(manageSrvrListShow);
			JSONObject tempSrvr = new JSONObject();
			for(int m=0; m<manageSrvrListShow.size(); m++)
			{
				EgName nameObj1 = (EgName)manageSrvrListShow.get(m);
				String tmpVal1 = nameObj1.getActualName();
				String tmpDis1 = nameObj1.getLocalName();
				tempSrvr.put("displayField",tmpDis1);
				tempSrvr.put("valueField",tmpVal1);
				selectedSrvrTypesArr.add(tempSrvr);
			}
			generalSettings.put("discSrvrArray",selectedSrvrTypesArr);
			serverTypesArr.removeAll(selectedSrvrTypesArr);
		}
		else if (serverDisplay == null && loadCount != null)
		{
			if (loadCount.equalsIgnoreCase("0"))
			{
				generalSettings.put("discSrvrArray",discSrvrArray);
				serverTypesArr.removeAll(discSrvrArray);
			}
		}
		else
		{
			discSrvrArray.clear();
			generalSettings.put("discSrvrArray",discSrvrArray);
		}
		generalSettings.put("allSrvrArray",serverTypesArr);
		
		rootObj.put("generalSettings",generalSettings);
	}
	out.println(rootObj.toString());
%>

<%!
	public ArrayList getAllServerGroups()
	{
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				grp.add(Subjects[i]);
			}
			ArrayList icTypes = getAllUserDefinedServers();
			if (com.eg.EgMemInfo.icEnabled && icTypes != null && icTypes.size()>0)
			{
				grp.add("CUSTOM COMPONENTS");
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			ArrayList otherServers = getOtherServers();
			if (otherServers.size() > 0)
			{
				grp.add("OTHERS");
			}
			EgAggregateInfo egagg=new EgAggregateInfo("manager");
			Vector aggComp = egagg.getAggregateTypes();
			if (aggComp == null || aggComp.size() == 0)
			{
				grp.remove("AGGREGATES");
			}
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}

	public ArrayList getOtherServers()
	{
		ArrayList tempServers = getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}
		for(int i=0; i<otherServers.length; i++)
		{
			if (!otherServers[i].equals("Site_servers") && !otherServers[i].toLowerCase().endsWith("_ex"))
			{
				if (!tempServers.contains(otherServers[i]))
				{
					serverList.add(otherServers[i]);
				}
			}
		}
		return serverList;
	}
	
	public ArrayList getAllUserDefinedServers()
	{
		Map serverList = new HashMap();
		ServerBean serverBean = new ServerBean();
		Hashtable allSrvMap = serverBean.getAllServerMap();
		ArrayList udServers = (ArrayList)allSrvMap.get("UDSERVERS");	//userdefined servers
		if(udServers != null && udServers.size()>0)
		{
			for(int i=udServers.size()-1;i>=0;i--)
			{
				String ud_server = (String)udServers.get(i);
				if(udServers.get(i).toString().startsWith("Agg_"))
				{
					udServers.remove(i);
				}
			}
		}
		return udServers;
	}

	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}

	public ArrayList getAllInfraServers()
	{
		ArrayList tempServers = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					if(!tempServers.contains(variables[j]))
						tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		return tempServers;
	}

	public ArrayList getCategorizedComponents(String compGroup)
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();

			String [] variables = iniFile.getVariables(compGroup);
			for (int j = 0;j<variables.length;j++)
			{
				comGroups.add(variables[j]);
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		if (!EgInstallInfo.isnamedUserLicense && !EgInstallInfo.isconcurrentUserLicense) //server based license, then remove Cloud_VMs type
		{
			comGroups.removeAll(EgInstallInfo.getUserCertSpecificTypes());
		}
		return comGroups;
	}
%>



