<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="com.eg.EgLicenseInfo"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="egurkha.UserBean" %>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	JSONObject logList = new JSONObject();
	JSONArray logListArray =new  JSONArray();
	JSONObject logDirList = new JSONObject();
	JSONArray logDirListArray =new  JSONArray();
	LinkedHashMap directoryMap = new LinkedHashMap();
	directoryMap.put("Select a log directory","-1");
	ArrayList logFileList = new ArrayList();

	String agentType = request.getParameter("agentType");
	if(agentType == null || agentType.trim().length() == 0)
	{
		agentType = "PremiumAgents";
	}
	
	String USER_COMP_AGENTS = "Agents for user licensed types";
	String[] agent_types = {"BasicAgents","PremiumAgents", "ExternalAgents", "RemoteAgents"};

	boolean agentStatusLog = false;
	IniFile serviceIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String agentStLog = serviceIni.getValue("MISC_ARGS","AgentStatusLog"); 
	if(agentStLog != null && (agentStLog.equalsIgnoreCase("yes") || agentStLog.equalsIgnoreCase("true")))
	{
		agentStatusLog = true;
	}

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID());
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean hasAllCompAccess = roleInfo.hasAllComponentAccess();
	EgServerList serverList = new EgServerList();
	boolean isUserBasedCert = false;

	ArrayList agentTypes = new ArrayList(Arrays.asList(agent_types));
	
	ArrayList noLiceList = EgInstallInfo.getCertCheckList();
	boolean agentsWithNoLicense = (noLiceList != null && noLiceList.size() > 0);
	if(agentsWithNoLicense)
	{
		agentTypes.add("Agents with no license");
	}
	
	if (usersInfo.getUserAllowedCount() > 0)
	{
		agentTypes.add(USER_COMP_AGENTS);
		isUserBasedCert = true;
	}
	
	JSONArray agentTypesArray = new JSONArray();
	for(int i=0;i<agentTypes.size();i++)
	{
		String agent_type = (String)agentTypes.get(i);
		JSONObject typeObj = new JSONObject();
		typeObj.put("valueField",agent_type);
		typeObj.put("displayField",_mapping.getTextDescription("admin.agents."+agent_type));
		agentTypesArray.add(typeObj);
	}
	rootJson.put("agentTypes",agentTypesArray);

	ArrayList noLicenseAgentList = userBean.getAgentsWithNoLicense();
	ArrayList agentList = new ArrayList();
	if(agentType.equalsIgnoreCase("ExternalAgents"))
	{
		agentList = hasAllCompAccess ? licInfo.getExternalAgents() : roleInfo.getExternalAgents();
	}
	else if(agentType.equalsIgnoreCase("BasicAgents"))
	{
		agentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
	}
	else if(agentType.equalsIgnoreCase("PremiumAgents"))
	{
		agentList = hasAllCompAccess ? userBean.getPremiumAgents() : roleInfo.getPremiumAgents();
	}
	else if(agentType.equalsIgnoreCase("RemoteAgents"))
	{
		agentList = hasAllCompAccess ? licInfo.getRemoteAgents() : roleInfo.getRemoteAgents();
	}
	else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
	{
		agentList = hasAllCompAccess ? userBean.getPremiumAgents(true) : roleInfo.getPremiumAgents(true);
		if (noLicenseAgentList != null && noLicenseAgentList.size() > 0)
		{
			agentList.removeAll(noLicenseAgentList);
		}
		ArrayList basicAgentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
		if (basicAgentList != null && basicAgentList.size() > 0)
		{
			agentList.removeAll(basicAgentList);
		}
	}
	else if (agentType.equalsIgnoreCase("Agents with no license"))
	{
		if(hasAllCompAccess)
		{
			agentList.addAll(noLicenseAgentList);
		}
		else
		{
			ArrayList tmpListCertCheckList = EgInstallInfo.getCertCheckList();
			ArrayList noLicenseComTypes  = new ArrayList();
			if (tmpListCertCheckList != null)
			{
				int size = tmpListCertCheckList.size();
				for (int t=0; t<size; t++)
				{
					String compType = (String)tmpListCertCheckList.get(t);
					compType = EgCrypt.decrypt(compType);
					noLicenseComTypes.add(compType);
				}
			}

			ArrayList allServersList = roleInfo.getAllServers();
			int allServerListSize = allServersList.size();
			for(int i = 0; i<allServerListSize; i++)
			{
				String temp = (String)allServersList.get(i);
				int cmpInd = temp.indexOf(":");
				String s_compType = temp.substring(0,cmpInd);
				if(noLicenseComTypes.contains(s_compType))
				{
					temp = temp.substring(cmpInd+1);
					String s_compNick = temp.substring(0,temp.indexOf(":"));
					agentList.add(s_compNick);
				}
			}
			agentList.retainAll(noLicenseAgentList);
		}
	}

	ArrayList aList = serverList.getAgentListFromDB();
	String currList[] = serverList.getTargetNames();
	Map allAgentsMap = serverList.getAgentList(agentList,aList,currList,"Running");
	ArrayList agentIPList = new ArrayList(allAgentsMap.keySet());

	JSONObject agentListObj = new JSONObject();
	JSONArray agentListArray = new JSONArray();
	String selDefault = agentIPList.isEmpty() ? "No agent IP/Nickname found" : "Select agent IP/Nickname";
	agentListObj.put("valueField","-1");
	agentListObj.put("displayField",selDefault);
	agentListArray.add(agentListObj);
	if(!agentIPList.isEmpty())
	{
		for(int i=0;i<agentIPList.size();i++)
		{
			String agent_ip = (String)agentIPList.get(i);
			agentListObj = new JSONObject();
			agentListObj.put("valueField",agent_ip);
			agentListObj.put("displayField",agent_ip);
			agentListArray.add(agentListObj);
		}
	}
	rootJson.put("agentListArray",agentListArray);

	String agentID = request.getParameter("componentName");
	if(agentID != null)
	{
		agentID = EgURLDecoder.decode(agentID,"UTF-8");
	}
	
	if(agentStatusLog)
	{
		logToErrorFile("");
		logToErrorFile("agentLogJson is called for agentID " + agentID);
	}
	String dirName = request.getParameter("dirname");

	boolean foldersAdded=false;
	IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	if(inifile != null)
	{
		Vector displayNames = inifile.getVariables("AGENT_LOG_FOLDERS",true);
		Vector actualNames = inifile.getAllValues("AGENT_LOG_FOLDERS");
		if(displayNames != null && actualNames != null)
		{
			int count = displayNames.size();
			if (count > 0)
			{
				foldersAdded = true;
			}
			for(int i=0;i<count;i++)
			{
				directoryMap.put((String)displayNames.get(i),(String)actualNames.get(i));
			}
		}
	}
	if(!foldersAdded)
	{
		directoryMap.put("Agent","agent/logs");
		directoryMap.put(".NET","agent/logs/.NetProfLogs");
	}
	Iterator dirListIter = directoryMap.keySet().iterator();
	while(dirListIter.hasNext())
	{
		String dispField = (String)dirListIter.next();
		String valueField = (String)directoryMap.get(dispField);
		logDirList.put("displayField",dispField);
		logDirList.put("valueField",valueField);
		logDirListArray.add(logDirList);
	}
	rootJson.put("logDirectoryList",logDirListArray);

	boolean showAlert=false;
	String alertMessage="-";
	if(dirName != null && !dirName.equals("-1"))
	{
		if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
		{
			agentID = agentID.substring(0,agentID.indexOf(":"));
		}
		RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
		if(helper.setAgentIntoControlMode(agentID))
		{
			if(agentStatusLog)
			{
				logToErrorFile("agentLogJson setAgentIntoControlMode is over for agentID " + agentID);
			}
			helper.executeTask("ListLogFiles", session.getId(), dirName + "@#@Y");
			if(helper.isOutputAvailable())
			{
				logFileList = helper.getOutput();
				if(agentStatusLog)
				{
					logToErrorFile("agentLogJson output available when list log files under directory "+dirName+" for agentID " + agentID);
				}
			}
			else
			{
				if(agentStatusLog)
				{
					logToErrorFile("agentLogJson output not available when list log files under directory "+dirName+" for agentID " + agentID);
				}
			}
		}
		String message=null;
		int filesCount=logFileList.size();
		if(filesCount==1)
		{
			message=((String)logFileList.get(0)).trim();
		}
		if(message !=null && message.equalsIgnoreCase("Directory does not exist"))
		{
			if(agentStatusLog)
			{
				logToErrorFile("agentLogJson "+dirName+" directory does not exists when list log files for agentID " + agentID);
			}
			showAlert=true;
			alertMessage="Selected directory does not exist";
			logList = new JSONObject();
			logListArray = new JSONArray();
			logList.put("displayField",message);
			logList.put("valueField","-1");
			logListArray.add(logList);
		}
		else if(message !=null && message.equalsIgnoreCase("Directory is empty"))
		{
			if(agentStatusLog)
			{
				logToErrorFile("agentLogJson "+dirName+" directory is empty when list log files for agentID " + agentID);
			}
			logList = new JSONObject();
			logListArray = new JSONArray();
			logList.put("displayField","Not Applicable");
			logList.put("valueField","-1");
			logListArray.add(logList);
		}
		else
		{
			if(agentStatusLog)
			{
				logToErrorFile("agentLogJson showing log files under this directory "+dirName+" for agentID " + agentID);
			}
			logList.put("displayField","Select a log file");
			logList.put("valueField","-1");
			logListArray.add(logList);

			//Remove the extention type files from agent log files list(logFileList)
			IniFile uiIniFile = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
			String fileExtention = uiIniFile.getValue("LOG_FILE_LENGTH", "FileExtention");
			StringTokenizer str = new StringTokenizer(fileExtention , ",");
			while(str.hasMoreTokens())
			{
				String ext = str.nextToken();
				for(int j = 0; j < logFileList.size(); j++)
				{
					String mgrLog = (String)logFileList.get(j);
					if(mgrLog.endsWith(ext))
					{
						logFileList.remove(j);
						j--;
					}
				}
			}
			Collections.sort(logFileList,String.CASE_INSENSITIVE_ORDER);
			for(int i=0;i<logFileList.size();i++)
			{
				logList = new JSONObject();
				String fileName = (String)logFileList.get(i);
				logList.put("displayField",fileName);
				logList.put("valueField",fileName);
				logListArray.add(logList);
			}
		}
	}
	else
	{
		logList.put("displayField","Select a log file");
		logList.put("valueField","-1");
		logListArray.add(logList);
	}
	rootJson.put("showAlert",showAlert);
	rootJson.put("alertMessage",alertMessage);
	rootJson.put("logFileList",logListArray);
	out.println(rootJson);
%>

<%!
	public synchronized void logToErrorFile(String msg)
	{
		String agentStatusLogFile = EgInstallInfo.getInstallDir() + "/manager/logs/AgentStatusLogFile";
		File ff = new File(agentStatusLogFile);
		long fileLimit = 5 * 1024 * 1024;
		if(ff != null && ff.length() >= fileLimit)
		{
			try
			{
				EgInstallInfo.fileRename(agentStatusLogFile,agentStatusLogFile+"1");
			}
			catch (Exception grr)
			{
				grr.printStackTrace();
			}
		}
		ff = null;
		PrintWriter logWriter;
		try
		{
			logWriter = new PrintWriter(new FileWriter(agentStatusLogFile, true));
		}
		catch (Exception e)
		{
			System.err.println("Cannot open log file " + agentStatusLogFile);
			return;
		}
		if(msg == null || msg.trim().length()==0)
		{
			logWriter.println(" ");
		}
		else
		{
			logWriter.println(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new java.util.Date()) + " " + msg);
		}
		logWriter.close();
	}
%>

