<%
/*****************************************************************************
*	Name		:	changeAgentOutputFile.jsp
*	Purpose		:	Sending request to write agent output(or error) either in agentout.log(or agenterr.log) 
					or output.log(or error.log)  file of agent
*	Version		:	5.2
*	CreationDate:	12/05/2011
*	Author		:	James Thomas P.
******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>

<%@ page import = "java.io.*"%>
<%@ page import = "java.text.*"%>

<%@ page import="net.sf.json.JSONObject"%>

<%
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	String agentID= request.getParameter("agentID");
	String agent_ip_address = request.getParameter("agent_ip_address");
	String output = request.getParameter("s_output");
	
	boolean agentStatusLog = false;
	IniFile serviceIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String agentStLog = serviceIni.getValue("MISC_ARGS","AgentStatusLog"); 
	if(agentStLog != null && (agentStLog.equalsIgnoreCase("yes") || agentStLog.equalsIgnoreCase("true")))
	{
		agentStatusLog = true;
	}

	if(agentStatusLog)
	{
		logToErrorFile("");
		logToErrorFile("changeAgentOutputFileJson is called for agentID " + agentID);
	}
	session.setAttribute("RC_AgentID",agentID);
	if(agentStatusLog)
	{
		logToErrorFile("changeAgentOutputFileJson is called for agent_ip_address " + agent_ip_address);
	}
	output = !StringUtils.isNull(output) && output.equalsIgnoreCase("yes")?"yes":"no";
	if(agentStatusLog)
	{
		logToErrorFile("changeAgentOutputFileJson is called for output(2) " + output);
	}
	RemoteControlTaskHelper helper = new RemoteControlTaskHelper();

	if(agentStatusLog)
	{
		logToErrorFile("changeAgentOutputFileJson setAgentIntoControlMode is called for agentID " + agentID);
	}
	String WVDHostPoolname=null;
	String WVDHostname=null;
	String rcAgentId=agentID;
	int idx = agentID.indexOf(" - ");
	if(idx>0)
	{
		WVDHostPoolname=agentID.substring(0,idx);
		WVDHostname=agentID.substring(idx+3);
		rcAgentId=StringUtils.replace(rcAgentId," - ","$");
	}
	if(helper.setAgentIntoControlMode(rcAgentId) && helper.executeTask("AgentDebug", session.getId(), output+"@#@Y"))
	{
		if(agentStatusLog)
		{
			logToErrorFile("changeAgentOutputFileJson setAgentIntoControlMode is over for agentID " + agentID);
		}
		String workStatus = "unknown";
		if(helper.isOutputAvailable())
		{
			ArrayList outputLines = helper.getOutput();
			if(outputLines != null && !outputLines.isEmpty())
			{
				workStatus = (String)outputLines.get(0);
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson workStatus for agentID " + agentID + " is " + workStatus);
				}
			}
			else
			{
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson outputLines is "+outputLines+" for agentID " + agentID);
				}
			}
		}
		if(workStatus == null || workStatus.equals("null") || workStatus.equals("unknown") || workStatus.equals("failed"))
		{
			workStatus = "failed";
			if(agentStatusLog)
			{
				logToErrorFile("changeAgentOutputFileJson workStatus is made to "+workStatus+" for agentID " + agentID);
			}
		}
		if(agentStatusLog)
		{
			logToErrorFile("changeAgentOutputFileJson finally workStatus is "+workStatus+" for agentID " + agentID);
		}
		if(workStatus.equals("done"))
		{
			IniFile agentStatus = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentoutputstatus.ini");
			if(agent_ip_address == null || agent_ip_address.trim().length()==0 || agent_ip_address.trim().equalsIgnoreCase("null"))
			{
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson agent_ip_address is "+agent_ip_address+" for agentID " + agentID);
				}
				agent_ip_address="NULL";
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson workStatus is made to "+agent_ip_address+" for agentID " + agentID);
				}
			}
			String agent_ip_address_arr[] = StringUtils.getTokens(agent_ip_address,":");
			int icount=agent_ip_address_arr.length;
			IniFile restartIniFile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agent_restart_time.ini");
			String ipStr[] = restartIniFile.getVariables("AGENT_RESTARTED_TIME");
			Vector v1 = new Vector();
			Vector v2 = new Vector();
			for(int i=0;i<ipStr.length;i++)
			{
				String remoteSystem = ipStr[i];
				String sep = ":";
				if(remoteSystem.indexOf(com.eg.EgInstallInfo.ipV6Sep)>=0)
				{
					sep = com.eg.EgInstallInfo.ipV6Sep;
				}
				String searchKey = (sep+remoteSystem+sep);
				for(int j=0;j<icount;j++)
				{
					agent_ip_address=agent_ip_address_arr[j];
					if(agentStatusLog)
					{
						logToErrorFile(j + " changeAgentOutputFileJson ipStr for agentID " + agentID + " " + agent_ip_address);
					}
					if(WVDHostPoolname != null && WVDHostname != null)
					{
						if((searchKey.startsWith(sep+WVDHostPoolname+sep) && searchKey.endsWith(sep+WVDHostname+sep)) || 
						(searchKey.startsWith(sep+WVDHostPoolname.toLowerCase()+sep) && searchKey.endsWith(sep+WVDHostname.toLowerCase()+sep)) || 
						(searchKey.startsWith(sep+WVDHostPoolname.toUpperCase()+sep) && searchKey.endsWith(sep+WVDHostname.toUpperCase()+sep)))
						{
							v1.add(remoteSystem);
							v2.add(output);
						}
					}
					else if (searchKey.indexOf(sep+agent_ip_address+sep) >=0 || 
						searchKey.indexOf(sep+agent_ip_address.toLowerCase()+sep) >=0 || 
						searchKey.indexOf(sep+agent_ip_address.toUpperCase()+sep) >=0 || 
						searchKey.indexOf(sep+agentID+sep) >=0 || 
						searchKey.indexOf(sep+agentID.toLowerCase()+sep) >=0 || 
						searchKey.indexOf(sep+agentID.toUpperCase()+sep) >=0)
					{
						v1.add(remoteSystem);
						v2.add(output);
					}
				}
			}
			if(v1 != null && !v1.isEmpty())
			{
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson updated v1 is "+v1+" for agentID " + agentID);
					logToErrorFile("changeAgentOutputFileJson updated v2 is "+v2+" for agentID " + agentID);
				}
				agentStatus.setValues("AGENT_OUTPUT_STATUS", v1,v2,false);
				agentStatus.saveFile();
			}
			else
			{
				if(agentStatusLog)
				{
					logToErrorFile("changeAgentOutputFileJson [AGENT_OUTPUT_STATUS] is not updated for agentID " + agentID);
				}
			}
			EgConfigFilesSync.releaseInstance(agentStatus);
		}
		String ss = "enabled";
		if(workStatus.equals("done") && output.equalsIgnoreCase("No"))
			ss = "disabled";
		try
		{
			Thread.sleep(2000);
		}
		catch(Exception e)
		{
			//e.printStackTrace();
		}

		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Agent Status");
		auditLogThread.setValue("Activity","Agent Output Enable/Disable");
		if(!workStatus.equals("done"))
		{
			auditLogThread.setValue("Description","Request for disabling agent output and error log files has been failed as the agent was manually started on debug mode");
		}
		else
		{
			auditLogThread.setValue("Description","Agent output and error logging has been "+ss);
		}
		auditLogThread.setCurrentValue("Agent ID", agentID);
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		rootJSON.put("ResultAlert",true);
		rootJSON.put("ResultTitle",_mapping.getTextDescription("admin.agent.Agent output status"));
		if(workStatus.equals("done"))
		{
			rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Agent output & error logging has been "+ss));
			if(agentStatusLog)
			{
				logToErrorFile("changeAgentOutputFileJson Agent output & error logging has been "+ss+" for agentID " + agentID);
				logToErrorFile("");
			}
		}
		else
		{
			rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Request for disabling agent output and error log files has been failed as the agent was manually started on debug mode"));
			if(agentStatusLog)
			{
				logToErrorFile("changeAgentOutputFileJson Request for disabling agent output and error log files has been failed as the agent was manually started on debug mode for agentID " + agentID);
				logToErrorFile("");
			}
		}
	}
	else
	{
		if(agentStatusLog)
		{
			logToErrorFile("changeAgentOutputFileJson setAgentIntoControlMode is failed for agentID " + agentID);
			logToErrorFile("");
		}
		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Agent Status");
		auditLogThread.setValue("Activity","Agent Output Enable/Disable");
		auditLogThread.setCurrentValue("Agent ID", agentID);
		auditLogThread.setValue("Description","Agent output change request has been timedout");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		rootJSON.put("ResultAlert",true);
		rootJSON.put("ResultTitle",_mapping.getTextDescription("admin.agent.Agent output status"));
		rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.agent.Agent output change request has been timedout"));
	}
	
	out.println(rootJSON);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgServerList.jsp?agent="+request.getParameter("agentType"));
%>


<%!
	public synchronized void logToErrorFile(String msg)
	{
		String agentStatusLogFile = EgInstallInfo.getInstallDir() + "/manager/logs/AgentStatusLogFile";
		File ff = new File(agentStatusLogFile);
		long fileLimit = 5 * 1024 * 1024;
		if(ff != null && ff.length() >= fileLimit)
		{
			try
			{
				EgInstallInfo.fileRename(agentStatusLogFile,agentStatusLogFile+"1");
			}
			catch (Exception grr)
			{
				grr.printStackTrace();
			}
		}
		ff = null;
		PrintWriter logWriter;
		try
		{
			logWriter = new PrintWriter(new FileWriter(agentStatusLogFile, true));
		}
		catch (Exception e)
		{
			System.err.println("Cannot open log file " + agentStatusLogFile);
			return;
		}
		if(msg == null || msg.trim().length()==0)
		{
			logWriter.println(" ");
		}
		else
		{
			logWriter.println(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new java.util.Date()) + " " + msg);
		}
		logWriter.close();
	}
%>


