$warningPreference = 'silentlycontinue'
Import-Module SharePointPnPPowerShellOnline

Write-host "========================================================================================================================="
Write-host "	eG Innovations Inc - Utility for injecting eG Real User Monitoring (RUM) JavaScript into SharePoint"
Write-host "========================================================================================================================="

if($Args.Count -ne 3){
Write-host ""
Write-host " Syntax : sharepoint_rum_injection.ps1 <<Site Collection URL>> <<RUM_Script_File>> <<Injection_Rule:siteID1#siteID>>"
Write-host ""
Write-host "	Following are the possible options (Injection_Rule) for injection."
Write-host "	------------------------------------------------------------------"
Write-host "	All			- Inject for all sub sites (Child) including site collection (Parent) as well."
Write-host "	NoSubSite		- Inject only for site collection (Parent) alone."
Write-host "	AllSubSite		- Inject only all sub sites (Child) under the site collection alone (Not for Parent)."
Write-host "	IncludeSome:id1#id2	- Inject into selected sub sites including site collection and do not inject for other sub sites."
Write-host "	ExcludeSome:id1#id2	- Do not inject for some sub sites and inject for all other sub sites including site collection."
Write-host "	Remove			- Remove the injected RUM script from all the sites."
Write-host "	Remove:id1#id2		- Remove RUM injection for the selected site id alone."
Write-host ""
Write-host " Example : sharepoint_rum_injection.ps1 https://xyz.sharepoint.com/sites/mytestcoll ./script.js All"
Write-host " Example : sharepoint_rum_injection.ps1 https://xyz.sharepoint.com/sites/mytestcoll ./script.js IncludeSome:subWebsId1#subWebsId2#subWebsId3"
Write-host ""
Write-host "-----------------------------------------------------------------------------------------------------------------------"
Exit
}

Write-Host  "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Starting RUM Injection process ...."
function isURI($address) {
	return ($address -as [System.URI]).AbsoluteURI -ne $null
}

function isFileExist($path)
{
	return [System.IO.File]::Exists($path)
}

# Validating the input arguments
$siteUrl=$args[0];
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	siteUrl			: "$siteUrl
$validUrl = isURI($siteUrl);
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	validUrl		: "$validUrl
if($siteUrl -and -not $validUrl){
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Input URL is Invalid	: "$siteUrl -f Red
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Exiting RUM Script Injection process ..." -f Red
	Exit
}

$scripFileName=$args[1]  # argument2 is script-file-path
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	scripFileName		: "$scripFileName
$validFile = isFileExist($scripFileName)
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	FileExists		: "$validFile
if ($scripFileName -and $validFile)
{
	$script=Get-Content $scripFileName | Out-String
	#Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	script			: "$script
}else{
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Script file is NULL or Empty or NOT FOUND" -f Red
	Exit
}

[string] $injectRule=$args[2]; #argument3 is subweb id
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	injectRule		: "$injectRule

if($injectRule)
{
	[string[]] $rules = @("*","ALL","NoSubSite","AllSubSite","IncludeSome","ExcludeSome","Remove")
	$index=$injectRule.IndexOf(":")

	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	index			: "$index

	if($index -gt -1)
	{
		$rule = $injectRule.Substring(0, $index)
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	rule			: "$rule
		if($rules -notcontains $rule)
		{
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Injection Rule	: " $rule -f Red
			Exit
		}
		$ids = $injectRule.Substring($index+1)
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	ids			: "$ids
		if($ids){
			[string []] $siteIds = $ids.Split("#")
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	siteIds			: "$siteIds
		}
		else {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Expected parameter missing. Site ID must be present for Include or Exclude rule" -f Red
			Exit
		}
	}
	else
	{
		if($rules -notcontains $injectRule)
		{
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Injection Rule	: " $injectRule -f Red
			Exit
		}
		$rule = $injectRule
		if ($rule -ieq "IncludeSome" -or $rule -ieq "ExcludeSome") {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Expected parameter missing. Site ID for Include or Exclude must be present" -f Red
			Exit
		}
	}
}
if($rule -ieq "Remove")
{
	$title    = 'eG RUM Script Add/Remove'
	$choices  = '&Yes', '&No'

	if($null -eq $siteIds)
	{
		$question = 'Are you sure you want to remove eG RUM Script for all sites ?'
	} elseif($siteIds.length -gt 0)
	{
		$question = 'Are you sure you want to remove eG RUM Script for selected sub-sites ?'
	}

	$decision = $Host.UI.PromptForChoice($title, $question, $choices, 1)

	if ($decision -eq 1)
	{
		Write-Host 'Cancelled'
		Exit
	}
}

$Credential=Get-Credential

if($Credential){
Try{
	Connect-PnPOnline -Url $siteUrl -Credentials $Credential

	# Yes opted for user confirmation 
	if ($decision -eq 0 -and $null -eq $siteIds) {
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script from all sites" -f Cyan
		Get-PnPCustomAction -Scope All | ? Location -eq ScriptLink | ? Name -eq eGRUM | Remove-PnPCustomAction -Force
		Write-host ""		
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script successfully from all sites " -f Cyan
		Disconnect-PnPOnline
		Exit
	} elseif ($decision -and $decision -eq 0) {
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script for all sub-sites" -f Cyan
		Get-PnPCustomAction -Scope web | ? Location -eq ScriptLink | ? Name -eg eGRUM | Remove-PnPCustomAction -Force
		Write-host ""
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script from all sub-sites" -f Cyan
		Disconnect-PnPOnline
		Exit
	}

	# For Addtion
	if($rule -ieq "*" -or $rule -ieq "all"){
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting for all sites !!!"
		Add-PnPJavaScriptBlock -Name "eGRUM" -Scope Site -Sequence 7077 -script $script
		Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection done Successfully" -f Green
		Disconnect-PnPOnline
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
		Exit
	} elseif ($rule -ieq "NoSubSite"){
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting only for Site Collection (parent) ..."
		Add-PnPJavaScriptBlock -Name "eGRUM" -Scope web -Sequence 7077 -script $script
		Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection done Successfully" -f Green
		Disconnect-PnPOnline
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
		Exit
	}
	
	$webHash =@{}
	$subWebsIds=@()
	$subWebs=Get-PnPSubWebs
	
	foreach($subWeb in $subWebs){
	  $subWebsIds+=$subWeb.id
	  $webHash.add($subWeb.id, $subWeb )
	}

	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Available Sub Site IDs : "
	$subWebsIds.foreach{
	  Write-Host "	"$PSItem
	}
	
	Disconnect-PnPOnline
}Catch [Exception] {
	Write-host $_.Exception.Message -f Red
	Exit
}

$result=@()
if($rule -ieq "AllSubSite" -or ($rule -ieq "Remove" -and $ids -ieq "All"))
{
	$result = $subWebsIds
}
else
{
	$subWebsIds | ForEach-Object {
		if ($rule -ieq "IncludeSome" -or $rule -ieq "Remove")
		{
			if($siteIds -contains $_) {
				$result+=$_
			}
		}elseif ($rule -ieq "ExcludeSome")
		{
			if($siteIds -notcontains $_) {
				$result+=$_
			}
		}
	}
}

foreach ($webId in $result)
{
	Try
	{
		Connect-PnPOnline -Url $webHash[$webId].Url -Credentials $Credential 
		if($rule -ieq "Remove"){
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script for site "  $webId
			Get-PnPCustomAction -Scope web | ? Location -eq ScriptLink | ? Name -eq eGRUM | Remove-PnPCustomAction -Force
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script successfully for site : "  $webId
		}
		else {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting eG RUM Script for site "  $webId
			Add-PnPJavaScriptBlock -Name "eGRUM" -Scope web -Sequence 7077 -script $script
		}
		Disconnect-PnPOnline
	}Catch [Exception] {
		Write-host $_.Exception.Message -f Red
	}
}
}
else {
	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Credentials or No Credentials provided ..."
}

Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
Write-host "========================================================================================================================="