$warningPreference = 'silentlycontinue'
Import-Module SharePointPnPPowerShellOnline

Write-host "========================================================================================================================="
Write-host "	eG Innovations Inc - Utility for injecting eG Real User Monitoring (RUM) JavaScript into SharePoint"
Write-host "========================================================================================================================="

if($Args.Count -ne 3){
Write-host ""
Write-host " Syntax : sharepoint_rum_injection.ps1 <<Site Collection URL>> <<RUM_Script_File>> <<Injection_Rule:siteID1#siteID>>"
Write-host ""
Write-host "	Following are the possible options (Injection_Rule) for injection."
Write-host "	------------------------------------------------------------------"
Write-host "	All			- Inject for all sub sites (Child) including site collection (Parent) as well."
Write-host "	NoSubSite		- Inject only for site collection (Parent) alone."
Write-host "	AllSubSite		- Inject only all sub sites (Child) under the site collection alone (Not for Parent)."
Write-host "	IncludeSome:id1#id2	- Inject into selected sub sites including site collection and do not inject for other sub sites."
Write-host "	ExcludeSome:id1#id2	- Do not inject for some sub sites and inject for all other sub sites including site collection."
Write-host "	Remove			- Remove the injected RUM script from all the sites."
Write-host "	Remove:id1#id2		- Remove RUM injection for the selected site id alone."
Write-host ""
Write-host " Example : sharepoint_rum_injection.ps1 https://xyz.sharepoint.com/sites/mytestcoll ./script.js All"
Write-host " Example : sharepoint_rum_injection.ps1 https://xyz.sharepoint.com/sites/mytestcoll ./script.js IncludeSome:subWebsId1#subWebsId2#subWebsId3"
Write-host ""
Write-host "-----------------------------------------------------------------------------------------------------------------------"
Exit
}

Write-Host  "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Starting RUM Injection process ...."
function isURI($address) {
	return ($address -as [System.URI]).AbsoluteURI -ne $null
}

function isFileExist($path)
{
	return [System.IO.File]::Exists($path)
}

# Validating the input arguments
$siteUrl=$args[0];
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	siteUrl			: "$siteUrl
$validUrl = isURI($siteUrl);
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	validUrl		: "$validUrl
if($siteUrl -and -not $validUrl){
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Input URL is Invalid	: "$siteUrl -f Red
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Exiting RUM Script Injection process ..." -f Red
	Exit
}

$scripFileName=$args[1]  # argument2 is script-file-path
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	scripFileName		: "$scripFileName
$validFile = isFileExist($scripFileName)
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	FileExists		: "$validFile
if ($scripFileName -and $validFile)
{
	$script=Get-Content $scripFileName | Out-String
	#Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	script			: "$script
}else{
	Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Script file is NULL or Empty or NOT FOUND" -f Red
	Exit
}

[string] $injectRule=$args[2]; #argument3 is subweb id
Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	injectRule		: "$injectRule

if($injectRule)
{
	[string[]] $rules = @("*","ALL","NoSubSite","AllSubSite","IncludeSome","ExcludeSome","Remove")
	$index=$injectRule.IndexOf(":")

	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	index			: "$index

	if($index -gt -1)
	{
		$rule = $injectRule.Substring(0, $index)
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	rule			: "$rule
		if($rules -notcontains $rule)
		{
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Injection Rule	: " $rule -f Red
			Exit
		}
		$ids = $injectRule.Substring($index+1)
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	ids			: "$ids
		if($ids){
			[string []] $siteIds = $ids.Split("#")
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	siteIds			: "$siteIds
		}
		else {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Expected parameter missing. Site ID must be present for Include or Exclude rule" -f Red
			Exit
		}
	}
	else
	{
		if($rules -notcontains $injectRule)
		{
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Injection Rule	: " $injectRule -f Red
			Exit
		}
		$rule = $injectRule
		if ($rule -ieq "IncludeSome" -or $rule -ieq "ExcludeSome") {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Expected parameter missing. Site ID for Include or Exclude must be present" -f Red
			Exit
		}
	}
}
if($rule -ieq "Remove")
{
	$title    = 'eG RUM Script Add/Remove'
	$choices  = '&Yes', '&No'

	if($null -eq $siteIds)
	{
		$question = 'Are you sure you want to remove eG RUM Script for all sites ?'
	} elseif($siteIds.length -gt 0)
	{
		$question = 'Are you sure you want to remove eG RUM Script for selected sub-sites ?'
	}

	$decision = $Host.UI.PromptForChoice($title, $question, $choices, 1)

	if ($decision -eq 1)
	{
		Write-Host 'Cancelled'
		Exit
	}
}

$Credential=Get-Credential

if($Credential){
Try{
	Connect-PnPOnline -Url $siteUrl -Credentials $Credential

	# Yes opted for user confirmation 
	if ($decision -eq 0 -and $null -eq $siteIds) {
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script from all sites" -f Cyan
		Get-PnPCustomAction -Scope All | ? Location -eq ScriptLink | ? Name -eq eGRUM | Remove-PnPCustomAction -Force
		Write-host ""		
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script successfully from all sites " -f Cyan
		Disconnect-PnPOnline
		Exit
	} elseif ($decision -and $decision -eq 0) {
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script for all sub-sites" -f Cyan
		Get-PnPCustomAction -Scope web | ? Location -eq ScriptLink | ? Name -eg eGRUM | Remove-PnPCustomAction -Force
		Write-host ""
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script from all sub-sites" -f Cyan
		Disconnect-PnPOnline
		Exit
	}

	# For Addtion
	if($rule -ieq "*" -or $rule -ieq "all"){
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting for all sites !!!"
		Add-PnPJavaScriptBlock -Name "eGRUM" -Scope Site -Sequence 7077 -script $script
		Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection done Successfully" -f Green
		Disconnect-PnPOnline
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
		Exit
	} elseif ($rule -ieq "NoSubSite"){
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting only for Site Collection (parent) ..."
		Add-PnPJavaScriptBlock -Name "eGRUM" -Scope web -Sequence 7077 -script $script
		Write-host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection done Successfully" -f Green
		Disconnect-PnPOnline
		Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
		Exit
	}
	
	$webHash =@{}
	$subWebsIds=@()
	$subWebs=Get-PnPSubWebs
	
	foreach($subWeb in $subWebs){
	  $subWebsIds+=$subWeb.id
	  $webHash.add($subWeb.id, $subWeb )
	}

	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Available Sub Site IDs : "
	$subWebsIds.foreach{
	  Write-Host "	"$PSItem
	}
	
	Disconnect-PnPOnline
}Catch [Exception] {
	Write-host $_.Exception.Message -f Red
	Exit
}

$result=@()
if($rule -ieq "AllSubSite" -or ($rule -ieq "Remove" -and $ids -ieq "All"))
{
	$result = $subWebsIds
}
else
{
	$subWebsIds | ForEach-Object {
		if ($rule -ieq "IncludeSome" -or $rule -ieq "Remove")
		{
			if($siteIds -contains $_) {
				$result+=$_
			}
		}elseif ($rule -ieq "ExcludeSome")
		{
			if($siteIds -notcontains $_) {
				$result+=$_
			}
		}
	}
}

foreach ($webId in $result)
{
	Try
	{
		Connect-PnPOnline -Url $webHash[$webId].Url -Credentials $Credential 
		if($rule -ieq "Remove"){
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removing eG RUM Script for site "  $webId
			Get-PnPCustomAction -Scope web | ? Location -eq ScriptLink | ? Name -eq eGRUM | Remove-PnPCustomAction -Force
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Removed eG RUM Script successfully for site : "  $webId
		}
		else {
			Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Injecting eG RUM Script for site "  $webId
			Add-PnPJavaScriptBlock -Name "eGRUM" -Scope web -Sequence 7077 -script $script
		}
		Disconnect-PnPOnline
	}Catch [Exception] {
		Write-host $_.Exception.Message -f Red
	}
}
}
else {
	Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	Invalid Credentials or No Credentials provided ..."
}

Write-Host "  $(get-date -UFormat '%d/%m/%Y %H:%M:%S')	RUM Script Injection process completed"
Write-host "========================================================================================================================="
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUpmptKPC/YYiswY1U2YUQqVxf
# NcmggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUPgxLOyuL8U0+Z4yrFne8RTAT
# PtIwDQYJKoZIhvcNAQEBBQAEggEAZoQPVCd9qKTbgd7bX+dcXkxaT/IAfRSMpA0f
# /S29G2G4ovVTn9WYGX2PeWOZ42JZybhSG5MM1ach0iXHX9sx9merBCgkyJluO540
# ELQ6bqrHZfc45MzobTALdPhMbw6ihh+fA3nvyUwf/Nq2Yz5Rt+jzWtxzGaj+WGDJ
# becZ6h3Ct4AJ14wRnd3wz1w0v9VBkhQp61+ElFVQoQDlPpWhtYmnRyNkWXUxzjk5
# q2X9x4KNq4rQN+CFalSYVL0B5Ovxx/Eq1NTt+unwGcbGzDhLpRRL3GBzgOYv8Cq/
# nVD218f0xIYas3UYA61k7i3Hfw2rd2oXMNaZTYdz//04bJnzKaGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwOTMwMDgzNjAxWjAjBgkqhkiG9w0BCQQxFgQUXB6d/DlnhXoqet+uHSQ7
# zAUSczYwDQYJKoZIhvcNAQEBBQAEggEARrO1rUOnCn45NV5F7+dq7N8yHnHXKA/1
# pOlJARtsiQ/QLvxDMy6TM0L3bj/8FkgwzrJdP87/VmhNd+9pB4o2ShH5dxVz1FpS
# Lu4qIjoeatdNX0sY0ftPYI7MMLND9rxKaLi9JEcqt0tfE4hNFSLk5llp8TpWEYBI
# xKayZnf2pzQqoA8yYV9eSko2HLlI4gEADeiSkMjvyIsNsnCIe3NJZnweUHsNKYVL
# q1TNJqQWAjcFXnieCMEyk1ILqk5wIT3NcH/74lR75i8RZQG2oW0c8+11fvGUnRql
# moDRgTKMLe9/d60vEs7m0YhBTLZrDZhYX4+xvwMTkNCRl3BysljURA==
# SIG # End signature block
