/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.TrueColorEncoder;
import java.awt.image.ColorModel;
import java.io.IOException;

public class TrueColorAlphaEncoder
extends TrueColorEncoder {
    TrueColorAlphaEncoder(int compression) {
        super(compression);
        this.colorType = 6;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (this.pngPixels == null || this.pngPixels.length < scansize * 4 + 1) {
            this.pngPixels = new byte[scansize * 4 + 1];
        }
        int rows = pixels.length / scansize;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            this.pngPixels[0] = 0;
            int p = 1;
            for (int i = 0; i < scansize; ++i) {
                this.pngPixels[p] = (byte)(pixels[index] >> 16 & 0xFF);
                this.pngPixels[p + 1] = (byte)(pixels[index] >> 8 & 0xFF);
                this.pngPixels[p + 2] = (byte)(pixels[index] & 0xFF);
                this.pngPixels[p + 3] = (byte)(pixels[index] >> 24 & 0xFF);
                p += 4;
                ++index;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, scansize * 4 + 1);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

