/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.CacheChunk;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;

public class CacheStream
extends InputStream {
    private static final int LOW_BYTE = 255;
    CacheManager _cm;
    InputStream _is;
    boolean _dead = false;
    boolean _rewindable = true;
    private boolean _reset = false;
    CacheChunk _first = null;
    CacheChunk _last = null;
    CacheChunk _current = null;
    int _timeout;
    int _nextByte = 0;

    public CacheStream(CacheManager cm, InputStream is, int timeout) {
        this._cm = cm;
        this._is = is;
        this._timeout = timeout;
    }

    private void addChunk(int size) throws IOException {
        CacheChunk cc = this._cm.getChunk(size, this._timeout);
        if (this._last == null) {
            this._first = cc;
        } else {
            this._last._next = cc;
        }
        this._last = cc;
        this._current = cc;
        this._nextByte = 0;
    }

    public synchronized int available() throws IOException {
        this.checkMe();
        if (this._current == null) {
            return 0;
        }
        CacheChunk cc = this._current;
        int count = cc._buf.length - this._nextByte;
        while (cc._next != null) {
            cc = cc._next;
            count += cc._buf.length;
        }
        return count;
    }

    public long cacheSize() {
        int count = 0;
        CacheChunk c = this._first;
        while (c != null) {
            count += c._length;
            c = c._next;
        }
        return count;
    }

    private void checkMe() throws IOException {
        if (this._dead) {
            CacheManager.raiseIOException("IO_CLOSED");
        }
    }

    public synchronized void close() throws IOException {
        this.checkMe();
        this._dead = true;
        this._cm.putChunks(this._first);
        this._first = null;
        this._current = null;
        this._last = null;
        this._is = null;
    }

    public synchronized int read() throws IOException {
        this.checkMe();
        if (this._current == null || this._nextByte == this._current._length && this._current._next == null && this._current._length == this._current._buf.length) {
            this.addChunk(1);
        } else if (this._nextByte == this._current._length && this._current._next != null) {
            this._current = this._current._next;
            this._nextByte = 0;
        }
        if (this._nextByte == this._current._length) {
            int readOne;
            if (this._reset) {
                Debug.println("Warning, reading beyond end of previously reset cache");
            }
            if ((readOne = this._is.read()) == -1) {
                return -1;
            }
            ++this._current._length;
            this._current._buf[this._nextByte] = (byte)(readOne & 0xFF);
        }
        int retval = this._current._buf[this._nextByte++] & 0xFF;
        return retval;
    }

    public synchronized int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        this.checkMe();
        int numToRead = length;
        while (numToRead > 0) {
            int thisRead;
            if (this._current == null) {
                this.addChunk(numToRead);
            } else if (this._nextByte == this._current._length) {
                if (this._current._length == this._current._buf.length && this._current._next == null) {
                    this.addChunk(numToRead);
                } else if (this._current._next != null) {
                    this._current = this._current._next;
                    this._nextByte = 0;
                }
            }
            int remaining = this._current._length - this._nextByte;
            int n = thisRead = numToRead < remaining ? numToRead : remaining;
            if (remaining == 0) {
                int chunkSpace = this._current._buf.length - this._current._length;
                int n2 = thisRead = chunkSpace > numToRead ? numToRead : chunkSpace;
                if (this._reset) {
                    Debug.println("Warning, reading beyond end of previously reset cache");
                }
                thisRead = this._is.read(this._current._buf, this._current._length, thisRead);
                this._current._length += thisRead;
            }
            System.arraycopy(this._current._buf, this._nextByte, buf, offset, thisRead);
            offset += thisRead;
            numToRead -= thisRead;
            this._nextByte += thisRead;
        }
        return length;
    }

    public synchronized void reset() throws IOException {
        this.checkMe();
        if (!this._rewindable) {
            CacheManager.raiseIOException("IO_NOT_RESETABLE");
        }
        this._current = this._first;
        this._nextByte = 0;
        this._reset = true;
    }

    public synchronized long skip(long n) throws IOException {
        this.checkMe();
        int chunks = 0;
        long toSkip = n;
        while (toSkip > 0L) {
            if (this._current != null) {
                int thisChunk = this._current._length - this._nextByte;
                if ((long)thisChunk <= toSkip) {
                    this._current = this._current._next;
                    this._nextByte = 0;
                    ++chunks;
                    toSkip -= (long)thisChunk;
                    continue;
                }
                this._nextByte = (int)((long)this._nextByte + toSkip);
                break;
            }
            this._rewindable = false;
            toSkip -= this._is.skip(toSkip);
        }
        return n;
    }
}

