/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.Debug;

public class BufferPool {
    public static final int BUFF_SIZE = 4096;
    private BufferInterval _head;
    private int _bufSize;
    private int _packetSize;
    private InStreamMgr _inMgr;
    private boolean _noLimit;
    protected static final boolean DEBUG = false;

    public BufferPool(InStreamMgr mgr, int cache, int packet) {
        this._inMgr = mgr;
        this._noLimit = cache <= 0;
        this._packetSize = packet;
        this._bufSize = cache <= 0 ? (2 * packet > 4096 ? 2 * packet : 4096) : (cache < 2 * packet ? 2 * packet : cache);
        this._head = this.makeBuffer();
    }

    private void checkMgr() {
        InStreamMgr inStreamMgr = this._inMgr;
        synchronized (inStreamMgr) {
            if (this._head != null && this._head._length >= this._packetSize) {
                this._inMgr.notify();
            }
        }
    }

    public synchronized BufferInterval getBI(boolean noLimit) {
        if (this._head == null || this._head._length < this._packetSize) {
            if (noLimit || this._noLimit) {
                return this.makeBuffer();
            }
            return null;
        }
        BufferInterval bi = this._head;
        BufferInterval newhead = this._head._next;
        this._head.detach();
        this._head = newhead;
        return bi;
    }

    private BufferInterval makeBuffer() {
        byte[] buf = new byte[this._bufSize];
        return new BufferInterval(buf, 0, buf.length, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(BufferInterval bi) {
        boolean checkInMgr = false;
        while (true) {
            if (checkInMgr) {
                this.checkMgr();
                return;
            }
            checkInMgr = true;
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                Object var4_4;
                block18: {
                    block19: {
                        block17: {
                            block16: {
                                if (bi == null) {
                                    return;
                                }
                                if (this._head == null) {
                                    this._head = bi;
                                    break block16;
                                }
                                boolean inList = false;
                                BufferInterval cur = this._head;
                                while (cur != null) {
                                    if (cur.merge(bi, inList)) {
                                        if (inList) {
                                            cur.detach();
                                            break;
                                        }
                                        bi = cur;
                                        inList = true;
                                    }
                                    cur = cur._next;
                                }
                                if (inList) {
                                    if (bi._prev == null) break block17;
                                    if (bi._prev._length >= bi._length) {
                                        break block17;
                                    }
                                    bi.detach();
                                }
                                BufferInterval tail = null;
                                BufferInterval cur2 = this._head;
                                while (true) {
                                    if (cur2 == null) {
                                        bi.attachAfter(tail);
                                        break block18;
                                    }
                                    if (bi._length >= cur2._length) {
                                        if (cur2 == this._head) {
                                            this._head = bi;
                                        }
                                        bi.attachBefore(cur2);
                                        break block19;
                                    }
                                    tail = cur2;
                                    cur2 = cur2._next;
                                }
                            }
                            var4_4 = null;
                            continue;
                        }
                        var4_4 = null;
                        continue;
                    }
                    var4_4 = null;
                    continue;
                }
                var4_4 = null;
            }
        }
    }

    public void setNetBufSize(int packetsize) {
        Debug.println(this, "setNetBufSize()");
        if (this._packetSize == packetsize) {
            return;
        }
        this._packetSize = packetsize;
        if (this._bufSize < 2 * packetsize) {
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                while (this._head != null) {
                    BufferInterval bi = this._head;
                    if (bi._length != this._bufSize) break;
                    Debug.println(this, "Change Buffer size");
                    BufferInterval newhead = this._head._next;
                    this._head.detach();
                    this._head = newhead;
                }
                this._bufSize = 2 * packetsize;
                this.put(this.makeBuffer());
            }
        }
    }
}

