/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.timedio.RequestObj;
import com.sybase.jdbc2.timedio.ResponseQueue;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;

public abstract class StreamContext
extends ProtocolContext {
    protected int _state;
    protected int _pduState;
    protected ResponseQueue _responseQue;
    protected RequestObj _request;
    protected InStreamMgr _inMgr;

    public StreamContext(Protocol p, InStreamMgr inMgr, OutStreamMgr outMgr) {
        super(p);
        this._inMgr = inMgr;
        this._state = 1;
        this._request = new RequestObj(outMgr.getWaitQueue());
        this._responseQue = new ResponseQueue(inMgr.getReadQueue(), 10);
    }

    protected abstract void beginRequest() throws SQLException;

    protected abstract void cancelled();

    protected abstract void chainException(SQLException var1);

    protected abstract void close(boolean var1);

    public int getState() {
        return this._state;
    }

    protected BufferInterval makeChunk(BufferInterval bi, int nBytes, boolean slurp) {
        Debug.println(this, "makeChunk() " + nBytes + " for " + this);
        if (nBytes == 0) {
            return bi;
        }
        BufferInterval pdubi = null;
        if (nBytes < bi._length) {
            pdubi = bi.divide(nBytes);
        } else {
            Debug.assert(this, nBytes == bi._length);
            pdubi = bi;
            bi = null;
        }
        if (pdubi != null) {
            if (slurp) {
                pdubi.free();
            } else {
                this._responseQue.push(pdubi);
            }
        }
        return bi;
    }

    protected abstract BufferInterval queueData(BufferInterval var1);

    protected void refreshYourself(Protocol p, InStreamMgr inMgr, OutStreamMgr outMgr) {
        Debug.println(this, "Refresh Myself as Stream");
        this._inMgr = inMgr;
        this._state = 1;
        this._request = new RequestObj(outMgr.getWaitQueue());
        this._responseQue = new ResponseQueue(inMgr.getReadQueue(), 10);
    }

    protected int responseState() {
        return this._pduState;
    }

    public void setSponsor(ProtocolContext pc) {
        if (pc != null) {
            StreamContext sc = (StreamContext)pc;
            this._request._guestOf = sc._request._guestOf != null ? sc._request._guestOf : sc._request;
        } else {
            this._request._guestOf = null;
        }
    }

    protected void setState(int newState) {
        Debug.println(this, String.valueOf(String.valueOf(this)) + " changing state from " + this._state + " to " + newState);
        this._state = newState;
    }
}

