/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybXAConnection;
import com.sybase.jdbc2.jdbc.SybXADataSource;
import com.sybase.jdbc2.jdbc.SybXAResource11;
import com.sybase.jdbc2.jdbc.SybXid;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SybXAResource
implements XAResource {
    private static final int MAX_SAFE_RM_NAME_LENGTH = 74;
    protected static final String RPC_PREFIX = "{?= call ";
    private static final String RPC_POSTFIX = " (?, ?, ?)}";
    private static final String COMMIT_RPC = "{?= call $commitSybDtmXact (?, ?, ?)}";
    private static final String ROLLBACK_RPC = "{?= call $rollbackSybDtmXact (?, ?, ?)}";
    private static final String FORGET_RPC = "{?= call $forgetSybDtmXact (?, ?, ?)}";
    private static final String PREPARE_RPC = "{?= call $prepareSybDtmXact (?, ?, ?)}";
    private static final String BEGIN_RPC = "{?= call $beginSybDtmXact (?, ?, ?, ?)}";
    private static final String END_RPC = "{?= call $endSybDtmXact (?, ?, ?)}";
    private static final String STATUS_RPC = "{?= call $statusSybDtmXact (?, ?, ?)}";
    private static final String ATTACH_RPC = "{?= call $attachSybDtmXact (?, ?, ?)}";
    private static final String DETACH_RPC = "{?= call $detachSybDtmXact (?, ?, ?)}";
    private static final String TRANSACTION_STATUS = "{?= call sp_transactions (?)}";
    private static final String ENCODING_MAP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@#";
    private static final String ENCODED_XID_DELIMITER = "_";
    private static final String ENCODED_RM_NAME_DELIMITER = ":";
    protected int _transProtocolType = 196608;
    private int _timeout = 0;
    private final SybXADataSource _xaDataSource;
    protected final SybXAConnection _xaConn;
    protected final String _resourceManagerID;
    protected boolean _localTransactionOK = true;

    static {
        Debug.assert(ENCODING_MAP.length() == 64, "encoding string is invalid");
    }

    protected SybXAResource(String rmID, SybXAConnection xaConn, SybXADataSource xaDS, SybUrlProvider up) {
        this._xaConn = xaConn;
        this._xaDataSource = xaDS;
        this._resourceManagerID = rmID;
        Debug.assert(this, this._resourceManagerID.length() <= 74, "Resource manager id length is too long, there is a risk of truncating information.");
        Debug.println(this, "SybXAResource() completed");
    }

    protected void close() {
        Debug.println(this, "close()");
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Debug.println(this, "commit(" + xid + ", " + onePhase + ")");
        int rpcFlags = 0;
        if (onePhase) {
            this.sendRPC(ATTACH_RPC, xid, 1, 2);
            this.sendRPC(END_RPC, xid, 2);
            rpcFlags = 32;
        }
        this.sendRPC(COMMIT_RPC, xid, 100, rpcFlags);
        this._localTransactionOK = true;
    }

    public static SybXAResource createSybXAResource(int coordinatorType, String rmID, SybXAConnection conn, SybXADataSource ds, SybUrlProvider up) {
        Debug.println(null, "createSybXAResource( " + coordinatorType + ")");
        Debug.assert(rmID != null, "resource manager id was null!");
        SybXAResource res = null;
        switch (coordinatorType) {
            case 2: {
                res = new SybXAResource(rmID, conn, ds, up);
                break;
            }
            case 1: {
                res = new SybXAResource11(rmID, conn, ds, up);
                break;
            }
            default: {
                Debug.println(null, "No XAResource available for the requested type: " + coordinatorType);
            }
        }
        return res;
    }

    protected final SybXid dtmDecode(String name) {
        Debug.println(null, "decode(" + name + ")");
        int gtrid = name.indexOf(ENCODED_XID_DELIMITER);
        int bqual = name.indexOf(ENCODED_XID_DELIMITER, gtrid + 1);
        int rmName = name.indexOf(ENCODED_RM_NAME_DELIMITER, bqual);
        SybXid xid = new SybXid(Integer.parseInt(name.substring(0, gtrid), 16), SybXAResource.jjDecode(name.substring(gtrid + 1, bqual)), SybXAResource.jjDecode(name.substring(bqual + 1, rmName)));
        return xid;
    }

    protected final String dtmEncode(Xid xid) throws XAException {
        Debug.println(null, "encode(" + xid + ")");
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid.length > 64 || bqual.length > 64) {
            Debug.println(this, "Xid was not valid");
            throw new XAException(-4);
        }
        String encodedXID = "";
        encodedXID = String.valueOf(encodedXID) + HexConverts.hexConvert(xid.getFormatId(), 4) + ENCODED_XID_DELIMITER;
        encodedXID = String.valueOf(encodedXID) + SybXAResource.jjEncode(gtrid) + ENCODED_XID_DELIMITER;
        encodedXID = String.valueOf(encodedXID) + SybXAResource.jjEncode(bqual) + ENCODED_RM_NAME_DELIMITER;
        encodedXID = String.valueOf(encodedXID) + this._resourceManagerID;
        Debug.println(null, "encoding complete: Xid is now < " + encodedXID + " >");
        Debug.assert(null, encodedXID.length() <= 255, "encoded XID is too long");
        return encodedXID;
    }

    public void end(Xid xid, int flags) throws XAException {
        Debug.println(this, "end(" + xid + ", " + flags + ")");
        int rpcStatus = 2;
        if ((flags & 0x2000000) != 0) {
            rpcStatus = 3;
        } else if ((flags & 0x20000000) != 0) {
            rpcStatus = 101;
        }
        this.sendRPC(DETACH_RPC, xid, rpcStatus);
        this._localTransactionOK = true;
    }

    public void forget(Xid xid) throws XAException {
        Debug.println(this, "forget(" + xid + ")");
        this.sendRPC(FORGET_RPC, xid, 102);
        this._localTransactionOK = true;
    }

    public int getTransactionTimeout() throws XAException {
        Debug.println(this, "getTransactionTimeout()");
        return this._timeout;
    }

    protected boolean isLocalTransactionOK() {
        return this._localTransactionOK;
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        Debug.println(this, "isSameRM(" + xaRes + ")");
        boolean isSame = false;
        if (xaRes instanceof SybXAResource) {
            isSame = this._resourceManagerID.equals(((SybXAResource)xaRes)._resourceManagerID);
        }
        return isSame;
    }

    private static final byte[] jjDecode(String rawData) {
        int low;
        int high;
        char[] data = rawData.toCharArray();
        Debug.assert(null, data.length > 1, "invalid String");
        int targetSize = data.length * 3 / 4;
        Debug.println(null, String.valueOf(data.length) + " chars should fit in " + targetSize + " bytes.");
        byte[] answer = new byte[targetSize];
        int i = 0;
        int j = 0;
        while (i < data.length - 3) {
            high = ENCODING_MAP.indexOf(data[i]) << 2;
            low = (ENCODING_MAP.indexOf(data[i + 1]) & 0x30) >> 4;
            answer[j++] = (byte)(high | low);
            high = (ENCODING_MAP.indexOf(data[i + 1]) & 0xF) << 4;
            low = (ENCODING_MAP.indexOf(data[i + 2]) & 0x3E) >> 2;
            answer[j++] = (byte)(high | low);
            high = (ENCODING_MAP.indexOf(data[i + 2]) & 3) << 6;
            low = ENCODING_MAP.indexOf(data[i + 3]) & 0x3F;
            answer[j++] = (byte)(high | low);
            i += 4;
        }
        Debug.println(null, "exited loop on char " + i + " out of " + data.length + " total chars to decode.");
        Debug.println(null, "next byte to build is: " + j);
        switch (data.length - i) {
            case 3: {
                high = (ENCODING_MAP.indexOf(data[i]) & 0x3F) << 2;
                low = (ENCODING_MAP.indexOf(data[i + 1]) & 0x30) >> 4;
                answer[j++] = (byte)(high | low);
                high = (ENCODING_MAP.indexOf(data[i + 1]) & 0xF) << 4;
                low = (ENCODING_MAP.indexOf(data[i + 2]) & 0x3E) >> 2;
                answer[j] = (byte)(high | low);
                break;
            }
            case 2: {
                high = (ENCODING_MAP.indexOf(data[i]) & 0x3F) << 2;
                low = (ENCODING_MAP.indexOf(data[i + 1]) & 0x30) >> 4;
                answer[j] = (byte)(high | low);
                break;
            }
            case 1: {
                Debug.assert(null, false, "data to decode had invalid length");
                break;
            }
            case 0: {
                --j;
                break;
            }
        }
        Debug.assert(null, j == answer.length - 1, "byte array was not filled exactly; size = " + answer.length + " last index assigned = " + j);
        return answer;
    }

    private static final String jjEncode(byte[] data) {
        int index;
        int targetSize = data.length * 4 / 3 + (data.length % 3 == 0 ? 0 : 1);
        Debug.println(null, String.valueOf(data.length) + " bytes should fit in " + targetSize + " chars.");
        char[] answer = new char[targetSize];
        Debug.println(null, "data to encode = 0x" + HexConverts.hexConvert(data));
        int i = 0;
        int j = 0;
        while (i < data.length - 2) {
            index = data[i] >> 2 & 0x3F;
            answer[j++] = ENCODING_MAP.charAt(index);
            index = (data[i] << 4 | data[i + 1] >> 4 & 0xF) & 0x3F;
            answer[j++] = ENCODING_MAP.charAt(index);
            index = (data[i + 1] << 2 | data[i + 2] >> 6 & 3) & 0x3F;
            answer[j++] = ENCODING_MAP.charAt(index);
            index = data[i + 2] & 0x3F;
            answer[j++] = ENCODING_MAP.charAt(index);
            i += 3;
        }
        Debug.println(null, "finished with byte " + i + " out of " + data.length + " total bytes to encode.");
        switch (data.length - i) {
            case 2: {
                index = data[i] >> 2 & 0x3F;
                answer[j++] = ENCODING_MAP.charAt(index);
                index = (data[i] << 4 | data[i + 1] >> 4 & 0xF) & 0x3F;
                answer[j++] = ENCODING_MAP.charAt(index);
                index = data[i + 1] << 2 & 0x3F;
                answer[j] = ENCODING_MAP.charAt(index);
                break;
            }
            case 1: {
                index = data[i] >> 2 & 0x3F;
                answer[j++] = ENCODING_MAP.charAt(index);
                index = data[i] << 4 & 0x3F;
                answer[j] = ENCODING_MAP.charAt(index);
                break;
            }
            case 0: {
                --j;
                break;
            }
        }
        Debug.assert(null, j == answer.length - 1, "char array was not filled exactly; size = " + answer.length + " last index assigned = " + j);
        return new String(answer);
    }

    public int prepare(Xid xid) throws XAException {
        Debug.println(this, "prepare(" + xid + ")");
        this._localTransactionOK = false;
        this.sendRPC(ATTACH_RPC, xid, 1, 2);
        this.sendRPC(DETACH_RPC, xid, 2, 4);
        int returnCode = this.sendRPC(PREPARE_RPC, xid, 7);
        return returnCode == -256 ? 3 : 0;
    }

    public Xid[] recover(int flag) throws XAException {
        Debug.println(this, "recover(" + flag + ")");
        Vector<SybXid> list = new Vector<SybXid>();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this._xaConn.prepareCall(TRANSACTION_STATUS);
                stmt.setString(2, "xa_recover");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString("xactname");
                    Debug.println(this, "Building xid using: " + name);
                    list.add(this.dtmDecode(name));
                }
            }
            catch (SQLException sqe) {
                Debug.println(this, "throwing this SQLException as an XAException:\n" + sqe);
                Debug.printStackTrace(this, sqe);
                throw new XAException(-3);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqe) {
                Debug.println(this, "problem cleaning up statement/resultset. " + sqe);
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqe) {
            Debug.println(this, "problem cleaning up statement/resultset. " + sqe);
        }
        Object[] xids = new Xid[list.size()];
        list.copyInto(xids);
        return xids;
    }

    public void rollback(Xid xid) throws XAException {
        Debug.println(this, "rollback(" + xid + ")");
        this.sendRPC(ROLLBACK_RPC, xid, 101);
        this._localTransactionOK = true;
    }

    private final int sendRPC(String rpcName, Xid xid, int status) throws XAException {
        return this.sendRPC(rpcName, xid, this._transProtocolType, status, 0);
    }

    private final int sendRPC(String rpcName, Xid xid, int status, int flags) throws XAException {
        return this.sendRPC(rpcName, xid, this._transProtocolType, status, flags);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private final int sendRPC(String rpcName, Xid xid, int mode, int status, int flags) throws XAException {
        Debug.println(this, "sendRPC( rpcName = " + rpcName + ", " + "xid = " + xid + ", " + "mode = " + mode + ", " + "status = " + status + ", " + "flags = " + flags + ")");
        int returnCode = 0;
        SybCallableStatement scs = null;
        SQLException rpcSQE = null;
        try {
            try {
                scs = (SybCallableStatement)this._xaConn.prepareCall(rpcName);
                scs.registerOutParameter(1, 4);
                scs.setString(2, this.dtmEncode(xid));
                scs.setParameterName(2, "@name");
                scs.setInt(3, status);
                scs.setParameterName(3, "@status");
                scs.setInt(4, flags);
                scs.setParameterName(4, "@flags");
                if (rpcName == BEGIN_RPC) {
                    scs.setInt(5, mode);
                    scs.setParameterName(5, "@mode");
                }
                scs.execute();
                returnCode = scs.getInt(1);
            }
            catch (SQLException sqe) {
                Debug.println(this, "throwing this SQLException as an XAException:\n" + sqe);
                Debug.printStackTrace(this, sqe);
                rpcSQE = sqe;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                try {
                    if (scs != null) {
                        scs.close();
                    }
                }
                catch (SQLException sqe) {
                    Debug.println(this, "problem cleaning up SybCallableStatement. " + sqe);
                }
                {
                }
            }
            finally {
                Object v0 = null;
            }
        }
        try {
            try {
                if (scs != null) {
                    scs.close();
                }
            }
            catch (SQLException sqe) {
                Debug.println(this, "problem cleaning up SybCallableStatement. " + sqe);
            }
            {
            }
        }
        finally {
            Object v1 = null;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        Debug.println(this, "setTransactionTimeout(" + seconds + ")");
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this._timeout = seconds;
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        Debug.println(this, "start(" + xid + ", " + flags + ")");
        this._localTransactionOK = false;
        if ((flags & 0x8200000) == 0) {
            Debug.println(this, "initiating a new transaction");
            this.sendRPC(BEGIN_RPC, xid, 1, 16);
        } else {
            int status = this.sendRPC(ATTACH_RPC, xid, 1);
            if ((flags & 0x8000000) != 0 && status != 3 || (flags & 0x200000) != 0 && status == 3 || (flags & 0x200000) != 0 && status == 101) {
                Debug.println(this, "join/resume invoked in improper context; detach and raise error");
                this.sendRPC(DETACH_RPC, xid, status);
                throw new XAException(-6);
            }
        }
    }

    private final void verifyReturnCode(int rtn) throws XAException {
        Debug.println(this, "Inspecting RPC return code of " + rtn);
        if (rtn < 0) {
            int xaCode = 0;
            String errMsg = null;
            boolean isError = true;
            switch (rtn) {
                case -1: {
                    xaCode = -3;
                    break;
                }
                case -2: {
                    xaCode = -4;
                    break;
                }
                case -3: {
                    xaCode = -8;
                    break;
                }
                case -4: {
                    xaCode = -7;
                    break;
                }
                case -5: {
                    xaCode = -5;
                    break;
                }
                case -6: {
                    xaCode = -6;
                    break;
                }
                case -128: {
                    xaCode = -6;
                    break;
                }
                case -256: {
                    isError = false;
                    break;
                }
                default: {
                    errMsg = "Unrecognized return code from server: " + rtn;
                    Debug.assert(this, false, errMsg);
                }
            }
            if (isError) {
                if (errMsg != null) {
                    throw new XAException(errMsg);
                }
                throw new XAException(xaCode);
            }
        }
    }
}

