/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.AdminApiDefinitionType;
import com.vmware.vcloud.api.rest.schema.extension.AdminFileDescriptorType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminFileDescriptor;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApiDefinition
extends VcloudEntity<AdminApiDefinitionType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminServiceRef;

    AdminApiDefinition(VcloudClient client, AdminApiDefinitionType apiDefinitionParams) {
        super(client, apiDefinitionParams);
        this.sortAdminApiDefinitionRefs();
    }

    private void sortAdminApiDefinitionRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((AdminApiDefinitionType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.service+xml")) continue;
                this.adminServiceRef = link;
            }
        }
    }

    public static AdminApiDefinition getAdminApiDefinitionByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminApiDefinition(client, (AdminApiDefinitionType)AdminApiDefinition.getResourceByReference(client, reference));
    }

    public static AdminApiDefinition getAdminApiDefinitionById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminApiDefinition(client, (AdminApiDefinitionType)AdminApiDefinition.getEntityById(client, vCloudId, "application/vnd.vmware.admin.apiDefinition+xml"));
    }

    public AdminFileDescriptor createAdminFileDescriptor(AdminFileDescriptorType fileDescParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createFileDescriptor(fileDescParams));
        return new AdminFileDescriptor(this.getVcloudClient(), (AdminFileDescriptorType)SdkUtil.post(this.getVcloudClient(), ((AdminApiDefinitionType)this.getResource()).getHref() + "/files", requestXML, "application/vnd.vmware.admin.fileDescriptor+xml", 201));
    }

    public ReferenceResult getAdminFileDescriptorRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/files" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminServiceReference() throws VCloudException {
        if (this.adminServiceRef != null) {
            return this.adminServiceRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

