/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ovf.CimString;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.api.rest.schema.ovf.ResourceType;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.constants.BusSubType;
import com.vmware.vcloud.sdk.constants.BusType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class VirtualDisk
extends HardwareItem {
    public VirtualDisk(BigInteger diskSize, BusType busType, BusSubType busSubType) {
        this(diskSize, busType, busSubType, null, null, null);
    }

    public VirtualDisk(BigInteger diskSize, BusType busType, BusSubType busSubType, Integer busNumber, Integer unitNumber) {
        this(diskSize, busType, busSubType, busNumber, unitNumber, null);
    }

    public VirtualDisk(BigInteger diskSize, BusType busType, BusSubType busSubType, ReferenceType storageProfileRef) {
        this(diskSize, busType, busSubType, null, null, storageProfileRef);
    }

    public VirtualDisk(BigInteger diskSize, BusType busType, BusSubType busSubType, Integer busNumber, Integer unitNumber, ReferenceType storageProfileRef) {
        super(new RASDType());
        CimString diskConfig = new CimString();
        Map cimAttributes = diskConfig.getOtherAttributes();
        if (busType.value().equals(BusType.IDE.value())) {
            cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "busType", "vcloud"), "5");
        } else {
            cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "busSubType", "vcloud"), busSubType.value());
            cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "busType", "vcloud"), "6");
        }
        cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "capacity", "vcloud"), diskSize.toString());
        if (storageProfileRef != null) {
            cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "storageProfileHref", "vcloud"), storageProfileRef.getHref());
            cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "storageProfileOverrideVmDefault", "vcloud"), "true");
        }
        CimString elementName = new CimString();
        elementName.setValue("");
        CimString instanceID = new CimString();
        instanceID.setValue("");
        ResourceType diskResourceType = new ResourceType();
        diskResourceType.setValue("17");
        RASDType disk = this.getItemResource();
        disk.setElementName(elementName);
        disk.setInstanceID(instanceID);
        disk.setResourceType(diskResourceType);
        if (unitNumber != null && busNumber != null) {
            CimString unitNo = new CimString();
            CimString busNo = new CimString();
            CimString busAddress = new CimString();
            unitNo.setValue(unitNumber.toString());
            busNo.setValue(busNumber.toString());
            busAddress.setValue(busNumber + busSubType.value() + unitNumber);
            disk.setAddressOnParent(unitNo);
            disk.setAddress(busNo);
            disk.setParent(busAddress);
        }
        List diskAttributes = disk.getHostResource();
        diskAttributes.add(diskConfig);
    }

    public VirtualDisk(RASDType virtualDiskItem) {
        super(virtualDiskItem);
    }

    public BigInteger getHardDiskSize() throws VCloudException {
        return new BigInteger(this.getHostResourceAttributeValue("capacity"));
    }

    public void updateHardDiskSize(BigInteger hardDiskSize) throws VCloudException {
        Map hostResourceAttributes = ((CimString)this.getItemResource().getHostResource().get(0)).getOtherAttributes();
        for (QName attr : hostResourceAttributes.keySet()) {
            if (!attr.getLocalPart().equals("capacity")) continue;
            hostResourceAttributes.put(attr, hardDiskSize.toString());
        }
    }

    public void overrideVmStorageProfile(boolean value) throws VCloudException {
        Map hostResourceAttributes = ((CimString)this.getItemResource().getHostResource().get(0)).getOtherAttributes();
        for (QName attr : hostResourceAttributes.keySet()) {
            if (!attr.getLocalPart().equals("storageProfileOverrideVmDefault")) continue;
            if (value) {
                hostResourceAttributes.put(attr, "true");
                continue;
            }
            hostResourceAttributes.put(attr, "false");
        }
    }

    public void updateStorageProfile(ReferenceType storageProfileRef) throws VCloudException {
        Map hostResourceAttributes = ((CimString)this.getItemResource().getHostResource().get(0)).getOtherAttributes();
        for (QName attr : hostResourceAttributes.keySet()) {
            if (!attr.getLocalPart().equals("storageProfileHref")) continue;
            hostResourceAttributes.put(attr, storageProfileRef.getHref());
        }
    }

    public String getHardDiskBusType() throws VCloudException {
        return this.getHostResourceAttributeValue("busSubType");
    }

    public Boolean isHardDisk() {
        return this.getItemResource().getResourceType().getValue().equals("17");
    }

    String getHostResourceAttributeValue(String attributeName) throws VCloudException {
        List hostResources;
        if (this.getItemResource().getResourceType().getValue().equals("17") && (hostResources = this.getItemResource().getHostResource()).size() > 0) {
            return this.getCimStringAttributeValue((CimString)this.getItemResource().getHostResource().get(0), attributeName);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_HARD_DISK_MSG) + " - " + this.getItemResource().getElementName().getValue());
    }
}

