/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.sdk.Expression;
import com.vmware.vcloud.sdk.constants.query.FilterType;
import java.util.ArrayList;
import java.util.List;

public class Filter {
    private String filterText = "";

    public Filter(Expression expression) {
        if (expression != null && expression.getExpressionText() != null && !expression.getExpressionText().isEmpty()) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            expressions.add(expression);
            this.setFilterText(expressions, null);
        }
    }

    public Filter(FilterType filterType, List<Expression> expressions) {
        this.setFilterText(expressions, filterType);
    }

    public Filter(List<Filter> filters, FilterType filterType) {
        StringBuilder filterValue = new StringBuilder();
        if (filters.size() > 0) {
            filterValue.append("(");
        }
        for (int i = 0; i < filters.size(); ++i) {
            if (filters.get(i).getFilterText().isEmpty()) continue;
            filterValue.append(filters.get(i).getFilterText());
            if (filterType.value() == null || i == filters.size() - 1) continue;
            filterValue.append(filterType.value());
        }
        if (filters.size() > 0) {
            filterValue.append(")");
        }
        this.filterText = filterValue.toString();
        if (this.filterText.equals("()")) {
            this.filterText = "";
        }
    }

    private void setFilterText(List<Expression> expressions, FilterType filterType) {
        StringBuilder filterValue = new StringBuilder();
        if (expressions.size() > 0) {
            filterValue.append("(");
        }
        for (int i = 0; i < expressions.size(); ++i) {
            if (expressions.get(i).getExpressionText().isEmpty()) continue;
            filterValue.append(expressions.get(i).getExpressionText());
            if (filterType == null || i == expressions.size() - 1 || expressions.get(i + 1).getExpressionText().isEmpty()) continue;
            filterValue.append(filterType.value());
        }
        if (expressions.size() > 0) {
            filterValue.append(")");
        }
        this.filterText = filterValue.toString();
        if (this.filterText.equals("()")) {
            this.filterText = "";
        }
    }

    String getFilterText() {
        return this.filterText;
    }
}

