/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.Base64Coder;
import com.eg.EgInstallInfo;
import com.eg.EgSSLCertificateAware;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

public class EgSSLCertificateManager
implements EgSSLCertificateAware {
    public ArrayList errorResult = new ArrayList();
    String aliasName = "";
    String certificateIssuerName = "";
    String certificateValidity = "";
    String version = "";
    boolean isCertInfoGenerated = false;
    Date certFrom = null;
    Date certTill = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllCertificateAlias(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        try {
            String string2 = System.getProperty("java.home");
            String string3 = string2 + "/lib/security/cacerts";
            File file = new File(string3);
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string4 = "changeit";
            keyStore.load(fileInputStream, string.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string5 = enumeration.nextElement();
                arrayList.add(string5);
            }
        }
        catch (CertificateException certificateException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(certificateException);
            certificateException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(noSuchAlgorithmException);
            noSuchAlgorithmException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(fileNotFoundException);
            fileNotFoundException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(keyStoreException);
            keyStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(iOException);
            iOException.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCertificateByAlias(String string, String string2) {
        String string3 = "";
        FileInputStream fileInputStream = null;
        try {
            String string4 = System.getProperty("java.home");
            String string5 = string4 + "/lib/security/cacerts";
            File file = new File(string5);
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string6 = "changeit";
            keyStore.load(fileInputStream, string2.toCharArray());
            Certificate certificate = keyStore.getCertificate(string);
            string3 = certificate.toString();
        }
        catch (CertificateException certificateException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(certificateException);
            certificateException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(noSuchAlgorithmException);
            noSuchAlgorithmException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(fileNotFoundException);
            fileNotFoundException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(keyStoreException);
            keyStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(iOException);
            iOException.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string3;
    }

    public synchronized boolean importSSLCertificate(String string) {
        BufferedInputStream bufferedInputStream = null;
        try {
            String string2 = System.getProperty("java.home");
            String string3 = string2 + "/lib/security/cacerts";
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string3), "changeit".toCharArray());
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = null;
            while (bufferedInputStream.available() > 0) {
                certificate = certificateFactory.generateCertificate(bufferedInputStream);
                keyStore.setCertificateEntry("adcert", certificate);
            }
            keyStore.setCertificateEntry("adcert", certificate);
            keyStore.store(new FileOutputStream(string3), "changeit".toCharArray());
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean importSSLCertificate(String string, String string2, String string3) {
        BufferedInputStream bufferedInputStream = null;
        try {
            String string4 = System.getProperty("java.home");
            String string5 = string4 + "/lib/security/cacerts";
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string5), string2.toCharArray());
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = null;
            while (bufferedInputStream.available() > 0) {
                certificate = certificateFactory.generateCertificate(bufferedInputStream);
                keyStore.setCertificateEntry(string3, certificate);
            }
            keyStore.setCertificateEntry(string3, certificate);
            keyStore.store(new FileOutputStream(string5), string2.toCharArray());
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean exportSSLCertificate(String string, String string2) {
        String string3 = EgInstallInfo.getInstallDir() + "/manager/tomcat/temp/";
        String string4 = this.getCertificateByAlias(string, string2);
        try {
            File file = new File(string3 + string + ".cer");
            if (file.exists()) {
                file.delete();
            }
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string4);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            return false;
        }
        return true;
    }

    public boolean isCertificateImported(String string, String string2) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            String string3 = System.getProperty("java.home");
            String string4 = string3 + "/lib/security/cacerts";
            File file = new File(string4);
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string5 = "changeit";
            keyStore.load(fileInputStream, string2.toCharArray());
            bl = keyStore.containsAlias(string);
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return bl;
    }

    public synchronized boolean deleteSSLCertificate(String string, String string2) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            String string3 = System.getProperty("java.home");
            String string4 = string3 + "/lib/security/cacerts";
            File file = new File(string4);
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string5 = "changeit";
            keyStore.load(fileInputStream, string2.toCharArray());
            try {
                keyStore.deleteEntry(string);
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
            keyStore.store(new FileOutputStream(string4), string2.toCharArray());
            bl = true;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        return bl;
    }

    public String getKeyStoreType() {
        return KeyStore.getDefaultType();
    }

    public String getCertificateImportedDate(String string, String string2) {
        String string3 = "";
        FileInputStream fileInputStream = null;
        Date date = null;
        try {
            String string4 = System.getProperty("java.home");
            String string5 = string4 + "/lib/security/cacerts";
            File file = new File(string5);
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string6 = "changeit";
            keyStore.load(fileInputStream, string2.toCharArray());
            date = keyStore.getCreationDate(string);
            string3 = date.toString();
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            this.errorResult.add("EXCEPTION");
            this.errorResult.add(exception);
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string3;
        }
        return string3;
    }

    public void generateCertificateInfo(String string, String string2) {
        Object var3_3 = null;
        Object var4_4 = null;
        try {
            String string3 = System.getProperty("java.home");
            String string4 = string3 + "/lib/security/cacerts";
            boolean bl = this.exportX509SSLCertificate(string, string2);
            if (bl) {
                String string5 = EgInstallInfo.getInstallDir() + "/manager/tomcat/temp/" + string + ".cer";
                FileInputStream fileInputStream = new FileInputStream(string5);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                ((InputStream)fileInputStream).close();
                this.isCertInfoGenerated = true;
                X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
                this.version = String.valueOf(x509Certificate.getVersion());
                this.certificateIssuerName = x500Principal.toString();
                this.certFrom = x509Certificate.getNotBefore();
                this.certTill = x509Certificate.getNotAfter();
                this.certificateValidity = x509Certificate.getNotBefore() + " - " + x509Certificate.getNotAfter();
                File file = new File(string5);
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setCertificateIssuerName(String string) {
        this.certificateIssuerName = string;
    }

    public String getCertificateIssuerName() {
        return this.certificateIssuerName;
    }

    public void setCertificateValidity(String string) {
        this.certificateValidity = string;
    }

    public String getCertificateValidity() {
        return this.certificateValidity;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isCertificateInfoGenerated() {
        return this.isCertInfoGenerated;
    }

    public void setCertFrom(Date date) {
        this.certFrom = date;
    }

    public Date getCertFrom() {
        return this.certFrom;
    }

    public void setCertTill(Date date) {
        this.certTill = date;
    }

    public Date getCertTill() {
        return this.certTill;
    }

    public static String getCertificateInstalledPath() {
        String string = System.getProperty("java.home");
        String string2 = string + "/lib/security/cacerts";
        return string2;
    }

    public boolean exportX509SSLCertificate(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = EgInstallInfo.getInstallDir() + "/manager/tomcat/temp/";
            String string4 = System.getProperty("java.home");
            String string5 = string4 + "/lib/security/cacerts";
            FileInputStream fileInputStream = new FileInputStream(string5);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, string2.toCharArray());
            Certificate certificate = keyStore.getCertificate(string);
            File file = new File(string3 + string + ".cer");
            if (file.exists()) {
                file.delete();
            }
            byte[] byArray = certificate.getEncoded();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            String string6 = new String(byArray, Charset.forName("UTF-8"));
            String string7 = Base64Coder.encodeString(string6);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            outputStreamWriter.write(string7);
            ((Writer)outputStreamWriter).flush();
            fileOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        EgSSLCertificateManager egSSLCertificateManager = new EgSSLCertificateManager();
        System.out.println("Certs " + egSSLCertificateManager.getAllCertificateAlias("changeit"));
    }
}

