/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgDbInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class EgDbConnection {
    Connection conn;
    Statement stmt;
    ResultSet rset;
    private String url;
    private String user;
    private String passwd;
    private String ntlmV2;
    EgDbInfo dbInfo = new EgDbInfo("manager");
    String dbType = "sql";

    public EgDbConnection() {
        System.setProperty("jsse.enableCBCProtection", "false");
        String string = this.dbInfo.getDriverForDb(this.dbType);
        if (string.equals("")) {
            return;
        }
        if (!this.loadDriver(string)) {
            return;
        }
        this.user = this.dbInfo.getUserForDb(this.dbType);
        this.passwd = this.dbInfo.getPasswdForDb(this.dbType);
        this.url = this.dbInfo.getUrlForDb(this.dbType);
        this.ntlmV2 = this.dbInfo.getNtlmV2ForDb(this.dbType);
        this.getConnection();
    }

    private boolean loadDriver(String string) {
        try {
            Driver driver = (Driver)Class.forName(string).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void getConnection() {
        try {
            int n = this.user.indexOf("\\");
            if (n < 0) {
                n = this.user.indexOf("/");
            }
            if (n < 0) {
                this.conn = DriverManager.getConnection(this.url, this.user, this.passwd);
            } else {
                String string = this.user.substring(0, n);
                String string2 = this.user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", string2);
                properties.put("password", this.passwd);
                properties.put("domain", string);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.url, properties);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

