/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import com.eg.cli.ConnectionThread;
import com.eg.cli.EgCLISSL;
import com.eg.cli.MyHostnameVerifier;
import com.eg.cli.MyX509TrustManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class URLConnect {
    private String IP = null;
    private String port = null;
    private boolean isSSLEnabled = false;
    private String servlet = null;
    private Object params = null;
    private ArrayList resultData = new ArrayList();
    private HttpURLConnection connection = null;

    public void setManagerIP(String string) {
        this.IP = string;
    }

    public void setManagerPort(String string) {
        this.port = string;
    }

    public void setSSLEnabled(boolean bl) {
        this.isSSLEnabled = bl;
    }

    public void setServerFile(String string) {
        this.servlet = string;
    }

    public void setResource(Object object) {
        this.params = object;
    }

    private void enableSSL() {
        EgCLISSL egCLISSL = EgCLISSL.getInstance();
        egCLISSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void connect() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isSSLEnabled) {
                this.enableSSL();
                stringBuffer.append("https");
            } else {
                stringBuffer.append("http");
            }
            stringBuffer.append("://");
            stringBuffer.append(this.IP);
            stringBuffer.append(":");
            stringBuffer.append(this.port);
            stringBuffer.append("/final/servlet/com.eg.");
            stringBuffer.append(this.servlet);
            URL uRL = new URL(stringBuffer.toString());
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("Content-Type", "text/plain;charset=UTF-8");
            Object[] objectArray = new Object[]{this.params};
            ArrayList arrayList = new ArrayList();
            ConnectionThread connectionThread = new ConnectionThread(this.connection, true, null, arrayList, objectArray);
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                this.resultData = connectionThread.data;
            } else {
                this.disconnect();
                String string = "Problem in communicating with the manager !";
                this.resultData.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l = 60000L;
        long l2 = 0L;
        long l3 = 250L;
        while (true) {
            URLConnect.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            long l4 = l3;
            if (l - l2 < l4) {
                l4 = l - l2;
            }
            l3 = l4;
        }
    }

    private static void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getLoginStatus() {
        String string = null;
        if (this.resultData != null && this.resultData.size() > 0) {
            string = (String)this.resultData.get(0);
        }
        return string;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }
}

