/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PGPU;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VGPU;
import com.xensource.xenapi.VGPUType;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class GPUGroup
extends XenAPIObject {
    protected final String ref;

    GPUGroup(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GPUGroup) {
            GPUGroup gPUGroup = (GPUGroup)object;
            return gPUGroup.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toGPUGroupRecord(v);
    }

    public static GPUGroup getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "GPU_group.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toGPUGroup(v);
    }

    public static Set<GPUGroup> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "GPU_group.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfGPUGroup(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<PGPU> getPGPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_PGPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPGPU(v);
    }

    public Set<VGPU> getVGPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_VGPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPU(v);
    }

    public Set<String> getGPUTypes(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_GPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Types.AllocationAlgorithm getAllocationAlgorithm(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_allocation_algorithm";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toAllocationAlgorithm(v);
    }

    public Set<VGPUType> getSupportedVGPUTypes(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_supported_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPUType(v);
    }

    public Set<VGPUType> getEnabledVGPUTypes(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPUType(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "GPU_group.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "GPU_group.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "GPU_group.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "GPU_group.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setAllocationAlgorithm(Connection connection, Types.AllocationAlgorithm allocationAlgorithm) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.set_allocation_algorithm";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)allocationAlgorithm)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task createAsync(Connection connection, String string, String string2, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.GPU_group.create";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string3, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static GPUGroup create(Connection connection, String string, String string2, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "GPU_group.create";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string3, objectArray);
        Object v = map2.get("Value");
        return Types.toGPUGroup(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.GPU_group.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task getRemainingCapacityAsync(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.GPU_group.get_remaining_capacity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long getRemainingCapacity(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_remaining_capacity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public static Set<GPUGroup> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfGPUGroup(v);
    }

    public static Map<GPUGroup, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "GPU_group.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfGPUGroupGPUGroupRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Set<PGPU> PGPUs;
        public Set<VGPU> VGPUs;
        public Set<String> GPUTypes;
        public Map<String, String> otherConfig;
        public Types.AllocationAlgorithm allocationAlgorithm;
        public Set<VGPUType> supportedVGPUTypes;
        public Set<VGPUType> enabledVGPUTypes;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "PGPUs", this.PGPUs);
            printWriter.printf("%1$20s: %2$s\n", "VGPUs", this.VGPUs);
            printWriter.printf("%1$20s: %2$s\n", "GPUTypes", this.GPUTypes);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"allocationAlgorithm", this.allocationAlgorithm});
            printWriter.printf("%1$20s: %2$s\n", "supportedVGPUTypes", this.supportedVGPUTypes);
            printWriter.printf("%1$20s: %2$s\n", "enabledVGPUTypes", this.enabledVGPUTypes);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("PGPUs", this.PGPUs == null ? new LinkedHashSet() : this.PGPUs);
            hashMap.put("VGPUs", this.VGPUs == null ? new LinkedHashSet() : this.VGPUs);
            hashMap.put("GPU_types", this.GPUTypes == null ? new LinkedHashSet() : this.GPUTypes);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("allocation_algorithm", (Object)(this.allocationAlgorithm == null ? Types.AllocationAlgorithm.UNRECOGNIZED : this.allocationAlgorithm));
            hashMap.put("supported_VGPU_types", this.supportedVGPUTypes == null ? new LinkedHashSet() : this.supportedVGPUTypes);
            hashMap.put("enabled_VGPU_types", this.enabledVGPUTypes == null ? new LinkedHashSet() : this.enabledVGPUTypes);
            return hashMap;
        }
    }
}

