/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.model;

import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.KeyValuePair;
import com.oracle.ovm.mgr.ws.model.ResourceGroup;
import java.util.List;

public abstract class BaseObject<T extends BaseObject> {
    private Id<T> id;
    private String name;
    private String description;
    private boolean locked;
    private long generation;
    private List<KeyValuePair> userData;
    private List<Id<ResourceGroup>> resourceGroupIds;

    public Id<T> getId() {
        return this.id;
    }

    public void setId(Id<T> id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration(long generation) {
        this.generation = generation;
    }

    public List<KeyValuePair> getUserData() {
        return this.userData;
    }

    public void setUserData(List<KeyValuePair> userData) {
        this.userData = userData;
    }

    public List<Id<ResourceGroup>> getResourceGroupIds() {
        return this.resourceGroupIds;
    }

    public void setResourceGroupIds(List<Id<ResourceGroup>> resourceGroupIds) {
        this.resourceGroupIds = resourceGroupIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseObject)) {
            return false;
        }
        BaseObject other = (BaseObject)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            String idName;
            name = "NULL";
            Id<T> id = this.getId();
            if (id != null && (idName = id.getValue()) != null) {
                name = idName;
            }
        }
        return name;
    }
}

