/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.i18n;

import com.oracle.ovm.mgr.ws.UtilMethods;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class I18NMessages {
    private static final String UNKNOWN_MESSAGE_KEY = "Unknown message key: {0}";

    private I18NMessages() {
    }

    public static String getMessage(Bundle i18nBundle, String messageKey, Object ... params) {
        try {
            Locale locale = I18NMessages.getClientLocale();
            ResourceBundle bundle = ResourceBundle.getBundle(i18nBundle.getBundlePath(), locale);
            String message = bundle.getString(messageKey);
            return MessageFormat.format(message, params);
        }
        catch (MissingResourceException ex) {
            return MessageFormat.format(UNKNOWN_MESSAGE_KEY, messageKey);
        }
    }

    public static boolean containsKey(Bundle i18nBundle, String messageKey) {
        Locale locale = I18NMessages.getClientLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(i18nBundle.getBundlePath(), locale);
        return bundle.containsKey(messageKey);
    }

    private static Locale getClientLocale() {
        Locale locale = null;
        try {
            locale = UtilMethods.getClientLocale();
        }
        catch (NoClassDefFoundError ex) {
            locale = null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static enum Bundle {
        ERROR_MESSAGES("com.oracle.ovm.mgr.ws.i18n.errorMessages"),
        JOB_MESSAGES("com.oracle.ovm.mgr.ws.i18n.jobMessages");

        private final String m_bundlePath;

        private Bundle(String bundlePath) {
            this.m_bundlePath = bundlePath;
        }

        public String getBundlePath() {
            return this.m_bundlePath;
        }
    }
}

