/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.GenericChart;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Renderer
implements Serializable {
    public static Cursor RESIZE_CURSOR;
    public static Cursor RESIZE_HOR_CURSOR;
    public static Cursor GRID_CURSOR_HORZ;
    public static Cursor GRID_CURSOR_VERT;
    public static Cursor HAND_CURSOR;
    public static Cursor DEFAULT_CURSOR;
    protected static final int DOUBLE_CLICK_TIME = 350;
    private Image do;
    private Image int;
    static Hashtable for;
    private static Object[] new;
    private static int byte;
    private static int if;
    private static int a;
    boolean try;
    protected GenericChart chart;

    public Renderer() {
    }

    public Renderer(GenericChart genericChart) {
        this.chart = genericChart;
        RESIZE_CURSOR = new Cursor(8);
        RESIZE_HOR_CURSOR = new Cursor(11);
        HAND_CURSOR = new Cursor(12);
        DEFAULT_CURSOR = new Cursor(0);
        GRID_CURSOR_VERT = new Cursor(8);
        GRID_CURSOR_HORZ = new Cursor(11);
        this.try = !System.getProperty("java.version").startsWith("1.1");
    }

    protected int getSeriesCount() {
        return this.chart.getSeriesCount();
    }

    protected int getSampleCount() {
        return this.chart.getSampleCount();
    }

    protected String getLabel(String string) {
        return this.chart.getLabel(string);
    }

    protected int getLabelAngle(String string) {
        return this.chart.getLabelAngle(string);
    }

    protected Font getFont(String string) {
        return this.chart.getFont(string);
    }

    protected FontMetrics getFontMetrics(Font font) {
        return this.chart.getFontMetrics(font);
    }

    protected Dimension getImageSize(String string) {
        Image image;
        Dimension dimension = new Dimension(0, 0);
        if (string != null && (image = this.chart.getImage(string)) != null) {
            dimension.width = image.getWidth(this.chart);
            dimension.height = image.getHeight(this.chart);
        }
        return dimension;
    }

    protected static Color getDarker(Color color) {
        if (color == null) {
            return null;
        }
        return new Color((int)((double)color.getRed() * 0.7), (int)((double)color.getGreen() * 0.7), (int)((double)color.getBlue() * 0.7), color.getAlpha());
    }

    protected static Color getBrighter(Color color) {
        if (color == null) {
            return null;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        n = n == 0 ? 64 : Math.min((int)((double)n / 0.7), 255);
        n2 = n2 == 0 ? 64 : Math.min((int)((double)n2 / 0.7), 255);
        n3 = n3 == 0 ? 64 : Math.min((int)((double)n3 / 0.7), 255);
        return new Color(n, n2, n3, n4);
    }

    protected void clearBackground(Graphics graphics, Dimension dimension) {
        if (this.try) {
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            try {
                Class<?> clazz = Class.forName("java.awt.Graphics2D");
                Method method = clazz.getMethod("getComposite", null);
                Object object = method.invoke((Object)graphics, null);
                Object object2 = Class.forName("java.awt.AlphaComposite").getField("Clear").get(null);
                Class[] classArray = new Class[]{Class.forName("java.awt.Composite")};
                Method method2 = clazz.getMethod("setComposite", classArray);
                method2.invoke((Object)graphics, object2);
                classArray = new Class[]{Class.forName("java.awt.Shape")};
                Method method3 = clazz.getMethod("fill", classArray);
                method3.invoke((Object)graphics, rectangle);
                method2.invoke((Object)graphics, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    protected void paintLabel(Graphics graphics, String string, int n, int n2, Dimension dimension, int n3, int n4, boolean bl) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string != null && n4 == 0) {
            String[] stringArray = Chart.getStringValues(string, "\n");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (stringArray[i] != null && !stringArray[i].equals("") && !stringArray[i].equals("\n")) {
                    int n5 = n;
                    int n6 = n2;
                    if (n3 != -1) {
                        if (n3 == 1) {
                            n5 = n + dimension.width - fontMetrics.stringWidth(stringArray[i]);
                        } else if (n3 == 0) {
                            n5 = n + dimension.width / 2 - fontMetrics.stringWidth(stringArray[i]) / 2;
                        }
                    }
                    graphics.drawString(stringArray[i], n5, n6);
                    if (bl) {
                        graphics.drawLine(n5, n6 + 1, n5 + fontMetrics.stringWidth(stringArray[i]) - 2, n6 + 1);
                    }
                }
                n2 += fontMetrics.getMaxAscent() + 1;
            }
        } else if (string != null && dimension.width != 0 && dimension.height != 0) {
            this.a(graphics, string, n, n2, dimension, n3, n4, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void a(Graphics graphics, String string, int n, int n2, Dimension dimension, int n3, int n4, boolean bl) {
        if (byte != for.size()) {
            Renderer.fifo_clear();
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Image image = null;
        Long l = null;
        if (new != null && !this.chart.isServletModeOn()) {
            l = new Long(Renderer.hashCode(string) + n4 + graphics.getFont().hashCode() + graphics.getColor().hashCode());
            image = (Image)for.get(l);
        }
        if (image == null) {
            Object[] objectArray;
            boolean bl2;
            boolean bl3 = bl2 = !System.getProperty("java.version").startsWith("1.1");
            if (!bl2) {
                if (this.do == null || dimension.width > this.do.getWidth(this.chart) || dimension.height > this.do.getHeight(this.chart)) {
                    if (this.do != null) {
                        this.do.flush();
                        this.do = null;
                        System.gc();
                    }
                    try {
                        this.do = this.chart.createImage(dimension.width, dimension.height);
                    }
                    catch (Throwable throwable) {
                        Renderer.fifo_clear();
                        try {
                            this.do = this.chart.createImage(dimension.width, dimension.height);
                        }
                        catch (Throwable throwable2) {
                            try {
                                this.do = this.chart.createImage_oldstyle(dimension.width, dimension.height);
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.do != null) {
                    objectArray = new Color[2];
                    objectArray[1] = graphics.getColor();
                    int[] nArray = new int[2];
                    this.a((Color[])objectArray, nArray);
                    Graphics graphics2 = this.do.getGraphics();
                    graphics2.setColor((Color)objectArray[0]);
                    graphics2.fillRect(0, 0, dimension.width, dimension.height);
                    graphics2.setColor((Color)objectArray[1]);
                    graphics2.setFont(graphics.getFont());
                    this.paintLabel(graphics2, string, 0, fontMetrics.getMaxAscent() - fontMetrics.getDescent() + 2, dimension, this.chart.getMultilineLabelAlignment(), 0, bl);
                    graphics2.dispose();
                    int[] nArray2 = new int[dimension.width * dimension.height];
                    PixelGrabber pixelGrabber = new PixelGrabber(this.do, 0, 0, dimension.width, dimension.height, nArray2, 0, dimension.width);
                    pixelGrabber.startGrabbing();
                    pixelGrabber.getPixels();
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray2[i] != nArray[0]) continue;
                        nArray2[i] = nArray[0] & 0xFFFFFF;
                    }
                    Dimension dimension2 = new Dimension(dimension.width, dimension.height);
                    int[] nArray3 = this.a(nArray2, n4, dimension2, nArray[0]);
                    try {
                        image = this.chart.createImage(new MemoryImageSource(dimension2.width, dimension2.height, nArray3, 0, dimension2.width));
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                if (n4 == 90) {
                    dimension.width += 2;
                }
                objectArray = this.getAngledLabelSize(dimension, n4);
                double d = (double)n4 / 180.0 * Math.PI;
                double d2 = (double)objectArray.width / 2.0;
                double d3 = (double)objectArray.height / 2.0;
                int n5 = (objectArray.height - dimension.height) / 2;
                int n6 = (objectArray.width - dimension.width) / 2;
                image = new BufferedImage(objectArray.width, objectArray.height, 2);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToRotation(d, d2, d3);
                Graphics2D graphics2D = (Graphics2D)image.getGraphics();
                graphics2D.setTransform(affineTransform);
                if (this.chart.isAntialiasingOn()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                graphics2D.setColor(graphics.getColor());
                graphics2D.setFont(graphics.getFont());
                this.paintLabel(graphics2D, string, n6, n5 + fontMetrics.getAscent() - fontMetrics.getDescent() + 2, dimension, -1, 0, bl);
            }
            if (new != null && !this.chart.isServletModeOn() && l != null && image != null) {
                Object[] objectArray2;
                objectArray = new;
                // MONITORENTER : new
                if (byte >= new.length && (objectArray2 = Renderer.fifo_remove()) != null) {
                    for.remove(objectArray2[0]);
                    ((Image)objectArray2[1]).flush();
                }
                for.put(l, image);
                Renderer.fifo_add(new Object[]{l, image});
                // MONITOREXIT : objectArray
            }
        }
        if (n4 == 180) {
            n2 -= fontMetrics.getAscent() - 2;
        }
        if (image == null) return;
        graphics.drawImage(image, n, n2, null);
    }

    private void a(Color[] colorArray, int[] nArray) {
        colorArray[0] = Color.white;
        if (colorArray[0].equals(colorArray[1])) {
            colorArray[0] = Color.black;
        }
        if (this.int == null) {
            try {
                this.int = this.chart.createImage(2, 1);
            }
            catch (Throwable throwable) {
                this.int = this.chart.createImage_oldstyle(2, 1);
            }
        }
        if (this.int != null) {
            Graphics graphics = this.int.getGraphics();
            graphics.setColor(colorArray[0]);
            graphics.drawLine(0, 0, 0, 0);
            graphics.setColor(colorArray[1]);
            graphics.drawLine(1, 0, 1, 0);
            PixelGrabber pixelGrabber = new PixelGrabber(this.int, 0, 0, 2, 1, nArray, 0, 2);
            pixelGrabber.startGrabbing();
            pixelGrabber.getPixels();
            if (nArray[0] == nArray[1]) {
                colorArray[0] = new Color(0x7FFFFF);
            }
            graphics.dispose();
        }
    }

    private int[] a(int[] nArray, int n, Dimension dimension, int n2) {
        if (n % 360 == 0) {
            return nArray;
        }
        if (n % 360 == 90) {
            int n3;
            int[] nArray2 = new int[nArray.length];
            for (n3 = 0; n3 < dimension.height; ++n3) {
                for (int i = 0; i < dimension.width; ++i) {
                    nArray2[i * dimension.height + n3] = nArray[dimension.width * dimension.height - dimension.width - n3 * dimension.width + i];
                }
            }
            n3 = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n3;
            return nArray2;
        }
        if (n % 360 == 180) {
            int[] nArray3 = new int[nArray.length];
            for (int i = 0; i < dimension.width; ++i) {
                for (int j = 0; j < dimension.height; ++j) {
                    nArray3[j * dimension.width + i] = nArray[dimension.width * dimension.height - 1 - j * dimension.width - i];
                }
            }
            return nArray3;
        }
        if (n % 360 == 270) {
            int n4;
            int[] nArray4 = new int[nArray.length];
            for (n4 = 0; n4 < dimension.height; ++n4) {
                for (int i = 0; i < dimension.width; ++i) {
                    nArray4[i * dimension.height + n4] = nArray[n4 * dimension.width + dimension.width - i - 1];
                }
            }
            n4 = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n4;
            return nArray4;
        }
        n = -n;
        double d = Math.sin((double)n * (Math.PI / 180));
        double d2 = Math.cos((double)n * (Math.PI / 180));
        double[] dArray = new double[2];
        Rectangle rectangle = new Rectangle(dimension);
        this.a(d2, d, rectangle, dArray);
        int n5 = -rectangle.x;
        int n6 = -rectangle.y;
        int[] nArray5 = new int[rectangle.width * rectangle.height];
        int[] nArray6 = new int[rectangle.width];
        for (int i = 0; i < rectangle.height; ++i) {
            this.a(d2, d, 0 - n5, i - n6, dArray);
            double d3 = dArray[0];
            double d4 = dArray[1];
            if (i == i) {
                // empty if block
            }
            this.a(d2, d, rectangle.width - n5, i - n6, dArray);
            double d5 = dArray[0];
            double d6 = dArray[1];
            double d7 = (d5 - d3) / (double)rectangle.width;
            double d8 = (d6 - d4) / (double)rectangle.width;
            for (int j = 0; j < rectangle.width; ++j) {
                int n7 = (int)Math.round(d3);
                int n8 = (int)Math.round(d4);
                nArray6[j] = n7 < 0 || n8 < 0 || n7 >= dimension.width || n8 >= dimension.height ? n2 & 0xFFFFFF : nArray[n8 * dimension.width + n7];
                d3 += d7;
                d4 += d8;
            }
            System.arraycopy(nArray6, 0, nArray5, i * rectangle.width, nArray6.length);
        }
        dimension.width = rectangle.width;
        dimension.height = rectangle.height;
        return nArray5;
    }

    private void if(double d, double d2, double d3, double d4, double[] dArray) {
        dArray[0] = d * d3 + d2 * d4;
        dArray[1] = d * d4 - d2 * d3;
    }

    private void a(double d, double d2, double d3, double d4, double[] dArray) {
        dArray[0] = d * d3 - d2 * d4;
        dArray[1] = d * d4 + d2 * d3;
    }

    private void a(double d, double d2, Rectangle rectangle, double[] dArray) {
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                this.if(d, d2, rectangle.x + j * rectangle.width, rectangle.y + i * rectangle.height, dArray);
                d3 = Math.min(d3, dArray[0]);
                d4 = Math.min(d4, dArray[1]);
                d5 = Math.max(d5, dArray[0]);
                d6 = Math.max(d6, dArray[1]);
            }
        }
        rectangle.x = (int)Math.floor(d3);
        rectangle.y = (int)Math.floor(d4);
        rectangle.width = (int)Math.ceil(d5) - rectangle.x + 1;
        rectangle.height = (int)Math.ceil(d6) - rectangle.y + 1;
    }

    protected void paintBox(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(bl ? color.darker() : Color.white);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4);
        graphics.setColor(bl ? Color.white : color.darker());
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
    }

    protected Dimension getLabelSize(String string, FontMetrics fontMetrics) {
        if (string == null || string.equals("") || fontMetrics == null) {
            return new Dimension(0, 0);
        }
        Long l = new Long(string.hashCode() + fontMetrics.getFont().hashCode());
        Dimension dimension = (Dimension)this.chart.F.get(l);
        if (dimension == null) {
            dimension = new Dimension(0, 0);
            if (string.indexOf("\n") == -1) {
                dimension.width = fontMetrics.stringWidth(string) + 2;
                dimension.height = fontMetrics.getMaxAscent() + 2;
            } else {
                String[] stringArray = Chart.getStringValues(string, "\n");
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    dimension.height += fontMetrics.getMaxAscent() + 1;
                    if (stringArray[i] == null || stringArray[i].equals("")) continue;
                    dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(stringArray[i]) + 2);
                }
                ++dimension.height;
            }
            dimension.height = Math.max(dimension.height, fontMetrics.getMaxAscent());
            if (!this.chart.isServletModeOn()) {
                this.chart.F.put(l, dimension);
            }
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    protected Dimension getAngledLabelSize(Dimension dimension, int n) {
        if (n == 90 || n == 270) {
            return new Dimension(dimension.height, dimension.width);
        }
        if (n > 0 && n < 360) {
            double d = Math.sin((double)n * (Math.PI / 180));
            double d2 = Math.cos((double)n * (Math.PI / 180));
            int n2 = (int)(Math.abs((double)dimension.width * d2) + Math.abs((double)dimension.height * d) + 0.5);
            int n3 = (int)(Math.abs((double)dimension.width * d) + Math.abs((double)dimension.height * d2) + 0.5);
            return new Dimension(n2, n3);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLabelAngleCacheSize(int n) {
        if (new != null) {
            Object[] objectArray = new;
            synchronized (new) {
                if (n > 0) {
                    new = new Object[n];
                    byte = 0;
                    if = 0;
                    a = 0;
                    for.clear();
                } else {
                    new = null;
                    for.clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (n > 0) {
            new = new Object[n];
            byte = 0;
            if = 0;
            a = 0;
            for.clear();
        } else {
            for.clear();
        }
    }

    public static Hashtable getAngledLabelCache() {
        return for;
    }

    public static void fifo_add(Object[] objectArray) {
        if (objectArray == null || objectArray.length != 2 || if == a && new[a] != null) {
            return;
        }
        if (++a >= new.length) {
            a = 0;
        }
        Renderer.new[Renderer.a] = objectArray;
        ++byte;
    }

    public static Object[] fifo_remove() {
        if (if == a && new[a] == null) {
            return null;
        }
        if (++if >= new.length) {
            if = 0;
        }
        Object[] objectArray = (Object[])new[if];
        Renderer.new[Renderer.if] = null;
        --byte;
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fifo_clear() {
        Object[] objectArray = new;
        synchronized (new) {
            for (int i = 0; new != null && i < new.length; ++i) {
                Object[] objectArray2 = (Object[])new[i];
                if (objectArray2 != null && objectArray2[1] != null) {
                    ((Image)objectArray2[1]).flush();
                }
                Renderer.new[i] = null;
            }
            byte = 0;
            if = 0;
            a = 0;
            for.clear();
            System.gc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Object[] getfifo_queue() {
        return new;
    }

    public static int getfifo_count() {
        return byte;
    }

    public static int hashCode(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (int i = n3; i > 0; --i) {
            n = n * 37 + cArray[n2++];
        }
        return n;
    }

    static {
        new = new Object[900];
        for = new Hashtable();
    }
}

