/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.HostDnsConfig;
import com.vmware.vim25.HostIpRouteConfig;
import com.vmware.vim25.HostIpRouteTableConfig;
import com.vmware.vim25.HostNetCapabilities;
import com.vmware.vim25.HostNetOffloadCapabilities;
import com.vmware.vim25.HostNetworkConfig;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.HostPortGroupSpec;
import com.vmware.vim25.HostVirtualNicSpec;
import com.vmware.vim25.HostVirtualSwitchSpec;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.PhysicalNicHintInfo;
import com.vmware.vim25.PhysicalNicLinkInfo;
import com.vmware.vim25.ResourceInUse;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ExtensibleManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class HostNetworkSystem
extends ExtensibleManagedObject {
    public HostNetworkSystem(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public HostNetCapabilities getCapabilities() {
        return (HostNetCapabilities)this.getCurrentProperty("capabilities");
    }

    public HostIpRouteConfig getConsoleIpRouteConfig() {
        return (HostIpRouteConfig)this.getCurrentProperty("consoleIpRouteConfig");
    }

    public HostDnsConfig getDnsConfig() {
        return (HostDnsConfig)this.getCurrentProperty("dnsConfig");
    }

    public HostIpRouteConfig getIpRouteConfig() {
        return (HostIpRouteConfig)this.getCurrentProperty("ipRouteConfig");
    }

    public HostNetworkConfig getNetworkConfig() {
        return (HostNetworkConfig)this.getCurrentProperty("networkConfig");
    }

    public HostNetworkInfo getNetworkInfo() {
        return (HostNetworkInfo)this.getCurrentProperty("networkInfo");
    }

    public HostNetOffloadCapabilities getOffloadCapabilities() {
        return (HostNetOffloadCapabilities)this.getCurrentProperty("offloadCapabilities");
    }

    public void addPortGroup(HostPortGroupSpec portgrp) throws HostConfigFault, AlreadyExists, NotFound, RuntimeFault, RemoteException {
        this.getVimService().addPortGroup(this.getMOR(), portgrp);
    }

    public String addServiceConsoleVirtualNic(String portgroup, HostVirtualNicSpec spec) throws HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().addServiceConsoleVirtualNic(this.getMOR(), portgroup, spec);
    }

    public String addVirtualNic(String portgroup, HostVirtualNicSpec nicSpec) throws HostConfigFault, AlreadyExists, RuntimeFault, RemoteException {
        return this.getVimService().addVirtualNic(this.getMOR(), portgroup, nicSpec);
    }

    public void addVirtualSwitch(String vswitchName, HostVirtualSwitchSpec spec) throws HostConfigFault, ResourceInUse, AlreadyExists, RuntimeFault, RemoteException {
        this.getVimService().addVirtualSwitch(this.getMOR(), vswitchName, spec);
    }

    public PhysicalNicHintInfo[] queryNetworkHint(String[] devices) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().queryNetworkHint(this.getMOR(), devices);
    }

    public void refreshNetworkSystem() throws RuntimeFault, RemoteException {
        this.getVimService().refreshNetworkSystem(this.getMOR());
    }

    public void removePortGroup(String pgName) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removePortGroup(this.getMOR(), pgName);
    }

    public void removeServiceConsoleVirtualNic(String device) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeServiceConsoleVirtualNic(this.getMOR(), device);
    }

    public void removeVirtualNic(String device) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeVirtualNic(this.getMOR(), device);
    }

    public void removeVirtualSwitch(String vswitchName) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeVirtualSwitch(this.getMOR(), vswitchName);
    }

    public void restartServiceConsoleVirtualNic(String device) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().restartServiceConsoleVirtualNic(this.getMOR(), device);
    }

    public void updateConsoleIpRouteConfig(HostIpRouteConfig config) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateConsoleIpRouteConfig(this.getMOR(), config);
    }

    public void updateDnsConfig(HostDnsConfig config) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateDnsConfig(this.getMOR(), config);
    }

    public void updateIpRouteConfig(HostIpRouteConfig config) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateIpRouteConfig(this.getMOR(), config);
    }

    public void updateIpRouteTableConfig(HostIpRouteTableConfig config) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateIpRouteTableConfig(this.getMOR(), config);
    }

    public void updateNetworkConfig(HostNetworkConfig config, String changeMode) throws HostConfigFault, AlreadyExists, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateNetworkConfig(this.getMOR(), config, changeMode);
    }

    public void updatePhysicalNicLinkSpeed(String device, PhysicalNicLinkInfo linkSpeed) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updatePhysicalNicLinkSpeed(this.getMOR(), device, linkSpeed);
    }

    public void updatePortGroup(String pgName, HostPortGroupSpec portgrp) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updatePortGroup(this.getMOR(), pgName, portgrp);
    }

    public void updateServiceConsoleVirtualNic(String device, HostVirtualNicSpec nic) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateServiceConsoleVirtualNic(this.getMOR(), device, nic);
    }

    public void updateVirtualNic(String device, HostVirtualNicSpec nic) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateVirtualNic(this.getMOR(), device, nic);
    }

    public void updateVirtualSwitch(String vswitchName, HostVirtualSwitchSpec spec) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateVirtualSwitch(this.getMOR(), vswitchName, spec);
    }
}

