/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.Protocol;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;

public class POP3Message
extends MimeMessage {
    static final String UNKNOWN = "UNKNOWN";
    private Protocol port;
    private int hdrSize = -1;
    private int msgSize = -1;
    String uid = "UNKNOWN";

    public POP3Message(POP3Folder pOP3Folder, int n, Protocol protocol) throws MessagingException {
        super((Folder)pOP3Folder, n);
        this.port = protocol;
    }

    public void setFlags(Flags flags, boolean bl) throws MessagingException {
        Flags flags2 = (Flags)this.flags.clone();
        super.setFlags(flags, bl);
        if (!this.flags.equals((Object)flags2)) {
            ((POP3Folder)((Message)this).folder).notifyMessageChangedListeners(1, (Message)this);
        }
    }

    public int getSize() throws MessagingException {
        if (this.msgSize >= 0) {
            return this.msgSize;
        }
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.msgSize < 0) {
                    if (this.headers == null) {
                        this.loadHeaders();
                    }
                    this.msgSize = this.content != null ? this.content.length : this.port.list(((Message)this).msgnum) - this.hdrSize;
                }
                int n = this.msgSize;
                Object var3_5 = null;
                return n;
            }
        }
        catch (EOFException eOFException) {
            ((Message)this).folder.close(false);
            throw new FolderClosedException(((Message)this).folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error getting size", (Exception)iOException);
        }
    }

    protected InputStream getContentStream() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.content == null) {
                    byte[] byArray = this.port.retr(((Message)this).msgnum);
                    if (byArray == null) {
                        ((Message)this).expunged = true;
                        throw new MessageRemovedException();
                    }
                    if (this.headers == null) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.headers = new InternetHeaders((InputStream)byteArrayInputStream);
                        this.hdrSize = byArray.length - ((InputStream)byteArrayInputStream).available();
                    } else {
                        int n;
                        int n2 = 0;
                        block6: do {
                            n = 0;
                            while (n2 < byArray.length) {
                                byte by;
                                if ((by = byArray[n2++]) == 10) continue block6;
                                if (by == 13) {
                                    if (n2 >= byArray.length || byArray[n2] != 10) continue block6;
                                    ++n2;
                                    continue block6;
                                }
                                ++n;
                            }
                        } while (n2 < byArray.length && n != 0);
                        this.hdrSize = n2;
                    }
                    this.content = new byte[byArray.length - this.hdrSize];
                    System.arraycopy(byArray, this.hdrSize, this.content, 0, this.content.length);
                    byArray = null;
                }
            }
        }
        catch (EOFException eOFException) {
            ((Message)this).folder.close(false);
            throw new FolderClosedException(((Message)this).folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error fetching POP3 content", (Exception)iOException);
        }
        return new ByteArrayInputStream(this.content, 0, this.content.length);
    }

    public String[] getHeader(String string) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    private void loadHeaders() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.headers != null) {
                    Object var2_4 = null;
                    return;
                }
                byte[] byArray = this.port.top(((Message)this).msgnum, 0);
                if (byArray == null) {
                    InputStream inputStream = this.getContentStream();
                    inputStream.close();
                } else {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.headers = new InternetHeaders((InputStream)byteArrayInputStream);
                    this.hdrSize = byArray.length;
                }
                return;
            }
        }
        catch (EOFException eOFException) {
            ((Message)this).folder.close(false);
            throw new FolderClosedException(((Message)this).folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error loading POP3 headers", (Exception)iOException);
        }
    }
}

