/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm;

import com.eg.org.objectweb.asm.ByteVector;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodWriter;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Symbol;
import com.eg.org.objectweb.asm.SymbolTable;
import com.eg.org.objectweb.asm.Type;

class Frame {
    static final int SAME_FRAME = 0;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    static final int RESERVED = 128;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    static final int CHOP_FRAME = 248;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int APPEND_FRAME = 252;
    static final int FULL_FRAME = 255;
    static final int ITEM_TOP = 0;
    static final int ITEM_INTEGER = 1;
    static final int ITEM_FLOAT = 2;
    static final int ITEM_DOUBLE = 3;
    static final int ITEM_LONG = 4;
    static final int ITEM_NULL = 5;
    static final int ITEM_UNINITIALIZED_THIS = 6;
    static final int ITEM_OBJECT = 7;
    static final int ITEM_UNINITIALIZED = 8;
    private static final int ITEM_ASM_BOOLEAN = 9;
    private static final int ITEM_ASM_BYTE = 10;
    private static final int ITEM_ASM_CHAR = 11;
    private static final int ITEM_ASM_SHORT = 12;
    private static final int DIM_SIZE = 6;
    private static final int KIND_SIZE = 4;
    private static final int FLAGS_SIZE = 2;
    private static final int VALUE_SIZE = 20;
    private static final int DIM_SHIFT = 26;
    private static final int KIND_SHIFT = 22;
    private static final int FLAGS_SHIFT = 20;
    private static final int DIM_MASK = -67108864;
    private static final int KIND_MASK = 0x3C00000;
    private static final int VALUE_MASK = 1048575;
    private static final int ARRAY_OF = 0x4000000;
    private static final int ELEMENT_OF = -67108864;
    private static final int CONSTANT_KIND = 0x400000;
    private static final int REFERENCE_KIND = 0x800000;
    private static final int UNINITIALIZED_KIND = 0xC00000;
    private static final int LOCAL_KIND = 0x1000000;
    private static final int STACK_KIND = 0x1400000;
    private static final int TOP_IF_LONG_OR_DOUBLE_FLAG = 0x100000;
    private static final int TOP = 0x400000;
    private static final int BOOLEAN = 0x400009;
    private static final int BYTE = 0x40000A;
    private static final int CHAR = 0x40000B;
    private static final int SHORT = 0x40000C;
    private static final int INTEGER = 0x400001;
    private static final int FLOAT = 0x400002;
    private static final int LONG = 0x400004;
    private static final int DOUBLE = 0x400003;
    private static final int NULL = 0x400005;
    private static final int UNINITIALIZED_THIS = 0x400006;
    Label owner;
    private int[] inputLocals;
    private int[] inputStack;
    private int[] outputLocals;
    private int[] outputStack;
    private short outputStackStart;
    private short outputStackTop;
    private int initializationCount;
    private int[] initializations;

    Frame(Label label) {
        this.owner = label;
    }

    final void copyFrom(Frame frame) {
        this.inputLocals = frame.inputLocals;
        this.inputStack = frame.inputStack;
        this.outputStackStart = 0;
        this.outputLocals = frame.outputLocals;
        this.outputStack = frame.outputStack;
        this.outputStackTop = frame.outputStackTop;
        this.initializationCount = frame.initializationCount;
        this.initializations = frame.initializations;
    }

    static int getAbstractTypeFromApiFormat(SymbolTable symbolTable, Object object) {
        if (object instanceof Integer) {
            return 0x400000 | (Integer)object;
        }
        if (object instanceof String) {
            String string = Type.getObjectType((String)object).getDescriptor();
            return Frame.getAbstractTypeFromDescriptor(symbolTable, string, 0);
        }
        return 0xC00000 | symbolTable.addUninitializedType("", ((Label)object).bytecodeOffset);
    }

    static int getAbstractTypeFromInternalName(SymbolTable symbolTable, String string) {
        return 0x800000 | symbolTable.addType(string);
    }

    private static int getAbstractTypeFromDescriptor(SymbolTable symbolTable, String string, int n2) {
        switch (string.charAt(n2)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0x400001;
            }
            case 'F': {
                return 0x400002;
            }
            case 'J': {
                return 0x400004;
            }
            case 'D': {
                return 0x400003;
            }
            case 'L': {
                String string2 = string.substring(n2 + 1, string.length() - 1);
                return 0x800000 | symbolTable.addType(string2);
            }
            case '[': {
                int n3;
                int n4 = n2 + 1;
                while (string.charAt(n4) == '[') {
                    ++n4;
                }
                switch (string.charAt(n4)) {
                    case 'Z': {
                        n3 = 0x400009;
                        break;
                    }
                    case 'C': {
                        n3 = 0x40000B;
                        break;
                    }
                    case 'B': {
                        n3 = 0x40000A;
                        break;
                    }
                    case 'S': {
                        n3 = 0x40000C;
                        break;
                    }
                    case 'I': {
                        n3 = 0x400001;
                        break;
                    }
                    case 'F': {
                        n3 = 0x400002;
                        break;
                    }
                    case 'J': {
                        n3 = 0x400004;
                        break;
                    }
                    case 'D': {
                        n3 = 0x400003;
                        break;
                    }
                    case 'L': {
                        String string3 = string.substring(n4 + 1, string.length() - 1);
                        n3 = 0x800000 | symbolTable.addType(string3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return n4 - n2 << 26 | n3;
            }
        }
        throw new IllegalArgumentException();
    }

    final void setInputFrameFromDescriptor(SymbolTable symbolTable, int n2, String string, int n3) {
        this.inputLocals = new int[n3];
        this.inputStack = new int[0];
        int n4 = 0;
        if ((n2 & 8) == 0) {
            if ((n2 & 0x40000) == 0) {
                int n5 = n4++;
                this.inputLocals[n5] = 0x800000 | symbolTable.addType(symbolTable.getClassName());
            } else {
                int n6 = n4++;
                this.inputLocals[n6] = 0x400006;
            }
        }
        for (Type type : Type.getArgumentTypes(string)) {
            int n7 = Frame.getAbstractTypeFromDescriptor(symbolTable, type.getDescriptor(), 0);
            this.inputLocals[n4++] = n7;
            if (n7 != 0x400004) {
                if (n7 != 0x400003) continue;
            }
            int n8 = n4++;
            this.inputLocals[n8] = 0x400000;
        }
        while (n4 < n3) {
            int n9 = n4++;
            this.inputLocals[n9] = 0x400000;
        }
    }

    final void setInputFrameFromApiFormat(SymbolTable symbolTable, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            this.inputLocals[n6++] = Frame.getAbstractTypeFromApiFormat(symbolTable, objectArray[n5]);
            if (objectArray[n5] != Opcodes.LONG && objectArray[n5] != Opcodes.DOUBLE) continue;
            int n7 = n6++;
            this.inputLocals[n7] = 0x400000;
        }
        while (n6 < this.inputLocals.length) {
            int n8 = n6++;
            this.inputLocals[n8] = 0x400000;
        }
        n5 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            if (objectArray2[n4] != Opcodes.LONG && objectArray2[n4] != Opcodes.DOUBLE) continue;
            ++n5;
        }
        this.inputStack = new int[n3 + n5];
        n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.inputStack[n4++] = Frame.getAbstractTypeFromApiFormat(symbolTable, objectArray2[i2]);
            if (objectArray2[i2] != Opcodes.LONG && objectArray2[i2] != Opcodes.DOUBLE) continue;
            int n9 = n4++;
            this.inputStack[n9] = 0x400000;
        }
        this.outputStackTop = 0;
        this.initializationCount = 0;
    }

    final int getInputStackSize() {
        return this.inputStack.length;
    }

    private int getLocal(int n2) {
        block5: {
            block4: {
                if (this.outputLocals == null) break block4;
                if (n2 < this.outputLocals.length) break block5;
            }
            return 0x1000000 | n2;
        }
        int n3 = this.outputLocals[n2];
        if (n3 == 0) {
            n3 = this.outputLocals[n2] = 0x1000000 | n2;
        }
        return n3;
    }

    private void setLocal(int n2, int n3) {
        int n4;
        if (this.outputLocals == null) {
            this.outputLocals = new int[10];
        }
        if (n2 >= (n4 = this.outputLocals.length)) {
            int[] nArray = new int[Math.max(n2 + 1, 2 * n4)];
            System.arraycopy(this.outputLocals, 0, nArray, 0, n4);
            this.outputLocals = nArray;
        }
        this.outputLocals[n2] = n3;
    }

    private void push(int n2) {
        int n3;
        if (this.outputStack == null) {
            this.outputStack = new int[10];
        }
        if (this.outputStackTop >= (n3 = this.outputStack.length)) {
            int[] nArray = new int[Math.max(this.outputStackTop + 1, 2 * n3)];
            System.arraycopy(this.outputStack, 0, nArray, 0, n3);
            this.outputStack = nArray;
        }
        short s2 = this.outputStackTop;
        this.outputStackTop = (short)(s2 + 1);
        this.outputStack[s2] = n2;
        short s3 = (short)(this.outputStackStart + this.outputStackTop);
        if (s3 > this.owner.outputStackMax) {
            this.owner.outputStackMax = s3;
        }
    }

    private void push(SymbolTable symbolTable, String string) {
        block2: {
            block3: {
                int n2 = string.charAt(0) == '(' ? Type.getReturnTypeOffset(string) : 0;
                int n3 = Frame.getAbstractTypeFromDescriptor(symbolTable, string, n2);
                if (n3 == 0) break block2;
                this.push(n3);
                if (n3 == 0x400004) break block3;
                if (n3 != 0x400003) break block2;
            }
            this.push(0x400000);
        }
    }

    private int pop() {
        if (this.outputStackTop > 0) {
            this.outputStackTop = (short)(this.outputStackTop - 1);
            return this.outputStack[this.outputStackTop];
        }
        this.outputStackStart = (short)(this.outputStackStart - 1);
        return 0x1400000 | -this.outputStackStart;
    }

    private void pop(int n2) {
        if (this.outputStackTop >= n2) {
            this.outputStackTop = (short)(this.outputStackTop - n2);
        } else {
            this.outputStackStart = (short)(this.outputStackStart - (n2 - this.outputStackTop));
            this.outputStackTop = 0;
        }
    }

    private void pop(String string) {
        char c10 = string.charAt(0);
        if (c10 == '(') {
            this.pop((Type.getArgumentsAndReturnSizes(string) >> 2) - 1);
        } else if (c10 == 'J' || c10 == 'D') {
            this.pop(2);
        } else {
            this.pop(1);
        }
    }

    private void addInitializedType(int n2) {
        int n3;
        if (this.initializations == null) {
            this.initializations = new int[2];
        }
        if (this.initializationCount >= (n3 = this.initializations.length)) {
            int[] nArray = new int[Math.max(this.initializationCount + 1, 2 * n3)];
            System.arraycopy(this.initializations, 0, nArray, 0, n3);
            this.initializations = nArray;
        }
        this.initializations[this.initializationCount++] = n2;
    }

    private int getInitializedType(SymbolTable symbolTable, int n2) {
        block9: {
            block8: {
                if (n2 == 0x400006) break block8;
                if ((n2 & 0xFFC00000) != 0xC00000) break block9;
            }
            for (int i2 = 0; i2 < this.initializationCount; ++i2) {
                int n3 = this.initializations[i2];
                int n4 = n3 & 0xFC000000;
                int n5 = n3 & 0x3C00000;
                int n6 = n3 & 0xFFFFF;
                if (n5 == 0x1000000) {
                    n3 = n4 + this.inputLocals[n6];
                } else if (n5 == 0x1400000) {
                    n3 = n4 + this.inputStack[this.inputStack.length - n6];
                }
                if (n2 != n3) continue;
                if (n2 == 0x400006) {
                    return 0x800000 | symbolTable.addType(symbolTable.getClassName());
                }
                return 0x800000 | symbolTable.addType(symbolTable.getType((int)(n2 & 0xFFFFF)).value);
            }
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    void execute(int var1_1, int var2_2, Symbol var3_3, SymbolTable var4_4) {
        block0 : switch (var1_1) {
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: {
                break;
            }
            case 1: {
                this.push(0x400005);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: {
                this.push(0x400001);
                break;
            }
            case 9: 
            case 10: 
            case 22: {
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                this.push(0x400002);
                break;
            }
            case 14: 
            case 15: 
            case 24: {
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 18: {
                switch (var3_3.tag) {
                    case 3: {
                        this.push(0x400001);
                        break block0;
                    }
                    case 5: {
                        this.push(0x400004);
                        this.push(0x400000);
                        break block0;
                    }
                    case 4: {
                        this.push(0x400002);
                        break block0;
                    }
                    case 6: {
                        this.push(0x400003);
                        this.push(0x400000);
                        break block0;
                    }
                    case 7: {
                        this.push(0x800000 | var4_4.addType("java/lang/Class"));
                        break block0;
                    }
                    case 8: {
                        this.push(0x800000 | var4_4.addType("java/lang/String"));
                        break block0;
                    }
                    case 16: {
                        this.push(0x800000 | var4_4.addType("java/lang/invoke/MethodType"));
                        break block0;
                    }
                    case 15: {
                        this.push(0x800000 | var4_4.addType("java/lang/invoke/MethodHandle"));
                        break block0;
                    }
                    case 17: {
                        this.push(var4_4, var3_3.value);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case 25: {
                this.push(this.getLocal(var2_2));
                break;
            }
            case 47: 
            case 143: {
                this.pop(2);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 49: 
            case 138: {
                this.pop(2);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 50: {
                this.pop(1);
                var5_5 = this.pop();
                this.push(var5_5 == 0x400005 ? var5_5 : -67108864 + var5_5);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                var5_6 = this.pop();
                this.setLocal(var2_2, var5_6);
                if (var2_2 <= 0) break;
                var9_16 = this.getLocal(var2_2 - 1);
                if (var9_16 == 0x400004) ** GOTO lbl107
                if (var9_16 != 0x400003) ** GOTO lbl109
lbl107:
                // 2 sources

                this.setLocal(var2_2 - 1, 0x400000);
                break;
lbl109:
                // 1 sources

                if ((var9_16 & 0x3C00000) != 0x1000000) {
                    if ((var9_16 & 0x3C00000) != 0x1400000) break;
                }
                this.setLocal(var2_2 - 1, var9_16 | 0x100000);
                break;
            }
            case 55: 
            case 57: {
                this.pop(1);
                var5_7 = this.pop();
                this.setLocal(var2_2, var5_7);
                this.setLocal(var2_2 + 1, 0x400000);
                if (var2_2 <= 0) break;
                var9_17 = this.getLocal(var2_2 - 1);
                if (var9_17 == 0x400004) ** GOTO lbl129
                if (var9_17 != 0x400003) ** GOTO lbl131
lbl129:
                // 2 sources

                this.setLocal(var2_2 - 1, 0x400000);
                break;
lbl131:
                // 1 sources

                if ((var9_17 & 0x3C00000) != 0x1000000) {
                    if ((var9_17 & 0x3C00000) != 0x1400000) break;
                }
                this.setLocal(var2_2 - 1, var9_17 | 0x100000);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 87: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 88: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 89: {
                var5_8 = this.pop();
                this.push(var5_8);
                this.push(var5_8);
                break;
            }
            case 90: {
                var5_9 = this.pop();
                var6_19 = this.pop();
                this.push(var5_9);
                this.push(var6_19);
                this.push(var5_9);
                break;
            }
            case 91: {
                var5_10 = this.pop();
                var6_20 = this.pop();
                var7_25 = this.pop();
                this.push(var5_10);
                this.push(var7_25);
                this.push(var6_20);
                this.push(var5_10);
                break;
            }
            case 92: {
                var5_11 = this.pop();
                var6_21 = this.pop();
                this.push(var6_21);
                this.push(var5_11);
                this.push(var6_21);
                this.push(var5_11);
                break;
            }
            case 93: {
                var5_12 = this.pop();
                var6_22 = this.pop();
                var7_26 = this.pop();
                this.push(var6_22);
                this.push(var5_12);
                this.push(var7_26);
                this.push(var6_22);
                this.push(var5_12);
                break;
            }
            case 94: {
                var5_13 = this.pop();
                var6_23 = this.pop();
                var7_27 = this.pop();
                var8_28 = this.pop();
                this.push(var6_23);
                this.push(var5_13);
                this.push(var8_28);
                this.push(var7_27);
                this.push(var6_23);
                this.push(var5_13);
                break;
            }
            case 95: {
                var5_14 = this.pop();
                var6_24 = this.pop();
                this.push(var5_14);
                this.push(var6_24);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(0x400001);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 137: 
            case 144: {
                this.pop(2);
                this.push(0x400002);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop(4);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 132: {
                this.setLocal(var2_2, 0x400001);
                break;
            }
            case 133: 
            case 140: {
                this.pop(1);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 134: {
                this.pop(1);
                this.push(0x400002);
                break;
            }
            case 135: 
            case 141: {
                this.pop(1);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 139: 
            case 190: 
            case 193: {
                this.pop(1);
                this.push(0x400001);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(0x400001);
                break;
            }
            case 168: 
            case 169: {
                throw new IllegalArgumentException("JSR/RET are not supported with computeFrames option");
            }
            case 178: {
                this.push(var4_4, var3_3.value);
                break;
            }
            case 179: {
                this.pop(var3_3.value);
                break;
            }
            case 180: {
                this.pop(1);
                this.push(var4_4, var3_3.value);
                break;
            }
            case 181: {
                this.pop(var3_3.value);
                this.pop();
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.pop(var3_3.value);
                if (var1_1 != 184) {
                    var5_15 = this.pop();
                    if (var1_1 == 183 && var3_3.name.charAt(0) == '<') {
                        this.addInitializedType(var5_15);
                    }
                }
                this.push(var4_4, var3_3.value);
                break;
            }
            case 186: {
                this.pop(var3_3.value);
                this.push(var4_4, var3_3.value);
                break;
            }
            case 187: {
                this.push(0xC00000 | var4_4.addUninitializedType(var3_3.value, var2_2));
                break;
            }
            case 188: {
                this.pop();
                switch (var2_2) {
                    case 4: {
                        this.push(0x4400009);
                        break block0;
                    }
                    case 5: {
                        this.push(0x440000B);
                        break block0;
                    }
                    case 8: {
                        this.push(0x440000A);
                        break block0;
                    }
                    case 9: {
                        this.push(0x440000C);
                        break block0;
                    }
                    case 10: {
                        this.push(0x4400001);
                        break block0;
                    }
                    case 6: {
                        this.push(0x4400002);
                        break block0;
                    }
                    case 7: {
                        this.push(0x4400003);
                        break block0;
                    }
                    case 11: {
                        this.push(0x4400004);
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 189: {
                var9_18 = var3_3.value;
                this.pop();
                if (var9_18.charAt(0) == '[') {
                    this.push(var4_4, '[' + var9_18);
                    break;
                }
                this.push(0x4800000 | var4_4.addType(var9_18));
                break;
            }
            case 192: {
                var10_29 = var3_3.value;
                this.pop();
                if (var10_29.charAt(0) == '[') {
                    this.push(var4_4, var10_29);
                    break;
                }
                this.push(0x800000 | var4_4.addType(var10_29));
                break;
            }
            case 197: {
                this.pop(var2_2);
                this.push(var4_4, var3_3.value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private int getConcreteOutputType(int n2, int n3) {
        block7: {
            int n4;
            block8: {
                block9: {
                    int n5;
                    int n6;
                    block4: {
                        int n7;
                        block5: {
                            block6: {
                                n6 = n2 & 0xFC000000;
                                n5 = n2 & 0x3C00000;
                                if (n5 != 0x1000000) break block4;
                                n7 = n6 + this.inputLocals[n2 & 0xFFFFF];
                                if ((n2 & 0x100000) == 0) break block5;
                                if (n7 == 0x400004) break block6;
                                if (n7 != 0x400003) break block5;
                            }
                            n7 = 0x400000;
                        }
                        return n7;
                    }
                    if (n5 != 0x1400000) break block7;
                    n4 = n6 + this.inputStack[n3 - (n2 & 0xFFFFF)];
                    if ((n2 & 0x100000) == 0) break block8;
                    if (n4 == 0x400004) break block9;
                    if (n4 != 0x400003) break block8;
                }
                n4 = 0x400000;
            }
            return n4;
        }
        return n2;
    }

    final boolean merge(SymbolTable symbolTable, Frame frame, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl2 = false;
        int n6 = this.inputLocals.length;
        int n7 = this.inputStack.length;
        if (frame.inputLocals == null) {
            frame.inputLocals = new int[n6];
            bl2 = true;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            n3 = this.outputLocals != null && n5 < this.outputLocals.length ? ((n4 = this.outputLocals[n5]) == 0 ? this.inputLocals[n5] : this.getConcreteOutputType(n4, n7)) : this.inputLocals[n5];
            if (this.initializations != null) {
                n3 = this.getInitializedType(symbolTable, n3);
            }
            bl2 |= Frame.merge(symbolTable, n3, frame.inputLocals, n5);
        }
        if (n2 > 0) {
            for (n5 = 0; n5 < n6; ++n5) {
                bl2 |= Frame.merge(symbolTable, this.inputLocals[n5], frame.inputLocals, n5);
            }
            if (frame.inputStack == null) {
                frame.inputStack = new int[1];
                bl2 = true;
            }
            return bl2 |= Frame.merge(symbolTable, n2, frame.inputStack, 0);
        }
        n5 = this.inputStack.length + this.outputStackStart;
        if (frame.inputStack == null) {
            frame.inputStack = new int[n5 + this.outputStackTop];
            bl2 = true;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n4 = this.inputStack[n3];
            if (this.initializations != null) {
                n4 = this.getInitializedType(symbolTable, n4);
            }
            bl2 |= Frame.merge(symbolTable, n4, frame.inputStack, n3);
        }
        for (n3 = 0; n3 < this.outputStackTop; ++n3) {
            n4 = this.outputStack[n3];
            int n8 = this.getConcreteOutputType(n4, n7);
            if (this.initializations != null) {
                n8 = this.getInitializedType(symbolTable, n8);
            }
            bl2 |= Frame.merge(symbolTable, n8, frame.inputStack, n5 + n3);
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean merge(SymbolTable var0, int var1_1, int[] var2_2, int var3_3) {
        block19: {
            block20: {
                block17: {
                    block18: {
                        block16: {
                            var4_4 = var2_2[var3_3];
                            if (var4_4 == var1_1) {
                                return false;
                            }
                            var5_5 = var1_1;
                            if ((var1_1 & 0x3FFFFFF) == 0x400005) {
                                if (var4_4 == 0x400005) {
                                    return false;
                                }
                                var5_5 = 0x400005;
                            }
                            if (var4_4 == 0) {
                                var2_2[var3_3] = var5_5;
                                return true;
                            }
                            if ((var4_4 & -67108864) != 0) break block16;
                            if ((var4_4 & 0x3C00000) != 0x800000) break block17;
                        }
                        if (var5_5 == 0x400005) {
                            return false;
                        }
                        if ((var5_5 & -4194304) != (var4_4 & -4194304)) break block18;
                        if ((var4_4 & 0x3C00000) == 0x800000) {
                            var6_6 = var5_5 & -67108864 | 0x800000 | var0.addMergedType(var5_5 & 1048575, var4_4 & 1048575);
                        } else {
                            var7_7 = -67108864 + (var5_5 & -67108864);
                            var6_6 = var7_7 | 0x800000 | var0.addType("java/lang/Object");
                        }
                        break block19;
                    }
                    if ((var5_5 & -67108864) != 0) ** GOTO lbl44
                    if ((var5_5 & 0x3C00000) == 0x800000) {
lbl44:
                        // 2 sources

                        if ((var7_8 = var5_5 & -67108864) != 0) {
                            if ((var5_5 & 0x3C00000) != 0x800000) {
                                var7_8 = -67108864 + var7_8;
                            }
                        }
                        if ((var8_9 = var4_4 & -67108864) != 0) {
                            if ((var4_4 & 0x3C00000) != 0x800000) {
                                var8_9 = -67108864 + var8_9;
                            }
                        }
                        var6_6 = Math.min(var7_8, var8_9) | 0x800000 | var0.addType("java/lang/Object");
                    } else {
                        var6_6 = 0x400000;
                    }
                    break block19;
                }
                if (var4_4 != 0x400005) break block20;
                if ((var5_5 & -67108864) != 0) ** GOTO lbl-1000
                if ((var5_5 & 0x3C00000) == 0x800000) lbl-1000:
                // 2 sources

                {
                    v0 = var5_5;
                } else {
                    v0 = 0x400000;
                }
                var6_6 = v0;
                break block19;
            }
            var6_6 = 0x400000;
        }
        if (var6_6 != var4_4) {
            var2_2[var3_3] = var6_6;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    final void accept(MethodWriter var1_1) {
        var2_2 = this.inputLocals;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var2_2.length) {
            var6_6 = var2_2[var5_5];
            if (var6_6 == 0x400004) ** GOTO lbl-1000
            if (var6_6 == 0x400003) lbl-1000:
            // 2 sources

            {
                v0 = 2;
            } else {
                v0 = 1;
            }
            var5_5 += v0;
            if (var6_6 == 0x400000) {
                ++var4_4;
                continue;
            }
            var3_3 += var4_4 + 1;
            var4_4 = 0;
        }
        var6_7 = this.inputStack;
        var7_8 = 0;
        var5_5 = 0;
        while (var5_5 < var6_7.length) {
            var8_9 = var6_7[var5_5];
            if (var8_9 == 0x400004) ** GOTO lbl-1000
            if (var8_9 == 0x400003) lbl-1000:
            // 2 sources

            {
                v1 = 2;
            } else {
                v1 = 1;
            }
            var5_5 += v1;
            ++var7_8;
        }
        var8_9 = var1_1.visitFrameStart(this.owner.bytecodeOffset, var3_3, var7_8);
        var5_5 = 0;
        while (var3_3-- > 0) {
            var9_10 = var2_2[var5_5];
            if (var9_10 == 0x400004) ** GOTO lbl-1000
            if (var9_10 == 0x400003) lbl-1000:
            // 2 sources

            {
                v2 = 2;
            } else {
                v2 = 1;
            }
            var5_5 += v2;
            var1_1.visitAbstractType(var8_9++, var9_10);
        }
        var5_5 = 0;
        while (var7_8-- > 0) {
            var9_10 = var6_7[var5_5];
            if (var9_10 == 0x400004) ** GOTO lbl-1000
            if (var9_10 == 0x400003) lbl-1000:
            // 2 sources

            {
                v3 = 2;
            } else {
                v3 = 1;
            }
            var5_5 += v3;
            var1_1.visitAbstractType(var8_9++, var9_10);
        }
        var1_1.visitFrameEnd();
    }

    static void putAbstractType(SymbolTable symbolTable, int n2, ByteVector byteVector) {
        int n3 = (n2 & 0xFC000000) >> 26;
        if (n3 == 0) {
            int n4 = n2 & 0xFFFFF;
            switch (n2 & 0x3C00000) {
                case 0x400000: {
                    byteVector.putByte(n4);
                    break;
                }
                case 0x800000: {
                    byteVector.putByte(7).putShort(symbolTable.addConstantClass((String)symbolTable.getType((int)n4).value).index);
                    break;
                }
                case 0xC00000: {
                    byteVector.putByte(8).putShort((int)symbolTable.getType((int)n4).data);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            while (n3-- > 0) {
                stringBuilder.append('[');
            }
            if ((n2 & 0x3C00000) == 0x800000) {
                stringBuilder.append('L').append(symbolTable.getType((int)(n2 & 0xFFFFF)).value).append(';');
            } else {
                switch (n2 & 0xFFFFF) {
                    case 9: {
                        stringBuilder.append('Z');
                        break;
                    }
                    case 10: {
                        stringBuilder.append('B');
                        break;
                    }
                    case 11: {
                        stringBuilder.append('C');
                        break;
                    }
                    case 12: {
                        stringBuilder.append('S');
                        break;
                    }
                    case 1: {
                        stringBuilder.append('I');
                        break;
                    }
                    case 2: {
                        stringBuilder.append('F');
                        break;
                    }
                    case 4: {
                        stringBuilder.append('J');
                        break;
                    }
                    case 3: {
                        stringBuilder.append('D');
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            byteVector.putByte(7).putShort(symbolTable.addConstantClass((String)stringBuilder.toString()).index);
        }
    }
}

