/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.Chart2;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.Renderer;
import com.objectplanet.chart.ext.PlotterChartRenderer;
import com.objectplanet.chart.ext.PlotterGrid;
import com.objectplanet.chart.ext.PlotterGridRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class PlotterChart
extends GenericChart
implements ItemSelectable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CENTER = 0;
    public static final int OVER = 1;
    public static final int UNDER = 2;
    public static final int BELOW = 3;
    public static final int FLOATING = 4;
    public static final int BELOW_AND_FLOATING = 5;
    public static final int SIDE = 6;
    public static final int PLOT_STYLE_CIRCLE = 0;
    public static final int PLOT_STYLE_CIRCLE_OPAQUE = 1;
    public static final int PLOT_STYLE_CIRCLE_FILLED = 2;
    public static final int PLOT_STYLE_SQUARE = 3;
    public static final int PLOT_STYLE_SQUARE_OPAQUE = 4;
    public static final int PLOT_STYLE_SQUARE_FILLED = 5;
    public static final int PLOT_STYLE_DIAMOND = 6;
    public static final int PLOT_STYLE_DIAMOND_OPAQUE = 7;
    public static final int PLOT_STYLE_DIAMOND_FILLED = 8;
    private int seriesCount;
    private boolean[] seriesOn;
    private double[][][] plots;
    private int[][] plotSize;
    private int[] plotSize_all;
    private int[] plotStyle;
    private String[][] plotLabels;
    private boolean plotLabelsOn;
    private int plotLabelStyle;
    private int XRangeLabelStyle;
    private Hashtable XRangeLabels;
    private Hashtable XRangeLabelLinesOn;
    private Hashtable XRangeLabelColors;
    private Color XRangeLabelsColor;
    private Color[] seriesColors;
    private double XUpperRange;
    private double XLowerRange;
    private double YUpperRange;
    private double YLowerRange;
    private double XCurrentUpperRange;
    private double XCurrentLowerRange;
    private double YCurrentUpperRange;
    private double YCurrentLowerRange;
    private double XRangeInterval;
    private double YRangeInterval;
    private int XRangeDecimalCount;
    private int YRangeDecimalCount;
    private int XMaxValueLineCount;
    private int YMaxValueLineCount;
    private boolean XAxisOn;
    private boolean YAxisOn;
    private boolean[] rangeOn;
    private boolean XValueLinesOn;
    private boolean YValueLinesOn;
    private Color XValueLinesColor;
    private Color YValueLinesColor;
    private Color[] rangeColor;
    Hashtable targetsLabel;
    Hashtable targetsValue;
    Hashtable targetsColor;
    Hashtable targetsStyle;
    private int targetLabelsPosition;
    private Color chartBackground;
    private Color chartForeground;
    private Color XAxisColor;
    private Color YAxisColor;
    private double[] gridLines;
    private Color[] gridLineColors;
    private Dimension preferredSize;
    private boolean automaticRepaintOn;
    private boolean[] connectedLinesOn;
    private int[] lineWidth;
    int mouseOverSampleIndex;
    int mouseOverSeriesIndex;
    private Vector listeners;
    private String[] seriesLabels;
    private Color[] seriesLabelColors;
    private int seriesLabelStyle;
    private boolean seriesLabelsOn;
    private int valueLabelStyle;
    private boolean[] XValueLabelsOn;
    private boolean[] YValueLabelsOn;
    private int[] XValueDecimalCount;
    private int[] YValueDecimalCount;
    private Hashtable labels;
    private Hashtable labelFonts;
    private Hashtable labelAngles;
    private boolean floatingOnLegendOn;
    private String chartTitle;
    private boolean chartTitleOn;
    private Hashtable images;
    private String gridImage;
    private String plotImage;
    private String[] plotImages_all;
    private Insets graphInsets;
    private boolean[] gridAdjustment;
    private Locale currentLocale;
    private String thousandsDelimiter;
    private Hashtable urlList;
    private boolean autoLabelSpacingOn;
    private boolean[] plotSortingOn;
    private boolean zoomOn;
    private NumberFormat[] rangeFormatters;
    private boolean[] rangeAdjusterOn;
    private NumberFormat numberFormatter;
    private Point mousePosition;
    private MediaTracker imageTracker;
    private int selectedSeries;
    private int selectedSample;
    private int lastSelectedSeries;
    private int lastSelectedSample;
    private Frame servletFrame;
    private Chart2 c2;
    private static Color[] DEFAULT_SERIES_COLORS = new Color[]{new Color(132, 130, 255), new Color(132, 32, 99), new Color(165, 227, 231), new Color(99, 0, 132), new Color(255, 130, 132), new Color(0, 130, 198), new Color(198, 195, 255), new Color(0, 0, 132), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(132, 0, 132), new Color(132, 0, 0), new Color(0, 130, 132), new Color(0, 0, 255), new Color(0, 207, 255), new Color(107, 255, 255), new Color(206, 255, 206), new Color(255, 255, 156), new Color(255, 255, 198)};
    private Class bufferedImageClass;
    private Constructor bufferedImageConstructor;
    private boolean bufferedImageClass_tried_loading;
    private int TYPE_INT_RGB;

    public PlotterChart() {
        this(1);
    }

    public PlotterChart(int seriesCount) {
        this.grid = new PlotterGrid(this);
        this.gridRenderer = new PlotterGridRenderer(this);
        this.renderer = new PlotterChartRenderer(this);
        this.chartType = "plotter";
        this.numberFormatter = NumberFormat.getInstance();
        this.old_cursor = null;
        this.new_cursor = Renderer.DEFAULT_CURSOR;
        this.setCursor(this.new_cursor);
        this.floatingOnLegendOn = true;
        try {
            this.c2 = new Chart2();
            this.c2.version = PlotterChart.getVersion();
        }
        catch (Throwable e) {
            throw new IllegalAccessError("No valid license");
        }
        this.enableEvents(49L);
        this.seriesOn = new boolean[seriesCount];
        this.plots = new double[seriesCount][0][3];
        this.plotSize = new int[seriesCount][0];
        this.plotSize_all = new int[seriesCount];
        this.plotStyle = new int[seriesCount];
        this.plotLabels = new String[seriesCount][0];
        this.plotLabelsOn = false;
        this.plotLabelStyle = 5;
        this.XRangeLabels = new Hashtable();
        this.XRangeLabelLinesOn = new Hashtable();
        this.XRangeLabelColors = new Hashtable();
        this.XRangeLabelStyle = 3;
        this.connectedLinesOn = new boolean[seriesCount];
        this.lineWidth = new int[seriesCount];
        this.plotSortingOn = new boolean[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            this.seriesOn[i] = true;
            this.plotStyle[i] = 2;
            this.lineWidth[i] = 1;
            this.plotSortingOn[i] = true;
        }
        this.plotImages_all = new String[seriesCount];
        this.setSeriesColors(null);
        this.legendSelection = new boolean[seriesCount];
        this.labels = new Hashtable();
        this.labelFonts = new Hashtable();
        this.labelAngles = new Hashtable();
        this.images = new Hashtable();
        this.imageTracker = new MediaTracker(this);
        this.graphInsets = new Insets(-1, -1, -1, -1);
        this.gridAdjustment = new boolean[4];
        this.urlList = new Hashtable();
        this.autoLabelSpacingOn = false;
        this.seriesLabels = new String[seriesCount];
        this.seriesLabelColors = new Color[seriesCount];
        this.XValueLabelsOn = new boolean[seriesCount];
        this.YValueLabelsOn = new boolean[seriesCount];
        this.XValueDecimalCount = new int[seriesCount];
        this.YValueDecimalCount = new int[seriesCount];
        this.preferredSize = new Dimension(300, 200);
        this.automaticRepaintOn = true;
        this.selectedSeries = -1;
        this.selectedSample = -1;
        this.listeners = new Vector();
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
        this.XUpperRange = 100.0;
        this.YUpperRange = 100.0;
        this.XCurrentUpperRange = 100.0;
        this.YCurrentUpperRange = 100.0;
        this.XAxisOn = true;
        this.YAxisOn = true;
        this.rangeOn = new boolean[4];
        this.rangeOn[0] = true;
        this.rangeOn[3] = true;
        this.rangeColor = new Color[4];
        this.rangeFormatters = new NumberFormat[2];
        this.XMaxValueLineCount = Integer.MAX_VALUE;
        this.YMaxValueLineCount = Integer.MAX_VALUE;
        this.rangeAdjusterOn = new boolean[4];
        this.XValueLinesOn = true;
        this.YValueLinesOn = true;
        this.targetsLabel = new Hashtable();
        this.targetsValue = new Hashtable();
        this.targetsColor = new Hashtable();
        this.targetsStyle = new Hashtable();
        this.mousePosition = new Point();
        this.setBackground(new Color(231, 221, 231));
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.setFont("plotLabelFont", new Font("Arial", 0, 11));
        this.chartBackground = Color.white;
        this.chartForeground = new Color(128, 128, 128);
        this.setForeground(Color.black);
        this.setBackground(new Color(231, 221, 231));
        this.seriesCount = seriesCount;
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.setSize(300, 200);
    }

    public void reset() {
        this.seriesCount = 1;
        this.plots = new double[this.seriesCount][0][3];
        this.plotSize = new int[this.seriesCount][0];
        this.plotSize_all = new int[this.seriesCount];
        this.plotLabels = new String[this.seriesCount][0];
        this.plotLabelsOn = false;
        this.plotLabelStyle = 5;
        this.XRangeLabels.clear();
        this.XRangeLabelLinesOn.clear();
        this.XRangeLabelColors.clear();
        this.XRangeLabelStyle = 3;
        this.lineWidth = new int[1];
        this.connectedLinesOn = new boolean[1];
        this.seriesOn = new boolean[1];
        this.plotSortingOn = new boolean[1];
        this.plotStyle = new int[this.seriesCount];
        this.lineWidth[0] = 1;
        this.seriesOn[0] = true;
        this.plotSortingOn[0] = true;
        this.plotStyle[0] = 2;
        this.plotImages_all = new String[this.seriesCount];
        this.setSeriesColors(null);
        this.legendSelection = new boolean[this.seriesCount];
        this.seriesLabels = new String[this.seriesCount];
        this.floatingOnLegendOn = true;
        this.displayVersionOn = false;
        this.images.clear();
        this.imageTracker = new MediaTracker(this);
        this.graphInsets = new Insets(-1, -1, -1, -1);
        this.gridAdjustment = new boolean[4];
        this.preferredSize = new Dimension(300, 200);
        this.automaticRepaintOn = true;
        this.selectedSeries = -1;
        this.selectedSample = -1;
        this.listeners = new Vector();
        this.labels.clear();
        this.labelFonts.clear();
        this.labelAngles.clear();
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
        this.urlList.clear();
        this.autoLabelSpacingOn = false;
        this.XUpperRange = 100.0;
        this.YUpperRange = 100.0;
        this.XCurrentUpperRange = 100.0;
        this.YCurrentUpperRange = 100.0;
        this.XAxisOn = true;
        this.YAxisOn = true;
        this.rangeOn = new boolean[4];
        this.rangeOn[0] = true;
        this.rangeOn[3] = true;
        this.rangeColor = new Color[4];
        this.XMaxValueLineCount = Integer.MAX_VALUE;
        this.YMaxValueLineCount = Integer.MAX_VALUE;
        this.rangeAdjusterOn = new boolean[4];
        this.XValueLinesOn = true;
        this.YValueLinesOn = true;
        this.targetsLabel.clear();
        this.targetsValue.clear();
        this.targetsColor.clear();
        this.targetsStyle.clear();
        this.gridLines = null;
        this.gridLineColors = null;
        this.seriesLabels = new String[this.seriesCount];
        this.seriesLabelColors = new Color[this.seriesCount];
        this.XValueLabelsOn = new boolean[this.seriesCount];
        this.YValueLabelsOn = new boolean[this.seriesCount];
        this.XValueDecimalCount = new int[this.seriesCount];
        this.YValueDecimalCount = new int[this.seriesCount];
        this.mousePosition = new Point();
        this.setBackground(new Color(231, 221, 231));
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.chartBackground = Color.white;
        this.chartForeground = new Color(96, 96, 96);
        this.setForeground(Color.black);
        this.setBackground(new Color(231, 221, 231));
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.currentLocale = null;
    }

    Grid getGrid() {
        return this.grid;
    }

    GridRenderer getGridRenderer() {
        return this.gridRenderer;
    }

    Legend getLegend() {
        return this.legend;
    }

    LegendRenderer getLegendRenderer() {
        return this.legendRenderer;
    }

    public void setSeriesCount(int count) {
        if (count != this.getSeriesCount()) {
            this.seriesCount = Math.max(1, count);
            double[][][] newPlots = new double[this.seriesCount][][];
            for (int series = 0; series < this.seriesCount; ++series) {
                if (series < this.plots.length) {
                    newPlots[series] = new double[this.plots[series].length][2];
                    for (int index = 0; index < this.plots[series].length; ++index) {
                        newPlots[series][index][0] = this.plots[series][index][0];
                        newPlots[series][index][1] = this.plots[series][index][1];
                    }
                    continue;
                }
                newPlots[series] = new double[0][2];
            }
            this.plots = newPlots;
            int[][] newPlotSize = new int[this.seriesCount][];
            for (int series = 0; series < this.seriesCount; ++series) {
                if (series < this.plotSize.length) {
                    newPlotSize[series] = new int[this.plotSize[series].length];
                    System.arraycopy(this.plotSize[series], 0, newPlotSize[series], 0, this.plotSize[series].length);
                    continue;
                }
                newPlotSize[series] = new int[0];
            }
            this.plotSize = newPlotSize;
            String[][] newPlotLabels = new String[this.seriesCount][];
            for (int series = 0; series < this.seriesCount; ++series) {
                if (series < this.plotLabels.length) {
                    newPlotLabels[series] = new String[this.plotLabels[series].length];
                    System.arraycopy(this.plotLabels[series], 0, newPlotLabels[series], 0, this.plotLabels[series].length);
                    continue;
                }
                newPlotLabels[series] = new String[0];
            }
            this.plotLabels = newPlotLabels;
            boolean[] newSeriesOn = new boolean[this.seriesCount];
            int[] newPlotSize_all = new int[this.seriesCount];
            int[] newLineWidth = new int[this.seriesCount];
            int[] newPlotStyle = new int[this.seriesCount];
            boolean[] newConnectedLinesOn = new boolean[this.seriesCount];
            boolean[] newPlotSortingOn = new boolean[this.seriesCount];
            String[] newSeriesLabels = new String[this.seriesCount];
            Color[] newSeriesLabelColors = new Color[this.seriesCount];
            boolean[] newXValueLabelsOn = new boolean[this.seriesCount];
            boolean[] newYValueLabelsOn = new boolean[this.seriesCount];
            int[] newXValueDecimalCount = new int[this.seriesCount];
            int[] newYValueDecimalCount = new int[this.seriesCount];
            System.arraycopy(this.seriesOn, 0, newSeriesOn, 0, Math.min(this.seriesOn.length, newSeriesOn.length));
            System.arraycopy(this.plotSize_all, 0, newPlotSize_all, 0, Math.min(this.plotSize_all.length, newPlotSize_all.length));
            System.arraycopy(this.plotStyle, 0, newPlotStyle, 0, Math.min(this.plotStyle.length, newPlotStyle.length));
            System.arraycopy(this.lineWidth, 0, newLineWidth, 0, Math.min(this.lineWidth.length, newLineWidth.length));
            System.arraycopy(this.connectedLinesOn, 0, newConnectedLinesOn, 0, Math.min(this.connectedLinesOn.length, newConnectedLinesOn.length));
            System.arraycopy(this.plotSortingOn, 0, newPlotSortingOn, 0, Math.min(this.plotSortingOn.length, newPlotSortingOn.length));
            System.arraycopy(this.seriesLabels, 0, newSeriesLabels, 0, Math.min(this.seriesLabels.length, newSeriesLabels.length));
            System.arraycopy(this.seriesLabelColors, 0, newSeriesLabelColors, 0, Math.min(this.seriesLabelColors.length, newSeriesLabelColors.length));
            System.arraycopy(this.XValueLabelsOn, 0, newXValueLabelsOn, 0, Math.min(this.XValueLabelsOn.length, newXValueLabelsOn.length));
            System.arraycopy(this.YValueLabelsOn, 0, newYValueLabelsOn, 0, Math.min(this.YValueLabelsOn.length, newYValueLabelsOn.length));
            System.arraycopy(this.XValueDecimalCount, 0, newXValueDecimalCount, 0, Math.min(this.XValueDecimalCount.length, newXValueDecimalCount.length));
            System.arraycopy(this.YValueDecimalCount, 0, newYValueDecimalCount, 0, Math.min(this.YValueDecimalCount.length, newYValueDecimalCount.length));
            for (int i = this.plotSize_all.length; i < newPlotSize_all.length; ++i) {
                newSeriesOn[i] = true;
                newPlotSortingOn[i] = true;
                newPlotSize_all[i] = 0;
                newPlotStyle[i] = 2;
                newLineWidth[i] = 1;
            }
            this.seriesOn = newSeriesOn;
            this.plotSize_all = newPlotSize_all;
            this.plotStyle = newPlotStyle;
            this.lineWidth = newLineWidth;
            this.connectedLinesOn = newConnectedLinesOn;
            this.plotSortingOn = newPlotSortingOn;
            this.seriesLabels = newSeriesLabels;
            this.seriesLabelColors = newSeriesLabelColors;
            this.XValueLabelsOn = newXValueLabelsOn;
            this.YValueLabelsOn = newYValueLabelsOn;
            this.XValueDecimalCount = newXValueDecimalCount;
            this.YValueDecimalCount = newYValueDecimalCount;
            String[] legendLabels = this.getLegendLabels();
            if (this.legendSelection.length != legendLabels.length) {
                boolean[] newLegendSelection = new boolean[legendLabels.length];
                System.arraycopy(this.legendSelection, 0, newLegendSelection, 0, Math.min(this.legendSelection.length, newLegendSelection.length));
                this.legendSelection = newLegendSelection;
            }
            this.autoRepaint();
        }
    }

    public void setSeriesOn(boolean on) {
        for (int i = 0; i < this.seriesOn.length; ++i) {
            this.setSeriesOn(i, on);
        }
    }

    public void setSeriesOn(int series, boolean on) {
        try {
            this.seriesOn[series] = on;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.autoRepaint();
    }

    public boolean isSeriesOn(int series) {
        try {
            return this.seriesOn[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public boolean isSeriesEmpty(int index) {
        return false;
    }

    protected String constructLabel(int series, int sample, int style, boolean paintSeriesOn, String percentLabel) {
        return ((PlotterChartRenderer)this.renderer).constructLabel(series, sample, style);
    }

    protected double getHighestValue(int rangeIndex) {
        return Double.MAX_VALUE;
    }

    protected double getLowestValue(int rangeIndex) {
        return Double.MIN_VALUE;
    }

    public void setTitle(String title) {
        this.chartTitle = title;
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public void setTitleOn(boolean on) {
        if (on != this.chartTitleOn) {
            this.chartTitleOn = on;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public boolean isTitleOn() {
        return this.chartTitleOn;
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public int getSampleCount() {
        int sampleCount = 0;
        for (int i = 0; i < this.plots.length; ++i) {
            sampleCount = Math.max(sampleCount, this.getSampleCount(i));
        }
        return sampleCount;
    }

    public int getSampleCount(int series) {
        if (series < this.plots.length) {
            return this.plots[series].length;
        }
        return 0;
    }

    public void setPlots(int series, double[][] plots) {
        this.setPlots(series, plots, 0);
    }

    public void setPlots(int series, double[][] plots, int size) {
        int[] plot_size = new int[plots.length];
        for (int i = 0; i < plot_size.length; ++i) {
            plot_size[i] = 0;
        }
        this.setPlots(series, plots, plot_size);
        this.plotSize_all[series] = size;
    }

    public void setPlots(int series, double[][] plots, int[] size) {
        int i;
        if (plots == null || series >= this.getSeriesCount() || series < 0) {
            return;
        }
        double[][] sorted_plots = new double[plots.length][3];
        for (i = 0; i < plots.length; ++i) {
            sorted_plots[i][0] = plots[i][0];
            sorted_plots[i][1] = plots[i][1];
            if (size == null || i >= size.length) continue;
            sorted_plots[i][2] = size[i];
        }
        if (this.plotSortingOn[series]) {
            this.qsort(series, sorted_plots, 0, sorted_plots.length - 1);
        }
        this.plots[series] = new double[plots.length][2];
        if (plots.length > this.plotSize[series].length || size != null && size.length > this.plotSize[series].length) {
            int[] new_size = new int[Math.max(plots.length, size.length)];
            System.arraycopy(this.plotSize[series], 0, new_size, 0, this.plotSize[series].length);
            this.plotSize[series] = new_size;
        }
        for (i = 0; i < plots.length; ++i) {
            this.plots[series][i][0] = sorted_plots[i][0];
            this.plots[series][i][1] = sorted_plots[i][1];
        }
        for (i = 0; size != null && i < size.length; ++i) {
            if (!(sorted_plots[i][2] > 0.0)) continue;
            this.plotSize[series][i] = (int)sorted_plots[i][2];
        }
        this.autoRepaint();
    }

    public double[][] getPlots(int series) {
        if (this.plots == null) {
            return null;
        }
        try {
            return this.plots[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public void setPlot(int series, double x, double y) {
        this.setPlot(series, x, y, 0);
    }

    public void setPlot(int series, double x, double y, int size) {
        if (this.plots == null) {
            return;
        }
        if (series >= this.plots.length || series < 0) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        double[][] currentPlots = this.plots[series];
        int[] currentSize = this.plotSize[series];
        if (currentPlots.length == 0) {
            currentPlots = new double[1][2];
            currentSize = new int[1];
            currentPlots[0][0] = x;
            currentPlots[0][1] = y;
            currentSize[0] = size;
        } else {
            for (int i = 0; i < currentPlots.length; ++i) {
                if (x < currentPlots[i][0]) {
                    double[][] newPlots = new double[currentPlots.length + 1][2];
                    System.arraycopy(currentPlots, 0, newPlots, 0, i);
                    newPlots[i][0] = x;
                    newPlots[i][1] = y;
                    System.arraycopy(currentPlots, i, newPlots, i + 1, currentPlots.length - i);
                    currentPlots = newPlots;
                    int[] newSize = new int[currentSize.length + 1];
                    System.arraycopy(currentSize, 0, newSize, 0, i);
                    newSize[i] = size;
                    System.arraycopy(currentSize, i, newSize, i + 1, currentSize.length - i);
                    currentSize = newSize;
                    break;
                }
                if (x != currentPlots[i][0]) continue;
                currentPlots[i][1] = y;
                currentSize[i] = size;
                break;
            }
            if (x > currentPlots[currentPlots.length - 1][0]) {
                double[][] newPlots = new double[currentPlots.length + 1][2];
                System.arraycopy(currentPlots, 0, newPlots, 0, currentPlots.length);
                newPlots[currentPlots.length][0] = x;
                newPlots[currentPlots.length][1] = y;
                currentPlots = newPlots;
                int[] newSize = new int[currentSize.length + 1];
                System.arraycopy(currentSize, 0, newSize, 0, currentSize.length);
                newSize[currentSize.length] = size;
                currentSize = newSize;
            }
        }
        this.plots[series] = currentPlots;
        this.plotSize[series] = currentSize;
        this.autoRepaint();
    }

    public void setPlotSize(int series, int size) {
        try {
            if (series == -1) {
                for (int i = 0; i < this.plotSize_all.length; ++i) {
                    this.plotSize_all[i] = size;
                }
            } else {
                this.plotSize_all[series] = size;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.autoRepaint();
    }

    public void setPlotSize(int series, int[] size) {
        if (size == null) {
            return;
        }
        try {
            if (series == -1) {
                for (int i = 0; i < this.plotSize.length; ++i) {
                    if (size.length > this.plotSize[i].length) {
                        this.plotSize[i] = new int[size.length];
                    }
                    System.arraycopy(size, 0, this.plotSize[i], 0, size.length);
                }
            } else {
                if (size.length > this.plotSize[series].length) {
                    this.plotSize[series] = new int[size.length];
                }
                System.arraycopy(size, 0, this.plotSize[series], 0, size.length);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.autoRepaint();
    }

    public int getPlotSize(int series) {
        try {
            return this.plotSize_all[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public int getPlotSize(int series, int index) {
        if (this.plotSize != null && series < this.plotSize.length && index < this.plotSize[series].length && this.plotSize[series][index] > 0) {
            return this.plotSize[series][index];
        }
        return this.getPlotSize(series);
    }

    public void setPlotLabels(int series, String[] labels) {
        if (labels == null) {
            return;
        }
        try {
            if (labels.length > this.plotLabels[series].length) {
                this.plotLabels[series] = new String[labels.length];
            }
            System.arraycopy(labels, 0, this.plotLabels[series], 0, labels.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        Chart.getAngledLabelCache().clear();
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public String[] getPlotLabels(int series) {
        try {
            if (this.plotLabels != null && this.plotLabels[series] != null) {
                return this.plotLabels[series];
            }
            return new String[0];
        }
        catch (IndexOutOfBoundsException e) {
            return new String[0];
        }
    }

    public void setPlotSortingOn(int series, boolean on) {
        if (series >= 0 && series < this.plotSortingOn.length) {
            this.plotSortingOn[series] = on;
        } else if (series < 0) {
            for (int i = 0; i < this.plotSortingOn.length; ++i) {
                this.plotSortingOn[i] = on;
            }
        }
    }

    public boolean isPlotSortingOn(int series) {
        if (series < 0 || series >= this.plots.length) {
            return false;
        }
        return this.plotSortingOn[series];
    }

    public void setXRangeLabel(double x, String label) {
        Double key = new Double(x);
        this.XRangeLabels.remove(key);
        if (label != null) {
            this.XRangeLabels.put(new Double(x), label);
        }
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public String getXRangeLabel(double x) {
        return (String)this.XRangeLabels.get(new Double(x));
    }

    public void setXRangeLabelLineOn(double x, boolean lineOn) {
        Double key = new Double(x);
        this.XRangeLabelLinesOn.remove(key);
        this.XRangeLabelLinesOn.put(new Double(x), new Boolean(lineOn));
        this.autoRepaint();
    }

    public boolean getXRangeLabelLineOn(double x) {
        Boolean value = (Boolean)this.XRangeLabelLinesOn.get(new Double(x));
        if (value == null) {
            return true;
        }
        return value;
    }

    public void setXRangeLabelColor(double x, Color color) {
        Double key = new Double(x);
        this.XRangeLabelColors.remove(key);
        if (color != null) {
            this.XRangeLabelColors.put(new Double(x), color);
        }
        this.autoRepaint();
    }

    public Color getXRangeLabelColor(double x) {
        return (Color)this.XRangeLabelColors.get(new Double(x));
    }

    public void setXRangeLabelsColor(Color c) {
        this.XRangeLabelsColor = c;
        this.autoRepaint();
    }

    public Color getXRangeLabelsColor() {
        return this.XRangeLabelsColor != null ? this.XRangeLabelsColor : this.getForeground();
    }

    public void setXRangeLabels(double[] x, String[] labels) {
        if (x == null || labels == null) {
            this.XRangeLabels.clear();
            return;
        }
        for (int i = 0; i < Math.min(x.length, labels.length); ++i) {
            Double key = new Double(x[i]);
            this.XRangeLabels.remove(key);
            if (labels[i] == null) continue;
            this.XRangeLabels.put(key, labels[i]);
        }
        Chart.getAngledLabelCache().clear();
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public double[] getXRangeLabelsPos() {
        double[][] sort_x = new double[this.XRangeLabels.size()][3];
        Enumeration e = this.XRangeLabels.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            Double value = (Double)e.nextElement();
            sort_x[i][0] = value;
            sort_x[i++][1] = value;
        }
        this.qsort(-1, sort_x, 0, sort_x.length - 1);
        double[] x = new double[sort_x.length];
        for (int j = 0; j < x.length; ++j) {
            x[j] = sort_x[j][0];
        }
        return x;
    }

    public String[] getXRangeLabels() {
        String[] labels = new String[this.XRangeLabels.size()];
        Enumeration e = this.XRangeLabels.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            labels[i++] = (String)e.nextElement();
        }
        return labels;
    }

    public void setXRangeLabelLinesOn(double[] x, boolean[] linesOn) {
        if (x == null || linesOn == null) {
            this.XRangeLabelLinesOn.clear();
            return;
        }
        for (int i = 0; i < Math.min(x.length, linesOn.length); ++i) {
            Double key = new Double(x[i]);
            this.XRangeLabelColors.remove(key);
            this.XRangeLabelColors.put(key, new Boolean(linesOn[i]));
        }
        this.autoRepaint();
    }

    public boolean[] getXRangeLabelLinesOn() {
        boolean[] linesOn = new boolean[this.XRangeLabelColors.size()];
        Enumeration e = this.XRangeLabelColors.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Boolean b = (Boolean)e.nextElement();
            linesOn[i++] = b;
        }
        return linesOn;
    }

    public void setXRangeLabelColors(double[] x, Color[] colors) {
        if (x == null || colors == null) {
            this.XRangeLabelColors.clear();
            return;
        }
        for (int i = 0; i < Math.min(x.length, colors.length); ++i) {
            Double key = new Double(x[i]);
            this.XRangeLabelColors.remove(key);
            if (colors[i] == null) continue;
            this.XRangeLabelColors.put(key, colors[i]);
        }
        this.autoRepaint();
    }

    public Color[] getXRangeLabelColors() {
        Color[] colors = new Color[this.XRangeLabelColors.size()];
        Enumeration e = this.XRangeLabelColors.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            colors[i++] = (Color)e.nextElement();
        }
        return colors;
    }

    public void setXRangeLabelStyle(int style) {
        if (this.XRangeLabelStyle != style) {
            this.XRangeLabelStyle = style;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public void setAutoLabelSpacingOn(boolean on) {
        if (on != this.autoLabelSpacingOn) {
            this.autoLabelSpacingOn = on;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public int getXRangeLabelStyle() {
        return this.XRangeLabelStyle;
    }

    public void setGridLines(double[] grid) {
        this.gridLines = grid;
        this.autoRepaint();
    }

    public double[] getGridLines() {
        return this.gridLines;
    }

    public void setGridLine(int index, double value) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + index);
        }
        if (this.gridLines == null) {
            this.gridLines = new double[index + 1];
            for (int i = 0; i < this.gridLines.length; ++i) {
                this.gridLines[i] = -2.147483648E9;
            }
        }
        if (index >= this.gridLines.length) {
            double[] tmp_arr = new double[index + 1];
            System.arraycopy(this.gridLines, 0, tmp_arr, 0, this.gridLines.length);
            for (int i = this.gridLines.length; i < tmp_arr.length - 1; ++i) {
                tmp_arr[i] = -2.147483648E9;
            }
            this.gridLines = tmp_arr;
        }
        this.gridLines[index] = value;
        this.autoRepaint();
    }

    public double getGridLine(int index) {
        if (this.gridLines == null || index >= this.gridLines.length) {
            return -2.147483648E9;
        }
        return this.gridLines[index];
    }

    public void setGridLinesColor(Color color) {
        if (this.gridLines != null) {
            Color[] colors = new Color[this.gridLines.length];
            for (int i = 0; i < this.gridLines.length; ++i) {
                colors[i] = color;
            }
            this.setGridLineColors(colors);
        }
    }

    public void setGridLineColors(Color[] colors) {
        this.gridLineColors = colors;
        this.autoRepaint();
    }

    public Color[] getGridLineColors() {
        return this.gridLineColors;
    }

    public void setGridLineColor(int index, Color color) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + index);
        }
        if (this.gridLineColors == null) {
            this.gridLineColors = new Color[index + 1];
        }
        if (index >= this.gridLineColors.length) {
            Color[] tmp_arr = new Color[index + 1];
            System.arraycopy(this.gridLineColors, 0, tmp_arr, 0, this.gridLineColors.length);
            this.gridLineColors = tmp_arr;
        }
        this.gridLineColors[index] = color;
        this.autoRepaint();
    }

    public Color getGridLineColor(int index) {
        if (this.gridLineColors == null || index >= this.gridLineColors.length) {
            return this.getForeground();
        }
        return this.gridLineColors[index];
    }

    public String getPlotLabel(int series, int index) {
        try {
            if (this.plotLabels != null && this.plotLabels[series] != null) {
                return this.plotLabels[series][index];
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setPlotLabelsOn(boolean on) {
        if (this.plotLabelsOn != on) {
            this.plotLabelsOn = on;
            this.autoRepaint();
        }
    }

    public boolean isPlotLabelsOn() {
        return this.plotLabelsOn;
    }

    public boolean isSampleLabelsOn() {
        return this.plotLabelsOn;
    }

    public void setPlotLabelStyle(int style) {
        if (this.plotLabelStyle != style) {
            this.plotLabelStyle = style;
            this.autoRepaint();
        }
    }

    public int getPlotLabelStyle() {
        return this.plotLabelStyle;
    }

    public void setConnectedLinesOn(int series, boolean on) {
        if (series >= 0 && series < this.connectedLinesOn.length) {
            this.connectedLinesOn[series] = on;
        } else if (series < 0) {
            for (int i = 0; i < this.connectedLinesOn.length; ++i) {
                this.connectedLinesOn[i] = on;
            }
        }
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int series) {
        if (series < 0 || series >= this.plots.length) {
            return false;
        }
        return this.connectedLinesOn[series];
    }

    public void setLineWidth(int series, int width) {
        if (series >= 0 && series < this.lineWidth.length) {
            this.lineWidth[series] = width;
        } else if (series < 0) {
            for (int i = 0; i < this.lineWidth.length; ++i) {
                this.lineWidth[i] = width;
            }
        }
        this.autoRepaint();
    }

    public int getLineWidth(int series) {
        if (series >= 0 && series < this.lineWidth.length) {
            return this.lineWidth[series];
        }
        return this.lineWidth[0];
    }

    public void setPlotStyle(int style) {
        for (int i = 0; i < this.plotStyle.length; ++i) {
            this.setPlotStyle(i, style);
        }
    }

    public void setPlotStyle(int series, int style) {
        try {
            this.plotStyle[series] = style;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.autoRepaint();
    }

    public int getPlotStyle(int series) {
        try {
            return this.plotStyle[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public void setPlotImage(int series, String name) {
        if (series >= -1 && series < 1000) {
            if (series == -1) {
                this.plotImage = name;
            } else {
                int series_count = Math.max(this.plotImages_all.length, series + 1);
                if (series >= this.plotImages_all.length) {
                    String[] newplotImages_all = new String[series_count];
                    for (int i = 0; i < this.plotImages_all.length; ++i) {
                        newplotImages_all[i] = this.plotImages_all[i];
                    }
                    this.plotImages_all = newplotImages_all;
                }
                this.plotImages_all[series] = name;
            }
            this.autoRepaint();
        }
    }

    public String getPlotImage(int series) {
        if (series == -1) {
            return this.plotImage;
        }
        if (series >= 0 && series < this.plotImages_all.length) {
            return this.plotImages_all[series];
        }
        return null;
    }

    public void setSeriesColors(Color[] colors) {
        if (colors != null) {
            this.seriesColors = colors;
        } else {
            this.seriesColors = new Color[DEFAULT_SERIES_COLORS.length];
            System.arraycopy(DEFAULT_SERIES_COLORS, 0, this.seriesColors, 0, this.seriesColors.length);
        }
        this.autoRepaint();
    }

    public Color[] getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesColor(int series, Color color) {
        if (series < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        if (series >= this.seriesColors.length) {
            Color[] newSeriesColors = new Color[series + 1];
            System.arraycopy(this.seriesColors, 0, newSeriesColors, 0, this.seriesColors.length);
            this.seriesColors = newSeriesColors;
        }
        this.seriesColors[series] = color;
        this.autoRepaint();
    }

    public Color getSeriesColor(int series) {
        Color c = DEFAULT_SERIES_COLORS[series % DEFAULT_SERIES_COLORS.length];
        if (this.seriesColors != null && this.seriesColors.length > 0 && (c = this.seriesColors[series % this.seriesColors.length]) == null) {
            int min = Math.min(this.seriesColors.length, DEFAULT_SERIES_COLORS.length);
            c = DEFAULT_SERIES_COLORS[series % min];
        }
        return c;
    }

    public void setLabel(String name, String label) {
        if (name != null && name.length() > 0) {
            name = name.toLowerCase().trim();
            if (label != null && label.length() > 0) {
                this.labels.put(name, label);
            } else {
                this.labels.remove(name);
            }
            this.autoRepaint();
        }
    }

    public String getLabel(String name) {
        if (name != null) {
            name = name.toLowerCase().trim();
            return (String)this.labels.get(name);
        }
        return null;
    }

    public void setLabelAngle(String name, int angle) {
        if (name != null && name.length() > 0) {
            name = name.toLowerCase().trim();
            this.labelAngles.put(name, new Integer(angle %= 360));
            Chart.getAngledLabelCache().clear();
            this.autoRepaint();
        }
    }

    public int getLabelAngle(String name) {
        if (name != null && this.labelAngles.get(name = name.toLowerCase().trim()) != null) {
            return (Integer)this.labelAngles.get(name);
        }
        return 0;
    }

    public void setSeriesLabels(String[] labels) {
        for (int i = 0; i < this.seriesCount; ++i) {
            this.seriesLabels[i] = labels == null ? null : (i < labels.length ? labels[i] : null);
        }
        Chart.getAngledLabelCache().clear();
        this.autoRepaint();
    }

    public String[] getSeriesLabels() {
        return this.seriesLabels;
    }

    public void setSeriesLabel(int series, String label) {
        try {
            this.seriesLabels[series] = label;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.autoRepaint();
    }

    public String getSeriesLabel(int series) {
        try {
            return this.seriesLabels[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public void setSeriesLabelColor(int series, Color color) {
        try {
            if (this.seriesLabelColors[series] != color) {
                this.seriesLabelColors[series] = color;
                this.autoRepaint();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series index: " + series);
        }
        if (this.getSeriesCount() > 1) {
            this.legend.setLabelColor(series, color);
            System.out.println(series + " " + color);
        }
    }

    public Color getSeriesLabelColor(int series) {
        if (series < this.seriesLabelColors.length) {
            return this.seriesLabelColors[series];
        }
        return null;
    }

    public void setSeriesLabelsOn(boolean on) {
        if (this.seriesLabelsOn != on) {
            this.seriesLabelsOn = on;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLabelsOn() {
        return this.seriesLabelsOn;
    }

    public void setSeriesLabelStyle(int style) {
        if (this.seriesLabelStyle != style) {
            this.seriesLabelStyle = style;
            this.autoRepaint();
        }
    }

    public int getSeriesLabelStyle() {
        return this.seriesLabelStyle;
    }

    public String[] getLegendLabels() {
        String[] legendLabels = this.legend.getLegendLabels();
        if (legendLabels != null) {
            return legendLabels;
        }
        return this.getSeriesLabels();
    }

    public Color getLegendColor(int index) {
        Color[] legendColors = this.legend.getLegendColors();
        if (legendColors != null && index >= 0 && index < legendColors.length && legendColors[index] != null) {
            return legendColors[index];
        }
        return this.getSeriesColor(index);
    }

    public void setXValueLabelsOn(boolean on) {
        this.setXValueLabelsOn(-1, on);
    }

    public void setXValueLabelsOn(int series, boolean on) {
        if (series >= 0 && series < this.XValueLabelsOn.length) {
            this.XValueLabelsOn[series] = on;
        } else if (series == -1) {
            for (int i = 0; i < this.XValueLabelsOn.length; ++i) {
                this.XValueLabelsOn[i] = on;
            }
        }
        Chart.getAngledLabelCache().clear();
        this.autoRepaint();
    }

    public boolean isXValueLabelsOn() {
        return this.isXValueLabelsOn(-1);
    }

    public boolean isXValueLabelsOn(int series) {
        if (series >= 0 && series < this.XValueLabelsOn.length) {
            return this.XValueLabelsOn[series];
        }
        if (series == -1) {
            for (int i = 0; i < this.XValueLabelsOn.length; ++i) {
                if (!this.XValueLabelsOn[i]) continue;
                return true;
            }
        }
        return false;
    }

    public void setYValueLabelsOn(boolean on) {
        this.setYValueLabelsOn(-1, on);
    }

    public void setYValueLabelsOn(int series, boolean on) {
        if (series >= 0 && series < this.YValueLabelsOn.length) {
            this.YValueLabelsOn[series] = on;
        } else if (series == -1) {
            for (int i = 0; i < this.YValueLabelsOn.length; ++i) {
                this.YValueLabelsOn[i] = on;
            }
        }
        Chart.getAngledLabelCache().clear();
        this.autoRepaint();
    }

    public boolean isYValueLabelsOn() {
        return this.isYValueLabelsOn(-1);
    }

    public boolean isYValueLabelsOn(int series) {
        if (series >= 0 && series < this.YValueLabelsOn.length) {
            return this.YValueLabelsOn[series];
        }
        if (series == -1) {
            for (int i = 0; i < this.YValueLabelsOn.length; ++i) {
                if (!this.YValueLabelsOn[i]) continue;
                return true;
            }
        }
        return false;
    }

    public void setValueLabelStyle(int style) {
        switch (style) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (style == this.valueLabelStyle) break;
                this.valueLabelStyle = style;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + style);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public void setFloatingOnLegendOn(boolean on) {
        this.floatingOnLegendOn = on;
        this.autoRepaint();
    }

    public boolean isFloatingOnLegendOn() {
        return this.floatingOnLegendOn;
    }

    public void displayFloatingLabel(int series, int sample) {
        this.mouseOverSampleIndex = sample;
        this.mouseOverSeriesIndex = series;
        this.repaint();
    }

    public Point getSamplePoint(int serie, int sample) {
        return ((PlotterChartRenderer)this.renderer).getSampleCenter(sample, serie);
    }

    public void setXUpperRange(double range) {
        boolean inverted = this.XUpperRange > this.XLowerRange && range < this.XLowerRange;
        this.XUpperRange = range;
        this.XCurrentUpperRange = this.XUpperRange >= this.XLowerRange ? Math.min(this.XCurrentUpperRange, range) : Math.max(this.XCurrentUpperRange, range);
        if (!this.rangeAdjusterOn[3] || (inverted |= this.XUpperRange < this.XLowerRange && range > this.XLowerRange)) {
            this.XCurrentUpperRange = range;
        }
        this.autoRepaint();
    }

    public double getXUpperRange() {
        return this.XUpperRange;
    }

    public void setXLowerRange(double range) {
        boolean inverted = this.XLowerRange < this.XUpperRange && range > this.XUpperRange;
        this.XLowerRange = range;
        this.XCurrentLowerRange = this.XUpperRange >= this.XLowerRange ? Math.max(this.XCurrentLowerRange, range) : Math.min(this.XCurrentLowerRange, range);
        if (!this.rangeAdjusterOn[3] || (inverted |= this.XLowerRange > this.XUpperRange && range < this.XUpperRange)) {
            this.XCurrentLowerRange = range;
        }
        this.autoRepaint();
    }

    public double getXLowerRange() {
        return this.XLowerRange;
    }

    public void setYUpperRange(double range) {
        boolean inverted = this.YUpperRange > this.YLowerRange && range < this.YLowerRange;
        this.YUpperRange = range;
        this.YCurrentUpperRange = this.YUpperRange >= this.YLowerRange ? Math.min(this.YCurrentUpperRange, range) : Math.max(this.YCurrentUpperRange, range);
        if (!this.rangeAdjusterOn[1] || (inverted |= this.YUpperRange < this.YLowerRange && range > this.YLowerRange)) {
            this.YCurrentUpperRange = range;
        }
        this.autoRepaint();
    }

    public double getYUpperRange() {
        return this.YUpperRange;
    }

    public void setYLowerRange(double range) {
        boolean inverted = this.YLowerRange < this.YUpperRange && range > this.YUpperRange;
        this.YLowerRange = range;
        this.YCurrentLowerRange = this.YUpperRange >= this.YLowerRange ? Math.max(this.YCurrentLowerRange, range) : Math.min(this.YCurrentLowerRange, range);
        if (!this.rangeAdjusterOn[1] || (inverted |= this.YLowerRange > this.YUpperRange && range < this.YUpperRange)) {
            this.YCurrentLowerRange = range;
        }
        this.autoRepaint();
    }

    public double getYLowerRange() {
        return this.YLowerRange;
    }

    public void setXRangeInterval(double interval) {
        this.XRangeInterval = interval;
        this.autoRepaint();
    }

    public double getXRangeInterval() {
        return this.XRangeInterval;
    }

    public void setYRangeInterval(double interval) {
        this.YRangeInterval = interval;
        this.autoRepaint();
    }

    public double getYRangeInterval() {
        return this.YRangeInterval;
    }

    public void setXCurrentUpperRange(double range) {
        if (this.XUpperRange >= this.XLowerRange) {
            range = Math.min(this.XUpperRange, range);
            range = Math.max(this.XCurrentLowerRange, range);
        } else {
            range = Math.max(this.XUpperRange, range);
            range = Math.min(this.XCurrentLowerRange, range);
        }
        this.XCurrentUpperRange = range;
        this.autoRepaint();
    }

    public double getXCurrentUpperRange() {
        return this.XCurrentUpperRange;
    }

    public void setXCurrentLowerRange(double range) {
        if (this.XUpperRange >= this.XLowerRange) {
            range = Math.max(this.XLowerRange, range);
            range = Math.min(this.XCurrentUpperRange, range);
        } else {
            range = Math.min(this.XLowerRange, range);
            range = Math.max(this.XCurrentUpperRange, range);
        }
        this.XCurrentLowerRange = range;
        this.autoRepaint();
    }

    public double getXCurrentLowerRange() {
        return this.XCurrentLowerRange;
    }

    public void setYCurrentUpperRange(double range) {
        if (this.YUpperRange >= this.YLowerRange) {
            range = Math.min(this.YUpperRange, range);
            range = Math.max(this.YCurrentLowerRange, range);
        } else {
            range = Math.max(this.YUpperRange, range);
            range = Math.min(this.YCurrentLowerRange, range);
        }
        this.YCurrentUpperRange = range;
        this.autoRepaint();
    }

    public double getYCurrentUpperRange() {
        return this.YCurrentUpperRange;
    }

    public void setYCurrentLowerRange(double range) {
        if (this.YUpperRange >= this.YLowerRange) {
            range = Math.max(this.YLowerRange, range);
            range = Math.min(this.YCurrentUpperRange, range);
        } else {
            range = Math.min(this.YLowerRange, range);
            range = Math.max(this.YCurrentUpperRange, range);
        }
        this.YCurrentLowerRange = range;
        this.autoRepaint();
    }

    public double getYCurrentLowerRange() {
        return this.YCurrentLowerRange;
    }

    public void setXRangeDecimalCount(int count) {
        this.XRangeDecimalCount = count;
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public int getXRangeDecimalCount() {
        int decimals = this.XRangeDecimalCount;
        if (decimals == -1) {
            String s = "" + this.getXUpperRange();
            int dot_pos = s.lastIndexOf(".");
            int upper_decimals = s.length() - dot_pos - 1;
            if (upper_decimals == 1 && s.charAt(dot_pos + 1) == '0') {
                upper_decimals = 0;
            }
            s = "" + this.getXLowerRange();
            dot_pos = s.lastIndexOf(".");
            int lower_decimals = s.length() - dot_pos - 1;
            if (lower_decimals == 1 && s.charAt(dot_pos + 1) == '0') {
                lower_decimals = 0;
            }
            decimals = Math.max(upper_decimals, lower_decimals);
            double delta = this.getXUpperRange() - this.getXLowerRange();
            if (2.0 >= Math.abs(delta *= Math.pow(10.0, decimals))) {
                ++decimals;
            }
        }
        return decimals;
    }

    public void setYRangeDecimalCount(int count) {
        this.YRangeDecimalCount = count;
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public int getYRangeDecimalCount() {
        int decimals = this.YRangeDecimalCount;
        if (decimals == -1) {
            String s = "" + this.getYUpperRange();
            int dot_pos = s.lastIndexOf(".");
            int upper_decimals = s.length() - dot_pos - 1;
            if (upper_decimals == 1 && s.charAt(dot_pos + 1) == '0') {
                upper_decimals = 0;
            }
            s = "" + this.getYLowerRange();
            dot_pos = s.lastIndexOf(".");
            int lower_decimals = s.length() - dot_pos - 1;
            if (lower_decimals == 1 && s.charAt(dot_pos + 1) == '0') {
                lower_decimals = 0;
            }
            decimals = Math.max(upper_decimals, lower_decimals);
            double delta = this.getYUpperRange() - this.getYLowerRange();
            if (2.0 >= Math.abs(delta *= Math.pow(10.0, decimals))) {
                ++decimals;
            }
        }
        return decimals;
    }

    public void setXAxisOn(boolean on) {
        this.XAxisOn = on;
        this.autoRepaint();
    }

    public boolean isXAxisOn() {
        return this.XAxisOn;
    }

    public void setXAxisColor(Color color) {
        this.XAxisColor = color;
        this.autoRepaint();
    }

    public Color getXAxisColor() {
        return this.XAxisColor;
    }

    public void setYAxisColor(Color color) {
        this.YAxisColor = color;
        this.autoRepaint();
    }

    public Color getYAxisColor() {
        return this.YAxisColor;
    }

    public void setYAxisOn(boolean on) {
        this.YAxisOn = on;
        this.autoRepaint();
    }

    public boolean isYAxisOn() {
        return this.YAxisOn;
    }

    public void setRangeOn(int side, boolean on) {
        if (side < this.rangeOn.length) {
            this.rangeOn[side] = on;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public boolean isRangeOn(int side) {
        if (side < this.rangeOn.length) {
            return this.rangeOn[Math.max(0, side)];
        }
        return false;
    }

    public void setRangeColor(int side, Color color) {
        if ((side = Math.max(0, side)) < this.rangeColor.length) {
            this.rangeColor[side] = color != null ? color : this.getForeground();
        }
        this.autoRepaint();
    }

    public Color getRangeColor(int side) {
        return this.rangeColor[side = Math.min(this.rangeColor.length - 1, Math.max(0, side))] != null ? this.rangeColor[side] : this.getForeground();
    }

    public void setXValueLinesOn(boolean on) {
        this.XValueLinesOn = on;
        this.autoRepaint();
    }

    public boolean isXValueLinesOn() {
        return this.XValueLinesOn;
    }

    public void setYValueLinesOn(boolean on) {
        this.YValueLinesOn = on;
        this.autoRepaint();
    }

    public boolean isYValueLinesOn() {
        return this.YValueLinesOn;
    }

    public void setXValueLinesColor(Color color) {
        this.XValueLinesColor = color;
        this.autoRepaint();
    }

    public Color getXValueLinesColor() {
        return this.XValueLinesColor != null ? this.XValueLinesColor : new Color(208, 208, 208);
    }

    public void setYValueLinesColor(Color color) {
        this.YValueLinesColor = color;
        this.autoRepaint();
    }

    public Color getYValueLinesColor() {
        return this.YValueLinesColor != null ? this.YValueLinesColor : new Color(208, 208, 208);
    }

    public void setTargetValueLine(String id, double value, Color color, int style) {
        if (color == null) {
            this.targetsLabel.remove(id);
            this.targetsValue.remove(id);
            this.targetsColor.remove(id);
            this.targetsStyle.remove(id);
        } else {
            this.targetsLabel.put(id, id);
            this.targetsValue.put(id, new Double(value));
            this.targetsColor.put(id, color);
            this.targetsStyle.put(id, new Integer(style));
        }
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    String getTargetLabel(String id) {
        String label = "";
        int style = (Integer)this.targetsStyle.get(id);
        double value = (Double)this.targetsValue.get(id);
        String number = this.formatRangeNumber(1, value);
        if (this.getLabel("rangeLabelPrefix") != null) {
            number = this.getLabel("rangeLabelPrefix") + number;
        }
        if (this.getLabel("rangeLabelPostfix") != null) {
            number = number + this.getLabel("rangeLabelPostfix");
        }
        switch (style) {
            case 0: {
                label = "";
                break;
            }
            case 1: {
                label = id;
                break;
            }
            case 2: {
                label = number;
                break;
            }
            case 3: {
                label = this.targetLabelsPosition == 0 ? id + " " + number : number + " " + id;
            }
        }
        return label;
    }

    public void setTargetLabelsPosition(int position) {
        this.targetLabelsPosition = Math.min(1, Math.max(0, position));
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public int getTargetLabelsPosition() {
        return this.targetLabelsPosition;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.autoRepaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.autoRepaint();
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
        this.autoRepaint();
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setChartForeground(Color color) {
        this.chartForeground = color;
        this.autoRepaint();
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public void setGridImage(String name) {
        this.gridImage = name;
        this.autoRepaint();
    }

    public String getGridImage() {
        return this.gridImage;
    }

    public void setXMaxValueLineCount(int count) {
        if (count != this.XMaxValueLineCount) {
            this.XMaxValueLineCount = count > -1 ? count : Integer.MAX_VALUE;
            this.autoRepaint();
        }
    }

    public int getXMaxValueLineCount() {
        if (this.XMaxValueLineCount != Integer.MAX_VALUE) {
            return this.XMaxValueLineCount;
        }
        return -1;
    }

    public void setYMaxValueLineCount(int count) {
        if (count != this.YMaxValueLineCount) {
            this.YMaxValueLineCount = count > -1 ? count : Integer.MAX_VALUE;
            this.autoRepaint();
        }
    }

    public int getYMaxValueLineCount() {
        if (this.YMaxValueLineCount != Integer.MAX_VALUE) {
            return this.YMaxValueLineCount;
        }
        return -1;
    }

    public void setRangeAdjusterOn(int adjuster, boolean on) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, adjuster));
        this.rangeAdjusterOn[adjuster] = on;
        if (!on) {
            if (adjuster == 1) {
                this.setYCurrentUpperRange(this.getYUpperRange());
                this.setYCurrentLowerRange(this.getYLowerRange());
            } else if (adjuster == 3) {
                this.setXCurrentUpperRange(this.getXUpperRange());
                this.setXCurrentLowerRange(this.getXLowerRange());
            }
        }
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public boolean isRangeAdjusterOn(int adjuster) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, adjuster));
        return this.rangeAdjusterOn[adjuster];
    }

    public void setZoomOn(boolean on) {
        this.zoomOn = on;
        this.autoRepaint();
    }

    public boolean isZoomOn() {
        return this.zoomOn;
    }

    public void setGraphInsets(int top, int left, int bottom, int right) {
        this.graphInsets.top = top;
        this.graphInsets.left = left;
        this.graphInsets.bottom = bottom;
        this.graphInsets.right = right;
        this.needGraphBounds = true;
        this.autoRepaint();
    }

    public Insets getGraphInsets() {
        if (this.graphInsets != null) {
            return this.graphInsets;
        }
        return new Insets(-1, -1, -1, -1);
    }

    public void setGridAdjustmentOn(int edge, boolean on) {
        if (edge >= 0 && edge < this.gridAdjustment.length) {
            this.gridAdjustment[edge] = on;
        }
    }

    public boolean isGridAdjustmentOn(int edge) {
        if (edge >= 0 && edge < this.gridAdjustment.length) {
            return this.gridAdjustment[edge];
        }
        return false;
    }

    public void addImage(String name, Image image) {
        if (name != null) {
            try {
                if (image != null) {
                    this.images.put(name, image);
                    this.imageTracker.addImage(image, 0);
                    this.imageTracker.waitForAll();
                } else {
                    this.images.remove(name);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Image loadImage(String name) {
        if (name == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(name);
        MediaTracker tracker = new MediaTracker(this);
        int id = (int)(Math.random() * 2.147483647E9);
        tracker.addImage(image, id);
        try {
            tracker.waitForID(id);
        }
        catch (InterruptedException e) {
            System.out.println("Could not load image: " + name);
        }
        return image;
    }

    public Image getImage(String name) {
        return (Image)this.images.get(name);
    }

    public void setAutomaticRepaintOn(boolean state) {
        this.automaticRepaintOn = state;
    }

    public boolean isAutomaticRepaintOn() {
        return this.automaticRepaintOn;
    }

    public void setXValueDecimalCount(int series, int count) {
        if (series == -1) {
            for (int i = 0; i < this.XValueDecimalCount.length; ++i) {
                this.XValueDecimalCount[i] = count;
            }
        } else if (series >= 0 && series < this.XValueDecimalCount.length) {
            this.XValueDecimalCount[series] = count;
        }
        this.autoRepaint();
    }

    public int getXValueDecimalCount(int series) {
        int decimals = 0;
        if (series >= 0 && series < this.XValueDecimalCount.length) {
            decimals = this.XValueDecimalCount[series];
        }
        if (decimals == -1) {
            decimals = this.getXRangeDecimalCount();
        }
        return decimals;
    }

    public void setYValueDecimalCount(int series, int count) {
        if (series == -1) {
            for (int i = 0; i < this.YValueDecimalCount.length; ++i) {
                this.YValueDecimalCount[i] = count;
            }
        } else if (series >= 0 && series < this.YValueDecimalCount.length) {
            this.YValueDecimalCount[series] = count;
        }
        this.autoRepaint();
    }

    public int getYValueDecimalCount(int series) {
        int decimals = 0;
        if (series >= 0 && series < this.YValueDecimalCount.length) {
            decimals = this.YValueDecimalCount[series];
        }
        if (decimals == -1) {
            decimals = this.getYRangeDecimalCount();
        }
        return decimals;
    }

    public void setRangeFormatter(int index, NumberFormat formatter) {
        this.rangeFormatters[index] = formatter;
    }

    public NumberFormat getRangeFormatter(int index) {
        if (index >= 0 && index < this.rangeFormatters.length) {
            return this.rangeFormatters[index];
        }
        return null;
    }

    public void addItemListener(ItemListener l) {
        if (l != null) {
            this.listeners.addElement(l);
        }
    }

    public void removeItemListener(ItemListener l) {
        if (l != null && this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize.width = width;
        this.preferredSize.height = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    public Image getImage(int width, int height) {
        Graphics g;
        width = Math.max(1, width);
        height = Math.max(1, height);
        Dimension oldSize = this.getSize();
        Image image = this.createImage(width, height);
        if (image != null && (g = image.getGraphics()) != null) {
            this.setSize(width, height);
            this.paint(g);
        }
        this.setSize(oldSize.width, oldSize.height);
        return image;
    }

    public Image createImage(int width, int height) {
        boolean is_java2;
        boolean bl = is_java2 = !System.getProperty("java.version").startsWith("1.1");
        if (is_java2) {
            if (!this.bufferedImageClass_tried_loading) {
                try {
                    this.bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
                    Class[] parameters = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                    this.bufferedImageConstructor = this.bufferedImageClass.getConstructor(parameters);
                    Field field = this.bufferedImageClass.getField("TYPE_INT_RGB");
                    this.TYPE_INT_RGB = field.getInt(null);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchMethodException e) {
                    this.bufferedImageClass = null;
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                this.bufferedImageClass_tried_loading = true;
            }
        } else {
            this.bufferedImageClass_tried_loading = true;
        }
        width = Math.max(1, width);
        height = Math.max(1, height);
        Image image = null;
        if (this.bufferedImageClass != null) {
            try {
                Object[] parameters = new Object[]{new Integer(width), new Integer(height), new Integer(this.TYPE_INT_RGB)};
                image = (Image)this.bufferedImageConstructor.newInstance(parameters);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (image == null && (image = super.createImage(width, height)) == null) {
            if (this.servletFrame == null) {
                this.servletFrame = new Frame();
                this.servletFrame.addNotify();
            }
            image = this.servletFrame.createImage(width, height);
            this.servletFrame.removeNotify();
        }
        return image;
    }

    public Image createImage_oldstyle(int width, int height) {
        Image image = super.createImage(width = Math.max(1, width), height = Math.max(1, height));
        if (image == null) {
            if (this.servletFrame == null) {
                this.servletFrame = new Frame();
                this.servletFrame.addNotify();
            }
            image = this.servletFrame.createImage(width, height);
            this.servletFrame.removeNotify();
        }
        return image;
    }

    protected int checkSelection(Point point) {
        if (point == null || this.getGraphBounds() == null) {
            return -1;
        }
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
        int seriesCount = this.getSeriesCount();
        int selectedLegend = this.legendRenderer.getSelectedElement(point, this.legend);
        if (selectedLegend >= 0) {
            this.mouseOverSeriesIndex = selectedLegend;
            return selectedLegend;
        }
        for (int series = 0; series < seriesCount; ++series) {
            for (int sample = 0; sample < this.plots[series].length; ++sample) {
                int plot_size = Math.max(1, this.plotSize_all[series]);
                if (sample < this.plotSize[series].length && this.plotSize[series][sample] > 0) {
                    plot_size = this.plotSize[series][sample];
                }
                int off = plot_size / 2;
                off = Math.max(off, 2);
                Point p = ((PlotterChartRenderer)this.renderer).getPoint(this.plots[series][sample][0], this.plots[series][sample][1], this.getGraphBounds());
                boolean inside = point.x >= p.x - off && point.x <= p.x + off;
                if (!(inside &= point.y >= p.y - off && point.y <= p.y + off)) continue;
                this.mouseOverSampleIndex = sample;
                this.mouseOverSeriesIndex = series;
                return series;
            }
        }
        return -1;
    }

    public void setSelection(int series, int sample, boolean selected) {
        this.setSelection(series, sample, selected, false, true);
    }

    public void setSelection(int series, int sample, boolean selected, boolean notify) {
        this.setSelection(series, sample, selected, false, notify);
    }

    public void setSelection(int series, int sample, boolean selected, boolean clear, boolean notify) {
        for (int i = 0; i < this.legendSelection.length; ++i) {
            this.legendSelection[i] = false;
        }
        if (series == -1 && sample == -1 && (this.selectedSeries != -1 || this.selectedSample != -1)) {
            if (notify) {
                this.notifyListeners(this, 2, new int[]{this.selectedSeries, this.selectedSample});
            }
            this.selectedSample = -1;
            this.selectedSeries = -1;
        } else if ((sample >= -1 || series >= -1) && selected) {
            if (notify && this.selectedSeries != -1 && this.selectedSeries != series) {
                this.notifyListeners(this, 2, new int[]{this.selectedSeries, this.selectedSample});
            }
            if (notify) {
                this.notifyListeners(this, 1, new int[]{series, sample});
            }
            this.selectedSample = sample;
            this.selectedSeries = series;
        }
        if (series >= 0 && series < this.legendSelection.length) {
            this.legendSelection[series] = selected;
        }
        this.autoRepaint();
    }

    public int getSelectedSeries() {
        return this.selectedSeries;
    }

    public int getSelectedSample() {
        return this.selectedSample;
    }

    public boolean isSelected(int series) {
        return series >= 0 && series == this.selectedSeries;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public static String[] getStringValues(String string, String delimiter) {
        String[] labels;
        if (delimiter == null) {
            delimiter = ",";
        }
        if (string == null) {
            labels = new String[]{};
        } else if (string.indexOf(delimiter) == -1) {
            labels = new String[]{string};
        } else {
            int length = string.length();
            int delimiter_length = delimiter.length();
            int count = 1;
            int index = 0;
            while (index >= 0) {
                if ((index = string.indexOf(delimiter, index)) != -1 && index != length - delimiter_length) {
                    index += delimiter_length;
                    ++count;
                    continue;
                }
                if (index != length - delimiter_length) continue;
                index = -1;
                ++count;
            }
            labels = new String[count];
            int start = 0;
            for (int i = 0; i < count; ++i) {
                boolean is_delimiter = false;
                if (start < length && string.charAt(start) == delimiter.charAt(0)) {
                    is_delimiter = true;
                    for (int c = 1; c < delimiter_length; ++c) {
                        if (string.charAt(start + c) == delimiter.charAt(c)) continue;
                        is_delimiter = false;
                    }
                }
                if (is_delimiter) {
                    labels[i] = "";
                    start += delimiter_length;
                    continue;
                }
                int end = string.indexOf(delimiter, start + 1);
                String sub = end > 0 ? string.substring(start, end) : string.substring(start);
                labels[i] = sub = PlotterChart.trim(sub);
                start = end + delimiter_length;
            }
        }
        return labels;
    }

    static String trim(String string) {
        int st;
        if (string == null) {
            return null;
        }
        if (string.indexOf("\n") == -1) {
            return string.trim();
        }
        int len = string.length();
        for (st = 0; st < len && string.charAt(st) <= ' ' && string.charAt(st) != '\n'; ++st) {
        }
        while (st < len && string.charAt(len - 1) <= ' ' && string.charAt(len - 1) != '\n') {
            --len;
        }
        return st > 0 || len < string.length() ? string.substring(st, len) : string;
    }

    public void setExternalGraphics(Graphics g, Image image) {
        this.renderer.setExternalGraphics(g, image);
        this.autoRepaint();
    }

    public void removeExternalGraphics() {
        this.renderer.removeExternalGraphics();
        this.autoRepaint();
    }

    public void autoRepaint() {
        if (this.automaticRepaintOn) {
            this.repaint();
        }
    }

    Dimension getImageSize(String name) {
        Image img;
        Dimension imageSize = new Dimension(0, 0);
        if (name != null && (img = (Image)this.images.get(name)) != null) {
            imageSize.width = img.getWidth(this);
            imageSize.height = img.getHeight(this);
        }
        return imageSize;
    }

    public void setThousandsDelimiter(String delimiter) {
        this.thousandsDelimiter = delimiter;
        if (this.thousandsDelimiter != null && this.thousandsDelimiter.length() > 1 && !this.thousandsDelimiter.trim().equalsIgnoreCase("off")) {
            this.thousandsDelimiter = this.thousandsDelimiter.substring(0, 1);
        } else if (this.thousandsDelimiter != null && !this.thousandsDelimiter.equals(" ")) {
            this.thousandsDelimiter = this.thousandsDelimiter.trim().toLowerCase();
        }
        this.autoRepaint();
    }

    public String getThousandsDelimeter() {
        return this.thousandsDelimiter;
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.numberFormatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
    }

    public Locale getLocale() {
        if (this.currentLocale != null) {
            return this.currentLocale;
        }
        return Locale.getDefault();
    }

    public String formatRangeNumber(int index, double value) {
        int decimals;
        String formatted = null;
        NumberFormat formatter = this.getRangeFormatter(index);
        int n = decimals = value != 0.0 ? this.getXRangeDecimalCount() : 0;
        if (index == 1) {
            int n2 = decimals = value != 0.0 ? this.getYRangeDecimalCount() : 0;
        }
        if (formatter != null) {
            formatter.setMaximumFractionDigits(decimals);
            formatter.setMinimumFractionDigits(decimals);
            StringBuffer sb = formatter.format(value, new StringBuffer(), new FieldPosition(1));
            if (sb != null) {
                formatted = sb.toString();
            }
        }
        if (formatted == null) {
            formatted = this.formatNumber(value, decimals);
        }
        return formatted;
    }

    public synchronized String formatNumber(double value, int decimals) {
        if (this.currentLocale != null) {
            this.numberFormatter.setMaximumFractionDigits(decimals);
            this.numberFormatter.setMinimumFractionDigits(decimals);
            return this.numberFormatter.format(value);
        }
        long rounded = value >= 0.0 ? (long)(value + 0.5) : (long)(value - 0.5);
        if (decimals == 0 && rounded < 1000L && rounded > -1000L) {
            return rounded + "";
        }
        long pow = (long)Math.pow(10.0, decimals);
        long integer = Math.round(value * (double)pow);
        long fraction = Math.abs(integer) % pow + pow;
        if (value >= 1000000.0 || value <= -1000000.0) {
            fraction = pow;
        }
        String formatted = "";
        if (decimals > 0) {
            formatted = "." + (fraction + "").substring(1);
        }
        integer /= pow;
        if (this.thousandsDelimiter == null) {
            this.numberFormatter.setGroupingUsed(true);
            formatted = this.numberFormatter.format(integer) + formatted;
        } else if (this.thousandsDelimiter.trim().equalsIgnoreCase("off")) {
            this.numberFormatter.setGroupingUsed(false);
            formatted = this.numberFormatter.format(integer) + formatted;
        } else {
            long integer_part = integer;
            if (integer_part > 0L) {
                while (integer_part >= 1L) {
                    long n = integer_part % 1000L + 1000L;
                    formatted = n >= 1000L && integer_part >= 1000L ? this.thousandsDelimiter + (n + "").substring(1) + formatted : integer_part % 1000L + formatted;
                    integer_part /= 1000L;
                }
            } else if (integer_part < 0L) {
                while (integer_part <= -1L) {
                    long n = integer_part % 1000L - 1000L;
                    formatted = n <= -1000L && integer_part <= -1000L ? this.thousandsDelimiter + (n + "").substring(2) + formatted : integer_part % 1000L + formatted;
                    integer_part /= 1000L;
                }
            } else if (integer_part == 0L) {
                formatted = "0" + formatted;
            }
        }
        if (value < 0.0 && integer == 0L) {
            formatted = "-" + formatted;
        }
        return formatted;
    }

    void addUrl(String name, String value) {
        this.urlList.put(name, value);
    }

    void removeUrl(String name) {
        this.urlList.remove(name);
    }

    private String createURLName(String prefix, int serie, int sample) {
        String param = prefix;
        if (serie >= 0) {
            param = param + "_" + serie;
        }
        if (sample >= 0) {
            param = param + "_" + sample;
        }
        return param;
    }

    private void qsort(int series, double[][] list, int lo0, int hi0) {
        if (lo0 < 0 || hi0 < 0 || list == null || list.length <= 1) {
            return;
        }
        int low = lo0;
        int high = hi0;
        if (hi0 > lo0) {
            double mid = list[(lo0 + hi0) / 2][0];
            while (low <= high) {
                while (low < hi0 && list[low][0] < mid) {
                    ++low;
                }
                while (high > lo0 && list[high][0] > mid) {
                    --high;
                }
                if (low > high) continue;
                if (list[low][0] != list[high][0]) {
                    double tmp = list[low][0];
                    list[low][0] = list[high][0];
                    list[high][0] = tmp;
                    tmp = list[low][1];
                    list[low][1] = list[high][1];
                    list[high][1] = tmp;
                    tmp = list[low][2];
                    list[low][2] = list[high][2];
                    list[high][2] = tmp;
                    if (series != -1 && series < this.plots.length && low < this.plotLabels[series].length && high < this.plotLabels[series].length) {
                        String s = this.plotLabels[series][low];
                        this.plotLabels[series][low] = this.plotLabels[series][high];
                        this.plotLabels[series][high] = s;
                    }
                }
                ++low;
                --high;
            }
            if (lo0 < high) {
                this.qsort(series, list, lo0, high);
            }
            if (low < hi0) {
                this.qsort(series, list, low, hi0);
            }
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof MouseEvent) {
            this.mousePosition.x = ((MouseEvent)event).getX();
            this.mousePosition.y = ((MouseEvent)event).getY();
        }
        if (event instanceof MouseEvent) {
            this.old_cursor = this.new_cursor;
            this.new_cursor = Renderer.DEFAULT_CURSOR;
            if (this.rangeAdjusterOn[1] || this.rangeAdjusterOn[3]) {
                ((PlotterChartRenderer)this.renderer).handleAdjusters(event);
            }
            ((PlotterChartRenderer)this.renderer).handleGridAdjustment(event);
            if (this.legendRenderer != null) {
                this.legendRenderer.handleLegendScrollers(event);
            }
            if (this.zoomOn && this.dragged_label == null) {
                ((PlotterChartRenderer)this.renderer).handleZoom(event);
            }
            this.handleCustomLabels(event);
        }
        Dimension size = this.getSize();
        switch (event.getID()) {
            case 501: {
                if (this.c2.copyright) {
                    this.c2.copyright = false;
                } else if (this.mousePosition.x > 0 && this.mousePosition.x < 11 && this.mousePosition.y > size.height - 11 && this.mousePosition.y < size.height) {
                    this.c2.copyright = true;
                }
                ((PlotterChartRenderer)this.renderer).lastClickTime = System.currentTimeMillis();
                break;
            }
            case 503: {
                this.checkSelection(this.mousePosition);
                if (this.mouseOverSeriesIndex != this.lastSelectedSeries || this.mouseOverSampleIndex != this.lastSelectedSample) {
                    this.repaint();
                    this.lastSelectedSeries = this.mouseOverSeriesIndex;
                    this.lastSelectedSample = this.mouseOverSampleIndex;
                }
                if (this.urlList.size() <= 0 || this.mouseOverSampleIndex <= -1 && this.mouseOverSeriesIndex <= -1) break;
                String url_param = this.createURLName("url", this.mouseOverSeriesIndex, this.mouseOverSampleIndex);
                Object url = this.urlList.get(url_param);
                if (url == null) {
                    url_param = this.seriesCount > 1 ? this.createURLName("url", this.mouseOverSeriesIndex, -1) : this.createURLName("url", -1, this.mouseOverSampleIndex);
                    url = this.urlList.get(url_param);
                }
                if (url == null) break;
                this.new_cursor = Renderer.HAND_CURSOR;
                break;
            }
            case 502: {
                if (this.getGraphBounds() == null) break;
                int selection = this.checkSelection(this.mousePosition);
                if (selection >= 0 && this.mouseOverSampleIndex == -1) {
                    try {
                        this.setSelection(selection, this.mouseOverSampleIndex, true, true, true);
                        this.repaint();
                    }
                    catch (IllegalArgumentException ex) {}
                    break;
                }
                if (selection >= 0 && this.mouseOverSampleIndex >= 0) {
                    try {
                        this.setSelection(selection, this.mouseOverSampleIndex, true, true, true);
                        this.repaint();
                    }
                    catch (IllegalArgumentException ex) {}
                    break;
                }
                this.setSelection(-1, -1, false, true, true);
                this.repaint();
                break;
            }
            case 505: {
                this.mouseOverSampleIndex = -1;
                this.mouseOverSeriesIndex = -1;
                this.repaint();
                break;
            }
            case 101: {
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.needRender = true;
                this.repaint();
            }
        }
        if (this.new_cursor != this.old_cursor) {
            this.setCursor(this.new_cursor);
        }
        super.processEvent(event);
    }

    void notifyListeners(PlotterChart chart, int selected, Object item) {
        if (this.listeners != null) {
            ItemEvent event = new ItemEvent(chart, 701, item, selected);
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((ItemListener)e.nextElement()).itemStateChanged(event);
            }
        }
    }

    public String toString() {
        if (this.chartTitle != null) {
            return this.getTitle();
        }
        return super.toString();
    }

    void setNewCursor(Cursor cursor) {
        this.new_cursor = cursor;
    }

    public static String getVersion() {
        return "4.1";
    }
}

