/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import java.awt.Color;
import java.io.Serializable;

public class ChartSample
implements Serializable {
    public Double value;
    protected String label;
    Color labelColor;
    private static final Color DEFAULT_COLOR = Color.black;
    private int series;
    private int index;
    Object key;
    private boolean selected;

    public ChartSample(int index) {
        this.index = index;
    }

    public ChartSample(int index, double value) {
        this.index = index;
        this.value = new Double(value);
    }

    public ChartSample(int index, double value, String label, Object key) {
        this.index = index;
        this.value = new Double(value);
        this.label = label;
        this.key = key;
    }

    public void set(double value, String label, Object key) {
        this.value = new Double(value);
        this.label = label;
        this.key = key;
    }

    public void setValue(double value) {
        this.value = new Double(value);
    }

    public long getValue() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return 0L;
    }

    public double getFloatValue() {
        if (this.value != null) {
            return this.value;
        }
        return Double.NaN;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isNaN();
    }

    public void clearValue() {
        this.value = null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setSeries(int series) {
        this.series = series;
    }

    public int getSeries() {
        return this.series;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean setSelection(boolean state) {
        this.selected = state;
        return this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean toggleSelection() {
        this.selected = !this.selected;
        return this.selected;
    }

    public String toString() {
        if (this.label != null && this.value != null) {
            return this.series + ":" + this.index + " " + this.label + " " + this.value;
        }
        if (this.value != null) {
            return this.series + ":" + this.index + " " + "null " + this.value;
        }
        if (this.label != null) {
            return this.series + ":" + this.index + " " + this.label;
        }
        return this.series + ":" + this.index + " " + "null 0";
    }
}

