/**
 * Provides a global error handler to report errors..
 */
import { NativeModules } from "react-native";
import { setJSExceptionHandler } from 'react-native-exception-handler';
import { parseStackTrace } from 'errorstacks';
// defaults
var PLUGIN_DEFAULTS = {
    veto: null,
};
// const reactNativeFrameFinder = frame => contains('/node_modules/react-native/', frame.fileName)
// our plugin entry point
export default (function (options) { return function (eg) {
    // setup configuration
    var config = Object.assign({}, PLUGIN_DEFAULTS, options || {});
    var swizzled = null;
    var isSwizzled = false;
    function eGExceptionHijacker(message, prettyStack, currentExceptionID) {
        // do Facebook's stuff first
        alert('eGExceptionHijacker');
        swizzled(message, prettyStack, currentExceptionID);
        // console.log("eGExceptionHijacker:message::"+message)
        // console.log("eGExceptionHijacker:prettyStack::"+prettyStack)
        // console.log("eGExceptionHijacker:currentExceptionID::"+currentExceptionID)
        // then convert & transport it
        try {
            // rewrite the stack frames to be in the format we're expecting
            var stack = prettyStack.map(function (frame) { return ({
                functionName: frame.methodName === "<unknown>" ? null : frame.methodName,
                lineNumber: frame.lineNumber,
                columnNumber: frame.column,
                fileName: frame.file,
            }); });
            // does the dev want us to keep each frame?
            if (config.veto) {
                stack = stack.filter(function (frame) { return config.veto(frame); });
            }
            // throw it over to us
            eg.error(message, stack); // TODO: Fix this.
        }
        catch (e) {
            console.log("eGExceptionHijacker:e::", e);
            // TODO: no one must ever know our dark secrets
        }
    }
    // here's how to swizzle
    function trackGlobalErrors() {
        // console.log("trackGlobalErrors:isSwizzled::"+isSwizzled)
        // console.log("trackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
        if (isSwizzled)
            return;
        if (!NativeModules.ExceptionsManager)
            return;
        swizzled = NativeModules.ExceptionsManager.updateExceptionMessage;
        NativeModules.ExceptionsManager.updateExceptionMessage = eGExceptionHijacker;
        isSwizzled = true;
    }
    // restore the original
    function untrackGlobalErrors() {
        // console.log("untrackGlobalErrors:isSwizzled::"+isSwizzled)
        // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
        if (!swizzled)
            return;
        if (!NativeModules.ExceptionsManager)
            return;
        NativeModules.ExceptionsManager.updateExceptionMessage = swizzled;
        isSwizzled = false;
    }
    // auto start this
    trackGlobalErrors();
    var handleError = function (error, isFatal) {
        if (isFatal) {
            reportError(error);
        }
        else {
            console.log(error);
        }
    };
    setJSExceptionHandler(handleError, true);
    // manually fire an error
    function reportError(error) {
        //console.log("reportError:isSwizzled::"+error)
        // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
        //(eg as any).error(error.message, true) 
        try {
            var parseErrorStack = parseStackTrace(error.stack);
            //console.log('parsed', parseErrorStack)
            if (parseErrorStack) {
                var stack = parseErrorStack.map(function (stackFrame) { return ({
                    fileName: stackFrame.file,
                    functionName: stackFrame.name,
                    lineNumber: stackFrame.line,
                }); });
                //console.log('error.message', error.message);
                if (config.veto) {
                    stack = stack.filter(function (frame) { return config.veto(frame); });
                }
                eg.error(error.message, error);
            }
        }
        catch (err) {
            //nothing happened. move along.
        }
    }
    // the eg plugin interface
    return {
        // attach these functions to the eg
        features: {
            reportError: reportError,
            trackGlobalErrors: trackGlobalErrors,
            untrackGlobalErrors: untrackGlobalErrors,
        },
    };
}; });
