var DEFAULTS = {
    url: "http://localhost:8081",
};
export default (function (pluginConfig) {
    if (pluginConfig === void 0) { pluginConfig = {}; }
    return function () {
        var options = Object.assign({}, DEFAULTS, pluginConfig);
        return {
            onCommand: function (command) {
                if (command.type !== "editor.open")
                    return;
                var payload = command.payload;
                var file = payload.file, lineNumber = payload.lineNumber;
                var url = options.url + "/open-stack-frame";
                var body = { file: file, lineNumber: lineNumber || 1 };
                var method = "POST";
                fetch(url, { method: method, body: JSON.stringify(body) });
            },
        };
    };
});
