import XHRInterceptor from 'react-native/Libraries/Network/XHRInterceptor';
/**
 * Don't include the response bodies for images by default.
 */
var DEFAULT_CONTENT_TYPES_RX = /^(image)\/.*$/i;
var DEFAULTS = {};
export default (function (pluginConfig) {
    if (pluginConfig === void 0) { pluginConfig = {}; }
    return function (eg) {
        var options = Object.assign({}, DEFAULTS, pluginConfig);
        // a RegExp to suppess adding the body cuz it costs a lot to serialize
        var ignoreContentTypes = options.ignoreContentTypes || DEFAULT_CONTENT_TYPES_RX;
        // a XHR call tracker
        var egCounter = 1000;
        // a temporary cache to hold requests so we can match up the data
        var requestCache = {};
        /**
         * Fires when we talk to the server.
         *
         * @param {*} data - The data sent to the server.
         * @param {*} instance - The XMLHTTPRequest instance.
         */
        function onSend(data, xhr) {
            if (options.ignoreUrls && options.ignoreUrls.test(xhr._url)) {
                xhr._skipEG = true;
                return;
            }
            // bump the counter
            egCounter++;
            // tag
            xhr._trackingName = egCounter;
            // cache
            requestCache[egCounter] = {
                data: data,
                xhr: xhr,
                stopTimer: eg.startTimer()
            };
        }
        /**
         * Fires when the server gives us a response.
         *
         * @param {number} status - The HTTP response status.
         * @param {boolean} timeout - Did we timeout?
         * @param {*} response - The response data.
         * @param {string} url - The URL we talked to.
         * @param {*} type - Not sure.
         * @param {*} xhr - The XMLHttpRequest instance.
         */
        function onResponse(status, timeout, response, url, type, xhr) {
            if (xhr._skipEG) {
                return;
            }
            var params = null;
            var queryParamIdx = url ? url.indexOf('?') : -1;
            if (queryParamIdx > -1) {
                // params = queryString.parse(url.substr(queryParamIdx))
                params = url.substr(queryParamIdx);
            }
            // fetch and clear the request data from the cache
            var rid = xhr._trackingName;
            var cachedRequest = requestCache[rid] || {};
            requestCache[rid] = null;
            // assemble the request object
            var data = cachedRequest.data, stopTimer = cachedRequest.stopTimer;
            var tronRequest = {
                url: url || cachedRequest.xhr._url,
                method: xhr._method || null,
                data: data,
                headers: xhr._headers || null,
                params: params
            };
            // what type of content is this?
            var contentType = (xhr.responseHeaders && xhr.responseHeaders['content-type']) ||
                (xhr.responseHeaders && xhr.responseHeaders['Content-Type']) ||
                '';
            var sendResponse = function (responseBodyText) {
                var body = "~~~ skipped ~~~";
                if (responseBodyText) {
                    try {
                        // all i am saying, is give JSON a chance...
                        body = JSON.parse(responseBodyText);
                    }
                    catch (boom) {
                        body = response;
                    }
                }
                var tronResponse = {
                    body: body,
                    status: status,
                    headers: xhr.responseHeaders || null
                };
                eg.apiResponse(tronRequest, tronResponse, stopTimer()); // TODO: Fix
            };
            // can we use the real response?
            var useRealResponse = (typeof response === 'string' || typeof response === 'object') &&
                !ignoreContentTypes.test(contentType || '');
            // prepare the right body to send
            if (useRealResponse) {
                if (type === 'blob' && typeof FileReader !== 'undefined' && response) {
                    // Disable reason: FileReader should be in global scope since RN 0.54
                    // eslint-disable-next-line no-undef
                    var bReader_1 = new FileReader();
                    var brListener_1 = function () {
                        sendResponse(bReader_1.result);
                        bReader_1.removeEventListener('loadend', brListener_1);
                    };
                    bReader_1.addEventListener('loadend', brListener_1);
                    bReader_1.readAsText(response);
                }
                else {
                    sendResponse(response);
                }
            }
            else {
                sendResponse('');
            }
        }
        // register our monkey-patch
        XHRInterceptor.setSendCallback(onSend);
        XHRInterceptor.setResponseCallback(onResponse);
        XHRInterceptor.enableInterception();
        // nothing of use to offer to the plugin
        return {};
    };
});
