'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var reactNative = require('react-native');
var React = require('react');
var XHRInterceptor = require('react-native/Libraries/Network/XHRInterceptor');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var XHRInterceptor__default = /*#__PURE__*/_interopDefaultLegacy(XHRInterceptor);

function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }

  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function () {
    var self = this,
        args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);

      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }

      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }

      _next(undefined);
    });
  };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    });
    keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};

    if (i % 2) {
      ownKeys(Object(source), true).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }

  return target;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();

  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived),
        result;

    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;

      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }

    return _possibleConstructorReturn(this, result);
  };
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

var isCreateSocketValid = function isCreateSocketValid(createSocket) {
  return typeof createSocket !== "undefined" && createSocket !== null;
};

var isHostValid = function isHostValid(host) {
  return typeof host === "string" && host && host !== "";
};

var isPortValid = function isPortValid(port) {
  return typeof port === "number" && port >= 1 && port <= 65535;
};

var onCommandValid = function onCommandValid(fn) {
  return typeof fn === "function";
};
/**
 * Ensures the options are sane to run this baby.  Throw if not.  These
 * are basically sanity checks.
 */


var validate = function validate(options) {
  var createSocket = options.createSocket,
      host = options.host,
      port = options.port,
      onCommand = options.onCommand;

  if (!isCreateSocketValid(createSocket)) {
    throw new Error("invalid createSocket function");
  }

  if (!isHostValid(host)) {
    throw new Error("invalid host");
  }

  if (!isPortValid(port)) {
    throw new Error("invalid port");
  }

  if (!onCommandValid(onCommand)) {
    throw new Error("invalid onCommand handler");
  }
};

// JSON.stringify() doesn't support circular dependencies or keeping
// falsy values.  This does.
//
// Mostly adapted from https://github.com/isaacs/json-stringify-safe
// replacement tokens
var UNDEFINED = "";
var NULL = "null";
var FALSE = "false";
var ZERO = "0";
var EMPTY_STRING = "";
var CIRCULAR = "";
var ANONYMOUS = "";
var INFINITY = "Infinity";
var NEGATIVE_INFINITY = "-Infinity"; // const NAN = '~~~ NaN ~~~'

/**
 * Attempts to give a name to a function.
 *
 * @param {Function} fn - The function to name.
 */

function getFunctionName(fn) {
  var n = fn.name;

  if (n === null || n === undefined || n === "") {
    return ANONYMOUS;
  } else {
    return "~~~ ".concat(n, "() ~~~");
  }
}
/**
 * Serializes an object to JSON.
 *
 *  @param {any} source - The victim.
 */


function serialize(source) {
  var proxyHack = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var stack = [];
  /**
   * Replace this object node with something potentially custom.
   *
   * @param {*} key - The key currently visited.
   * @param {*} value - The value to replace.
   */

  function serializer(replacer) {
    return function (key, value) {
      // slam dunks
      if (value === true) return true; // weird stuff
      // if (Object.is(value, NaN)) return NAN // OK, apparently this is hard... leaving out for now

      if (value === Infinity) return INFINITY;
      if (value === -Infinity) return NEGATIVE_INFINITY;
      if (value === 0) return ZERO; // classic javascript

      if (value === undefined) return UNDEFINED;
      if (value === null) return NULL;
      if (value === false) return FALSE; // head shakers

      if (value === -0) return ZERO; // eslint-disable-line

      if (value === "") return EMPTY_STRING;

      if (proxyHack && _typeof(value) === "object" && value.nativeEvent) {
        return value.nativeEvent;
      } // known types that have easy resolving


      switch (_typeof(value)) {
        case "string":
          return value;

        case "number":
          return value;

        case "function":
          return getFunctionName(value);
      } // Tough things to crack
      // If we have an iterator but are not an array (because arrays are easily seralizeable already)...


      if (value[Symbol.iterator] && !Array.isArray(value)) {
        // Convert to an array!
        return _toConsumableArray(value);
      }

      if (stack.length > 0) {
        // check for prior existance
        var thisPos = stack.indexOf(this);
        ~thisPos ? stack.splice(thisPos + 1) : stack.push(this);
        if (~stack.indexOf(value)) value = CIRCULAR;
      } else {
        stack.push(value);
      }

      return replacer == null ? value : replacer.call(this, key, value);
    };
  }

  return JSON.stringify(source, serializer(null));
}

/*import { eG } from "../eg-core-client";
import serialize from "../serialize"
/**
 * Provides 4 features for logging.  log & debug are the same.
 
export default () => (eg: eG) => {
  return {
    features: {
      // log: (...args) => {
      //   const content = (args && args.length === 1) ? args[0] : args
      //   // eg.send("log", { level: "debug", message: content }, false)
      // },
      // logImportant: (...args) => {
      //   const content = (args && args.length === 1) ? args[0] : args
      //   // eg.send("log", { level: "debug", message: content }, true)
      // },
      // debug: (message, important = false) => 
      //   // eg.send("log", { level: "debug", message }, !!important),
      // warn: message => eg.send("log", { level: "warn", message }, true),
      error: (message, stack) => {
        // console.log("logger:error::message:::"+message)
        // console.log("logger:error::stack:::"+stack)
        let errors = getJSONData(message, stack);
        // console.log("logger:error:serialize:stack:::"+ errors)
        eg.send("JSError", errors , true)
      } 
    },
  }
}

function getJSONData(message, stack) {
  return {"pageId":"", "errorPageId":"","parentPageId":"","isError": true,  "errorMessage": message,  "errorFunction": "", "line": 0,  "column" : 0,  "stacktrace": serialize(stack, true),  "metaData": ""}
  
}
*/
/**
 * Provides 4 features for logging.  log & debug are the same.
 */

var logger = (function () {
  return function (eg) {
    return {
      features: {
        // log: (...args) => {
        //   const content = (args && args.length === 1) ? args[0] : args
        //   // eg.send("log", { level: "debug", message: content }, false)
        // },
        // logImportant: (...args) => {
        //   const content = (args && args.length === 1) ? args[0] : args
        //   // eg.send("log", { level: "debug", message: content }, true)
        // },
        // debug: (message, important = false) => 
        //   // eg.send("log", { level: "debug", message }, !!important),
        // warn: message => eg.send("log", { level: "warn", message }, true),
        error: function error(message, stack) {
          // console.log("logger:error::message:::"+message)
          // console.log("logger:error::stack:::"+stack)
          var errors = getJSONData(message, stack); // console.log("logger:error:serialize:stack:::"+ errors)

          eg.send("JSError", errors, true);
        }
      }
    };
  };
});

function getJSONData(message, stack) {
  //console.log('logger message', message);
  //console.log('logger message', stack)
  return {
    "pageId": "",
    "errorPageId": "",
    "parentPageId": "",
    "isError": true,
    "errorMessage": message,
    "errorFunction": stack.name,
    "line": stack.line,
    "column": stack.column,
    "stacktrace": serialize(stack, true),
    "metaData": ""
  };
}

/**
 * Provides an image.
 */
var image = (function () {
  return function (eg) {
    return {
      features: {
        // expanded just to show the specs
        image: function image(_ref) {
          var uri = _ref.uri,
              preview = _ref.preview,
              filename = _ref.filename,
              width = _ref.width,
              height = _ref.height,
              caption = _ref.caption;
          return console.log(uri + preview + filename + width + height + caption);
        } // eg.send("image", { uri, preview, filename, width, height, caption }),

      }
    };
  };
});

/**
 * Runs small high-unscientific benchmarks for you.
 */
var benchmark = (function () {
  return function (eg) {
    var startTimer = eg.startTimer;

    var benchmark = function benchmark(title) {
      var steps = [];
      var elapsed = startTimer();

      var step = function step(stepTitle) {
        var previousTime = steps.length === 0 ? 0 : steps[steps.length - 1].time;
        var nextTime = elapsed();
        steps.push({
          title: stepTitle,
          time: nextTime,
          delta: nextTime - previousTime
        });
      };

      steps.push({
        title: title,
        time: 0,
        delta: 0
      });

      var stop = function stop(stopTitle) {
        step(stopTitle); // eg.send("benchmark.report", { title, steps })
      };

      return {
        step: step,
        stop: stop,
        last: stop
      };
    };

    return {
      features: {
        benchmark: benchmark
      }
    };
  };
});

/**
 * Provides helper functions for send state responses.
 */
var stateResponses = (function () {
  return function (eg) {
    return {
      features: {
        stateActionComplete: function stateActionComplete(name, action) {
          return console.log("name:" + name);
        },
        // eg.send("state.action.complete", { name, action }, !!important),
        stateValuesResponse: function stateValuesResponse(path, value) {
          return console.log("path:" + path);
        },
        // eg.send("state.values.response", { path, value, valid }),
        stateKeysResponse: function stateKeysResponse(path, keys) {
          return console.log("path:" + path);
        },
        // eg.send("state.keys.response", { path, keys, valid }),
        stateValuesChange: function stateValuesChange(changes) {
          return changes.length > 0;
        },
        //  && eg.send("state.values.change", { changes }),
        // sends the state backup over to the server
        stateBackupResponse: function stateBackupResponse(state) {
          return console.log("state:" + state);
        } //eg.send("state.backup.response", { state }),

      }
    };
  };
});

/**
 * Sends API request/response information.
 */
var apiResponse = (function () {
  return function (eg) {
    return {
      features: {
        apiResponse: function apiResponse(request, response, duration) {
          if (request.url != null && request.url.indexOf(eg.host) > -1) {
            return;
          }

          var ok = response && response.status && typeof response.status === "number" && response.status >= 200 && response.status <= 299;
          console.log("ok ----" + ok);
          console.log("request.url ----" + request.url);
          console.log("isRemoteCall(request.url) ----" + !isLocalCall(request.url));
          console.log("duration ----" + duration);
          var important = !ok;

          if (!isLocalCall(request.url)) {
            var httpInformation = getHTTPJSONData(request, response, duration);
            eg.send("HTTP", httpInformation, important);
          } else {
            var pageInformation = getPageJSONData(request, response, duration);
            eg.send("Page", pageInformation, important);
          }
        }
      }
    };
  };
});

function isLocalCall(hostname) {
  var isLocal = false;
  console.log('hostname:::' + hostname);
  isLocal = "undefined" === typeof hostname || hostname.startsWith('file://') || hostname.indexOf('localhost') > -1 || hostname.indexOf('127.0.0.1') > -1 || hostname.indexOf('192.168.') > -1 || hostname.indexOf('10.0.') > -1 || hostname.indexOf('.local') > -1 || ['localhost', '127.0.0.1', '192.168.', '10.0.', '::1'].includes(hostname); // console.log('isLocal:::'+isLocal);

  return isLocal;
}

function getHTTPJSONData(request, response, duration) {
  return {
    "url": request.url,
    "httpMethod": request.method,
    "statusCode": response.status,
    "bytesSent": request.data != null ? request.data.toString().length : 0,
    "bytesReceived": response.body.toString().length,
    "startTime": 0,
    "endTime": 0,
    "executionTime": duration,
    "errorCode": "",
    "errorMessage": ""
  };
}

function getPageJSONData(request, response, duration) {
  return {
    "page": request.url,
    "title": "",
    "httpMethod": request.method,
    "statusCode": response.status,
    "bytesSent": request.data != null ? request.data.toString().length : 0,
    "bytesReceived": response.body.toString().length,
    "startTime": 0,
    "endTime": 0,
    "executionTime": duration,
    "errorCode": "",
    "errorMessage": ""
  };
}

/**
 * Clears the eg-manager server.
 */
var clear = (function () {
  return function (eg) {
    return {
      features: {// clear: () => eg.send("clear"),
      }
    };
  };
});

var repl = (function () {
  return function (eg) {
    var myRepls = {}; // let currentContext = null

    return {
      onCommand: function onCommand(_ref) {
        var type = _ref.type,
            payload = _ref.payload;
        if (type.substr(0, 5) !== "repl.") return;

        switch (type.substr(5)) {
          case "ls":
            // eg.send("repl.ls.response", Object.keys(myRepls))
            console.log("myRepls:" + myRepls);
            break;
          // case "cd":
          //   const changeTo = myRepls.find(r => r.name === payload)
          //   if (!changeTo) {
          //     eg.send("repl.cd.response", "That REPL does not exist")
          //     break
          //   }
          //   currentContext = payload
          //   eg.send("repl.cd.response", `Change REPL to "${payload}"`)
          //   break

          case "execute":
            // if (!currentContext) {
            //   eg.send(
            //     "repl.execute.response",
            //     "You must first select the REPL to use. Try 'ls'"
            //   )
            //   break
            // }
            // const currentRepl = myRepls.find(r => r.name === currentContext)
            // if (!currentRepl) {
            //   eg.send("repl.execute.response", "The selected REPL no longer exists.")
            //   break
            // }
            console.log("payload:" + payload); // eg.send(
            //   "repl.execute.response",
            //   function() {
            //     return eval(payload) // eslint-disable-line no-eval
            //   }.call(myRepls)
            // )

            break;
        }
      },
      features: {
        repl: function repl(name, value) {
          if (!name) {
            throw new Error("You must provide a name for your REPL");
          }

          if (myRepls[name]) {
            throw new Error("You are already REPLing an item with that name");
          }

          myRepls[name] = value;
        }
      }
    };
  };
});

// eslint-disable-next-line @typescript-eslint/no-unused-vars

var defaultPerformanceNow = function defaultPerformanceNow(started) {
  return Date.now();
}; // try to find the browser-based performance timer


var nativePerformance = typeof window !== "undefined" && window && (window.performance || window.msPerformance || window.webkitPerformance); // the function we're trying to assign

var performanceNow = defaultPerformanceNow; // accepts an already started time and returns the number of milliseconds

var delta = function delta(started) {
  return performanceNow() - started;
};

if (global.nativePerformanceNow) {
  // react native 47
  performanceNow = global.nativePerformanceNow;
} else if (nativePerformance) {
  // browsers + safely check for react native < 47
  performanceNow = function performanceNow() {
    return nativePerformance.now && nativePerformance.now();
  };
}
/**
 * Starts a lame, low-res timer.  Returns a function which when invoked,
 * gives you the number of milliseconds since passing.  ish.
 */


var start = function start() {
  //  record the start time
  var started = performanceNow();
  return function () {
    return delta(started);
  };
};

var devicesWithNotch = [{
  brand: 'Apple',
  model: 'iPhone 11'
}, {
  brand: 'Apple',
  model: 'iPhone 11 Pro'
}, {
  brand: 'Apple',
  model: 'iPhone 11 Pro Max'
}, {
  brand: 'Apple',
  model: 'iPhone X'
}, {
  brand: 'Apple',
  model: 'iPhone XS'
}, {
  brand: 'Apple',
  model: 'iPhone XS Max'
}, {
  brand: 'Apple',
  model: 'iPhone XR'
}, {
  brand: 'Asus',
  model: 'ZenFone 5'
}, {
  brand: 'Asus',
  model: 'ZenFone 5z'
}, {
  brand: 'google',
  model: 'Pixel 3 XL'
}, {
  brand: 'Huawei',
  model: 'P20'
}, {
  brand: 'Huawei',
  model: 'P20 Plus'
}, {
  brand: 'Huawei',
  model: 'P20 Lite'
}, {
  brand: 'Huawei',
  model: 'ANE-LX1'
}, {
  brand: 'Huawei',
  model: 'INE-LX1'
}, {
  brand: 'Huawei',
  model: 'POT-LX1'
}, {
  brand: 'Huawei',
  model: 'Honor 10'
}, {
  brand: 'Huawei',
  model: 'Mate 20 Lite'
}, {
  brand: 'Huawei',
  model: 'Mate 20 Pro'
}, {
  brand: 'Huawei',
  model: 'P30 Lite'
}, {
  brand: 'Huawei',
  model: 'P30 Pro'
}, {
  brand: 'Huawei',
  model: 'Nova 3'
}, {
  brand: 'Huawei',
  model: 'Nova 3i'
}, {
  brand: 'Leagoo',
  model: 'S9'
}, {
  brand: 'LG',
  model: 'G7'
}, {
  brand: 'LG',
  model: 'G7 ThinQ'
}, {
  brand: 'LG',
  model: 'G7+ ThinQ'
}, {
  brand: 'LG',
  model: 'LM-Q910' //G7 One

}, {
  brand: 'LG',
  model: 'LM-G710' //G7 ThinQ

}, {
  brand: 'LG',
  model: 'LM-V405' //V40 ThinQ

}, {
  brand: 'Motorola',
  model: 'Moto g7 Play'
}, {
  brand: 'Motorola',
  model: 'Moto g7 Power'
}, {
  brand: 'Motorola',
  model: 'One'
}, {
  brand: 'Motorola',
  model: 'Motorola One Vision'
}, {
  brand: 'Nokia',
  model: '5.1 Plus'
}, {
  brand: 'Nokia',
  model: 'Nokia 6.1 Plus'
}, {
  brand: 'Nokia',
  model: '7.1'
}, {
  brand: 'Nokia',
  model: '8.1'
}, {
  brand: 'OnePlus',
  model: '6'
}, {
  brand: 'OnePlus',
  model: 'A6003'
}, {
  brand: 'ONEPLUS',
  model: 'A6000'
}, {
  brand: 'OnePlus',
  model: 'OnePlus A6003'
}, {
  brand: 'OnePlus',
  model: 'ONEPLUS A6010'
}, {
  brand: 'OnePlus',
  model: 'ONEPLUS A6013'
}, {
  brand: 'OnePlus',
  model: 'ONEPLUS A6000'
}, {
  brand: 'Oppo',
  model: 'R15'
}, {
  brand: 'Oppo',
  model: 'R15 Pro'
}, {
  brand: 'Oppo',
  model: 'F7'
}, {
  brand: 'Oukitel',
  model: 'U18'
}, {
  brand: 'Sharp',
  model: 'Aquos S3'
}, {
  brand: 'Vivo',
  model: 'V9'
}, {
  brand: 'Vivo',
  model: 'X21'
}, {
  brand: 'Vivo',
  model: 'X21 UD'
}, {
  brand: 'xiaomi',
  model: 'MI 8'
}, {
  brand: 'xiaomi',
  model: 'MI 8 Explorer Edition'
}, {
  brand: 'xiaomi',
  model: 'MI 8 SE'
}, {
  brand: 'xiaomi',
  model: 'MI 8 UD'
}, {
  brand: 'xiaomi',
  model: 'MI 8 Lite'
}, {
  brand: 'xiaomi',
  model: 'Mi 9'
}, {
  brand: 'xiaomi',
  model: 'POCO F1'
}, {
  brand: 'xiaomi',
  model: 'POCOPHONE F1'
}, {
  brand: 'xiaomi',
  model: 'Redmi 6 Pro'
}, {
  brand: 'xiaomi',
  model: 'Redmi Note 7'
}, {
  brand: 'xiaomi',
  model: 'Redmi Note 8'
}, {
  brand: 'xiaomi',
  model: 'Mi A2 Lite'
}];

var RNDeviceInfo = reactNative.NativeModules.eGAgent; // @ts-ignore
// if (Platform.OS === 'web' || Platform.OS === 'dom') {
//   RNDeviceInfo = require('./web.js');
// }

if (!RNDeviceInfo) {
  // Produce an error if we don't have the native module
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web' || // @ts-ignore
  reactNative.Platform.OS === 'dom') {
    throw new Error("@react-native-community/react-native-device-info: NativeModule.RNDeviceInfo is null. To fix this issue try these steps:\n  \u2022 For react-native <= 0.59: Run `react-native link react-native-device-info` in the project root.\n  \u2022 Rebuild and re-run the app.\n  \u2022 If you are using CocoaPods on iOS, run `pod install` in the `ios` directory and then rebuild and re-run the app. You may also need to re-open Xcode to get the new pods.\n  If none of these fix the issue, please open an issue on the Github repository: https://github.com/react-native-community/react-native-device-info");
  }
}

// import { DeviceType, LocationProviderInfo, PowerState, AsyncHookResult } from './types';
// import { DeviceType, LocationProviderInfo, PowerState } from './types';
// export type DeviceType = 'Handset' | 'Tablet' | 'Tv' | 'unknown';
var DeviceType;

(function (DeviceType) {
  DeviceType[DeviceType["Handset"] = 0] = "Handset";
  DeviceType[DeviceType["Tablet"] = 1] = "Tablet";
  DeviceType[DeviceType["TV"] = 2] = "TV";
  DeviceType[DeviceType["unknown"] = 3] = "unknown";
})(DeviceType || (DeviceType = {}));

var uniqueId;
function getUniqueId() {
  if (!uniqueId) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      uniqueId = RNDeviceInfo.uniqueId;
    } else {
      uniqueId = 'unknown';
    }
  }

  return uniqueId;
}
function syncUniqueId() {
  return _syncUniqueId.apply(this, arguments);
}

function _syncUniqueId() {
  _syncUniqueId = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'ios')) {
              _context3.next = 6;
              break;
            }

            _context3.next = 3;
            return RNDeviceInfo.syncUniqueId();

          case 3:
            uniqueId = _context3.sent;
            _context3.next = 7;
            break;

          case 6:
            uniqueId = getUniqueId();

          case 7:
            return _context3.abrupt("return", uniqueId);

          case 8:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _syncUniqueId.apply(this, arguments);
}

var instanceId;
function getInstanceId() {
  return _getInstanceId.apply(this, arguments);
}

function _getInstanceId() {
  _getInstanceId = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            if (instanceId) {
              _context4.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context4.next = 7;
              break;
            }

            _context4.next = 4;
            return RNDeviceInfo.getInstanceId();

          case 4:
            instanceId = _context4.sent;
            _context4.next = 8;
            break;

          case 7:
            instanceId = 'unknown';

          case 8:
            return _context4.abrupt("return", instanceId);

          case 9:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _getInstanceId.apply(this, arguments);
}

function getInstanceIdSync() {
  if (!instanceId) {
    if (reactNative.Platform.OS === 'android') {
      instanceId = RNDeviceInfo.getInstanceIdSync();
    } else {
      instanceId = 'unknown';
    }
  }

  return instanceId;
}
var serialNumber;
function getSerialNumber() {
  return _getSerialNumber.apply(this, arguments);
}

function _getSerialNumber() {
  _getSerialNumber = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            if (serialNumber) {
              _context5.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context5.next = 7;
              break;
            }

            _context5.next = 4;
            return RNDeviceInfo.getSerialNumber();

          case 4:
            serialNumber = _context5.sent;
            _context5.next = 8;
            break;

          case 7:
            serialNumber = 'unknown';

          case 8:
            return _context5.abrupt("return", serialNumber);

          case 9:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _getSerialNumber.apply(this, arguments);
}

function getSerialNumberSync() {
  if (!serialNumber) {
    if (reactNative.Platform.OS === 'android') {
      serialNumber = RNDeviceInfo.getSerialNumberSync();
    } else {
      serialNumber = 'unknown';
    }
  }

  return serialNumber;
}
var androidId;
function getAndroidId() {
  return _getAndroidId.apply(this, arguments);
}

function _getAndroidId() {
  _getAndroidId = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
    return regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            if (androidId) {
              _context6.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context6.next = 7;
              break;
            }

            _context6.next = 4;
            return RNDeviceInfo.getAndroidId();

          case 4:
            androidId = _context6.sent;
            _context6.next = 8;
            break;

          case 7:
            androidId = 'unknown';

          case 8:
            return _context6.abrupt("return", androidId);

          case 9:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));
  return _getAndroidId.apply(this, arguments);
}

function getAndroidIdSync() {
  if (!androidId) {
    if (reactNative.Platform.OS === 'android') {
      androidId = RNDeviceInfo.getAndroidIdSync();
    } else {
      androidId = 'unknown';
    }
  }

  return androidId;
}
function getIpAddress() {
  return _getIpAddress.apply(this, arguments);
}

function _getIpAddress() {
  _getIpAddress = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
    return regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context7.next = 2;
              break;
            }

            return _context7.abrupt("return", RNDeviceInfo.getIpAddress());

          case 2:
            return _context7.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7);
  }));
  return _getIpAddress.apply(this, arguments);
}

function getIpAddressSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
    return RNDeviceInfo.getIpAddressSync();
  }

  return 'unknown';
}
function getFrequency() {
  return _getFrequency.apply(this, arguments);
}

function _getFrequency() {
  _getFrequency = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
    return regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context8.next = 2;
              break;
            }

            return _context8.abrupt("return", RNDeviceInfo.getFrequency());

          case 2:
            return _context8.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  }));
  return _getFrequency.apply(this, arguments);
}

function getBroadcast() {
  return _getBroadcast.apply(this, arguments);
}

function _getBroadcast() {
  _getBroadcast = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
    return regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context9.next = 2;
              break;
            }

            return _context9.abrupt("return", RNDeviceInfo.getBroadcast());

          case 2:
            return _context9.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));
  return _getBroadcast.apply(this, arguments);
}

function isCameraPresent() {
  return _isCameraPresent.apply(this, arguments);
}

function _isCameraPresent() {
  _isCameraPresent = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
    return regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web')) {
              _context10.next = 2;
              break;
            }

            return _context10.abrupt("return", RNDeviceInfo.isCameraPresent());

          case 2:
            return _context10.abrupt("return", false);

          case 3:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10);
  }));
  return _isCameraPresent.apply(this, arguments);
}

function isCameraPresentSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.isCameraPresentSync();
  }

  return false;
}
function getMacAddress() {
  return _getMacAddress.apply(this, arguments);
}

function _getMacAddress() {
  _getMacAddress = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11() {
    return regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android')) {
              _context11.next = 4;
              break;
            }

            return _context11.abrupt("return", RNDeviceInfo.getMacAddress());

          case 4:
            if (!(reactNative.Platform.OS === 'ios')) {
              _context11.next = 6;
              break;
            }

            return _context11.abrupt("return", '02:00:00:00:00:00');

          case 6:
            return _context11.abrupt("return", 'unknown');

          case 7:
          case "end":
            return _context11.stop();
        }
      }
    }, _callee11);
  }));
  return _getMacAddress.apply(this, arguments);
}

function getMacAddressSync() {
  if (reactNative.Platform.OS === 'android') {
    return RNDeviceInfo.getMacAddressSync();
  } else if (reactNative.Platform.OS === 'ios') {
    return '02:00:00:00:00:00';
  }

  return 'unknown';
}
var deviceId;
function getDeviceId() {
  if (!deviceId) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      deviceId = RNDeviceInfo.deviceId;
    } else {
      deviceId = 'unknown';
    }
  }

  return deviceId;
}
var manufacturer;
function getManufacturer() {
  return _getManufacturer.apply(this, arguments);
}

function _getManufacturer() {
  _getManufacturer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12() {
    return regeneratorRuntime.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            if (manufacturer) {
              _context12.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows')) {
              _context12.next = 7;
              break;
            }

            _context12.next = 4;
            return RNDeviceInfo.getSystemManufacturer();

          case 4:
            manufacturer = _context12.sent;
            _context12.next = 8;
            break;

          case 7:
            if (reactNative.Platform.OS === 'ios') {
              manufacturer = 'Apple';
            } else {
              manufacturer = 'unknown';
            }

          case 8:
            return _context12.abrupt("return", manufacturer);

          case 9:
          case "end":
            return _context12.stop();
        }
      }
    }, _callee12);
  }));
  return _getManufacturer.apply(this, arguments);
}

function getManufacturerSync() {
  if (!manufacturer) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows') {
      manufacturer = RNDeviceInfo.getSystemManufacturerSync();
    } else if (reactNative.Platform.OS === 'ios') {
      manufacturer = 'Apple';
    } else {
      manufacturer = 'unknown';
    }
  }

  return manufacturer;
}
var model;
function getModel() {
  if (!model) {
    if (reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows') {
      model = RNDeviceInfo.model;
    } else {
      model = 'unknown';
    }
  }

  return model;
}
var brand;
function getBrand() {
  if (!brand) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      brand = RNDeviceInfo.brand;
    } else {
      brand = 'unknown';
    }
  }

  return brand;
}
var systemName;
function getSystemName() {
  if (!systemName) {
    if (reactNative.Platform.OS === 'ios') {
      systemName = RNDeviceInfo.systemName;
    } else if (reactNative.Platform.OS === 'android') {
      systemName = 'Android';
    } else if (reactNative.Platform.OS === 'windows') {
      systemName = 'Windows';
    } else {
      systemName = 'unknown';
    }
  }

  return systemName;
}
var systemVersion;
function getSystemVersion() {
  if (!systemVersion) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      systemVersion = RNDeviceInfo.systemVersion;
    } else {
      systemVersion = 'unknown';
    }
  }

  return systemVersion;
}
var buildId;
function getBuildId() {
  return _getBuildId.apply(this, arguments);
}

function _getBuildId() {
  _getBuildId = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13() {
    return regeneratorRuntime.wrap(function _callee13$(_context13) {
      while (1) {
        switch (_context13.prev = _context13.next) {
          case 0:
            if (buildId) {
              _context13.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context13.next = 7;
              break;
            }

            _context13.next = 4;
            return RNDeviceInfo.getBuildId();

          case 4:
            buildId = _context13.sent;
            _context13.next = 8;
            break;

          case 7:
            buildId = 'unknown';

          case 8:
            return _context13.abrupt("return", buildId);

          case 9:
          case "end":
            return _context13.stop();
        }
      }
    }, _callee13);
  }));
  return _getBuildId.apply(this, arguments);
}

function getBuildIdSync() {
  if (!buildId) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
      buildId = RNDeviceInfo.getBuildIdSync();
    } else {
      buildId = 'unknown';
    }
  }

  return buildId;
}
var apiLevel;
function getApiLevel() {
  return _getApiLevel.apply(this, arguments);
}

function _getApiLevel() {
  _getApiLevel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14() {
    return regeneratorRuntime.wrap(function _callee14$(_context14) {
      while (1) {
        switch (_context14.prev = _context14.next) {
          case 0:
            if (apiLevel) {
              _context14.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context14.next = 7;
              break;
            }

            _context14.next = 4;
            return RNDeviceInfo.getApiLevel();

          case 4:
            apiLevel = _context14.sent;
            _context14.next = 8;
            break;

          case 7:
            apiLevel = -1;

          case 8:
            return _context14.abrupt("return", apiLevel);

          case 9:
          case "end":
            return _context14.stop();
        }
      }
    }, _callee14);
  }));
  return _getApiLevel.apply(this, arguments);
}

function getApiLevelSync() {
  if (!apiLevel) {
    if (reactNative.Platform.OS === 'android') {
      apiLevel = RNDeviceInfo.getApiLevelSync();
    } else {
      apiLevel = -1;
    }
  }

  return apiLevel;
}
var bundleId;
function getBundleId() {
  if (!bundleId) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      bundleId = RNDeviceInfo.bundleId;
    } else {
      bundleId = 'unknown';
    }
  }

  return bundleId;
}
var installerPackageName;
function getInstallerPackageName() {
  return _getInstallerPackageName.apply(this, arguments);
}

function _getInstallerPackageName() {
  _getInstallerPackageName = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15() {
    return regeneratorRuntime.wrap(function _callee15$(_context15) {
      while (1) {
        switch (_context15.prev = _context15.next) {
          case 0:
            if (installerPackageName) {
              _context15.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context15.next = 7;
              break;
            }

            _context15.next = 4;
            return RNDeviceInfo.getInstallerPackageName();

          case 4:
            installerPackageName = _context15.sent;
            _context15.next = 8;
            break;

          case 7:
            installerPackageName = 'unknown';

          case 8:
            return _context15.abrupt("return", installerPackageName);

          case 9:
          case "end":
            return _context15.stop();
        }
      }
    }, _callee15);
  }));
  return _getInstallerPackageName.apply(this, arguments);
}

function getInstallerPackageNameSync() {
  if (!installerPackageName) {
    if (reactNative.Platform.OS === 'android') {
      installerPackageName = RNDeviceInfo.getInstallerPackageNameSync();
    } else {
      installerPackageName = 'unknown';
    }
  }

  return installerPackageName;
}
var appName;
function getApplicationName() {
  if (!appName) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      appName = RNDeviceInfo.appName;
    } else {
      appName = 'unknown';
    }
  }

  return appName;
}
var buildNumber;
function getBuildNumber() {
  if (!buildNumber) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      buildNumber = RNDeviceInfo.buildNumber;
    } else {
      buildNumber = 'unknown';
    }
  }

  return buildNumber;
}
var version;
function getVersion() {
  if (!version) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      version = RNDeviceInfo.appVersion;
    } else {
      version = 'unknown';
    }
  }

  return version;
}
function getReadableVersion() {
  return getVersion() + '.' + getBuildNumber();
}
var deviceName;
function getDeviceName() {
  return _getDeviceName.apply(this, arguments);
}

function _getDeviceName() {
  _getDeviceName = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee16() {
    return regeneratorRuntime.wrap(function _callee16$(_context16) {
      while (1) {
        switch (_context16.prev = _context16.next) {
          case 0:
            if (deviceName) {
              _context16.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context16.next = 7;
              break;
            }

            _context16.next = 4;
            return RNDeviceInfo.getDeviceName();

          case 4:
            deviceName = _context16.sent;
            _context16.next = 8;
            break;

          case 7:
            deviceName = 'unknown';

          case 8:
            return _context16.abrupt("return", deviceName);

          case 9:
          case "end":
            return _context16.stop();
        }
      }
    }, _callee16);
  }));
  return _getDeviceName.apply(this, arguments);
}

function getDeviceNameSync() {
  if (!deviceName) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      deviceName = RNDeviceInfo.getDeviceNameSync();
    } else {
      deviceName = 'unknown';
    }
  }

  return deviceName;
}
function getUsedMemory() {
  return _getUsedMemory.apply(this, arguments);
}

function _getUsedMemory() {
  _getUsedMemory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee17() {
    return regeneratorRuntime.wrap(function _callee17$(_context17) {
      while (1) {
        switch (_context17.prev = _context17.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context17.next = 2;
              break;
            }

            return _context17.abrupt("return", RNDeviceInfo.getUsedMemory());

          case 2:
            return _context17.abrupt("return", -1);

          case 3:
          case "end":
            return _context17.stop();
        }
      }
    }, _callee17);
  }));
  return _getUsedMemory.apply(this, arguments);
}

function getUsedMemorySync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.getUsedMemorySync();
  }

  return -1;
}
var userAgent;
function getUserAgent() {
  return _getUserAgent.apply(this, arguments);
}

function _getUserAgent() {
  _getUserAgent = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee18() {
    return regeneratorRuntime.wrap(function _callee18$(_context18) {
      while (1) {
        switch (_context18.prev = _context18.next) {
          case 0:
            if (userAgent) {
              _context18.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context18.next = 7;
              break;
            }

            _context18.next = 4;
            return RNDeviceInfo.getUserAgent();

          case 4:
            userAgent = _context18.sent;
            _context18.next = 8;
            break;

          case 7:
            userAgent = 'unknown';

          case 8:
            return _context18.abrupt("return", userAgent);

          case 9:
          case "end":
            return _context18.stop();
        }
      }
    }, _callee18);
  }));
  return _getUserAgent.apply(this, arguments);
}

function getUserAgentSync() {
  if (!userAgent) {
    // getUserAgentSync is not available on iOS since it rely on an completion operation
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web') {
      userAgent = RNDeviceInfo.getUserAgentSync();
    } else {
      userAgent = 'unknown';
    }
  }

  return userAgent;
}
function getFontScale() {
  return _getFontScale.apply(this, arguments);
}

function _getFontScale() {
  _getFontScale = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee19() {
    return regeneratorRuntime.wrap(function _callee19$(_context19) {
      while (1) {
        switch (_context19.prev = _context19.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context19.next = 2;
              break;
            }

            return _context19.abrupt("return", RNDeviceInfo.getFontScale());

          case 2:
            return _context19.abrupt("return", -1);

          case 3:
          case "end":
            return _context19.stop();
        }
      }
    }, _callee19);
  }));
  return _getFontScale.apply(this, arguments);
}

function getFontScaleSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.getFontScaleSync();
  }

  return -1;
}
var bootloader;
function getBootloader() {
  return _getBootloader.apply(this, arguments);
}

function _getBootloader() {
  _getBootloader = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee20() {
    return regeneratorRuntime.wrap(function _callee20$(_context20) {
      while (1) {
        switch (_context20.prev = _context20.next) {
          case 0:
            if (bootloader) {
              _context20.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context20.next = 7;
              break;
            }

            _context20.next = 4;
            return RNDeviceInfo.getBootloader();

          case 4:
            bootloader = _context20.sent;
            _context20.next = 8;
            break;

          case 7:
            bootloader = 'unknown';

          case 8:
            return _context20.abrupt("return", bootloader);

          case 9:
          case "end":
            return _context20.stop();
        }
      }
    }, _callee20);
  }));
  return _getBootloader.apply(this, arguments);
}

function getBootloaderSync() {
  if (!bootloader) {
    if (reactNative.Platform.OS === 'android') {
      bootloader = RNDeviceInfo.getBootloaderSync();
    } else {
      bootloader = 'unknown';
    }
  }

  return bootloader;
}
var device;
function getDevice() {
  return _getDevice.apply(this, arguments);
}

function _getDevice() {
  _getDevice = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee21() {
    return regeneratorRuntime.wrap(function _callee21$(_context21) {
      while (1) {
        switch (_context21.prev = _context21.next) {
          case 0:
            if (device) {
              _context21.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context21.next = 7;
              break;
            }

            _context21.next = 4;
            return RNDeviceInfo.getDevice();

          case 4:
            device = _context21.sent;
            _context21.next = 8;
            break;

          case 7:
            device = 'unknown';

          case 8:
            return _context21.abrupt("return", device);

          case 9:
          case "end":
            return _context21.stop();
        }
      }
    }, _callee21);
  }));
  return _getDevice.apply(this, arguments);
}

function getDeviceSync() {
  if (!device) {
    if (reactNative.Platform.OS === 'android') {
      device = RNDeviceInfo.getDeviceSync();
    } else {
      device = 'unknown';
    }
  }

  return device;
}
var display;
function getDisplay() {
  return _getDisplay.apply(this, arguments);
}

function _getDisplay() {
  _getDisplay = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee22() {
    return regeneratorRuntime.wrap(function _callee22$(_context22) {
      while (1) {
        switch (_context22.prev = _context22.next) {
          case 0:
            if (display) {
              _context22.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context22.next = 7;
              break;
            }

            _context22.next = 4;
            return RNDeviceInfo.getDisplay();

          case 4:
            display = _context22.sent;
            _context22.next = 8;
            break;

          case 7:
            display = 'unknown';

          case 8:
            return _context22.abrupt("return", display);

          case 9:
          case "end":
            return _context22.stop();
        }
      }
    }, _callee22);
  }));
  return _getDisplay.apply(this, arguments);
}

function getDisplaySync() {
  if (!display) {
    if (reactNative.Platform.OS === 'android') {
      display = RNDeviceInfo.getDisplaySync();
    } else {
      display = 'unknown';
    }
  }

  return display;
}
var fingerprint;
function getFingerprint() {
  return _getFingerprint.apply(this, arguments);
}

function _getFingerprint() {
  _getFingerprint = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee23() {
    return regeneratorRuntime.wrap(function _callee23$(_context23) {
      while (1) {
        switch (_context23.prev = _context23.next) {
          case 0:
            if (fingerprint) {
              _context23.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context23.next = 7;
              break;
            }

            _context23.next = 4;
            return RNDeviceInfo.getFingerprint();

          case 4:
            fingerprint = _context23.sent;
            _context23.next = 8;
            break;

          case 7:
            fingerprint = 'unknown';

          case 8:
            return _context23.abrupt("return", fingerprint);

          case 9:
          case "end":
            return _context23.stop();
        }
      }
    }, _callee23);
  }));
  return _getFingerprint.apply(this, arguments);
}

function getFingerprintSync() {
  if (!fingerprint) {
    if (reactNative.Platform.OS === 'android') {
      fingerprint = RNDeviceInfo.getFingerprintSync();
    } else {
      fingerprint = 'unknown';
    }
  }

  return fingerprint;
}
var hardware;
function getHardware() {
  return _getHardware.apply(this, arguments);
}

function _getHardware() {
  _getHardware = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee24() {
    return regeneratorRuntime.wrap(function _callee24$(_context24) {
      while (1) {
        switch (_context24.prev = _context24.next) {
          case 0:
            if (hardware) {
              _context24.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context24.next = 7;
              break;
            }

            _context24.next = 4;
            return RNDeviceInfo.getHardware();

          case 4:
            hardware = _context24.sent;
            _context24.next = 8;
            break;

          case 7:
            hardware = 'unknown';

          case 8:
            return _context24.abrupt("return", hardware);

          case 9:
          case "end":
            return _context24.stop();
        }
      }
    }, _callee24);
  }));
  return _getHardware.apply(this, arguments);
}

function getHardwareSync() {
  if (!hardware) {
    if (reactNative.Platform.OS === 'android') {
      hardware = RNDeviceInfo.getHardwareSync();
    } else {
      hardware = 'unknown';
    }
  }

  return hardware;
}
var host;
function getHost() {
  return _getHost.apply(this, arguments);
}

function _getHost() {
  _getHost = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee25() {
    return regeneratorRuntime.wrap(function _callee25$(_context25) {
      while (1) {
        switch (_context25.prev = _context25.next) {
          case 0:
            if (host) {
              _context25.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context25.next = 7;
              break;
            }

            _context25.next = 4;
            return RNDeviceInfo.getHost();

          case 4:
            host = _context25.sent;
            _context25.next = 8;
            break;

          case 7:
            host = 'unknown';

          case 8:
            return _context25.abrupt("return", host);

          case 9:
          case "end":
            return _context25.stop();
        }
      }
    }, _callee25);
  }));
  return _getHost.apply(this, arguments);
}

function getHostSync() {
  if (!host) {
    if (reactNative.Platform.OS === 'android') {
      host = RNDeviceInfo.getHostSync();
    } else {
      host = 'unknown';
    }
  }

  return host;
}
var product;
function getProduct() {
  return _getProduct.apply(this, arguments);
}

function _getProduct() {
  _getProduct = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee26() {
    return regeneratorRuntime.wrap(function _callee26$(_context26) {
      while (1) {
        switch (_context26.prev = _context26.next) {
          case 0:
            if (product) {
              _context26.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context26.next = 7;
              break;
            }

            _context26.next = 4;
            return RNDeviceInfo.getProduct();

          case 4:
            product = _context26.sent;
            _context26.next = 8;
            break;

          case 7:
            product = 'unknown';

          case 8:
            return _context26.abrupt("return", product);

          case 9:
          case "end":
            return _context26.stop();
        }
      }
    }, _callee26);
  }));
  return _getProduct.apply(this, arguments);
}

function getProductSync() {
  if (!product) {
    if (reactNative.Platform.OS === 'android') {
      product = RNDeviceInfo.getProductSync();
    } else {
      product = 'unknown';
    }
  }

  return product;
}
var tags;
function getTags() {
  return _getTags.apply(this, arguments);
}

function _getTags() {
  _getTags = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee27() {
    return regeneratorRuntime.wrap(function _callee27$(_context27) {
      while (1) {
        switch (_context27.prev = _context27.next) {
          case 0:
            if (tags) {
              _context27.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context27.next = 7;
              break;
            }

            _context27.next = 4;
            return RNDeviceInfo.getTags();

          case 4:
            tags = _context27.sent;
            _context27.next = 8;
            break;

          case 7:
            tags = 'unknown';

          case 8:
            return _context27.abrupt("return", tags);

          case 9:
          case "end":
            return _context27.stop();
        }
      }
    }, _callee27);
  }));
  return _getTags.apply(this, arguments);
}

function getTagsSync() {
  if (!tags) {
    if (reactNative.Platform.OS === 'android') {
      tags = RNDeviceInfo.getTagsSync();
    } else {
      tags = 'unknown';
    }
  }

  return tags;
}
var type;
function getType() {
  return _getType.apply(this, arguments);
}

function _getType() {
  _getType = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee28() {
    return regeneratorRuntime.wrap(function _callee28$(_context28) {
      while (1) {
        switch (_context28.prev = _context28.next) {
          case 0:
            if (type) {
              _context28.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context28.next = 7;
              break;
            }

            _context28.next = 4;
            return RNDeviceInfo.getType();

          case 4:
            type = _context28.sent;
            _context28.next = 8;
            break;

          case 7:
            type = 'unknown';

          case 8:
            return _context28.abrupt("return", type);

          case 9:
          case "end":
            return _context28.stop();
        }
      }
    }, _callee28);
  }));
  return _getType.apply(this, arguments);
}

function getTypeSync() {
  if (!type) {
    if (reactNative.Platform.OS === 'android') {
      type = RNDeviceInfo.getTypeSync();
    } else {
      type = 'unknown';
    }
  }

  return type;
}
var baseOs;
function getBaseOs() {
  return _getBaseOs.apply(this, arguments);
}

function _getBaseOs() {
  _getBaseOs = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee29() {
    return regeneratorRuntime.wrap(function _callee29$(_context29) {
      while (1) {
        switch (_context29.prev = _context29.next) {
          case 0:
            if (baseOs) {
              _context29.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web')) {
              _context29.next = 7;
              break;
            }

            _context29.next = 4;
            return RNDeviceInfo.getBaseOs();

          case 4:
            baseOs = _context29.sent;
            _context29.next = 8;
            break;

          case 7:
            baseOs = 'unknown';

          case 8:
            return _context29.abrupt("return", baseOs);

          case 9:
          case "end":
            return _context29.stop();
        }
      }
    }, _callee29);
  }));
  return _getBaseOs.apply(this, arguments);
}

function getBaseOsSync() {
  if (!baseOs) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web') {
      baseOs = RNDeviceInfo.getBaseOsSync();
    } else {
      baseOs = 'unknown';
    }
  }

  return baseOs;
}
var previewSdkInt;
function getPreviewSdkInt() {
  return _getPreviewSdkInt.apply(this, arguments);
}

function _getPreviewSdkInt() {
  _getPreviewSdkInt = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee30() {
    return regeneratorRuntime.wrap(function _callee30$(_context30) {
      while (1) {
        switch (_context30.prev = _context30.next) {
          case 0:
            if (previewSdkInt) {
              _context30.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context30.next = 7;
              break;
            }

            _context30.next = 4;
            return RNDeviceInfo.getPreviewSdkInt();

          case 4:
            previewSdkInt = _context30.sent;
            _context30.next = 8;
            break;

          case 7:
            previewSdkInt = -1;

          case 8:
            return _context30.abrupt("return", previewSdkInt);

          case 9:
          case "end":
            return _context30.stop();
        }
      }
    }, _callee30);
  }));
  return _getPreviewSdkInt.apply(this, arguments);
}

function getPreviewSdkIntSync() {
  if (!previewSdkInt) {
    if (reactNative.Platform.OS === 'android') {
      previewSdkInt = RNDeviceInfo.getPreviewSdkIntSync();
    } else {
      previewSdkInt = -1;
    }
  }

  return previewSdkInt;
}
var securityPatch;
function getSecurityPatch() {
  return _getSecurityPatch.apply(this, arguments);
}

function _getSecurityPatch() {
  _getSecurityPatch = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee31() {
    return regeneratorRuntime.wrap(function _callee31$(_context31) {
      while (1) {
        switch (_context31.prev = _context31.next) {
          case 0:
            if (securityPatch) {
              _context31.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context31.next = 7;
              break;
            }

            _context31.next = 4;
            return RNDeviceInfo.getSecurityPatch();

          case 4:
            securityPatch = _context31.sent;
            _context31.next = 8;
            break;

          case 7:
            securityPatch = 'unknown';

          case 8:
            return _context31.abrupt("return", securityPatch);

          case 9:
          case "end":
            return _context31.stop();
        }
      }
    }, _callee31);
  }));
  return _getSecurityPatch.apply(this, arguments);
}

function getSecurityPatchSync() {
  if (!securityPatch) {
    if (reactNative.Platform.OS === 'android') {
      securityPatch = RNDeviceInfo.getSecurityPatchSync();
    } else {
      securityPatch = 'unknown';
    }
  }

  return securityPatch;
}
var codeName;
function getCodename() {
  return _getCodename.apply(this, arguments);
}

function _getCodename() {
  _getCodename = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee32() {
    return regeneratorRuntime.wrap(function _callee32$(_context32) {
      while (1) {
        switch (_context32.prev = _context32.next) {
          case 0:
            if (codeName) {
              _context32.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context32.next = 7;
              break;
            }

            _context32.next = 4;
            return RNDeviceInfo.getCodename();

          case 4:
            codeName = _context32.sent;
            _context32.next = 8;
            break;

          case 7:
            codeName = 'unknown';

          case 8:
            return _context32.abrupt("return", codeName);

          case 9:
          case "end":
            return _context32.stop();
        }
      }
    }, _callee32);
  }));
  return _getCodename.apply(this, arguments);
}

function getCodenameSync() {
  if (!codeName) {
    if (reactNative.Platform.OS === 'android') {
      codeName = RNDeviceInfo.getCodenameSync();
    } else {
      codeName = 'unknown';
    }
  }

  return codeName;
}
var incremental;
function getIncremental() {
  return _getIncremental.apply(this, arguments);
}

function _getIncremental() {
  _getIncremental = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee33() {
    return regeneratorRuntime.wrap(function _callee33$(_context33) {
      while (1) {
        switch (_context33.prev = _context33.next) {
          case 0:
            if (incremental) {
              _context33.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context33.next = 7;
              break;
            }

            _context33.next = 4;
            return RNDeviceInfo.getIncremental();

          case 4:
            incremental = _context33.sent;
            _context33.next = 8;
            break;

          case 7:
            incremental = 'unknown';

          case 8:
            return _context33.abrupt("return", incremental);

          case 9:
          case "end":
            return _context33.stop();
        }
      }
    }, _callee33);
  }));
  return _getIncremental.apply(this, arguments);
}

function getIncrementalSync() {
  if (!incremental) {
    if (reactNative.Platform.OS === 'android') {
      incremental = RNDeviceInfo.getIncrementalSync();
    } else {
      incremental = 'unknown';
    }
  }

  return incremental;
}
var emulator;
function isEmulator() {
  return _isEmulator.apply(this, arguments);
}

function _isEmulator() {
  _isEmulator = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee34() {
    return regeneratorRuntime.wrap(function _callee34$(_context34) {
      while (1) {
        switch (_context34.prev = _context34.next) {
          case 0:
            if (!(emulator === undefined)) {
              _context34.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context34.next = 7;
              break;
            }

            _context34.next = 4;
            return RNDeviceInfo.isEmulator();

          case 4:
            emulator = _context34.sent;
            _context34.next = 8;
            break;

          case 7:
            emulator = false;

          case 8:
            return _context34.abrupt("return", emulator);

          case 9:
          case "end":
            return _context34.stop();
        }
      }
    }, _callee34);
  }));
  return _isEmulator.apply(this, arguments);
}

function isEmulatorSync() {
  if (emulator === undefined) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      emulator = RNDeviceInfo.isEmulatorSync();
    } else {
      emulator = false;
    }
  }

  return emulator;
}
var tablet;
function isTablet() {
  if (tablet === undefined) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
      tablet = RNDeviceInfo.isTablet;
    } else {
      tablet = false;
    }
  }

  return tablet;
}
function isPinOrFingerprintSet() {
  return _isPinOrFingerprintSet.apply(this, arguments);
}

function _isPinOrFingerprintSet() {
  _isPinOrFingerprintSet = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee35() {
    return regeneratorRuntime.wrap(function _callee35$(_context35) {
      while (1) {
        switch (_context35.prev = _context35.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows')) {
              _context35.next = 2;
              break;
            }

            return _context35.abrupt("return", RNDeviceInfo.isPinOrFingerprintSet());

          case 2:
            return _context35.abrupt("return", false);

          case 3:
          case "end":
            return _context35.stop();
        }
      }
    }, _callee35);
  }));
  return _isPinOrFingerprintSet.apply(this, arguments);
}

function isPinOrFingerprintSetSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows') {
    return RNDeviceInfo.isPinOrFingerprintSetSync();
  }

  return false;
}
var notch;
function hasNotch() {
  if (notch === undefined) {
    var _brand = getBrand();

    var _model = getModel();

    notch = devicesWithNotch.findIndex(function (item) {
      return item.brand.toLowerCase() === _brand.toLowerCase() && item.model.toLowerCase() === _model.toLowerCase();
    }) !== -1;
  }

  return notch;
}
var firstInstallTime;
function getFirstInstallTime() {
  return _getFirstInstallTime.apply(this, arguments);
}

function _getFirstInstallTime() {
  _getFirstInstallTime = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee36() {
    return regeneratorRuntime.wrap(function _callee36$(_context36) {
      while (1) {
        switch (_context36.prev = _context36.next) {
          case 0:
            if (firstInstallTime) {
              _context36.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows')) {
              _context36.next = 7;
              break;
            }

            _context36.next = 4;
            return RNDeviceInfo.getFirstInstallTime();

          case 4:
            firstInstallTime = _context36.sent;
            _context36.next = 8;
            break;

          case 7:
            firstInstallTime = -1;

          case 8:
            return _context36.abrupt("return", firstInstallTime);

          case 9:
          case "end":
            return _context36.stop();
        }
      }
    }, _callee36);
  }));
  return _getFirstInstallTime.apply(this, arguments);
}

function getFirstInstallTimeSync() {
  if (!firstInstallTime) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows') {
      firstInstallTime = RNDeviceInfo.getFirstInstallTimeSync();
    } else {
      firstInstallTime = -1;
    }
  }

  return firstInstallTime;
}
var installReferrer;
function getInstallReferrer() {
  return _getInstallReferrer.apply(this, arguments);
}

function _getInstallReferrer() {
  _getInstallReferrer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee37() {
    return regeneratorRuntime.wrap(function _callee37$(_context37) {
      while (1) {
        switch (_context37.prev = _context37.next) {
          case 0:
            if (installReferrer) {
              _context37.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web')) {
              _context37.next = 7;
              break;
            }

            _context37.next = 4;
            return RNDeviceInfo.getInstallReferrer();

          case 4:
            installReferrer = _context37.sent;
            _context37.next = 8;
            break;

          case 7:
            installReferrer = 'unknown';

          case 8:
            return _context37.abrupt("return", installReferrer);

          case 9:
          case "end":
            return _context37.stop();
        }
      }
    }, _callee37);
  }));
  return _getInstallReferrer.apply(this, arguments);
}

function getInstallReferrerSync() {
  if (!installReferrer) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web') {
      installReferrer = RNDeviceInfo.getInstallReferrerSync();
    } else {
      installReferrer = 'unknown';
    }
  }

  return installReferrer;
}
var lastUpdateTime;
function getLastUpdateTime() {
  return _getLastUpdateTime.apply(this, arguments);
}

function _getLastUpdateTime() {
  _getLastUpdateTime = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee38() {
    return regeneratorRuntime.wrap(function _callee38$(_context38) {
      while (1) {
        switch (_context38.prev = _context38.next) {
          case 0:
            if (lastUpdateTime) {
              _context38.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context38.next = 7;
              break;
            }

            _context38.next = 4;
            return RNDeviceInfo.getLastUpdateTime();

          case 4:
            lastUpdateTime = _context38.sent;
            _context38.next = 8;
            break;

          case 7:
            lastUpdateTime = -1;

          case 8:
            return _context38.abrupt("return", lastUpdateTime);

          case 9:
          case "end":
            return _context38.stop();
        }
      }
    }, _callee38);
  }));
  return _getLastUpdateTime.apply(this, arguments);
}

function getLastUpdateTimeSync() {
  if (!lastUpdateTime) {
    if (reactNative.Platform.OS === 'android') {
      lastUpdateTime = RNDeviceInfo.getLastUpdateTimeSync();
    } else {
      lastUpdateTime = -1;
    }
  }

  return lastUpdateTime;
}
function getPhoneNumber() {
  return _getPhoneNumber.apply(this, arguments);
}

function _getPhoneNumber() {
  _getPhoneNumber = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee39() {
    return regeneratorRuntime.wrap(function _callee39$(_context39) {
      while (1) {
        switch (_context39.prev = _context39.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android')) {
              _context39.next = 2;
              break;
            }

            return _context39.abrupt("return", RNDeviceInfo.getPhoneNumber());

          case 2:
            return _context39.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context39.stop();
        }
      }
    }, _callee39);
  }));
  return _getPhoneNumber.apply(this, arguments);
}

function getPhoneNumberSync() {
  if (reactNative.Platform.OS === 'android') {
    return RNDeviceInfo.getPhoneNumberSync();
  }

  return 'unknown';
}
function getCarrier() {
  return _getCarrier.apply(this, arguments);
}

function _getCarrier() {
  _getCarrier = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee40() {
    return regeneratorRuntime.wrap(function _callee40$(_context40) {
      while (1) {
        switch (_context40.prev = _context40.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context40.next = 2;
              break;
            }

            return _context40.abrupt("return", RNDeviceInfo.getCarrier());

          case 2:
            return _context40.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context40.stop();
        }
      }
    }, _callee40);
  }));
  return _getCarrier.apply(this, arguments);
}

function getCarrierSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.getCarrierSync();
  }

  return 'unknown';
}
var totalMemory;
function getTotalMemory() {
  return _getTotalMemory.apply(this, arguments);
}

function _getTotalMemory() {
  _getTotalMemory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee41() {
    return regeneratorRuntime.wrap(function _callee41$(_context41) {
      while (1) {
        switch (_context41.prev = _context41.next) {
          case 0:
            if (totalMemory) {
              _context41.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web')) {
              _context41.next = 7;
              break;
            }

            _context41.next = 4;
            return RNDeviceInfo.getTotalMemory();

          case 4:
            totalMemory = _context41.sent;
            _context41.next = 8;
            break;

          case 7:
            totalMemory = -1;

          case 8:
            return _context41.abrupt("return", totalMemory);

          case 9:
          case "end":
            return _context41.stop();
        }
      }
    }, _callee41);
  }));
  return _getTotalMemory.apply(this, arguments);
}

function getTotalMemorySync() {
  if (!totalMemory) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web') {
      totalMemory = RNDeviceInfo.getTotalMemorySync();
    } else {
      totalMemory = -1;
    }
  }

  return totalMemory;
}
var maxMemory;
function getMaxMemory() {
  return _getMaxMemory.apply(this, arguments);
}

function _getMaxMemory() {
  _getMaxMemory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee42() {
    return regeneratorRuntime.wrap(function _callee42$(_context42) {
      while (1) {
        switch (_context42.prev = _context42.next) {
          case 0:
            if (maxMemory) {
              _context42.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web')) {
              _context42.next = 7;
              break;
            }

            _context42.next = 4;
            return RNDeviceInfo.getMaxMemory();

          case 4:
            maxMemory = _context42.sent;
            _context42.next = 8;
            break;

          case 7:
            maxMemory = -1;

          case 8:
            return _context42.abrupt("return", maxMemory);

          case 9:
          case "end":
            return _context42.stop();
        }
      }
    }, _callee42);
  }));
  return _getMaxMemory.apply(this, arguments);
}

function getMaxMemorySync() {
  if (!maxMemory) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web') {
      maxMemory = RNDeviceInfo.getMaxMemorySync();
    } else {
      maxMemory = -1;
    }
  }

  return maxMemory;
}
function getTotalDiskCapacity() {
  return _getTotalDiskCapacity.apply(this, arguments);
}

function _getTotalDiskCapacity() {
  _getTotalDiskCapacity = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee43() {
    return regeneratorRuntime.wrap(function _callee43$(_context43) {
      while (1) {
        switch (_context43.prev = _context43.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context43.next = 2;
              break;
            }

            return _context43.abrupt("return", RNDeviceInfo.getTotalDiskCapacity());

          case 2:
            return _context43.abrupt("return", -1);

          case 3:
          case "end":
            return _context43.stop();
        }
      }
    }, _callee43);
  }));
  return _getTotalDiskCapacity.apply(this, arguments);
}

function getTotalDiskCapacitySync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.getTotalDiskCapacitySync();
  }

  return -1;
}
function getFreeDiskStorage() {
  return _getFreeDiskStorage.apply(this, arguments);
}

function _getFreeDiskStorage() {
  _getFreeDiskStorage = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee44() {
    return regeneratorRuntime.wrap(function _callee44$(_context44) {
      while (1) {
        switch (_context44.prev = _context44.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context44.next = 2;
              break;
            }

            return _context44.abrupt("return", RNDeviceInfo.getFreeDiskStorage());

          case 2:
            return _context44.abrupt("return", -1);

          case 3:
          case "end":
            return _context44.stop();
        }
      }
    }, _callee44);
  }));
  return _getFreeDiskStorage.apply(this, arguments);
}

function getFreeDiskStorageSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.getFreeDiskStorageSync();
  }

  return -1;
}
function getBatteryLevel() {
  return _getBatteryLevel.apply(this, arguments);
}

function _getBatteryLevel() {
  _getBatteryLevel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee45() {
    return regeneratorRuntime.wrap(function _callee45$(_context45) {
      while (1) {
        switch (_context45.prev = _context45.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web')) {
              _context45.next = 2;
              break;
            }

            return _context45.abrupt("return", RNDeviceInfo.getBatteryLevel());

          case 2:
            return _context45.abrupt("return", -1);

          case 3:
          case "end":
            return _context45.stop();
        }
      }
    }, _callee45);
  }));
  return _getBatteryLevel.apply(this, arguments);
}

function getBatteryLevelSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'windows' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.getBatteryLevelSync();
  }

  return -1;
}
function getPowerState() {
  return _getPowerState.apply(this, arguments);
}

function _getPowerState() {
  _getPowerState = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee46() {
    return regeneratorRuntime.wrap(function _callee46$(_context46) {
      while (1) {
        switch (_context46.prev = _context46.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web')) {
              _context46.next = 2;
              break;
            }

            return _context46.abrupt("return", RNDeviceInfo.getPowerState());

          case 2:
            return _context46.abrupt("return", {});

          case 3:
          case "end":
            return _context46.stop();
        }
      }
    }, _callee46);
  }));
  return _getPowerState.apply(this, arguments);
}

function getPowerStateSync() {
  if (reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.getPowerStateSync();
  }

  return {};
}
function isBatteryCharging() {
  return _isBatteryCharging.apply(this, arguments);
}

function _isBatteryCharging() {
  _isBatteryCharging = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee47() {
    return regeneratorRuntime.wrap(function _callee47$(_context47) {
      while (1) {
        switch (_context47.prev = _context47.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context47.next = 2;
              break;
            }

            return _context47.abrupt("return", RNDeviceInfo.isBatteryCharging());

          case 2:
            return _context47.abrupt("return", false);

          case 3:
          case "end":
            return _context47.stop();
        }
      }
    }, _callee47);
  }));
  return _isBatteryCharging.apply(this, arguments);
}

function isBatteryChargingSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.isBatteryChargingSync();
  }

  return false;
}
function isLandscape() {
  return _isLandscape.apply(this, arguments);
}

function _isLandscape() {
  _isLandscape = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee48() {
    return regeneratorRuntime.wrap(function _callee48$(_context48) {
      while (1) {
        switch (_context48.prev = _context48.next) {
          case 0:
            return _context48.abrupt("return", Promise.resolve(isLandscapeSync()));

          case 1:
          case "end":
            return _context48.stop();
        }
      }
    }, _callee48);
  }));
  return _isLandscape.apply(this, arguments);
}

function isLandscapeSync() {
  var _Dimensions$get = reactNative.Dimensions.get('window'),
      height = _Dimensions$get.height,
      width = _Dimensions$get.width;

  return width >= height;
}
function isAirplaneMode() {
  return _isAirplaneMode.apply(this, arguments);
}

function _isAirplaneMode() {
  _isAirplaneMode = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee49() {
    return regeneratorRuntime.wrap(function _callee49$(_context49) {
      while (1) {
        switch (_context49.prev = _context49.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web')) {
              _context49.next = 2;
              break;
            }

            return _context49.abrupt("return", RNDeviceInfo.isAirplaneMode());

          case 2:
            return _context49.abrupt("return", Promise.resolve(false));

          case 3:
          case "end":
            return _context49.stop();
        }
      }
    }, _callee49);
  }));
  return _isAirplaneMode.apply(this, arguments);
}

function isAirplaneModeSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.isAirplaneModeSync();
  }

  return false;
}
var deviceType;
function getDeviceType() {
  if (!deviceType) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
      deviceType = RNDeviceInfo.deviceType;
    } else {
      deviceType = 'unknown';
    }
  }

  return deviceType;
}

var _supportedAbis;

function supportedAbis() {
  return _supportedAbis2.apply(this, arguments);
}

function _supportedAbis2() {
  _supportedAbis2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee50() {
    return regeneratorRuntime.wrap(function _callee50$(_context50) {
      while (1) {
        switch (_context50.prev = _context50.next) {
          case 0:
            if (_supportedAbis) {
              _context50.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context50.next = 7;
              break;
            }

            _context50.next = 4;
            return RNDeviceInfo.getSupportedAbis();

          case 4:
            _supportedAbis = _context50.sent;
            _context50.next = 8;
            break;

          case 7:
            _supportedAbis = [];

          case 8:
            return _context50.abrupt("return", _supportedAbis);

          case 9:
          case "end":
            return _context50.stop();
        }
      }
    }, _callee50);
  }));
  return _supportedAbis2.apply(this, arguments);
}

function supportedAbisSync() {
  if (!_supportedAbis) {
    if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
      _supportedAbis = RNDeviceInfo.getSupportedAbisSync();
    } else {
      _supportedAbis = [];
    }
  }

  return _supportedAbis;
}

var _supported32BitAbis;

function supported32BitAbis() {
  return _supported32BitAbis2.apply(this, arguments);
}

function _supported32BitAbis2() {
  _supported32BitAbis2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee51() {
    return regeneratorRuntime.wrap(function _callee51$(_context51) {
      while (1) {
        switch (_context51.prev = _context51.next) {
          case 0:
            if (_supported32BitAbis) {
              _context51.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context51.next = 7;
              break;
            }

            _context51.next = 4;
            return RNDeviceInfo.getSupported32BitAbis();

          case 4:
            _supported32BitAbis = _context51.sent;
            _context51.next = 8;
            break;

          case 7:
            _supported32BitAbis = [];

          case 8:
            return _context51.abrupt("return", _supported32BitAbis);

          case 9:
          case "end":
            return _context51.stop();
        }
      }
    }, _callee51);
  }));
  return _supported32BitAbis2.apply(this, arguments);
}

function supported32BitAbisSync() {
  if (!_supported32BitAbis) {
    if (reactNative.Platform.OS === 'android') {
      _supported32BitAbis = RNDeviceInfo.getSupported32BitAbisSync();
    } else {
      _supported32BitAbis = [];
    }
  }

  return _supported32BitAbis;
}

var _supported64BitAbis;

function supported64BitAbis() {
  return _supported64BitAbis2.apply(this, arguments);
}

function _supported64BitAbis2() {
  _supported64BitAbis2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee52() {
    return regeneratorRuntime.wrap(function _callee52$(_context52) {
      while (1) {
        switch (_context52.prev = _context52.next) {
          case 0:
            if (_supported64BitAbis) {
              _context52.next = 8;
              break;
            }

            if (!(reactNative.Platform.OS === 'android')) {
              _context52.next = 7;
              break;
            }

            _context52.next = 4;
            return RNDeviceInfo.getSupported64BitAbis();

          case 4:
            _supported64BitAbis = _context52.sent;
            _context52.next = 8;
            break;

          case 7:
            _supported64BitAbis = [];

          case 8:
            return _context52.abrupt("return", _supported64BitAbis);

          case 9:
          case "end":
            return _context52.stop();
        }
      }
    }, _callee52);
  }));
  return _supported64BitAbis2.apply(this, arguments);
}

function supported64BitAbisSync() {
  if (!_supported64BitAbis) {
    if (reactNative.Platform.OS === 'android') {
      _supported64BitAbis = RNDeviceInfo.getSupported64BitAbisSync();
    } else {
      _supported64BitAbis = [];
    }
  }

  return _supported64BitAbis;
}
function hasSystemFeature(_x) {
  return _hasSystemFeature.apply(this, arguments);
}

function _hasSystemFeature() {
  _hasSystemFeature = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee53(feature) {
    return regeneratorRuntime.wrap(function _callee53$(_context53) {
      while (1) {
        switch (_context53.prev = _context53.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android')) {
              _context53.next = 2;
              break;
            }

            return _context53.abrupt("return", RNDeviceInfo.hasSystemFeature(feature));

          case 2:
            return _context53.abrupt("return", false);

          case 3:
          case "end":
            return _context53.stop();
        }
      }
    }, _callee53);
  }));
  return _hasSystemFeature.apply(this, arguments);
}

function hasSystemFeatureSync(feature) {
  if (reactNative.Platform.OS === 'android') {
    return RNDeviceInfo.hasSystemFeatureSync(feature);
  }

  return false;
}
function getSystemAvailableFeatures() {
  return _getSystemAvailableFeatures.apply(this, arguments);
}

function _getSystemAvailableFeatures() {
  _getSystemAvailableFeatures = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee54() {
    return regeneratorRuntime.wrap(function _callee54$(_context54) {
      while (1) {
        switch (_context54.prev = _context54.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android')) {
              _context54.next = 2;
              break;
            }

            return _context54.abrupt("return", RNDeviceInfo.getSystemAvailableFeatures());

          case 2:
            return _context54.abrupt("return", []);

          case 3:
          case "end":
            return _context54.stop();
        }
      }
    }, _callee54);
  }));
  return _getSystemAvailableFeatures.apply(this, arguments);
}

function getSystemAvailableFeaturesSync() {
  if (reactNative.Platform.OS === 'android') {
    return RNDeviceInfo.getSystemAvailableFeaturesSync();
  }

  return [];
}
function isLocationEnabled() {
  return _isLocationEnabled.apply(this, arguments);
}

function _isLocationEnabled() {
  _isLocationEnabled = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee55() {
    return regeneratorRuntime.wrap(function _callee55$(_context55) {
      while (1) {
        switch (_context55.prev = _context55.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web')) {
              _context55.next = 2;
              break;
            }

            return _context55.abrupt("return", RNDeviceInfo.isLocationEnabled());

          case 2:
            return _context55.abrupt("return", false);

          case 3:
          case "end":
            return _context55.stop();
        }
      }
    }, _callee55);
  }));
  return _isLocationEnabled.apply(this, arguments);
}

function isLocationEnabledSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios' || reactNative.Platform.OS === 'web') {
    return RNDeviceInfo.isLocationEnabledSync();
  }

  return false;
}
function isHeadphonesConnected() {
  return _isHeadphonesConnected.apply(this, arguments);
}

function _isHeadphonesConnected() {
  _isHeadphonesConnected = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee56() {
    return regeneratorRuntime.wrap(function _callee56$(_context56) {
      while (1) {
        switch (_context56.prev = _context56.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context56.next = 2;
              break;
            }

            return _context56.abrupt("return", RNDeviceInfo.isHeadphonesConnected());

          case 2:
            return _context56.abrupt("return", false);

          case 3:
          case "end":
            return _context56.stop();
        }
      }
    }, _callee56);
  }));
  return _isHeadphonesConnected.apply(this, arguments);
}

function isHeadphonesConnectedSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.isHeadphonesConnectedSync();
  }

  return false;
}
function getAvailableLocationProviders() {
  return _getAvailableLocationProviders.apply(this, arguments);
}

function _getAvailableLocationProviders() {
  _getAvailableLocationProviders = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee57() {
    return regeneratorRuntime.wrap(function _callee57$(_context57) {
      while (1) {
        switch (_context57.prev = _context57.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context57.next = 2;
              break;
            }

            return _context57.abrupt("return", RNDeviceInfo.getAvailableLocationProviders());

          case 2:
            return _context57.abrupt("return", {});

          case 3:
          case "end":
            return _context57.stop();
        }
      }
    }, _callee57);
  }));
  return _getAvailableLocationProviders.apply(this, arguments);
}

function getAvailableLocationProvidersSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.getAvailableLocationProvidersSync();
  }

  return {};
}
function getDeviceToken() {
  return _getDeviceToken.apply(this, arguments);
}

function _getDeviceToken() {
  _getDeviceToken = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee58() {
    return regeneratorRuntime.wrap(function _callee58$(_context58) {
      while (1) {
        switch (_context58.prev = _context58.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'ios')) {
              _context58.next = 2;
              break;
            }

            return _context58.abrupt("return", RNDeviceInfo.getDeviceToken());

          case 2:
            return _context58.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context58.stop();
        }
      }
    }, _callee58);
  }));
  return _getDeviceToken.apply(this, arguments);
}

function getCurrentActivityNameSync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.getCurrentActivityNameSync();
  }

  return {};
}
function getCurrentActivityName() {
  return _getCurrentActivityName.apply(this, arguments);
}

function _getCurrentActivityName() {
  _getCurrentActivityName = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee59() {
    return regeneratorRuntime.wrap(function _callee59$(_context59) {
      while (1) {
        switch (_context59.prev = _context59.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context59.next = 2;
              break;
            }

            return _context59.abrupt("return", RNDeviceInfo.getCurrentActivityName());

          case 2:
            return _context59.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context59.stop();
        }
      }
    }, _callee59);
  }));
  return _getCurrentActivityName.apply(this, arguments);
}

function getUserCountrySync() {
  if (reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios') {
    return RNDeviceInfo.getUserCountrySync();
  }

  return {};
}
function getUserCountry() {
  return _getUserCountry.apply(this, arguments);
}

function _getUserCountry() {
  _getUserCountry = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee60() {
    return regeneratorRuntime.wrap(function _callee60$(_context60) {
      while (1) {
        switch (_context60.prev = _context60.next) {
          case 0:
            if (!(reactNative.Platform.OS === 'android' || reactNative.Platform.OS === 'ios')) {
              _context60.next = 2;
              break;
            }

            return _context60.abrupt("return", RNDeviceInfo.getUserCountry());

          case 2:
            return _context60.abrupt("return", 'unknown');

          case 3:
          case "end":
            return _context60.stop();
        }
      }
    }, _callee60);
  }));
  return _getUserCountry.apply(this, arguments);
}

var deviceInfoEmitter = new reactNative.NativeEventEmitter(reactNative.NativeModules.RNDeviceInfo);
function useBatteryLevel() {
  var _useState = React.useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      batteryLevel = _useState2[0],
      setBatteryLevel = _useState2[1];

  React.useEffect(function () {
    var setInitialValue = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var initialValue;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return getBatteryLevel();

              case 2:
                initialValue = _context.sent;
                setBatteryLevel(initialValue);

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function setInitialValue() {
        return _ref.apply(this, arguments);
      };
    }();

    var onChange = function onChange(level) {
      setBatteryLevel(level);
    };

    setInitialValue();
    var subscription = deviceInfoEmitter.addListener('RNDeviceInfo_batteryLevelDidChange', onChange);
    return function () {
      return subscription.remove();
    };
  }, []);
  return batteryLevel;
}
function useBatteryLevelIsLow() {
  var _useState3 = React.useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      batteryLevelIsLow = _useState4[0],
      setBatteryLevelIsLow = _useState4[1];

  React.useEffect(function () {
    var setInitialValue = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var initialValue;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return getBatteryLevel();

              case 2:
                initialValue = _context2.sent;
                setBatteryLevelIsLow(initialValue);

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function setInitialValue() {
        return _ref2.apply(this, arguments);
      };
    }();

    var onChange = function onChange(level) {
      setBatteryLevelIsLow(level);
    };

    setInitialValue();
    var subscription = deviceInfoEmitter.addListener('RNDeviceInfo_batteryLevelIsLow', onChange);
    return function () {
      return subscription.remove();
    };
  }, []);
  return batteryLevelIsLow;
} // export function usePowerState(): PowerState | {} {
var deviceInfoModule = {
  getAndroidId: getAndroidId,
  getAndroidIdSync: getAndroidIdSync,
  getApiLevel: getApiLevel,
  getApiLevelSync: getApiLevelSync,
  getApplicationName: getApplicationName,
  getAvailableLocationProviders: getAvailableLocationProviders,
  getAvailableLocationProvidersSync: getAvailableLocationProvidersSync,
  getBaseOs: getBaseOs,
  getBaseOsSync: getBaseOsSync,
  getBatteryLevel: getBatteryLevel,
  getBatteryLevelSync: getBatteryLevelSync,
  getBootloader: getBootloader,
  getBootloaderSync: getBootloaderSync,
  getBrand: getBrand,
  getBroadcast: getBroadcast,
  getBuildId: getBuildId,
  getBuildIdSync: getBuildIdSync,
  getBuildNumber: getBuildNumber,
  getBundleId: getBundleId,
  getCurrentActivityName: getCurrentActivityName,
  getCurrentActivityNameSync: getCurrentActivityNameSync,
  getCarrier: getCarrier,
  getCarrierSync: getCarrierSync,
  getCodename: getCodename,
  getCodenameSync: getCodenameSync,
  getDevice: getDevice,
  getDeviceId: getDeviceId,
  getDeviceName: getDeviceName,
  getDeviceNameSync: getDeviceNameSync,
  getDeviceSync: getDeviceSync,
  getDeviceToken: getDeviceToken,
  getDeviceType: getDeviceType,
  getDisplay: getDisplay,
  getDisplaySync: getDisplaySync,
  getFingerprint: getFingerprint,
  getFingerprintSync: getFingerprintSync,
  getFirstInstallTime: getFirstInstallTime,
  getFirstInstallTimeSync: getFirstInstallTimeSync,
  getFontScale: getFontScale,
  getFontScaleSync: getFontScaleSync,
  getFreeDiskStorage: getFreeDiskStorage,
  getFreeDiskStorageSync: getFreeDiskStorageSync,
  getFrequency: getFrequency,
  getHardware: getHardware,
  getHardwareSync: getHardwareSync,
  getHost: getHost,
  getHostSync: getHostSync,
  getIncremental: getIncremental,
  getIncrementalSync: getIncrementalSync,
  getInstallerPackageName: getInstallerPackageName,
  getInstallerPackageNameSync: getInstallerPackageNameSync,
  getInstallReferrer: getInstallReferrer,
  getInstallReferrerSync: getInstallReferrerSync,
  getInstanceId: getInstanceId,
  getInstanceIdSync: getInstanceIdSync,
  getIpAddress: getIpAddress,
  getIpAddressSync: getIpAddressSync,
  getLastUpdateTime: getLastUpdateTime,
  getLastUpdateTimeSync: getLastUpdateTimeSync,
  getMacAddress: getMacAddress,
  getMacAddressSync: getMacAddressSync,
  getManufacturer: getManufacturer,
  getManufacturerSync: getManufacturerSync,
  getMaxMemory: getMaxMemory,
  getMaxMemorySync: getMaxMemorySync,
  getModel: getModel,
  getPhoneNumber: getPhoneNumber,
  getPhoneNumberSync: getPhoneNumberSync,
  getPowerState: getPowerState,
  getPowerStateSync: getPowerStateSync,
  getPreviewSdkInt: getPreviewSdkInt,
  getPreviewSdkIntSync: getPreviewSdkIntSync,
  getProduct: getProduct,
  getProductSync: getProductSync,
  getReadableVersion: getReadableVersion,
  getSecurityPatch: getSecurityPatch,
  getSecurityPatchSync: getSecurityPatchSync,
  getSerialNumber: getSerialNumber,
  getSerialNumberSync: getSerialNumberSync,
  getSystemAvailableFeatures: getSystemAvailableFeatures,
  getSystemAvailableFeaturesSync: getSystemAvailableFeaturesSync,
  getSystemName: getSystemName,
  getSystemVersion: getSystemVersion,
  getTags: getTags,
  getTagsSync: getTagsSync,
  getTotalDiskCapacity: getTotalDiskCapacity,
  getTotalDiskCapacitySync: getTotalDiskCapacitySync,
  getTotalMemory: getTotalMemory,
  getTotalMemorySync: getTotalMemorySync,
  getType: getType,
  getTypeSync: getTypeSync,
  getUniqueId: getUniqueId,
  getUsedMemory: getUsedMemory,
  getUsedMemorySync: getUsedMemorySync,
  getUserAgent: getUserAgent,
  getUserAgentSync: getUserAgentSync,
  getUserCountry: getUserCountry,
  getUserCountrySync: getUserCountrySync,
  getVersion: getVersion,
  hasNotch: hasNotch,
  hasSystemFeature: hasSystemFeature,
  hasSystemFeatureSync: hasSystemFeatureSync,
  isAirplaneMode: isAirplaneMode,
  isAirplaneModeSync: isAirplaneModeSync,
  isBatteryCharging: isBatteryCharging,
  isBatteryChargingSync: isBatteryChargingSync,
  isCameraPresent: isCameraPresent,
  isCameraPresentSync: isCameraPresentSync,
  isEmulator: isEmulator,
  isEmulatorSync: isEmulatorSync,
  isHeadphonesConnected: isHeadphonesConnected,
  isHeadphonesConnectedSync: isHeadphonesConnectedSync,
  isLandscape: isLandscape,
  isLandscapeSync: isLandscapeSync,
  isLocationEnabled: isLocationEnabled,
  isLocationEnabledSync: isLocationEnabledSync,
  isPinOrFingerprintSet: isPinOrFingerprintSet,
  isPinOrFingerprintSetSync: isPinOrFingerprintSetSync,
  isTablet: isTablet,
  supported32BitAbis: supported32BitAbis,
  supported32BitAbisSync: supported32BitAbisSync,
  supported64BitAbis: supported64BitAbis,
  supported64BitAbisSync: supported64BitAbisSync,
  supportedAbis: supportedAbis,
  supportedAbisSync: supportedAbisSync,
  syncUniqueId: syncUniqueId,
  useBatteryLevel: useBatteryLevel,
  useBatteryLevelIsLow: useBatteryLevelIsLow // useDeviceName,
  // useFirstInstallTime,
  // useHasSystemFeature,
  // useIsEmulator,
  // usePowerState,

};

var corePlugins = [image(), logger(), benchmark(), stateResponses(), apiResponse(), clear(), repl()];
var DEFAULT_OPTIONS = {
  appToken: "",
  createSocket: null,
  host: "1.1.1.1",
  port: 0,
  loggingEnabled: true,
  logLevel: 1,
  name: "@eginnovations/react-native-eg-agent",
  secure: false,
  plugins: corePlugins,
  safeRecursion: true,
  onCommand: function onCommand() {
    return null;
  },
  onConnect: function onConnect() {
    return null;
  },
  onDisconnect: function onDisconnect() {
    return null;
  }
}; // these are not for you.

var reservedFeatures = ["options", "connected", "socket", "plugins", "configure", "connect", "send", "use", "startTimer", "setUserName", "setAttribute"];

var isReservedFeature = function isReservedFeature(value) {
  return reservedFeatures.some(function (res) {
    return res === value;
  });
};

var ArgType;

(function (ArgType) {
  ArgType["String"] = "string";
})(ArgType || (ArgType = {}));

var eGImpl = /*#__PURE__*/function () {
  function eGImpl() {
    var _this = this;

    _classCallCheck(this, eGImpl);

    _defineProperty(this, "options", Object.assign({}, DEFAULT_OPTIONS));

    _defineProperty(this, "connected", false);

    _defineProperty(this, "socket", null);

    _defineProperty(this, "plugins", []);

    _defineProperty(this, "sendQueue", []);

    _defineProperty(this, "isReady", false);

    _defineProperty(this, "lastMessageDate", new Date());

    _defineProperty(this, "customCommands", []);

    _defineProperty(this, "customCommandLatestId", 1);

    _defineProperty(this, "startTimer", function () {
      return start();
    });

    _defineProperty(this, "host", void 0);

    _defineProperty(this, "deviceInfo", void 0);

    _defineProperty(this, "appData", void 0);

    _defineProperty(this, "resourceData", void 0);

    _defineProperty(this, "userData", void 0);

    _defineProperty(this, "send", function (type, data) {
      // set the timing info
      console.log("send called to agent url..." + _this.host);
      var date = new Date();

      var deltaTime = date.getTime() - _this.lastMessageDate.getTime(); // glitches in the matrix


      if (deltaTime < 0) {
        deltaTime = 0;
      }

      _this.lastMessageDate = date;
      var appToken = _this.options.appToken;
      var instrumentationType = type;
      var appName = deviceInfoModule.getApplicationName();
      var activityName = deviceInfoModule.getCurrentActivityNameSync();
      var osName = deviceInfoModule.getBaseOsSync();
      var osVersion = deviceInfoModule.getSystemVersion();
      var deviceName = deviceInfoModule.getDeviceNameSync(); // this.deviceInfo = NativeModules.eGAgent.getDevInfo();
      // this.appData =NativeModules.eGAgent.getAppinfo();
      // this.resourceData = NativeModules.eGAgent.getResInfo();

      var deviceInformation = JSON.parse(_this.deviceInfo);
      var applicationInformation = JSON.parse(_this.appData);
      var resourceInformation = JSON.parse(_this.resourceData);
      var userInformation = JSON.parse(_this.userData);
      var executionTime = deltaTime;
      var country = deviceInfoModule.getUserCountrySync();
      var fullMessage = {};
      console.log("send called type..." + type);

      if (type == 'HTTP') {
        var httpInformation = data;
        fullMessage = {
          appName: appName,
          instrumentationType: instrumentationType,
          appToken: appToken,
          activityName: activityName,
          osName: osName,
          osVersion: osVersion,
          deviceName: deviceName,
          deviceInformation: deviceInformation,
          applicationInformation: applicationInformation,
          resourceInformation: resourceInformation,
          httpInformation: httpInformation,
          userInformation: userInformation,
          executionTime: executionTime,
          country: country
        };
      } else if (type == 'Page') {
        var pageInformation = data;
        fullMessage = {
          appName: appName,
          instrumentationType: instrumentationType,
          appToken: appToken,
          activityName: activityName,
          osName: osName,
          osVersion: osVersion,
          deviceName: deviceName,
          deviceInformation: deviceInformation,
          applicationInformation: applicationInformation,
          resourceInformation: resourceInformation,
          pageInformation: pageInformation,
          userInformation: userInformation,
          executionTime: executionTime,
          country: country
        };
      } else if (type == 'JSError') {
        var _message = data;
        console.log("sending serialized message .." + _message);
        fullMessage = {
          appName: appName,
          instrumentationType: instrumentationType,
          activityName: activityName,
          deviceName: deviceName,
          osName: osName,
          osVersion: osVersion,
          appToken: appToken,
          deviceInformation: deviceInformation,
          applicationInformation: applicationInformation,
          resourceInformation: resourceInformation,
          userInformation: userInformation,
          errordetails: _message,
          executionTime: executionTime,
          country: country
        };
      }

      console.log("sending serialized data .." + serialize(data, _this.options.proxyHack));
      console.log('url in send is.... ' + _this.host);
      var serializedMessage = serialize(fullMessage, _this.options.proxyHack);
      console.log("sending serializedMessage.." + serializedMessage);
      console.log("this.isready .. " + _this.isReady);

      if (_this.isReady) {
        // send this command
        try {
          send(serializedMessage, _this.host);

          while (_this.sendQueue.length > 0) {
            var h = _this.sendQueue[0];
            _this.sendQueue = _this.sendQueue.slice(1);
            send(h, _this.host);
          }
        } catch (e) {
          _this.isReady = false;
          console.log("An error occured communicating with eG. Please reload your app", e);
        }
      } else {
        // queue it up until we can connect
        _this.sendQueue.push(serializedMessage);
      }
    });
  }

  _createClass(eGImpl, [{
    key: "setUserName",

    /**
     * Set the user name.
     */
    value: function setUserName(name) {
      reactNative.NativeModules.eGAgent.setUserName(name);
    }
  }, {
    key: "setAttribute",
    value: function setAttribute(name, value) {
      reactNative.NativeModules.eGAgent.setUserAttribute(name, value);
    }
    /**
     * Set the configuration options.
     */

  }, {
    key: "configure",
    value: function configure() {
      var _this2 = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      // options get merged & validated before getting set
      var newOptions = Object.assign({}, this.options, options);
      validate(newOptions);
      this.options = newOptions;
      var _this$options = this.options,
          appToken = _this$options.appToken,
          secure = _this$options.secure,
          host = _this$options.host,
          loggingEnabled = _this$options.loggingEnabled,
          logLevel = _this$options.logLevel,
          port = _this$options.port; //  console.log("appToken::"+appToken);
      //  console.log("configure::$host::${host}"+host)

      var protocol = secure ? "https" : "http"; // this.host = `${protocol}://${host}:${port}/` 

      if (host.startsWith("http")) {
        this.host = host + "/rumcollector/servlet/eGMobileRumCollector";
      } else {
        this.host = protocol + "://" + host + ":" + port + "/rumcollector/servlet/eGMobileRumCollector";
      }

      console.log("configure:host.toString(): " + host.toString()); // console.log("configure:host.toString().indexOf('1.1.1.1'): "+host.toString().indexOf('1.1.1.1'))

      try {
        if (host.toString().indexOf('1.1.1.1') == -1) {
          // console.log("host URL ..."+this.host)
          if (host.startsWith("http")) {
            reactNative.NativeModules.eGAgent.start({
              appToken: appToken,
              hostUrl: host,
              loggingEnabled: loggingEnabled,
              useSsl: secure,
              logLevel: logLevel
            }, function () {
              return console.log('EG Agent  Initialized');
            });
          } else {
            reactNative.NativeModules.eGAgent.start({
              appToken: appToken,
              hostUrl: protocol + "://" + host + ":" + port + "/",
              loggingEnabled: loggingEnabled,
              useSsl: secure,
              logLevel: logLevel
            }, function () {
              return console.log('EG Agent  Initialized');
            });
          }

          this.isReady = true;
        }
      } catch (e) {
        console.log("eg agent start::::" + e);
        console.error("Error:" + e);
      } // if we have plugins, let's add them here


      if (Array.isArray(this.options.plugins)) {
        this.options.plugins.forEach(function (p) {
          return _this2.use(p);
        });
      }

      return this; // cast needed to allow patching by other implementations like eG-react-native
    }
  }, {
    key: "close",
    value: function close() {
      this.connected = false; // this.socket && this.socket.close && this.socket.close()
    }
    /**
     * Connect to the eg-manager server.
     */

  }, {
    key: "connect",
    value: function connect() {
      this.connected = true;
      this.isReady = true;
      this.deviceInfo = reactNative.NativeModules.eGAgent.getDevInfo();
      this.appData = reactNative.NativeModules.eGAgent.getAppinfo();
      this.resourceData = reactNative.NativeModules.eGAgent.getResInfo();
      this.userData = reactNative.NativeModules.eGAgent.getUserInfo();
      console.log('connected...');
      return this; // cast needed to allow patching by other implementations like eg-react-native
    }
    /**
     * Sends a command to the server
     */

  }, {
    key: "display",

    /**
     * Sends a custom command to the server to displays nicely.
     */
    value: function display() {
      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var name = config.name,
          value = config.value,
          preview = config.preview,
          img = config.image,
          _config$important = config.important,
          important = _config$important === void 0 ? false : _config$important;
      var payload = {
        name: name,
        value: value || null,
        preview: preview || null,
        image: img || null
      };
      this.send("display", payload, important);
    }
    /**
     * Client libraries can hijack this to report errors.
     */

  }, {
    key: "reportError",
    value: function reportError(error) {
      this.error(error);
    }
    /**
     * Adds a plugin to the system
     */

  }, {
    key: "use",
    value: function use(pluginCreator) {
      var _this3 = this;

      // we're supposed to be given a function
      if (typeof pluginCreator !== "function") {
        throw new Error("plugins must be a function");
      } // execute it immediately passing the send function


      var plugin = pluginCreator.bind(this)(this); // ensure we get an Object-like creature back

      if (_typeof(plugin) !== "object") {
        throw new Error("plugins must return an object");
      } // do we have features to mixin?


      if (plugin.features) {
        // validate
        if (_typeof(plugin.features) !== "object") {
          throw new Error("features must be an object");
        } // here's how we're going to inject these in


        var inject = function inject(key) {
          // grab the function
          var featureFunction = plugin.features[key]; // only functions may pass

          if (typeof featureFunction !== "function") {
            throw new Error("feature ".concat(key, " is not a function"));
          } // ditch reserved names


          if (isReservedFeature(key)) {
            throw new Error("feature ".concat(key, " is a reserved name"));
          } // ok, let's glue it up... and lose all respect from elite JS champions.


          _this3[key] = featureFunction;
        }; // let's inject


        Object.keys(plugin.features).forEach(function (key) {
          return inject(key);
        });
      } // add it to the list


      this.plugins.push(plugin); // call the plugins onPlugin

      plugin.onPlugin && typeof plugin.onPlugin === "function" && plugin.onPlugin.bind(this)(this); // chain-friendly

      return this; // cast needed to allow patching by other implementations like eG-react-native
    }
  }, {
    key: "onCustomCommand",
    value: function onCustomCommand(config, optHandler) {
      var _this4 = this;

      var command;
      var handler;
      var title;
      var description;
      var args;

      if (typeof config === "string") {
        command = config;
        handler = optHandler;
      } else {
        command = config.command;
        handler = config.handler;
        title = config.title;
        description = config.description;
        args = config.args;
      } // Validations
      // Make sure there is a command


      if (!command) {
        throw new Error("A command is required");
      } // Make sure there is a handler


      if (!handler) {
        throw new Error("A handler is required for command \"".concat(command, "\""));
      } // Make sure the command doesn't already exist


      var existingCommands = this.customCommands.filter(function (cc) {
        return cc.command === command;
      });

      if (existingCommands.length > 0) {
        existingCommands.forEach(function (command) {
          console.log(command);
          _this4.customCommands = _this4.customCommands.filter(function (cc) {
            return cc.id !== command.id;
          });

          _this4.send("customCommand.unregister", {
            id: command.id,
            command: command.command
          });
        });
      }

      if (args) {
        var argNames = [];
        args.forEach(function (arg) {
          if (!arg.name) {
            throw new Error("A arg on the command \"".concat(command, "\" is missing a name"));
          }

          if (argNames.indexOf(arg.name) > -1) {
            throw new Error("A arg with the name \"".concat(arg.name, "\" already exists in the command \"").concat(command, "\""));
          }

          argNames.push(arg.name);
        });
      } // Create this command handlers object


      var customHandler = {
        id: this.customCommandLatestId,
        command: command,
        handler: handler,
        title: title,
        description: description,
        args: args
      }; // Increment our id counter

      this.customCommandLatestId += 1; // Add it to our array

      this.customCommands.push(customHandler);
      this.send("customCommand.register", {
        id: customHandler.id,
        command: customHandler.command,
        title: customHandler.title,
        description: customHandler.description,
        args: customHandler.args
      });
      return function () {
        _this4.customCommands = _this4.customCommands.filter(function (cc) {
          return cc.id !== customHandler.id;
        });

        _this4.send("customCommand.unregister", {
          id: customHandler.id,
          command: customHandler.command
        });
      };
    }
  }]);

  return eGImpl;
}(); // convenience factory function

function createClient(options) {
  var client = new eGImpl();
  client.configure(options);
  return client; // cast needed to allow patching by other implementations like eg-react-native
}

function send(serializedMessage, host) {
  var myHeaders = new Headers();
  myHeaders.append("Content-Type", "application/json");
  var requestOptions = {
    method: 'POST',
    headers: myHeaders,
    body: serializedMessage // redirect: 'follow'

  };
  console.log("JSON::" + serializedMessage);
  fetch(host, requestOptions).then(function (response) {
    var text = response.text();
    console.log("text::" + text);
    return text;
  }).then(function (result) {
    console.log("result::" + result);
    return result;
  })["catch"](function (error) {
    console.log('error', error);
    return error;
  });
}

function getReactNativeVersionWithModules(nativeModules) {
  try {
    // dodge some bullets
    if (!nativeModules.PlatformConstants) return null;
    if (!nativeModules.PlatformConstants.reactNativeVersion) return null; // grab the raw numbers

    var major = nativeModules.PlatformConstants.reactNativeVersion.major;
    var minor = nativeModules.PlatformConstants.reactNativeVersion.minor;
    var patch = nativeModules.PlatformConstants.reactNativeVersion.patch;
    var prerelease = nativeModules.PlatformConstants.reactNativeVersion.prerelease; // check the major or jet

    if (typeof major !== "number") return null; // assemble!

    var vParts = [];
    vParts.push("".concat(major, ".").concat(minor, ".").concat(patch));
    if (prerelease) vParts.push("-".concat(prerelease));
    return vParts.join("");
  } catch (_unused) {}

  return null;
}
function getReactNativeVersion() {
  return getReactNativeVersionWithModules(reactNative.NativeModules);
}

function getReactNativeDimensionsWithDimensions(screen, win) {
  try {
    var screenInfo = {};
    var windowInfo = {};

    if (screen) {
      screenInfo = {
        screenWidth: Math.ceil(screen.width),
        screenHeight: Math.ceil(screen.height),
        screenScale: screen.scale,
        screenFontScale: screen.fontScale
      };
    }

    if (win) {
      windowInfo = {
        windowWidth: Math.ceil(win.width),
        windowHeight: Math.ceil(win.height),
        windowScale: win.scale,
        windowFontScale: win.fontScale
      };
    }

    return _objectSpread2(_objectSpread2({}, screenInfo), windowInfo);
  } catch (e) {}

  return null;
}
function getReactNativeDimensions() {
  var screen = null;
  var win = null;

  try {
    screen = reactNative.Dimensions.get("screen");
  } catch (_unused) {}

  try {
    win = reactNative.Dimensions.get("window");
  } catch (_unused2) {}

  return getReactNativeDimensionsWithDimensions(screen, win);
}

var PLUGIN_DEFAULTS = {
  ignore: []
};
var asyncStorage = (function (options) {
  return function (eg) {
    // setup configuration
    var config = Object.assign({}, PLUGIN_DEFAULTS, options || {});
    var ignore = config.ignore || PLUGIN_DEFAULTS.ignore;
    var swizzSetItem;
    var swizzRemoveItem;
    var swizzMergeItem;
    var swizzClear;
    var swizzMultiSet;
    var swizzMultiRemove;
    var swizzMultiMerge;
    var isSwizzled = false;

    var sendToEG = function sendToEG(action, data) {
      console.log("action:" + action + ", data:" + data); // eg.send("asyncStorage.mutation", { action, data })
    };

    var setItem = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(key, value, callback) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                try {
                  if (ignore.indexOf(key) < 0) {
                    sendToEG("setItem", {
                      key: key,
                      value: value
                    });
                  }
                } catch (e) {}

                return _context.abrupt("return", swizzSetItem(key, value, callback));

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function setItem(_x, _x2, _x3) {
        return _ref.apply(this, arguments);
      };
    }();

    var removeItem = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(key, callback) {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                try {
                  if (ignore.indexOf(key) < 0) {
                    sendToEG("removeItem", {
                      key: key
                    });
                  }
                } catch (e) {}

                return _context2.abrupt("return", swizzRemoveItem(key, callback));

              case 2:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function removeItem(_x4, _x5) {
        return _ref2.apply(this, arguments);
      };
    }();

    var mergeItem = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(key, value, callback) {
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                try {
                  if (ignore.indexOf(key) < 0) {
                    sendToEG("mergeItem", {
                      key: key,
                      value: value
                    });
                  }
                } catch (e) {}

                return _context3.abrupt("return", swizzMergeItem(key, value, callback));

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      return function mergeItem(_x6, _x7, _x8) {
        return _ref3.apply(this, arguments);
      };
    }();

    var clear = /*#__PURE__*/function () {
      var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(callback) {
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                try {
                  sendToEG("clear");
                } catch (e) {}

                return _context4.abrupt("return", swizzClear(callback));

              case 2:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));

      return function clear(_x9) {
        return _ref4.apply(this, arguments);
      };
    }();

    var multiSet = /*#__PURE__*/function () {
      var _ref5 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(pairs, callback) {
        var shippablePairs;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                try {
                  shippablePairs = (pairs || []).filter(function (pair) {
                    return pair && pair[0] && ignore.indexOf(pair[0]) < 0;
                  });

                  if (shippablePairs.length > 0) {
                    sendToEG("multiSet", {
                      pairs: shippablePairs
                    });
                  }
                } catch (e) {}

                return _context5.abrupt("return", swizzMultiSet(pairs, callback));

              case 2:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }));

      return function multiSet(_x10, _x11) {
        return _ref5.apply(this, arguments);
      };
    }();

    var multiRemove = /*#__PURE__*/function () {
      var _ref6 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(keys, callback) {
        var shippableKeys;
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                try {
                  shippableKeys = (keys || []).filter(function (key) {
                    return ignore.indexOf(key) < 0;
                  });

                  if (shippableKeys.length > 0) {
                    sendToEG("multiRemove", {
                      keys: shippableKeys
                    });
                  }
                } catch (e) {}

                return _context6.abrupt("return", swizzMultiRemove(keys, callback));

              case 2:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6);
      }));

      return function multiRemove(_x12, _x13) {
        return _ref6.apply(this, arguments);
      };
    }();

    var multiMerge = /*#__PURE__*/function () {
      var _ref7 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(pairs, callback) {
        var shippablePairs;
        return regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                try {
                  shippablePairs = (pairs || []).filter(function (pair) {
                    return pair && pair[0] && ignore.indexOf(pair[0]) < 0;
                  });

                  if (shippablePairs.length > 0) {
                    sendToEG("multiMerge", {
                      pairs: shippablePairs
                    });
                  }
                } catch (e) {}

                return _context7.abrupt("return", swizzMultiMerge(pairs, callback));

              case 2:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7);
      }));

      return function multiMerge(_x14, _x15) {
        return _ref7.apply(this, arguments);
      };
    }();
    /**
     * Hijacks the AsyncStorage API.
     */


    var trackAsyncStorage = function trackAsyncStorage() {
      if (isSwizzled) return;
      swizzSetItem = eg.asyncStorageHandler.setItem;
      eg.asyncStorageHandler.setItem = setItem;
      swizzRemoveItem = eg.asyncStorageHandler.removeItem;
      eg.asyncStorageHandler.removeItem = removeItem;
      swizzMergeItem = eg.asyncStorageHandler.mergeItem;
      eg.asyncStorageHandler.mergeItem = mergeItem;
      swizzClear = eg.asyncStorageHandler.clear;
      eg.asyncStorageHandler.clear = clear;
      swizzMultiSet = eg.asyncStorageHandler.multiSet;
      eg.asyncStorageHandler.multiSet = multiSet;
      swizzMultiRemove = eg.asyncStorageHandler.multiRemove;
      eg.asyncStorageHandler.multiRemove = multiRemove;
      swizzMultiMerge = eg.asyncStorageHandler.multiMerge;
      eg.asyncStorageHandler.multiMerge = multiMerge;
      isSwizzled = true;
    };

    var untrackAsyncStorage = function untrackAsyncStorage() {
      if (!isSwizzled) return;
      eg.asyncStorageHandler.setItem = swizzSetItem;
      eg.asyncStorageHandler.removeItem = swizzRemoveItem;
      eg.asyncStorageHandler.mergeItem = swizzMergeItem;
      eg.asyncStorageHandler.clear = swizzClear;
      eg.asyncStorageHandler.multiSet = swizzMultiSet;
      eg.asyncStorageHandler.multiRemove = swizzMultiRemove;
      eg.asyncStorageHandler.multiMerge = swizzMultiMerge;
      isSwizzled = false;
    }; // egShipStorageValues()


    if (eg.asyncStorageHandler) {
      trackAsyncStorage();
    }

    return {
      features: {
        trackAsyncStorage: trackAsyncStorage,
        untrackAsyncStorage: untrackAsyncStorage
      }
    };
  };
});

// An event handler can take an optional event argument
// and should not return a value
// An array of all currently registered event handlers for a type
// A map of event types and their corresponding event handlers.

/**
 * Mitt: Tiny (~200b) functional event emitter / pubsub.
 * @name mitt
 * @returns {Mitt}
 */
function mitt(all) {
  all = all || new Map();
  return {
    /**
     * A Map of event names to registered handler functions.
     */
    all: all,

    /**
     * Register an event handler for the given type.
     * @param {string|symbol} type Type of event to listen for, or `"*"` for all events
     * @param {Function} handler Function to call in response to given event
     * @memberOf mitt
     */
    on: function on(type, handler) {
      var handlers = all.get(type);
      var added = handlers && handlers.push(handler);

      if (!added) {
        all.set(type, [handler]);
      }
    },

    /**
     * Remove an event handler for the given type.
     * @param {string|symbol} type Type of event to unregister `handler` from, or `"*"`
     * @param {Function} handler Handler function to remove
     * @memberOf mitt
     */
    off: function off(type, handler) {
      var handlers = all.get(type);

      if (handlers) {
        handlers.splice(handlers.indexOf(handler) >>> 0, 1);
      }
    },

    /**
     * Invoke all handlers for the given type.
     * If present, `"*"` handlers are invoked after type-matched handlers.
     *
     * Note: Manually firing "*" handlers is not supported.
     *
     * @param {string|symbol} type The event type to invoke
     * @param {Any} [evt] Any value (object is recommended and powerful), passed to each handler
     * @memberOf mitt
     */
    emit: function emit(type, evt) {
      (all.get(type) || []).slice().map(function (handler) {
        handler(evt);
      });
      (all.get('*') || []).slice().map(function (handler) {
        handler(type, evt);
      });
    }
  };
}

var Styles = {
  container: {
    position: "absolute",
    left: 0,
    top: 0,
    right: 0,
    bottom: 0,
    zIndex: 1000,
    opacity: 0.25
  }
};

/** An overlay for showing an image to help with layout.
 *
 * @class FullScreenOverlay
 * @extends {Component}
 */
var FullScreenOverlay = /*#__PURE__*/function (_Component) {
  _inherits(FullScreenOverlay, _Component);

  var _super = _createSuper(FullScreenOverlay);

  function FullScreenOverlay(props) {
    var _this;

    _classCallCheck(this, FullScreenOverlay);

    _this = _super.call(this, props);
    _this.state = {
      opacity: Styles.container.opacity,
      uri: null,
      justifyContent: "center",
      alignItems: "center"
    }; // when the server sends stuff

    props.emitter.on("overlay", function (payload) {
      _this.setState(_objectSpread2(_objectSpread2({}, _this.state), payload));
    });
    return _this;
  }

  _createClass(FullScreenOverlay, [{
    key: "createContainerStyle",
    value: function createContainerStyle() {
      var _this$state = this.state,
          opacity = _this$state.opacity,
          justifyContent = _this$state.justifyContent,
          alignItems = _this$state.alignItems;

      var _Dimensions$get = reactNative.Dimensions.get("window"),
          width = _Dimensions$get.width,
          height = _Dimensions$get.height;

      var containerStyle = _objectSpread2(_objectSpread2({}, Styles.container), {}, {
        opacity: opacity,
        width: width,
        height: height,
        justifyContent: justifyContent,
        alignItems: alignItems
      });

      return containerStyle;
    }
    /**
     * Draw.
     */

  }, {
    key: "render",
    value: function render() {
      var _this$state2 = this.state,
          uri = _this$state2.uri,
          width = _this$state2.width,
          height = _this$state2.height,
          growToWindow = _this$state2.growToWindow,
          resizeMode = _this$state2.resizeMode,
          _this$state2$marginLe = _this$state2.marginLeft,
          marginLeft = _this$state2$marginLe === void 0 ? 0 : _this$state2$marginLe,
          _this$state2$marginRi = _this$state2.marginRight,
          marginRight = _this$state2$marginRi === void 0 ? 0 : _this$state2$marginRi,
          _this$state2$marginTo = _this$state2.marginTop,
          marginTop = _this$state2$marginTo === void 0 ? 0 : _this$state2$marginTo,
          _this$state2$marginBo = _this$state2.marginBottom,
          marginBottom = _this$state2$marginBo === void 0 ? 0 : _this$state2$marginBo;
      var imageStyle = {
        width: width,
        height: height,
        marginTop: marginTop,
        marginRight: marginRight,
        marginBottom: marginBottom,
        marginLeft: marginLeft
      };

      if (growToWindow) {
        var windowSize = reactNative.Dimensions.get("window");
        imageStyle.width = windowSize.width;
        imageStyle.height = windowSize.height;
      }

      var image = uri ? /*#__PURE__*/React__default['default'].createElement(reactNative.Image, {
        source: {
          uri: uri
        },
        style: imageStyle,
        resizeMode: growToWindow ? resizeMode : null
      }) : /*#__PURE__*/React__default['default'].createElement(reactNative.View, null);
      return /*#__PURE__*/React__default['default'].createElement(reactNative.View, {
        style: this.createContainerStyle(),
        pointerEvents: "none"
      }, image);
    }
  }]);

  return FullScreenOverlay;
}(React.Component);

var overlay = (function () {
  return function () {
    var emitter = mitt();
    return {
      /**
       * Fires when any eG message arrives.
       *
       * @param {object} command The eG command object.
       */
      onCommand: function onCommand(command) {
        if (command.type !== "overlay") return; // relay this payload on to the emitter

        emitter.emit("overlay", command.payload);
      },
      features: {
        overlay: function overlay(WrappedComponent) {
          return function (props) {
            return /*#__PURE__*/React__default['default'].createElement(reactNative.View, {
              style: {
                flex: 1
              }
            }, /*#__PURE__*/React__default['default'].createElement(WrappedComponent, props), /*#__PURE__*/React__default['default'].createElement(FullScreenOverlay, {
              emitter: emitter
            }));
          };
        }
      }
    };
  };
});

var DEFAULTS = {
  url: "http://localhost:8081"
};
var openInEditor = (function () {
  var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return function () {
    var options = Object.assign({}, DEFAULTS, pluginConfig);
    return {
      onCommand: function onCommand(command) {
        if (command.type !== "editor.open") return;
        var payload = command.payload;
        var file = payload.file,
            lineNumber = payload.lineNumber;
        var url = "".concat(options.url, "/open-stack-frame");
        var body = {
          file: file,
          lineNumber: lineNumber || 1
        };
        var method = "POST";
        fetch(url, {
          method: method,
          body: JSON.stringify(body)
        });
      }
    };
  };
});

const noop = () => { };

const setJSExceptionHandler = (customHandler = noop, allowedInDevMode = false) => {
  if (typeof allowedInDevMode !== "boolean" || typeof customHandler !== "function") {
    console.log("setJSExceptionHandler is called with wrong argument types.. first argument should be callback function and second argument is optional should be a boolean");
    console.log("Not setting the JS handler .. please fix setJSExceptionHandler call");
    return;
  }
  const allowed = allowedInDevMode ? true : !__DEV__;
  if (allowed) {
    global.ErrorUtils.setGlobalHandler(customHandler);
    const consoleError = console.error;
    console.error = (...args) => {
      global.ErrorUtils.reportError(...args);
      consoleError(...args);
    };
  } else {
    console.log("Skipping setJSExceptionHandler: Reason: In DEV mode and allowedInDevMode = false");
  }
};

function createRawFrame(raw) {
    return {
        column: -1,
        fileName: "",
        line: -1,
        name: "",
        raw: raw,
        sourceColumn: -1,
        sourceFileName: "",
        sourceLine: -1,
        type: "",
    };
}
var FIREFOX_WEBKIT = /([^@]+|^)@(.*):(\d+):(\d+)/;
var WEBKIT_ADDRESS_UNNAMED = /^(http(s)?:\/\/.*):(\d+):(\d+)$/;
var WEBKIT_NATIVE_UNNAMED = "[native code]";
function parsWebkit(str) {
    if (str.includes(WEBKIT_NATIVE_UNNAMED)) {
        return {
            line: -1,
            column: -1,
            type: "native",
            fileName: "",
            name: "",
            raw: str,
            sourceColumn: -1,
            sourceFileName: "",
            sourceLine: -1,
        };
    }
    var match = str.match(WEBKIT_ADDRESS_UNNAMED);
    if (match) {
        var line = match[3] ? +match[3] : -1;
        var column = match[4] ? +match[4] : -1;
        var fileName = match[1] ? match[1] : "";
        return {
            line: line,
            column: column,
            type: "",
            fileName: fileName,
            name: "",
            raw: str,
            sourceColumn: -1,
            sourceFileName: "",
            sourceLine: -1,
        };
    }
    return createRawFrame(str);
}
function parseFirefoxWebkit(lines) {
    return lines.map(function (str) {
        var match = str.match(FIREFOX_WEBKIT);
        if (!match) {
            return parsWebkit(str);
        }
        var line = match[3] ? +match[3] : -1;
        var column = match[4] ? +match[4] : -1;
        var fileName = match[2] ? match[2] : "";
        return {
            line: line,
            column: column,
            type: match[0] ? "" : "native",
            fileName: fileName,
            name: (match[1] || "").trim(),
            raw: str,
            sourceColumn: -1,
            sourceFileName: "",
            sourceLine: -1,
        };
    });
}
// foo.bar.js:123:39
// foo.bar.js:123:39 <- original.js:123:34
var CHROME_MAPPED = /(.*?):(\d+):(\d+)(\s<-\s(.+):(\d+):(\d+))?/;
function parseMapped(frame, maybeMapped) {
    var match = maybeMapped.match(CHROME_MAPPED);
    if (match) {
        frame.fileName = match[1];
        frame.line = +match[2];
        frame.column = +match[3];
        if (match[5])
            frame.sourceFileName = match[5];
        if (match[6])
            frame.sourceLine = +match[6];
        if (match[7])
            frame.sourceColumn = +match[7];
    }
}
// at <SomeFramework>
var CHROME_IE_NATIVE_NO_LINE = /^at\s(<.*>)$/;
// at <SomeFramework>:123:39
var CHROME_IE_NATIVE = /^\s*at\s(<.*>):(\d+):(\d+)$/;
// at foo.bar(bob) (foo.bar.js:123:39)
// at foo.bar(bob) (foo.bar.js:123:39 <- original.js:123:34)
var CHROME_IE_FUNCTION = /^at\s(.*)\s\((.*)\)$/;
// >= Chrome 88
// spy() at Component.Foo [as constructor] (original.js:123:34)
// spy() at Component.Foo [as constructor] (foo.bar.js:123:39 <- original.js:123:34)
var CHROME_IE_FUNCTION_WITH_CALL = /^([\w\W]*)\s\((.*)\)/;
var CHROME_IE_DETECTOR = /\s*at\s.+/;
// at about:blank:1:7
// >= Chrome 99
// at /projects/foo.test.js:689:1 <- /projects/foo.test.js:10:1
var CHROME_BLANK = /\s*at\s(.*):(\d+):(\d+)$/;
function parseChromeIe(lines) {
    // Many frameworks mess with error.stack. So we use this check
    // to find the first line of the actual stack
    var start = lines.findIndex(function (line) { return CHROME_IE_DETECTOR.test(line); });
    if (start === -1) {
        return [];
    }
    var frames = [];
    for (var i = start; i < lines.length; i++) {
        var str = lines[i].replace(/^\s+|\s+$/g, "");
        var frame = createRawFrame(lines[i]);
        var nativeNoLine = str.match(CHROME_IE_NATIVE_NO_LINE);
        if (nativeNoLine) {
            frame.fileName = nativeNoLine[1];
            frame.type = "native";
            frames.push(frame);
            continue;
        }
        var native = str.match(CHROME_IE_NATIVE);
        if (native) {
            frame.fileName = native[1];
            frame.type = "native";
            if (native[2])
                frame.line = +native[2];
            if (native[3])
                frame.column = +native[3];
            frames.push(frame);
            continue;
        }
        var withFn = str.match(CHROME_IE_FUNCTION);
        if (withFn) {
            frame.name = withFn[1];
            parseMapped(frame, withFn[2]);
            frames.push(frame);
            continue;
        }
        var blank = str.match(CHROME_BLANK);
        if (blank) {
            frame.fileName = blank[1];
            frame.line = +blank[2];
            frame.column = +blank[3];
            parseMapped(frame, blank[1] + ":" + blank[2] + ":" + blank[3]);
            frames.push(frame);
            continue;
        }
        var withFnCall = str.match(CHROME_IE_FUNCTION_WITH_CALL);
        if (withFnCall) {
            frame.name = withFnCall[1];
            parseMapped(frame, withFnCall[2]);
            frames.push(frame);
            continue;
        }
        frames.push(frame);
    }
    return frames;
}
function parseStackTrace(stack) {
    if (!stack)
        return [];
    var lines = stack.split("\n").filter(Boolean);
    // Libraries like node's "assert" module mess with the stack trace by
    // prepending custom data. So we need to do a precheck, to determine
    // which browser the trace is coming from.
    if (lines.some(function (line) { return CHROME_IE_DETECTOR.test(line); })) {
        return parseChromeIe(lines);
    }
    return parseFirefoxWebkit(lines);
}

/**
 * Provides a global error handler to report errors..
 */
// so we're lazy loading.
//let parseErrorStack
//let symbolicateStackTrace

// defaults
var PLUGIN_DEFAULTS$1 = {
  veto: null
}; // const reactNativeFrameFinder = frame => contains('/node_modules/react-native/', frame.fileName)
// our plugin entry point

var trackGlobalErrors = (function (options) {
  return function (eg) {
    // setup configuration
    var config = Object.assign({}, PLUGIN_DEFAULTS$1, options || {});
    var swizzled = null;
    var isSwizzled = false;

    function eGExceptionHijacker(message, prettyStack, currentExceptionID) {
      // do Facebook's stuff first
      alert('eGExceptionHijacker');
      swizzled(message, prettyStack, currentExceptionID); // console.log("eGExceptionHijacker:message::"+message)
      // console.log("eGExceptionHijacker:prettyStack::"+prettyStack)
      // console.log("eGExceptionHijacker:currentExceptionID::"+currentExceptionID)
      // then convert & transport it

      try {
        // rewrite the stack frames to be in the format we're expecting
        var stack = prettyStack.map(function (frame) {
          return {
            functionName: frame.methodName === "<unknown>" ? null : frame.methodName,
            lineNumber: frame.lineNumber,
            columnNumber: frame.column,
            fileName: frame.file
          };
        }); // does the dev want us to keep each frame?

        if (config.veto) {
          stack = stack.filter(function (frame) {
            return config.veto(frame);
          });
        } // throw it over to us


        eg.error(message, stack); // TODO: Fix this.
      } catch (e) {
        console.log("eGExceptionHijacker:e::", e); // TODO: no one must ever know our dark secrets
      }
    } // here's how to swizzle


    function trackGlobalErrors() {
      // console.log("trackGlobalErrors:isSwizzled::"+isSwizzled)
      // console.log("trackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
      if (isSwizzled) return;
      if (!reactNative.NativeModules.ExceptionsManager) return;
      swizzled = reactNative.NativeModules.ExceptionsManager.updateExceptionMessage;
      reactNative.NativeModules.ExceptionsManager.updateExceptionMessage = eGExceptionHijacker;
      isSwizzled = true;
    } // restore the original


    function untrackGlobalErrors() {
      // console.log("untrackGlobalErrors:isSwizzled::"+isSwizzled)
      // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
      if (!swizzled) return;
      if (!reactNative.NativeModules.ExceptionsManager) return;
      reactNative.NativeModules.ExceptionsManager.updateExceptionMessage = swizzled;
      isSwizzled = false;
    } // auto start this


    trackGlobalErrors();

    var handleError = function handleError(error, isFatal) {
      if (isFatal) {
        reportError(error);
      } else {
        console.log(error);
      }
    };

    setJSExceptionHandler(handleError, true); // manually fire an error

    function reportError(error) {
      //console.log("reportError:isSwizzled::"+error)
      // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
      //(eg as any).error(error.message, true) 
      try {
        var parseErrorStack = parseStackTrace(error.stack); //console.log('parsed', parseErrorStack)

        if (parseErrorStack) {
          var stack = parseErrorStack.map(function (stackFrame) {
            return {
              fileName: stackFrame.file,
              functionName: stackFrame.name,
              lineNumber: stackFrame.line
            };
          }); //console.log('error.message', error.message);

          if (config.veto) {
            stack = stack.filter(function (frame) {
              return config.veto(frame);
            });
          }

          eg.error(error.message, error);
        }
      } catch (err) {//nothing happened. move along.
      }
    } // the eg plugin interface


    return {
      // attach these functions to the eg
      features: {
        reportError: reportError,
        trackGlobalErrors: trackGlobalErrors,
        untrackGlobalErrors: untrackGlobalErrors
      }
    };
  };
});

/**
 * Don't include the response bodies for images by default.
 */
var DEFAULT_CONTENT_TYPES_RX = /^(image)\/.*$/i;
var DEFAULTS$1 = {};
var networking = (function () {
  var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return function (eg) {
    var options = Object.assign({}, DEFAULTS$1, pluginConfig); // a RegExp to suppess adding the body cuz it costs a lot to serialize

    var ignoreContentTypes = options.ignoreContentTypes || DEFAULT_CONTENT_TYPES_RX; // a XHR call tracker

    var egCounter = 1000; // a temporary cache to hold requests so we can match up the data

    var requestCache = {};
    /**
     * Fires when we talk to the server.
     *
     * @param {*} data - The data sent to the server.
     * @param {*} instance - The XMLHTTPRequest instance.
     */

    function onSend(data, xhr) {
      if (options.ignoreUrls && options.ignoreUrls.test(xhr._url)) {
        xhr._skipEG = true;
        return;
      } // bump the counter


      egCounter++; // tag

      xhr._trackingName = egCounter; // cache

      requestCache[egCounter] = {
        data: data,
        xhr: xhr,
        stopTimer: eg.startTimer()
      };
    }
    /**
     * Fires when the server gives us a response.
     *
     * @param {number} status - The HTTP response status.
     * @param {boolean} timeout - Did we timeout?
     * @param {*} response - The response data.
     * @param {string} url - The URL we talked to.
     * @param {*} type - Not sure.
     * @param {*} xhr - The XMLHttpRequest instance.
     */


    function onResponse(status, timeout, response, url, type, xhr) {
      if (xhr._skipEG) {
        return;
      }

      var params = null;
      var queryParamIdx = url ? url.indexOf('?') : -1;

      if (queryParamIdx > -1) {
        // params = queryString.parse(url.substr(queryParamIdx))
        params = url.substr(queryParamIdx);
      } // fetch and clear the request data from the cache


      var rid = xhr._trackingName;
      var cachedRequest = requestCache[rid] || {};
      requestCache[rid] = null; // assemble the request object

      var data = cachedRequest.data,
          stopTimer = cachedRequest.stopTimer;
      var tronRequest = {
        url: url || cachedRequest.xhr._url,
        method: xhr._method || null,
        data: data,
        headers: xhr._headers || null,
        params: params
      }; // what type of content is this?

      var contentType = xhr.responseHeaders && xhr.responseHeaders['content-type'] || xhr.responseHeaders && xhr.responseHeaders['Content-Type'] || '';

      var sendResponse = function sendResponse(responseBodyText) {
        var body = "~~~ skipped ~~~";

        if (responseBodyText) {
          try {
            // all i am saying, is give JSON a chance...
            body = JSON.parse(responseBodyText);
          } catch (boom) {
            body = response;
          }
        }

        var tronResponse = {
          body: body,
          status: status,
          headers: xhr.responseHeaders || null
        } // send this off to eg
        ;
        eg.apiResponse(tronRequest, tronResponse, stopTimer()); // TODO: Fix
      }; // can we use the real response?


      var useRealResponse = (typeof response === 'string' || _typeof(response) === 'object') && !ignoreContentTypes.test(contentType || ''); // prepare the right body to send

      if (useRealResponse) {
        if (type === 'blob' && typeof FileReader !== 'undefined' && response) {
          // Disable reason: FileReader should be in global scope since RN 0.54
          // eslint-disable-next-line no-undef
          var bReader = new FileReader();

          var brListener = function brListener() {
            sendResponse(bReader.result);
            bReader.removeEventListener('loadend', brListener);
          };

          bReader.addEventListener('loadend', brListener);
          bReader.readAsText(response);
        } else {
          sendResponse(response);
        }
      } else {
        sendResponse('');
      }
    } // register our monkey-patch


    XHRInterceptor__default['default'].setSendCallback(onSend);
    XHRInterceptor__default['default'].setResponseCallback(onResponse);
    XHRInterceptor__default['default'].enableInterception(); // nothing of use to offer to the plugin

    return {};
  };
});

var StorybookSwitcher = /*#__PURE__*/function (_Component) {
  _inherits(StorybookSwitcher, _Component);

  var _super = _createSuper(StorybookSwitcher);

  /**
   * Creates an instance of FullScreenOverlay.
   *
   * @param {any} props
   * @param {Object} props.emitter An event emitter.
   *
   * @memberOf FullScreenOverlay
   */
  function StorybookSwitcher(props) {
    var _this;

    _classCallCheck(this, StorybookSwitcher);

    _this = _super.call(this, props);
    _this.state = {
      showStorybook: false
    }; // when the server sends stuff

    props.emitter.on("storybook", function (payload) {
      _this.setState({
        showStorybook: payload
      });
    });
    return _this;
  }
  /**
   * Draw.
   */


  _createClass(StorybookSwitcher, [{
    key: "render",
    value: function render() {
      var showStorybook = this.state.showStorybook;
      var _this$props = this.props,
          StorybookUi = _this$props.storybookUi,
          children = _this$props.children;
      return /*#__PURE__*/React__default['default'].createElement(reactNative.View, {
        style: {
          flex: 1
        }
      }, showStorybook ? /*#__PURE__*/React__default['default'].createElement(StorybookUi, null) : children);
    }
  }]);

  return StorybookSwitcher;
}(React.Component);

/**
 * A plugin which provides .storybookSwitcher() on eG.
 */

var storybook = (function () {
  return function () {
    var emitter = mitt();
    return {
      onCommand: function onCommand(command) {
        if (command.type !== "storybook") return; // relay this payload on to the emitter

        emitter.emit("storybook", command.payload);
      },
      features: {
        storybookSwitcher: function storybookSwitcher(storybookUi) {
          return function (WrappedComponent) {
            return function (props) {
              return /*#__PURE__*/React__default['default'].createElement(StorybookSwitcher, {
                storybookUi: storybookUi,
                emitter: emitter
              }, /*#__PURE__*/React__default['default'].createElement(WrappedComponent, props));
            };
          };
        }
      }
    };
  };
});

var devTools = (function () {
  return function () {
    return {
      onCommand: function onCommand(command) {
        if (command.type !== "devtools.open" && command.type !== "devtools.reload") return;

        if (command.type === "devtools.open") {
          reactNative.NativeModules.DevMenu.show();
        }

        if (command.type === "devtools.reload") {
          reactNative.NativeModules.DevMenu.reload();
        }
      }
    };
  };
});

var ConnectionManager = /*#__PURE__*/function () {
  function ConnectionManager(path) {
    _classCallCheck(this, ConnectionManager);

    _defineProperty(this, "webSocket", void 0);

    this.webSocket = new WebSocket(path);
  }

  _createClass(ConnectionManager, [{
    key: "send",
    value: function send(payload) {
      if (this.webSocket.readyState === 1) {
        this.webSocket.send(payload);
      }
    }
  }, {
    key: "on",
    value: function on(event, callback) {
      console.log(event);

      if (event === "open") {
        this.webSocket.onopen = callback;
      } else if (event === "message") {
        this.webSocket.onmessage = function (evt) {
          return callback(evt.data);
        };
      }
    }
  }, {
    key: "close",
    value: function close() {
      this.webSocket.close();
    }
  }]);

  return ConnectionManager;
}();

var constants = reactNative.NativeModules.PlatformConstants || {};
var tempClientId = null;
var DEFAULTS$2 = {
  appToken: "",
  createSocket: function createSocket(path) {
    return new ConnectionManager(path);
  },
  host: "1.1.1.1",
  port: 1,
  name: "React Native App",
  environment: process.env.NODE_ENV || (__DEV__ ? "development" : "production"),
  client: _objectSpread2({
    eGLibraryName: "@eginnovations/react-native-eg-agent",
    eGLibraryVersion: "REACT_NATIVE_EG-AGENT_VERSION",
    platform: reactNative.Platform.OS,
    platformVersion: reactNative.Platform.Version,
    osRelease: constants.Release,
    model: constants.Model,
    serverHost: constants.ServerHost,
    forceTouch: constants.forceTouchAvailable || false,
    interfaceIdiom: constants.interfaceIdiom,
    systemName: constants.systemName,
    uiMode: constants.uiMode,
    serial: constants.Serial,
    androidId: constants.androidID,
    reactNativeVersion: getReactNativeVersion()
  }, getReactNativeDimensions()),

  /* eslint-disable @typescript-eslint/no-use-before-define */
  getClientId: function getClientId() {
    if (eGAgent.asyncStorageHandler) {
      return eGAgent.asyncStorageHandler.getItem(tempClientId);
    }

    return new Promise(function (resolve) {
      return resolve(tempClientId);
    });
  },
  setClientId: function setClientId(clientId) {
    if (eGAgent.asyncStorageHandler) {
      return eGAgent.asyncStorageHandler.setItem(tempClientId, clientId);
    }

    tempClientId = clientId;
    return Promise.resolve();
  },

  /* eslint-enable @typescript-eslint/no-use-before-define */
  proxyHack: true
};
var eGAgent = createClient(DEFAULTS$2);

function getPluginOptions(options) {
  return _typeof(options) === "object" ? options : null;
}

eGAgent.useReactNative = function () {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  if (options.errors !== false) {
    eGAgent.use(trackGlobalErrors(getPluginOptions(options.errors)));
  }

  if (options.editor !== false) {
    eGAgent.use(openInEditor(getPluginOptions(options.editor)));
  }

  if (options.overlay !== false) {
    eGAgent.use(overlay());
  }

  if (options.asyncStorage !== false) {
    eGAgent.use(asyncStorage(getPluginOptions(options.asyncStorage)));
  }

  if (options.networking !== false) {
    eGAgent.use(networking(getPluginOptions(options.networking)));
  }

  if (options.storybook !== false) {
    eGAgent.use(storybook());
  }

  if (options.devTools !== false) {
    eGAgent.use(devTools());
  }

  return eGAgent;
};

eGAgent.setAsyncStorageHandler = function (asyncStorage) {
  eGAgent.asyncStorageHandler = asyncStorage;
  return eGAgent;
};

exports.asyncStorage = asyncStorage;
exports.default = eGAgent;
exports.devTools = devTools;
exports.networking = networking;
exports.openInEditor = openInEditor;
exports.overlay = overlay;
exports.storybook = storybook;
exports.trackGlobalErrors = trackGlobalErrors;
