package com.eginnovations.capacitor.plugin;

import com.getcapacitor.JSObject;
import com.getcapacitor.NativePlugin;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;

import org.json.JSONException;
import org.json.JSONObject;

import com.eg.agent.android.AppPlatform;
import com.eg.agent.android.BaseAndroidAgent;
import com.eg.agent.android.DataController;
import com.eg.agent.android.MobileAgentUpload;
import com.eg.agent.android.Queue;
import com.eg.agent.android.eGAndroidAgent;
import com.eg.agent.android.analytics.Attributes;
import com.eg.agent.android.instrumentation.crash.EgExceptionHandler;

import android.util.Log;


@NativePlugin
public class eGCapacitorPlugin extends Plugin {
	
	private final static String TAG = eGCapacitorPlugin.class.getSimpleName();

    @PluginMethod
    public void start(PluginCall call) {
       
		String appToken = call.getString("ANDROID_APP_TOKEN", null);
        String managerURL = call.getString("MANAGER_URL", null);
		String logLevel = call.getString("LOG_LEVEL", null);
		String ssl = call.getString("SSL", "true");
		String unsigned = call.getString("UNSIGNED", "true");
		int logLvl = 1;
		if(logLevel != null && logLevel.trim().length() > 0) {
			try {
				logLvl = Integer.parseInt(logLevel);
			} catch (Exception e) {
			}
		}
        if (appToken == null || appToken.isEmpty() || "x".equals(appToken)) {
            Log.e(TAG, "Failed to load application token! The Android agent is not configured for Capacitor.");
        } else if(managerURL == null || managerURL.isEmpty() || "x".equals(managerURL)){
            Log.e(TAG, "Failed to load eG Manager URL! The Android agent is not configured for Capacitor.");
        }else {
            eGAndroidAgent.withCollectorHost(appToken, managerURL).withLoggingEnabled(true).withLogLevel(logLvl).usingSsl(Boolean.valueOf(ssl)).unsigned(Boolean.valueOf(unsigned)).start(getContext());
            final String pluginVersion = call.getString("PLUGIN_VERSION", "1.0.0");
            
            eGAndroidAgent.setAppliactionPlatform(AppPlatform.Capacitor);
            eGAndroidAgent.setAttribute(Attributes.APPLICATION_PLATFORM_VERSION_ATTRIBUTE, pluginVersion);
            Thread.UncaughtExceptionHandler mDefaultHandler = Thread
                    .getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new EgExceptionHandler(true,mDefaultHandler));
        }
		
		 call.resolve();
    }
    
    @PluginMethod
    public void postData(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getOSVersion:PluginCall:::"+call);
		String data = call.getString("data", null);
        
		try {
			Queue.queue(new JSONObject(data));
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			call.error("JSON Exception", e);
		}
		call.resolve();
    }
    
    
    @PluginMethod
	public void getOSVersion(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getOSVersion:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("osVersion", BaseAndroidAgent.getInstance().getDeviceInformation().getOsVersion());
    	call.resolve(ret);
		
		//Log.e(TAG, "eGCapacitorPlugin::getOSVersion:ret:::"+ret);
//		return BaseAndroidAgent.getInstance().getDeviceInformation().getOsVersion();
	}

    @PluginMethod
	public void getDevInfo(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getDevInfo:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("deviceInformation", MobileAgentUpload.getDevInfo());
    	call.resolve(ret);
		
		//Log.e(TAG, "eGCapacitorPlugin::getDevInfo:ret:::"+ret);
//		return MobileAgentUpload.getDevInfo();
	}

    @PluginMethod
	public void getAppinfo(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getAppinfo:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("applicationInformation", MobileAgentUpload.getAppinfo());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getAppinfo:ret:::"+ret);
//		return MobileAgentUpload.getAppinfo();
	}

    @PluginMethod
	public void getResInfo(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getResInfo:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("resourceInformation", MobileAgentUpload.getResInfo());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getResInfo:ret:::"+ret);
//		return MobileAgentUpload.getResInfo();
	}

    @PluginMethod
	public void getCurrentActivityName(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getCurrentActivityName:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("activityName", this.getActivity().getLocalClassName());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getCurrentActivityName:ret:::"+ret);
//		return super.getActivity().getLocalClassName();
	}

    @PluginMethod
	public void getUserCountry(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getUserCountry:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("country", BaseAndroidAgent.getUserCountry(this.getContext()));
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getUserCountry:ret:::"+ret);
//		return BaseAndroidAgent.getUserCountry(this.getContext());
	}

    @PluginMethod
	public void getDeviceName(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getDeviceName:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("deviceName", BaseAndroidAgent.getInstance().getDeviceInformation().getDeviceName());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getDeviceName:ret:::"+ret);
//		return BaseAndroidAgent.getInstance().getDeviceInformation().getDeviceName();
	}

    @PluginMethod
	public void getBaseOs(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getBaseOs:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("osName","Android");
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getBaseOs:ret:::"+ret);
//		return "Android";
	}

    @PluginMethod
	public void getAppName(PluginCall call) {
    	if (!eGAndroidAgent.isStarted()) {
    		return;
    	}
		//Log.e(TAG, "eGCapacitorPlugin::getAppName:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("appName", BaseAndroidAgent.getInstance().getApplicationInformation().getAppName());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getAppName:ret:::"+ret);
//		return BaseAndroidAgent.getInstance().getApplicationInformation().getAppName();
	}
    
    @PluginMethod
    public void isEnabled(PluginCall call) {
    	//Log.e(TAG, "eGCapacitorPlugin::isEnabled:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("isEnabled", eGAndroidAgent.isStarted());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::isEnabled:ret:::"+ret);
	}
    
    @PluginMethod
    public void setUserName(PluginCall call) {
    	//Log.d(TAG, "eGCapacitorPlugin::setUserName:PluginCall:::"+call);
    	String name =  call.getString("userName");
    	//Log.d(TAG, "eGCapacitorPlugin::setUserName:PluginCall::name:"+name);
    	eGAndroidAgent.setUserName(name);
    	call.resolve();
    }
    
    @PluginMethod
    public void setAttribute(PluginCall call) {
    	//Log.d(TAG, "eGCapacitorPlugin::setAttribute:PluginCall:::"+call);
    	String key =  call.getString("key");
    	//Log.d(TAG, "eGCapacitorPlugin::setAttribute:PluginCall::name:"+key);
    	String value =  call.getString("value");
    	//Log.d(TAG, "eGCapacitorPlugin::setAttribute:PluginCall::name:"+value);
    	eGAndroidAgent.setAttribute(key, value);
    	call.resolve();
    }
    
    @PluginMethod
    public void getUserInfo(PluginCall call) {
    	//Log.e(TAG, "eGCapacitorPlugin::getUserInfo:PluginCall:::"+call);
    	JSObject ret = new JSObject();
        ret.put("getUserInfo", MobileAgentUpload.getUserInfo());
    	call.resolve(ret);
		//Log.e(TAG, "eGCapacitorPlugin::getUserInfo:ret:::"+ret);
	}
    

}
