import 'package:flutter/material.dart';
import 'package:eginnovations/src/eginnovations_plugin.dart';

class eGNavigatorObserver extends NavigatorObserver {
  final List<Route> _steps = <Route>[];

  void screenChanged(Route newRoute) {
    try {
      // If there is a step that hasn't been pushed yet
      if (_steps.isNotEmpty) {
        // Report the last step and remove it from the list
        EginnovationsPlugin.reportScreenChange(
          _steps[_steps.length - 1].settings.name.toString(),
        );
        _steps.remove(_steps[_steps.length - 1]);
      }
      // Add the new step to the list
      _steps.add(newRoute);
      Future<dynamic>.delayed(const Duration(milliseconds: 1000), () {
        // If this route is in the array, report it and remove it from the list
        if (_steps.contains(newRoute)) {
          EginnovationsPlugin.reportScreenChange(
              newRoute.settings.name.toString());
          _steps.remove(newRoute);
        }
      });
    } catch (e) {
      debugPrint('[eGInnovation] - Reporting screen failed');
    }
  }

  @override
  void didPop(Route route, Route? previousRoute) {
    if (previousRoute != null) {
      screenChanged(previousRoute);
    }
  }

  @override
  void didPush(Route route, Route? previousRoute) {
    screenChanged(route);
  }
}




  // @override
  // void didPush(Route<dynamic> route, Route<dynamic>? previousRoute) {
  //   super.didPush(route, previousRoute);
  //   if (route is PageRoute) {
  //     // screenChanged(route);
  //     _reportRoute(route);
  //   }
  // }

  // @override
  // void didReplace({Route<dynamic>? newRoute, Route<dynamic>? oldRoute}) {
  //   super.didReplace(newRoute: newRoute, oldRoute: oldRoute);
  //   if (newRoute is PageRoute) {
  //     // screenChanged(newRoute);
  //     _reportRoute(newRoute);
  //   }
  // }

  // @override
  // void didPop(Route<dynamic> route, Route<dynamic>? previousRoute) {
  //   super.didPop(route, previousRoute);
  //   if (previousRoute is PageRoute && route is PageRoute) {
  //     // screenChanged(previousRoute);
  //     _reportRoute(previousRoute);
  //   }
  // }

  // void _reportRoute(PageRoute route) {
  //   if (route.settings.name != null) {
  //     // Route has a name and will be reported
  //     // _dynatrace!
  //     //     .enterAction("Navigated to screen ${route.settings.name}")
  //     //     .leaveAction();
  //     // screenChanged(route);
  //     debugPrint(route.settings.name);
  //   } else {
  //     // Logger().d(
  //     //     "Navigation occurred but Route will not be reported as it has no name!",
  //     //     logType: LogType.Info);
  //   }
  // }


// class eGNavigatorObserver extends NavigatorObserver {
//   final EginnovationsPlugin? _eginnovations;

//   /// Constructor for dynatrace navigation observer
//   eGNavigatorObserver() : _eginnovations = EginnovationsPluginI();

//   /// Private constructor which should only be used for testing purpose
//   @visibleForTesting
//   eGNavigatorObserver.private({EginnovationsPlugin? eginnovations})
//       : _eginnovations = eginnovations;

//   @override
//   void didPush(Route<dynamic> route, Route<dynamic>? previousRoute) {
//     super.didPush(route, previousRoute);
//     if (route is PageRoute) {
//       _reportRoute(route);
//       _log('didPush', route, previousRoute);
//     }
//   }

//   @override
//   void didReplace({Route<dynamic>? newRoute, Route<dynamic>? oldRoute}) {
//     super.didReplace(newRoute: newRoute, oldRoute: oldRoute);
//     if (newRoute is PageRoute) {
//       _reportRoute(newRoute);
//       _log('didReplace', oldRoute, newRoute);
//     }
//   }

//   @override
//   void didPop(Route<dynamic> route, Route<dynamic>? previousRoute) {
//     super.didPop(route, previousRoute);
//     if (previousRoute is PageRoute && route is PageRoute) {
//       _reportRoute(previousRoute);
//       _log('pop', route, previousRoute);
//     }
//   }

//   void _reportRoute(PageRoute route) {
//     if (route.settings.name != null) {
//       // Route has a name and will be reported
//       _eginnovations!
//           .enterAction("Navigated to screen ${route.settings.name}")
//           .leaveAction();
//     } else {
//       // Logger().d(
//       //     "Navigation occurred but Route will not be reported as it has no name!",
//       //     logType: LogType.Info);
//     }
//   }

//   void _log(String method, Route? fromRoute, Route? toRoute) {
//     debugPrint(
//         '[Navigator] ${_getPageName(fromRoute)} => ${_getPageName(toRoute)} ($method)');
//   }

//   String _getPageName(dynamic route) {
//     // Because the builder field is not on a common class, we must try dynamically.
//     try {
//       final routeBuilderString = route.builder
//           .toString(); // Example: 'Closure: (BuildContext) => WashingsPage'
//       return routeBuilderString
//           .substring(routeBuilderString.lastIndexOf(' ') + 1);
//     } catch (_) {
//       return 'X';
//     }
//   }
// }

// abstract class eGRootAction implements eGAction {
//   /// Enters a (child) Action with a specified [actionName] on this Action.
//   /// If the given [actionName] is [null] or an empty string, no reporting
//   /// will happen on that [RootAction].
//   eGAction enterAction(String? actionName, {Platform? platform});
// }

// enum Platform {
//   /// Platform identifier for Android
//   Android,

//   /// Platform identifier for iOS
//   iOS
// }

// abstract class eGAction {
//   /// Reports an event with a specified [eventName] (but without any value).
//   void reportEvent(String? eventName, {Platform? platform});

//   /// Reports an int [value] with a specified [valueName].
//   void reportIntValue(String? valueName, int? value, {Platform? platform});

//   /// Reports a double [value] with a specified [valueName].
//   void reportDoubleValue(String? valueName, double? value,
//       {Platform? platform});

//   /// Reports a String [value] with a specified [valueName].
//   void reportStringValue(String? valueName, String? value,
//       {Platform? platform});

//   /// Reports an error with a specified [errorName], [errorCode].
//   void reportError(String? errorName, int? errorCode, {Platform? platform});

//   /// Returns a unique x-dynatrace header for the web request with a specified [url].
//   Future<String> getRequestTag(String url);

//   /// Returns the header key that needs to be added to the web request for user action/purepath correlation.
//   String getRequestTagHeader();

//   /// Returns a webrequest timing object which can be used to measure a web request. Input the [url] of the web request.
//   // Future<WebRequestTiming> createWebRequestTiming(String url);

//   /// Leaves this action.
//   void leaveAction();

//   /// Cancel this action.
//   void cancel();
// }

// class EginnovationsPluginImpl implements EginnovationsPlugin {
//   static EginnovationsPlugin? _instance;
//   final MethodChannel _methodChannel;

//   final Function _startupUpFunction;

//   bool _started = false;
//   bool _crashReporting = true;

//   /// Factory method initializing singelton if not already created
//   factory EginnovationsPluginImpl() {
//     if (_instance == null) {
//       const MethodChannel _methodChannel =
//           MethodChannel('eginnovations_plugin');
//       EginnovationsPluginImpl.private(_methodChannel);
//     }

//     return _instance as EginnovationsPluginImpl;
//   }
// }
