<%
/*******************************************************************************
*	File name		:	ErCrashFault.jsp
*	Purpose			:	Displays the Citrix Overview report
*	Version			:	7.0
*	Author			:	S.Ezhilarasi
*	Creation Date	:	01/Nov/2017 
*******************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "net.sf.json.*" %>
<html>
	<head>
		<title><egui:intnl text="reporter.common.eG Reporter"/> </title>
		<egui:skin ui="reporter"/>
		<meta charset="utf-8">
		<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
		<script src="/final/jquery/jquery.js"></script>
		<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
		<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
		<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
		<script src="/final/reporter/scripts/eg_DateUtil.js"></script>
		<script src="/final/reporter/scripts/er_validator.js"></script>
		<script src="../scripts/<%=script_src%>"></script>
		<script type="text/javascript" src="/final/Highcharts/js/highstock.js"></script>
		<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>
		<script src="../reporter/scripts/ErHighChart.js"></script>
		<script src="../reporter/scripts/ErHighChartBarOverview.js"></script>
		<script src="../reporter/scripts/ErCombineHighCharts.js"></script>
		<script src="../reporter/scripts/ErHighChartColumns.js"></script>
		<script src="../reporter/scripts/ErHighChart_builder.js"></script>
		<%
			session.removeAttribute("htdata");
			String currentDateFormat = strUserDateFormat;
			String isSubmit = (request.getParameter("isSubmit")!=null) ? request.getParameter("isSubmit") : "";
			String favoriteID =  request.getParameter("FavoriteId"); 
			String scheduleID =  request.getParameter("schedule_id"); 
			String fromMenu = null; 
			if(request.getParameter("fromMenu") != null && request.getParameter("fromMenu").toString().equalsIgnoreCase("yes"))
			{
				fromMenu=(String)request.getParameter("fromMenu");
			}
			String isModifyFavorite =  request.getParameter("fromFavoriteModify");
			String isModifySchedule =  request.getParameter("fromScheduleModify");
			String templateCompType =  request.getParameter("templateCompType");
			String erFavorite =  request.getParameter("er_favorite");
			String buttonId =  (request.getParameter("buttonId")!= null)?request.getParameter("buttonId"):"citrixUserExperience";
			String queryStr = (String)ErUtils.prepareQueryString(request.getParameterMap());
			String analysisby = request.getParameter("analysisBy");
			String analysis = request.getParameter("analysis");
			String isAVDSessionHost="no";
			if(request.getParameter("isAVDSessionHost") != null && request.getParameter("isAVDSessionHost").toString().equalsIgnoreCase("yes"))
				isAVDSessionHost="yes";
			String isAvDHostPool="no";
			if(request.getParameter("isAvDHostPool") != null && request.getParameter("isAvDHostPool").toString().equalsIgnoreCase("yes"))
				isAvDHostPool="yes";
			boolean isVDI=false;
			if(templateCompType != null && templateCompType.equalsIgnoreCase("VmVdi_i_server"))
				isVDI=true;
			if(analysisby != null && analysisby.trim().length() > 0 && analysis != null && analysis.trim().length() > 0){
				StringTokenizer strtok = new StringTokenizer(queryStr,"&");
				queryStr = "";
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam.equals("analysisBy") && analysisby != null && analysisby.equalsIgnoreCase("ComponentType"))
					{
						queryStr += "analysisBy=Component"+"&";
					}
					else if(reqparam.equals("analysis"))
					{
						queryStr += "er_site="+value+"&";
					}
					else
						queryStr += reqparam+"="+value+"&";
				}
			}
			String isEnableBack =  ("true".equalsIgnoreCase(request.getParameter("enableBack")))? "true" : "false";
			String er_status =  ("Max".equalsIgnoreCase(request.getParameter("er_status")))? "Max" : "Avg";
			String er_eventTest =  ("SystemEvtLogTest_DDD".equalsIgnoreCase(request.getParameter("er_eventTest")))? "SystemEvtLogTest_DDD" : "AppEvtLogTest_DDD";
			if(isAVDSessionHost.equals("yes") || isAvDHostPool.equals("yes"))
				er_eventTest=er_eventTest.equals("WVDSysEvtLogTest_DDD")?"WVDSysEvtLogTest_DDD":"WVDAppEvtLogTest_DDD";
			ErUtils erUtils = new ErUtils();
			String method="init";
			IniFile inifile;
			Map tRequestMap=new HashMap();
			String columnRowCountPrint="";
			try
			{
				if(method.equalsIgnoreCase("init"))
				{
					inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini",true);
					String componentTypeGroup = inifile.getValue("CitrixXenApp_OverView","componentTypeGroup");
					if(isAVDSessionHost.equals("yes") || isAvDHostPool.equals("yes"))
						componentTypeGroup=inifile.getValue("CitrixXenApp_OverView","seperateReport_WVD_RDS_server");
					List componentTypeGroupList=null;
					ArrayList componentTypeSupports=new ArrayList();
					if(componentTypeGroup != null && componentTypeGroup.trim() != "" && componentTypeGroup.length() > 2)
					{
						componentTypeGroupList = Arrays.asList(componentTypeGroup.split(","));
					}
					List v_components= UBean.getAllUserComponents(3);
					if(componentTypeGroupList!=null && templateCompType!=null && !componentTypeGroupList.contains(templateCompType))
					{
						templateCompType = null;
					}
					if(templateCompType==null || templateCompType.length()==0)
					{
						int index = 9999;
						for(int v=0;v<v_components.size();v++)
						{
							String eachCompType=(String)v_components.get(v);
							if(eachCompType != null && eachCompType.indexOf(":") != -1)
							{
								eachCompType=eachCompType.substring(eachCompType.lastIndexOf(":")+1);
								if(componentTypeGroupList.contains(eachCompType))
								{
									componentTypeSupports.add(eachCompType);
									int ind = componentTypeGroupList.indexOf(eachCompType);
									if(index>=ind)
									{
										index = ind;
									}
								}
							}
						}
						if(index != 9999)
						{
							templateCompType = (String)componentTypeGroupList.get(index);
						}
					}
					String typSub = templateCompType+"_OverView_detail";
					if(templateCompType.equalsIgnoreCase("Citrix_XcXenApp_server"))
					{
						typSub = "CitrixXenApp_OverView_detail";
					}
					List vList = new ArrayList(Arrays.asList(inifile.getVariables("CitrixXenApp_OverView")));
					List vList_Type=new ArrayList(Arrays.asList(inifile.getVariables(templateCompType+"_OverView")));
					vList.addAll(vList_Type);
					List vListDetail=new ArrayList(Arrays.asList(inifile.getVariables(typSub)));
					String vname=null;
					for(int v=0;v<vList.size();v++)
					{
						vname=(String)vList.get(v);
						String vnameVal=inifile.getValue("CitrixXenApp_OverView",vname);
						if(vnameVal==null || vnameVal.length()==0)
						{
							vnameVal=inifile.getValue(templateCompType+"_OverView",vname);
						}
						if(vname != null && vname.indexOf("orderDetail") != -1)
						{
							try
							{
								JSONArray orderDetailArry=(JSONArray)JSONSerializer.toJSON(vnameVal);
								tRequestMap.put(vname,orderDetailArry);
							}
							catch(Exception e)
							{
								//System.out.println("===convertexception===>>>>>>>"+e);
								e.printStackTrace();
							}
						}
						else
						{
							
							tRequestMap.put(vname,vnameVal);
						}
					}
					for(int d=0;d<vListDetail.size();d++)
					{
						vname=(String)vListDetail.get(d);
						tRequestMap.put(vname,inifile.getValue(typSub,vname));
					}
				}
				//System.out.println("===tRequestMap==11>>>>>>>>>>>>>>"+tRequestMap);
				session.setAttribute("tRequestMap",tRequestMap);
				columnRowCountPrint=(String)tRequestMap.get("columnRowCountPrint");
				ErCitrixOverviewBean overviewBean=new ErCitrixOverviewBean();
				overviewBean.setRequestMap(tRequestMap);
	
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

			
		%>
		<script>
			var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
			var currentDateFormat='<%=currentDateFormat%>';
			var requestId='';
			var requestCount=0;
			var totalPanelCount=0;
			var appConstants = new Object();
			appConstants.forGrdReportConfirmMsg = '<%=trackerMappingInfo.getTextDescription("reporter.common.Foreground report generation will take some time Do you want to proceed?")%>';
			appConstants.erUtils = null;
			appConstants.defaultLoadData = null;
			appConstants.LoadingMask = null;
			appConstants.appController = null;
			appConstants.appObj = null;
			appConstants.favoriteID ='<%=favoriteID%>';
			appConstants.scheduleID ='<%=scheduleID%>';
			appConstants.fromMenu ='<%=fromMenu%>';
			appConstants.isModifyFavorite = '<%=isModifyFavorite%>';
			appConstants.isModifySchedule = '<%=isModifySchedule%>';
			appConstants.erFavorite = '<%=erFavorite%>';
			appConstants.er_status = '<%=er_status%>';
			appConstants.er_eventTest = '<%=er_eventTest%>';
			appConstants.isSubmit = '<%=isSubmit%>';
			appConstants.buttonId = '<%=buttonId%>';
			appConstants.isAVDSessionHost = '<%=isAVDSessionHost%>';
			appConstants.isAvDHostPool = '<%=isAvDHostPool%>';
			appConstants.isEnableBack = true;
			appConstants.isShowSubmitBtn = true;
			appConstants.siteOrDirectoryLabel = '<%=trackerMappingInfo.getTextDescription("reporter.common.Sites/ Director")%>';
			appConstants.columnRowCountPrint = '<%=columnRowCountPrint%>';
			appConstants.queryStr = '<%=queryStr.replace("\\","\\\\")%>';
			var userExpText='<%=trackerMappingInfo.getTextDescription("reporter.common.USER EXPERIENCE")%>';
			var sessionText='<%=trackerMappingInfo.getTextDescription("reporter.common.SESSIONS")%>';
			var applicationText='<%=trackerMappingInfo.getTextDescription("reporter.common.APPLICATIONS")%>';
			var eventsText='<%=trackerMappingInfo.getTextDescription("reporter.common.EVENTS")%>';
			var serverText='<%=trackerMappingInfo.getTextDescription("reporter.common.SERVERS")%>';
			var serverDesktopText='<%=trackerMappingInfo.getTextDescription("reporter.common.SERVERS/ DESKTOP")%>';
			var licenseText='<%=trackerMappingInfo.getTextDescription("reporter.common.LICENSE")%>';
			var XenAppComponentsText='<%=trackerMappingInfo.getTextDescription("reporter.common.Components")%>';
			var hostPoolText='<%=trackerMappingInfo.getTextDescription("reporter.common.Host Pool")%>';
			var sessionHostsText='<%=trackerMappingInfo.getTextDescription("reporter.common.Session Hosts")%>';
			var selectionsText='<%=trackerMappingInfo.getTextDescription("reporter.common.Selections")%>';
			var settingsText='<%=trackerMappingInfo.getTextDescription("reporter.common.Settings")%>';
			var logonAsSlow='<%=trackerMappingInfo.getTextDescription("reporter.common.Consider Logons as Slow beyond")%>';
			var lanchesAsSlow='<%=trackerMappingInfo.getTextDescription("reporter.common.Consider Launches as Slow beyond")%>';
			var exportAllwidget='<%=trackerMappingInfo.getTextDescription("reporter.common.Export All Widgets")%>';
			var displayDomainUser='<%=trackerMappingInfo.getTextDescription("reporter.common.Display User Domain")%>';
			var Average='<%=trackerMappingInfo.getTextDescription("reporter.common.Average")%>';
			var Maximum='<%=trackerMappingInfo.getTextDescription("reporter.common.Maximum")%>';
			if(appConstants.isAvDHostPool != undefined && appConstants.isAvDHostPool == 'yes')
			{
				appConstants.siteOrDirectoryLabel = '<%=trackerMappingInfo.getTextDescription("reporter.common.Microsoft AVD Broker")%>';
				serverText='<%=trackerMappingInfo.getTextDescription("reporter.common.HOST POOL")%>';
			}
			if(appConstants.isAVDSessionHost != undefined && appConstants.isAVDSessionHost == 'yes')
				serverText='<%=trackerMappingInfo.getTextDescription("reporter.common.SESSION HOSTS")%>';;
			if((appConstants.isModifyFavorite.toUpperCase() == 'YES') || (appConstants.isModifySchedule.toUpperCase() == 'YES'))
			{
				appConstants.isShowSubmitBtn = false;
			}
			if('true'=='<%=isEnableBack.toLowerCase()%>')
			{
				appConstants.isEnableBack = false;
			}
			function reportForHighChart(id,detailData)
			{
				var chartData = {};
				chartData = jQuery.extend(true, {}, getHighChartsBarInstance(id,"",""), chartData);
				chartData.setData(detailData,'<%=currentDateFormat%>','');
				chartData.drawChart();		
			}
			function linkURL(urlKey)
			{
				//alert("===urlKey==123>>>>>>>>>"+urlKey)
				var QString = urlKey;
				if(QString != 'undefined')
				{
					//alert("11111111==>>"+QString);
					document.location=QString;
				}
			}
		</script>
		<egui:loadApp baseDir="/final/reporter/scripts" appName="CitrixOverviewApp" appFile="app.js"/>
		<script>
			Ext.onReady(function(){
				Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			});
		</script>
	</head>
</html>