<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String user_command=request.getParameter("user_command");
	String s_component_types=request.getParameter("s_component_types");
	String s_components=request.getParameter("s_components");

	JSONObject rootJson = new JSONObject();

	JSONArray compTypeOpts = new JSONArray();
	JSONArray compOpts = new JSONArray();

	boolean notApplicable=false;
	String selectedComponentType="-1";
	List componentTypes=new ArrayList();
	List components=u_ser.getServers(false);
	IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_containerapps.ini");
	if(inifile != null)
	{
		Vector contApps=inifile.getVariables("Container_Applications",true);
		if(contApps != null)
		{
			components.removeAll(contApps);
		}
	}
	inifile=null;
	for(int i=0;i<components.size();i++)
	{
		String type=(String)components.get(i);
		type=type.substring(0,type.indexOf(":"));
		if(!componentTypes.contains(type))
		{
			componentTypes.add(type);
		}
	}
	if(componentTypes != null && !componentTypes.isEmpty())
	{
		JSONObject jOpt = new JSONObject();
		EgName nameObj = null;
		MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
		ArrayList serverList = sorter.getSortedCompTypeList(componentTypes);
		for(int i=0;i<serverList.size();i++)
		{
			nameObj = (EgName)serverList.get(i);
			String componentType = nameObj.getActualName();
			if(componentType.startsWith("Agg_") || componentType.equals("Host_system"))
				continue;
			if(selectedComponentType.equals("-1"))
			{
				selectedComponentType=componentType;
			}
			String displayname = nameObj.getLocalName();
			jOpt.put("displayField",displayname);
			jOpt.put("valueField",componentType);
			compTypeOpts.add(jOpt);
		}
	}
	else
	{
		JSONObject jOpt = new JSONObject();
		jOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol.Not Applicable"));
		jOpt.put("valueField","-1");
		compTypeOpts.add(jOpt);
		notApplicable=true;
	}
	rootJson.put("componentTypes",compTypeOpts);
	rootJson.put("selectedComponentType",selectedComponentType);

	String selectedComponent="-1";
	if(s_component_types != null && s_component_types.trim().length()>0 && !s_component_types.equalsIgnoreCase("null") && !s_component_types.equalsIgnoreCase("-1"))
	{
		Set alreadyAdded=new TreeSet();
		EgDiscInfo discObj = new EgDiscInfo("manager");
		Hashtable htt = discObj.getIpNickMap();
		Hashtable nickIpMap = discObj.getNickIpMap();
		ArrayList compTypeList = StringUtils.myTokenizer(s_component_types,",");
		if(components != null && !components.isEmpty())
		{
			JSONObject compOpt = new JSONObject();
			ArrayList compList = new ArrayList();
			compList.addAll(components);
			ArrayList tempList = new ArrayList();
			Hashtable hostnames = new com.egurkha.admin.WVDHostnames().getWVDHostnames();
			Set keys=hostnames.keySet();
			for(int i=compList.size()-1;i>=0;i--)
			{
				String wvdComp=(String)compList.get(i);
				if(wvdComp.startsWith("WVD_RDS_server:"))
				{
					compList.remove(i);
					int idx=wvdComp.indexOf(":");
					int lidx=wvdComp.lastIndexOf(":");
					String wvdCompNick=wvdComp.substring(idx+1,lidx);
					ArrayList alist = (ArrayList)hostnames.get(wvdCompNick);
					if(alist != null)
					{
						for(int n=0;n<alist.size();n++)
						{
							String host_name=(String)alist.get(n);
							tempList.add("WVD_RDS_server:"+wvdCompNick+" - "+host_name+":NULL");
						}
					}
				}
			}
			if(!tempList.isEmpty())
			{
				compList.addAll(tempList);
			}
			Collections.sort(compList,String.CASE_INSENSITIVE_ORDER);
			for(int i=0;i<compList.size();i++)
			{
				String compNow = (String)compList.get(i);
				int idx = compNow.indexOf(":");
				String typeNow = compNow.substring(0,idx);
				if(typeNow.startsWith("Agg_") || !compTypeList.contains(typeNow))
				{
					continue;
				}
				String nickPort=compNow.substring(idx+1);
				if(nickPort.endsWith(":NULL"))
				{
					nickPort=nickPort.substring(0,nickPort.lastIndexOf(":"));
				}
				if(!compNow.startsWith("WVD_RDS_server:"))
				{
					String onlyNick=nickPort;
					idx=onlyNick.indexOf(":");
					if(idx>-1)
					{
						onlyNick=onlyNick.substring(0,idx);
					}
	//				if(EgStateManager.notRunningAgents.contains(onlyNick))
	//				{
	//					continue;
	//				}
					String ipAssociated=(String)nickIpMap.get(onlyNick);
					if(ipAssociated == null)
					{
						continue;
					}
					if(ipAssociated != null && (alreadyAdded.contains(ipAssociated) || alreadyAdded.contains(onlyNick)))
					{
						continue;
					}
					alreadyAdded.add(ipAssociated);
					if(htt.containsKey(ipAssociated))
					{
						String otherNicks = (String)htt.get(ipAssociated);
						ArrayList tokens=StringUtils.myTokenizer(otherNicks,":");
						alreadyAdded.addAll(tokens);
					}
				}
				if(selectedComponent.equals("-1"))
				{
					selectedComponent=compNow;
				}
				compOpt.put("displayField",nickPort);
				compOpt.put("valueField",compNow);
				compOpts.add(compOpt);
			}
		}
	}
	if(compOpts.size()==0)
	{
		JSONObject compOpt = new JSONObject();
		if(notApplicable)
		{
			compOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol.Not Applicable"));
		}
		else
		{
			compOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol.Select component type(s)"));
		}
		compOpt.put("valueField","-1");
		compOpts.add(compOpt);
	}
	rootJson.put("components",compOpts);
	rootJson.put("selectedComponent",selectedComponent);

	JSONArray yesNoOpts = new JSONArray();

	JSONObject yesOpt = new JSONObject();
	yesOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol.Yes"));
	yesOpt.put("valueField","Y");
	yesNoOpts.add(yesOpt);
	JSONObject noOpt = new JSONObject();
	noOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol.No"));
	noOpt.put("valueField","N");
	yesNoOpts.add(noOpt);
	rootJson.put("yesNoOpts",yesNoOpts);
	rootJson.put("executeAllCommands",new Boolean(u_ser.getRCExecuteAllCommands()));
	response.getWriter().write(rootJson.toString());
%>




