require.def("preview/requestList",["domplate/domplate","core/lib","i18n!nls/requestList","preview/harModel","core/cookies","preview/requestBody","domplate/infoTip","domplate/popupMenu"],function(Domplate,Lib,Strings,HarModel,Cookies,RequestBody,InfoTip,Menu){with(Domplate){function RequestList(input){this.input=input;
this.pageTimings=[];this.addPageTiming({name:"onContentLoad",classes:"netContentLoadBar",description:Strings["ContentLoad"]});this.addPageTiming({name:"onLoad",classes:"netWindowLoadBar",description:Strings["WindowLoad"]});InfoTip.addListener(this);}RequestList.columns=["url","status","type","domain","size","timeline"];
RequestList.defaultColumns=["url","status","size","timeline"];RequestList.getVisibleColumns=function(){var cols=Cookies.getCookie("previewCols");if(cols){cols=cols.replace(/\+/g," ");cols=unescape(cols);return cols.split(" ");}if(!cols){var content=document.getElementById(elementId);if(content){cols=content.getAttribute("previewCols");
if(cols){return cols.split(" ");}}}return Lib.cloneArray(RequestList.defaultColumns);};RequestList.setVisibleColumns=function(cols,avoidCookies){if(!cols){cols=RequestList.getVisibleColumns();}if(cols.join){cols=cols.join(" ");}var content="";if(elementId!=""&&elementId=="content"){content=document.getElementById(elementId);
}if(content){content.setAttribute("previewCols",cols);}if(!avoidCookies){Cookies.setCookie("previewCols",cols);}};RequestList.setVisibleColumns();RequestList.prototype=domplate({tableTag:TABLE({"class":"netTable",cellpadding:0,cellspacing:0,onclick:"$onClick",_repObject:"$requestList"},TBODY(TR({"class":"netSizerRow"},TD({"class":"netHrefCol "+netCol,width:"20%"}),TD({"class":"netStatusCol "+netCol,width:"8%"}),TD({"class":"netTypeCol "+netCol,width:"7%"}),TD({"class":"netDomainCol "+netCol,width:"7%"}),TD({"class":"netSizeCol "+netCol,width:"13%"}),TD({"class":"netTimeCol "+netCol,width:"100%"})))),fileTag:FOR("file","$files",TR({"class":netRow,$isExpandable:"$file|isExpandable",$responseError:"$file|isError",$responseRedirect:"$file|isRedirect",$fromCache:"$file|isFromCache"},TD({"class":"netHrefCol "+netCol},DIV({"class":"netHrefLabel netLabel",style:"margin-left: $file|getIndent\\px"},"$file|getHref"),DIV({"class":netFullHrefLabel+" netHrefLabel netLabel",style:"margin-left: $file|getIndent\\px"},"$file|getFullHref")),TD({"class":"netStatusCol "+netCol},DIV({"class":"netStatusLabel netLabel"},"$file|getStatus")),TD({"class":"netTypeCol "+netCol},DIV({"class":"netTypeLabel netLabel"},"$file|getType")),TD({"class":"netDomainCol "+netCol},DIV({"class":"netDomainLabel netLabel"},"$file|getDomain")),TD({"class":"netSizeCol "+netCol},DIV({"class":"netSizeLabel netLabel"},"$file|getSize")),TD({"class":"netTimeCol "+netCol},DIV({"class":"netTimelineBar"},"&nbsp;",DIV({"class":"netBlockingBar netBar"}),DIV({"class":"netResolvingBar netBar"}),DIV({"class":"netConnectingBar netBar"}),DIV({"class":"netSendingBar netBar"}),DIV({"class":"netWaitingBar netBar"}),DIV({"class":"netReceivingBar netBar"},SPAN({"class":"netTimeLabel"},"$file|getElapsedTime")))),TD({"class":"netOptionsCol "+netCol},DIV({"class":"netOptionsLabel netLabel",onclick:"$onOpenOptions"})))),headTag:TR({"class":"netHeadRow"},TD({"class":"netHeadCol",colspan:7},DIV({"class":"netHeadLabel"},"$doc.rootFile.href"))),netInfoTag:TR({"class":"netInfoRow"},TD({"class":"netInfoCol",colspan:7})),summaryTag:TR({"class":netSummaryRow},TD({"class":"netHrefCol "+netCol},DIV({"class":"netCountLabel netSummaryLabel"},"-")),TD({"class":"netStatusCol "+netCol}),TD({"class":"netTypeCol "+netCol}),TD({"class":"netDomainCol "+netCol}),TD({"class":"netTotalSizeCol netSizeCol "+netCol},DIV({"class":"netTotalSizeLabel netSummaryLabel"},"0KB")),TD({"class":"netTotalTimeCol netTimeCol "+netCol},DIV({"class":"",style:"width: 100%"},DIV({"class":"netCacheSizeLabel netSummaryLabel"},"(",SPAN("0KB"),SPAN(" "+Strings.fromCache),")"),DIV({"class":"netTimeBar"},SPAN({"class":"netTotalTimeLabel netSummaryLabel"},"0ms")))),TD({"class":"netOptionsCol netCol"})),getIndent:function(file){return 0;
},isError:function(file){var errorRange=Math.floor(file.response.status/100);return errorRange==4||errorRange==5;},isRedirect:function(file){return false;},isFromCache:function(file){return file.cache&&file.cache.afterRequest;},getHref:function(file){var fileName=Lib.getFileName(this.getFullHref(file));
return unescape(file.request.method+" "+fileName);},getFullHref:function(file){return unescape(file.request.url);},getStatus:function(file){var status=file.response.status>0?(file.response.status+" "):"";return status+file.response.statusText;},getType:function(file){return file.response.content.mimeType;
},getDomain:function(file){return Lib.getPrettyDomain(file.request.url);},getSize:function(file){var bodySize=file.response.bodySize;var size=(bodySize&&bodySize!=-1)?bodySize:file.response.content.size;return this.formatSize(size);},isExpandable:function(file){var hasHeaders=file.response.headers.length>0;
var hasDataURL=file.request.url.indexOf("data:")==0;return hasHeaders||hasDataURL;},formatSize:function(bytes){return Lib.formatSize(bytes);},getElapsedTime:function(file){return Lib.formatTime(file.time);},onClick:function(event){var e=Lib.fixEvent(event);if(Lib.isLeftClick(event)){var row=Lib.getAncestorByClass(e.target,"netRow");
if(row){this.toggleHeadersRow(row);Lib.cancelEvent(event);}}else{if(Lib.isControlClick(event)){window.open(event.target.innerText||event.target.textContent);}}},toggleHeadersRow:function(row){if(!Lib.hasClass(row,"isExpandable")){return;}var file=row.repObject;Lib.toggleClass(row,"opened");if(Lib.hasClass(row,"opened")){var netInfoRow=this.netInfoTag.insertRows({},row)[0];
netInfoRow.repObject=file;var requestBody=new RequestBody();requestBody.render(netInfoRow.firstChild,file);}else{var netInfoRow=row.nextSibling;var netInfoBox=Lib.getElementByClass(netInfoRow,"netInfoBody");row.parentNode.removeChild(netInfoRow);}},onOpenOptions:function(event){var e=Lib.fixEvent(event);
Lib.cancelEvent(event);if(!Lib.isLeftClick(event)){return;}var target=e.target;var row=Lib.getAncestorByClass(target,"netRow");var items=this.getMenuItems(row);if(!items.length){return;}var menu=new Menu({id:"requestContextMenu",items:items});menu.showPopup(target);},getMenuItems:function(row){var file=row.repObject;
var phase=row.phase;var disableBreakLayout=(phase.files[0]==file&&this.phases[0]==phase);var items=[{label:Strings.menuBreakTimeline,type:"checkbox",disabled:disableBreakLayout,checked:phase.files[0]==file&&!disableBreakLayout,command:Lib.bind(this.breakLayout,this,row)},"-",{label:Strings.menuOpenRequest,command:Lib.bind(this.openRequest,this,file)},{label:Strings.menuOpenResponse,disabled:!file.response.content.text,command:Lib.bind(this.openResponse,this,file)}];
Lib.dispatch(this.listeners,"getMenuItems",[items,this.input,file]);return items;},openRequest:function(event,file){window.open(file.request.url);},openResponse:function(event,file){var response=file.response.content.text;var mimeType=file.response.content.mimeType;var encoding=file.response.content.encoding;
var url="data:"+(mimeType?mimeType:"")+";"+(encoding?encoding:"")+","+response;window.open(url);},breakLayout:function(event,row){var file=row.repObject;var phase=row.phase;var layoutBroken=phase.files[0]==file;row.breakLayout=!layoutBroken;row.setAttribute("breakLayout",row.breakLayout?"true":"false");
var netTable=Lib.getAncestorByClass(row,"netTable");var page=HarModel.getParentPage(this.input,file);this.updateLayout(netTable,page);},updateLayout:function(table,page){var requests=HarModel.getPageEntries(this.input,page);this.table=table;var tbody=this.table.firstChild;var row=this.firstRow=tbody.firstChild.nextSibling;
this.phases=[];var phaseInterval=Cookies.getCookie("phaseInterval");if(!phaseInterval){phaseInterval=4000;}var phase=null;var pageStartedDateTime=page?Lib.parseISO8601(page.startedDateTime):null;var onLoadTime=(page&&page.pageTimings)?page.pageTimings["onLoad"]:-1;if(onLoadTime>0){onLoadTime+=pageStartedDateTime;
}for(var i=0;i<requests.length;i++){var file=requests[i];if(Lib.hasClass(row,"netInfoRow")){row=row.nextSibling;}row.repObject=file;if(!pageStartedDateTime){pageStartedDateTime=Lib.parseISO8601(file.startedDateTime);}var startedDateTime=Lib.parseISO8601(file.startedDateTime);var phaseLastStartTime=phase?Lib.parseISO8601(phase.getLastStartTime()):0;
var phaseEndTime=phase?phase.endTime:0;var newPhase=false;if(phaseInterval>=0){newPhase=(startedDateTime>onLoadTime)&&((startedDateTime-phaseLastStartTime)>=phaseInterval)&&(startedDateTime+file.time>=phaseEndTime+phaseInterval);}if(typeof(row.breakLayout)=="boolean"){if(!phase||row.breakLayout){phase=this.startPhase(file);
}else{phase.addFile(file);}}else{if(!phase||newPhase){phase=this.startPhase(file);}else{phase.addFile(file);}}if(this.phases[0]!=phase){row.setAttribute("breakLayout",(phase.files[0]==file)?"true":"false");}if(phase.startTime==undefined||phase.startTime>startedDateTime){phase.startTime=startedDateTime;
}if(phase.endTime==undefined||phase.endTime<startedDateTime+file.time){phase.endTime=startedDateTime+file.time;}row=row.nextSibling;}this.updateTimeStamps(page);this.updateTimeline(page);this.updateSummaries(page);},startPhase:function(file){var phase=new Phase(file);this.phases.push(phase);return phase;
},calculateFileTimes:function(page,file,phase){if(phase!=file.phase){phase=file.phase;this.phaseStartTime=phase.startTime;this.phaseEndTime=phase.endTime;this.phaseElapsed=this.phaseEndTime-phase.startTime;}if(!file.timings){return phase;}var blocking=((file.timings.blocked<0)?0:file.timings.blocked);
var resolving=blocking+((file.timings.dns<0)?0:file.timings.dns);var connecting=resolving+((file.timings.connect<0)?0:file.timings.connect);var sending=connecting+((file.timings.send<0)?0:file.timings.send);var waiting=sending+((file.timings.wait<0)?0:file.timings.wait);var receiving=waiting+((file.timings.receive<0)?0:file.timings.receive);
var elapsed=file.time;var startedDateTime=Lib.parseISO8601(file.startedDateTime);this.barOffset=(((startedDateTime-this.phaseStartTime)/this.phaseElapsed)*100).toFixed(3);this.barBlockingWidth=((blocking/this.phaseElapsed)*100).toFixed(3);this.barResolvingWidth=((resolving/this.phaseElapsed)*100).toFixed(3);
this.barConnectingWidth=((connecting/this.phaseElapsed)*100).toFixed(3);this.barSendingWidth=((sending/this.phaseElapsed)*100).toFixed(3);this.barWaitingWidth=((waiting/this.phaseElapsed)*100).toFixed(3);this.barReceivingWidth=((receiving/this.phaseElapsed)*100).toFixed(3);this.calculatePageTimings(page,file,phase);
return phase;},calculatePageTimings:function(page,file,phase){if(!page){return;}var pageStart=Lib.parseISO8601(page.startedDateTime);for(var i=0;i<phase.pageTimings.length;i++){var time=phase.pageTimings[i].time;if(time>0){var timeOffset=pageStart+time-phase.startTime;var barOffset=((timeOffset/this.phaseElapsed)*100).toFixed(3);
phase.pageTimings[i].offset=barOffset;}}},updateTimeline:function(page){var tbody=this.table.firstChild;var phase;for(var row=this.firstRow;row;row=row.nextSibling){var file=row.repObject;if(!file){continue;}if(Lib.hasClass(row,"netInfoRow")){continue;}phase=this.calculateFileTimes(page,file,phase);row.phase=file.phase;
delete file.phase;var timelineBar=Lib.getElementByClass(row,"netTimelineBar");var blockingBar=timelineBar.children[0];var resolvingBar=blockingBar.nextSibling;var connectingBar=resolvingBar.nextSibling;var sendingBar=connectingBar.nextSibling;var waitingBar=sendingBar.nextSibling;var receivingBar=waitingBar.nextSibling;
blockingBar.style.left=connectingBar.style.left=resolvingBar.style.left=sendingBar.style.left=waitingBar.style.left=receivingBar.style.left=this.barOffset+"%";blockingBar.style.width=this.barBlockingWidth+"%";resolvingBar.style.width=this.barResolvingWidth+"%";connectingBar.style.width=this.barConnectingWidth+"%";
sendingBar.style.width=this.barSendingWidth+"%";waitingBar.style.width=this.barWaitingWidth+"%";receivingBar.style.width=this.barReceivingWidth+"%";var bars=Lib.getElementsByClass(timelineBar,"netPageTimingBar");for(var i=0;i<bars.length;i++){bars[i].parentNode.removeChild(bars[i]);}for(var i=0;i<phase.pageTimings.length;
i++){var timing=phase.pageTimings[i];if(!timing.offset){continue;}var bar=timelineBar.ownerDocument.createElement("DIV");timelineBar.appendChild(bar);if(timing.classes){Lib.setClass(bar,timing.classes);}Lib.setClass(bar,"netPageTimingBar netBar");bar.style.left=timing.offset+"%";bar.style.display="block";
timing.offset=null;}}},updateTimeStamps:function(page){if(!page){return;}var pageTimings=[];for(var i=0;page.pageTimings&&i<this.pageTimings.length;i++){var timing=this.pageTimings[i];var eventTime=page.pageTimings[timing.name];if(eventTime>0){pageTimings.push({label:timing.name,time:eventTime,classes:timing.classes,comment:timing.description});
}}var timeStamps=page.pageTimings?page.pageTimings._timeStamps:[];if(timeStamps){pageTimings.push.apply(pageTimings,timeStamps);}var phases=this.phases;for(var i=0;i<phases.length;i++){var phase=phases[i];var nextPhase=phases[i+1];for(var j=0;j<pageTimings.length;j++){var stamp=pageTimings[j];var time=stamp.time;
if(!time){continue;}var startedDateTime=Lib.parseISO8601(page.startedDateTime);time+=startedDateTime;if(!nextPhase||time<nextPhase.startTime){if(i==0||time>=phase.startTime){if(phase.startTime>time){phase.startTime=time;}if(phase.endTime<time){phase.endTime=time;}phase.pageTimings.push({classes:stamp.classes?stamp.classes:"netTimeStampBar",name:stamp.label,description:stamp.comment,time:stamp.time});
}}}}},updateSummaries:function(page){var phases=this.phases;var fileCount=0,totalSize=0,cachedSize=0,totalTime=0;for(var i=0;i<phases.length;++i){var phase=phases[i];phase.invalidPhase=false;var summary=this.summarizePhase(phase);fileCount+=summary.fileCount;totalSize+=summary.totalSize;cachedSize+=summary.cachedSize;
totalTime+=summary.totalTime;}var row=this.summaryRow;if(!row){return;}var countLabel=Lib.getElementByClass(row,"netCountLabel");countLabel.firstChild.nodeValue=this.formatRequestCount(fileCount);var sizeLabel=Lib.getElementByClass(row,"netTotalSizeLabel");sizeLabel.setAttribute("totalSize",totalSize);
sizeLabel.firstChild.nodeValue=Lib.formatSize(totalSize);var cacheSizeLabel=Lib.getElementByClass(row,"netCacheSizeLabel");cacheSizeLabel.setAttribute("collapsed",cachedSize==0);cacheSizeLabel.childNodes[1].firstChild.nodeValue=Lib.formatSize(cachedSize);var timeLabel=Lib.getElementByClass(row,"netTotalTimeLabel");
var timeText=Lib.formatTime(totalTime);if(page&&page.pageTimings.onLoad>0){timeText+=" (onload: "+Lib.formatTime(page.pageTimings.onLoad)+")";}timeLabel.innerHTML=timeText;},formatRequestCount:function(count){return count+" "+(count==1?Strings.request:Strings.requests);},summarizePhase:function(phase){var cachedSize=0,totalSize=0;
var category="all";if(category=="all"){category=null;}var fileCount=0;var minTime=0,maxTime=0;for(var i=0;i<phase.files.length;i++){var file=phase.files[i];var startedDateTime=Lib.parseISO8601(file.startedDateTime);if(!category||file.category==category){++fileCount;var bodySize=file.response.bodySize;
var size=(bodySize&&bodySize!=-1)?bodySize:file.response.content.size;totalSize+=size;if(file.response.status==304){cachedSize+=size;}if(!minTime||startedDateTime<minTime){minTime=startedDateTime;}var fileEndTime=startedDateTime+file.time;if(fileEndTime>maxTime){maxTime=fileEndTime;}}}var totalTime=maxTime-minTime;
return{cachedSize:cachedSize,totalSize:totalSize,totalTime:totalTime,fileCount:fileCount};},showInfoTip:function(infoTip,target,x,y){var table=Lib.getAncestorByClass(target,"netTable");if(!table||table.repObject!=this){return;}var row=Lib.getAncestorByClass(target,"netRow");if(row){if(Lib.getAncestorByClass(target,"netBar")){infoTip.setAttribute("multiline",true);
var infoTipURL=row.repObject.startedDateTime+"-nettime";this.infoTipURL=infoTipURL;return this.populateTimeInfoTip(infoTip,row);}else{if(Lib.hasClass(target,"netSizeLabel")){var infoTipURL=row.repObject.startedDateTime+"-netsize";this.infoTipURL=infoTipURL;return this.populateSizeInfoTip(infoTip,row);
}}}},populateTimeInfoTip:function(infoTip,row){EntryTimeInfoTip.render(this,row,infoTip);return true;},populateSizeInfoTip:function(infoTip,row){EntrySizeInfoTip.render(this,row,infoTip);return true;},render:function(parentNode,page){var entries=HarModel.getPageEntries(this.input,page);if(!entries.length){return null;
}return this.append(parentNode,page,entries);},append:function(parentNode,page,entries){if(!this.table){this.table=this.tableTag.replace({requestList:this},parentNode,this);}if(!this.summaryRow){this.summaryRow=this.summaryTag.insertRows({},this.table.firstChild)[0];}var tbody=this.table.firstChild;var lastRow=tbody.lastChild.previousSibling;
var result=this.fileTag.insertRows({files:entries},lastRow,this);this.updateLayout(this.table,page);return result[0];},addPageTiming:function(timing){this.pageTimings.push(timing);}});function Phase(file){this.files=[];this.pageTimings=[];this.addFile(file);}Phase.prototype={addFile:function(file){this.files.push(file);
file.phase=this;},getLastStartTime:function(){return this.files[this.files.length-1].startedDateTime;}};var EntryTimeInfoTip=domplate({tableTag:TABLE({"class":"timeInfoTip"},TBODY()),timingsTag:FOR("time","$timings",TR({"class":"timeInfoTipRow",$collapsed:"$time|hideBar"},TD({"class":"$time|getBarClass timeInfoTipBar",$loaded:"$time.loaded",$fromCache:"$time.fromCache"}),TD({"class":"timeInfoTipCell startTime"},"$time.start|formatStartTime"),TD({"class":"timeInfoTipCell elapsedTime"},"$time.elapsed|formatTime"),TD("$time|getLabel"))),startTimeTag:TR(TD(),TD("$startTime.time|formatStartTime"),TD({"class":"timeInfoTipStartLabel","colspan":2},"$startTime|getLabel")),separatorTag:TR({},TD({"class":"timeInfoTipSeparator","colspan":4,"height":"10px"},SPAN("$label"))),eventsTag:FOR("event","$events",TR({"class":"timeInfoTipEventRow"},TD({"class":"timeInfoTipBar",align:"center"},DIV({"class":"$event|getPageTimingClass timeInfoTipEventBar"})),TD("$event.start|formatStartTime"),TD({"colspan":2},"$event|getTimingLabel"))),hideBar:function(obj){return !obj.elapsed&&obj.bar=="request.phase.Blocking";
},getBarClass:function(obj){var className=obj.bar.substr(obj.bar.lastIndexOf(".")+1);return"net"+className+"Bar";},getPageTimingClass:function(timing){return timing.classes?timing.classes:"";},formatTime:function(time){return Lib.formatTime(time);},formatStartTime:function(time){var positive=time>0;var label=Lib.formatTime(Math.abs(time));
if(!time){return label;}return(positive>0?"+":"-")+label;},getLabel:function(obj){return Strings[obj.bar];},getTimingLabel:function(obj){return obj.bar;},render:function(requestList,row,parentNode){var input=requestList.input;var file=row.repObject;var page=HarModel.getParentPage(input,file);var pageStart=page?Lib.parseISO8601(page.startedDateTime):null;
var requestStart=Lib.parseISO8601(file.startedDateTime);var infoTip=EntryTimeInfoTip.tableTag.replace({},parentNode);var startTimeObj={};if(pageStart){startTimeObj.time=requestStart-pageStart;}else{startTimeObj.time=requestStart-row.phase.startTime;}startTimeObj.bar="request.Started";this.startTimeTag.insertRows({startTime:startTimeObj},infoTip.firstChild);
this.separatorTag.insertRows({label:Strings["request.phases.label"]},infoTip.firstChild);var startTime=0;var timings=[];var blocked=file.timings.blocked;var dns=file.timings.dns;var ssl=file.timings.ssl;var connect=file.timings.connect;var send=file.timings.send;var wait=file.timings.wait;var receive=file.timings.receive;
if(blocked>=0){timings.push({bar:"request.phase.Blocking",elapsed:blocked,start:startTime});}if(dns>=0){timings.push({bar:"request.phase.Resolving",elapsed:dns,start:startTime+=(blocked<0)?0:blocked});}if(connect>=0){timings.push({bar:"request.phase.Connecting",elapsed:connect,start:startTime+=(dns<0)?0:dns});
}if(send>=0){timings.push({bar:"request.phase.Sending",elapsed:send,start:startTime+=(connect<0)?0:connect});}if(wait>=0){timings.push({bar:"request.phase.Waiting",elapsed:wait,start:startTime+=(send<0)?0:send});}if(receive>=0){timings.push({bar:"request.phase.Receiving",elapsed:receive,start:startTime+=(wait<0)?0:wait,loaded:file.loaded,fromCache:file.fromCache});
}this.timingsTag.insertRows({timings:timings},infoTip.firstChild);if(!page){return true;}var events=[];for(var i=0;i<row.phase.pageTimings.length;i++){var timing=row.phase.pageTimings[i];events.push({bar:timing.description?timing.description:timing.name,start:pageStart+timing.time-requestStart,classes:timing.classes,time:timing.time});
}if(events.length){events.sort(function(a,b){return(a.time<b.time)?-1:1;});this.separatorTag.insertRows({label:Strings["request.timings.label"]},infoTip.firstChild);this.eventsTag.insertRows({events:events},infoTip.firstChild);}return true;}});var EntrySizeInfoTip=domplate({tag:DIV({"class":"sizeInfoTip"},"$file|getSize"),zippedTag:DIV(DIV({"class":"sizeInfoTip"},"$file|getBodySize"),DIV({"class":"sizeInfoTip"},"$file|getContentSize")),getSize:function(file){var bodySize=file.response.bodySize;
if(bodySize<0){return Strings.unknownSize;}return Lib.formatString(Strings.tooltipSize,Lib.formatSize(bodySize),Lib.formatNumber(bodySize));},getBodySize:function(file){var bodySize=file.response.bodySize;if(bodySize<0){return Strings.unknownSize;}return Lib.formatString(Strings.tooltipZippedSize,Lib.formatSize(bodySize),Lib.formatNumber(bodySize));
},getContentSize:function(file){var contentSize=file.response.content.size;if(contentSize<0){return Strings.unknownSize;}return Lib.formatString(Strings.tooltipUnzippedSize,Lib.formatSize(contentSize),Lib.formatNumber(contentSize));},render:function(requestList,row,parentNode){var input=requestList.input;
var file=row.repObject;if(file.response.bodySize==file.response.content.size){return this.tag.replace({file:file},parentNode);}return this.zippedTag.replace({file:file},parentNode);}});return RequestList;}});