var setIntervalID = [];
Ext.define('vmdatastoretopology.view.Topology',{
	extend: 'Ext.panel.Panel',
	alias: 'widget.topologyPanel',
	//title: 'VMStr',
	trim: function (fullStr, strLen, separator) {
		if (!Ext.isEmpty(fullStr)) {
			if (fullStr.length <= strLen) return fullStr;
			separator = separator || '...';
			var sepLen = separator.length,
				charsToShow = strLen - sepLen,
				frontChars = Math.ceil(charsToShow / 2),
				backChars = Math.floor(charsToShow / 2);
			return fullStr.substr(0, frontChars) + separator + fullStr.substr(fullStr.length -
				backChars);
		}
	},
	zoomScale: [0.3, 1],
	zoomScaleMid: function () {
		var me = this;
		return (me.zoomScale[0] + me.zoomScale[1]) / 2;
	},
	zoom: function () {
		var me = this;
		return d3.zoom().scaleExtent(me.zoomScale);
	},
	constructor: function (config) {
		this.initConfig(config);
		this.callParent(arguments);
	},
	config: {
		topoData: {}
	},
	applyTopoData: function (newValue, oldValue) {
		var me = this;
		return newValue;
	},
	getTopoData: function () {
		var me = this;
		return me.topoData;
	},
	setTopoData: function (newValue, oldValue) {
		var me = this;
		me.topoData = newValue;
		return newValue;
	},
	resize:function(c, newWidth, newHeight, oldWidth, oldHeight)
	{
		var me = this;
		if (!Ext.isEmpty(Ext.get(me.body.id + '-SVG'))) {
			d3.select('#' + me.body.id + '-SVG').attr('height', newHeight).attr(
					'width', newWidth)
				.attr('viewBox', '0 0 ' + newWidth + ' ' + newHeight + '');
			me.scaleGraph(me.svg, me.inner, me.graphRender, me.graphBound(me
				.nodes), newWidth, newHeight);
		}
	},
	initComponent: function () {
		var me = this;
		var data = this.getTopoData();
		/*data = {
				"esx": [{
					id: 'vm',
					state: 'HIGH',
					iconName: 'VM',
					name: 'esx-egmanager0034',
				}],
				"nodes": [{
					id: 'vm',
					state: 'HIGH',
					iconName: 'vm',
					name: 'dev-win0',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]
				}, {
					id: 'store1',
					iconName: 'data-storage',
					state: 'GOOD',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]
				}, {
					id: 'store2',
					state: 'GOOD',
					iconName: 'data-storage',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]
				}, {

					id: 'store3',
					state: 'GOOD',
					iconName: 'data-storage',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]

				}, {

					id: 'store4',
					state: 'GOOD',
					iconName: 'LUN',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]

				}, {

					id: 'store5',
					state: 'GOOD',
					iconName: 'LUN',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]

				}, {

					id: 'store6',
					state: 'GOOD',
					iconName: 'LUN',
					name: 'iscsidatastore',
					measures: [{
							name: 'read latency',
							value: '0.01',
							unit: 's',
							state: 'GOOD'
						},
						{
							name: 'write latency',
							value: '0.01',
							unit: 's',
							state: 'LOW'
						}
					]

				}, {

					id: 'store7',
					state: null,
					iconName: 'HBA',
					name: 'iscsidatastore',
					measures: []

				}, {

					id: 'store8',
					state: null,
					iconName: 'HBA',
					name: 'iscsidatastore',
					measures: []

				}, {

					id: 'store9',
					state: null,
					iconName: 'HBA',
					name: 'iscsidatastore',
					measures: []

				}, {

					id: 'store10',
					state: null,
					iconName: 'storage',
					name: 'iscsidatastore',
					measures: []

				}, {

					id: 'store11',
					state: null,
					iconName: 'storage',
					name: 'iscsidatastore',
					measures: []

				}, {

					id: 'store12',
					state: null,
					iconName: 'storage',
					name: 'iscsidatastore',
					measures: []

				}, {
					id: 'exs',
					state: 'GOOD',
					iconName: 'VIRTUALIZATION_PLATFORMS',
					name: 'esx-egmanager0034',
				}],
				"links": [{
					from: 'vm',
					to: 'store1'
				}, {
					from: 'store1',
					to: 'store4'
				}, {
					from: 'store4',
					to: 'store7'
				}, {
					from: 'store7',
					to: 'store10'
				}, {
					from: 'vm',
					to: 'store2'
				}, {
					from: 'store2',
					to: 'store5'
				}, {
					from: 'store5',
					to: 'store8'
				}, {
					from: 'store8',
					to: 'store11'
				}, {
					from: 'vm',
					to: 'store3'
				}, {
					from: 'store3',
					to: 'store6'
				}, {
					from: 'store6',
					to: 'store9'
				}, {
					from: 'store9',
					to: 'store11'
				}, {
					from: 'store11',
					to: 'store12'
				}]};*/

		me.callParent();
		//rendering
		me.mon(me, 'boxready', function (c) {
			me.renderSvg();
			//..TODO
			me.drawTopology(data, true);			
		});
		//resize
		me.mon(me, 'resize', function (c, newWidth, newHeight, oldWidth, oldHeight) {
			if (!Ext.isEmpty(Ext.get(me.body.id + '-SVG'))) {
				d3.select('#' + me.body.id + '-SVG').attr('height', newHeight).attr(
						'width', newWidth)
					.attr('viewBox', '0 0 ' + newWidth + ' ' + newHeight + '');
				me.scaleGraph(me.svg, me.inner, me.graphRender, me.graphBound(me
					.nodes), newWidth, newHeight);
			}
		});
	},
	d3scale: d3.scaleLinear().domain([0.3, 1]).range([1.8, 1.5]),
	d3sqt: d3.scaleSqrt().domain([0.3, 1]).range([1.1, 1]),
	//setting up zoom
	applyZoom: function (svg, inner, g, translateX, translateY, scale) {
		var me = this;
		var max_font_size = 12;



		svg.call(me.zoom().on("zoom", function () {
			inner.attr("transform", d3.event.transform);
			d3.selectAll('.textGrp').each(function (d, i) {
				//d3.select(this).attr("transform", function (d) {
					//return "translate(" + me.nodes[i].grpX + "," +
						//(me.nodes[i].grpY * me.d3sqt(d3.event.transform.k)) + ")scale(" + me.d3scale(d3.event.transform.k) + ")"
				//})
			})

		}));

		inner.attr("transform", function () {
			return 'translate(' + translateX + ',' + translateY + ')scale(' +
				scale + ')';

		});

	},
	bodyPadding: 0,
	scaleGraph: function (svg, inner, g, bounds, w, h) {
		var me = this,
			width = bounds.X - bounds.x,
			height = bounds.Y - bounds.y,
			h = (typeof h !== 'undefined') ? h : me.getHeight(),
			w = (typeof w !== 'undefined') ? w : g.getWidth(),
			panelWidth = w - me.bodyPadding,
			panelHeight = h - me.bodyPadding;


		//me.svg.attr('width', panelWidth).attr('height', panelHeight).attr('viewBox', '0 0 ' + panelWidth + ' ' + panelHeight);

		if (width == 0 || height == 0) return; //no need to fit

		me.scale = Math.min(1, Math.min(panelWidth / width, panelHeight / height));

		me.translateX = (-bounds.x * me.scale + (panelWidth / me.scale - width) * me.scale / 2);
		me.translateY = (-bounds.y * me.scale + (panelHeight / me.scale - height) * me.scale / 2);

		// console.log('zoomToFit()',me.translateX,me.translateY,me.scale);
		me.transform = d3.zoomIdentity.translate(me.translateX, me.translateY).scale(me
			.scale);
		//initial zoom setting
		me.applyZoom(svg, inner, g, me.translateX, me.translateY, me.scale);

		svg.call(me.zoom().transform, d3.zoomIdentity.translate(me.translateX, me.translateY)
			.scale(me.scale));
		d3.selectAll('.textGrp').each(function (d, i) {
			//d3.select(this).attr("transform", function (d) {
				//return "translate(" + me.nodes[i].grpX + "," + (me.nodes[i]
					//.grpY * me.d3sqt(me.scale)) + ")scale(" + me.d3scale(
					//me.scale) + ")"
			//})
		})
	},
	//contains arrows etc...
	svgAssets: function (svg) {
		svg.append("svg:marker")
			.attr("id", "arrow")
			.attr("viewBox", "0 0 10 10")
			.attr("refX", 5)
			.attr("refY", 5)
			.attr("markerUnits", "strokeWidth")
			.attr("markerWidth", 10)
			.attr("markerHeight", 10)
			.attr("orient", "auto")
			.append("path")
			.attr("d",
				"M7.585,4.952C5.526,3.404,2.887,1.548,0.829,0c0.016,3.08,0.043,6.92,0.059,10C2.93,8.468,5.542,6.484,7.585,4.952z"
			)
			.style("fill", "#918f90")
			.style("stroke", "#918f90")
			.style("stroke-width", "0");

	},
	//appending svg 
	renderSvg: function () {
		var me = this,
			container = d3.select('#' + me.body.id),
			width = parseInt(container.style('width'), 10),
			height = parseInt(container.style('height'), 10),
			aspect = width / height,
			svg = container.append('svg').style('background',(strSkin == "Dark")?'#333333':'#fff').attr('height', height).attr('preserveAspectRatio',
				'xMidYMid meet').attr('width', width)
			.attr('viewBox', '0 0 ' + width + ' ' + height + '').attr('id', me.body.id +
				'-SVG'),
			inner = svg.append('g').attr('class', 'inner');
			svg.append('text').style('font-weight','500').style('display','none').attr('id','topologytitle').text(me.up('panel').title).attr('text-anchor','middle').attr('x','50%').attr('y','30');
		
			me.svgAssets(svg);


	},
	calcPoints: function (g, e) {
		var me = this;
		const tail = g.node(e.v);
		const head = g.node(e.w);


		const startPoint = {
			x: tail.x + (tail.width / 2),
			y: tail.y
		}
		const endPoint = {
			x: head.x - (head.width / 2),
			y: head.y
		}
		return me.diagonal(startPoint, endPoint)
	},
	diagonal: function (start, end) {

		//return `M ${start.x} ${start.y}
							//C ${(start.x + end.x) / 2} ${start.y},
								//${(start.x + end.x) / 2} ${end.y},
								//${end.x} ${end.y}`
		return "M ".concat(start.x, " ").concat(start.y, "C ").concat((start.x + end.x) / 2, " ").concat(start.y, ",\n").concat((start.x + end.x) / 2, " ").concat(end.y, ",").concat(end.x, " ").concat(end.y);
	},
	createEdgePaths: function (selection, g, arrows) {
		var me = this;
		selection.selectAll('*').remove();
		var linkGrp = selection.selectAll("g.edgePath")
			.data(g.edges())
			.enter();
		var links = linkGrp.append("g").attr('class', 'edgePaths');
		links.append("path")
			.attr("d", function (e) {
				return g.me.calcPoints(g, e);
			}).attr("marker-end", function (d) {
				return "url(#arrow)"
			});
	},
	//***********************************************************
	//topology formation and autoReload**************************
	//@https://github.com/dagrejs/graphlib/wiki/API-Reference****
	//***********************************************************
	graphObj: function () {
		return new dagreD3.graphlib.Graph().setGraph({
			rankdir: 'LR',
			edgesep: 120,
			nodesep:108
		})
	},
	graphRenderObj: function () {
		var me = this;
		return new dagreD3.render().createEdgePaths(me.createEdgePaths);
	},
	//***********************************************************
	nodeHeight: 108,
	nodeWidth: 108,
	NODEPADDING: 108 * 2,
	edgeLen: 2.5,
	drawTopology: function (topoData, isUpdate) {
		var me = this,
			g = me.graphObj(),
			render = me.graphRenderObj();
		me.graphRender = g;
		//***********************************************************
		//setting the scope for @createEdgePaths function
		g.me = me;
		//***********************************************************

		g.setDefaultEdgeLabel(function () {
			return {};
		});

		/*-------skeleton points----------*/
		// Setting the nodes 
		topoData.nodes.forEach(function (node) {
			g.setNode(node.id, {
				nodeLabel: node.name,
				measures: node.measures,
				icon: node.iconName,
				state: node.state,
				width: me.nodeWidth,
				id: node.id,
				height: me.nodeHeight,
				detailURL: node.detailURL
			});

		});
		// Setting the links 
		topoData.links.forEach(function (link) {

			g.setEdge(link.from, link.to, {
				curve: d3.curveBasis,
				minlen: me.edgeLen
			});
		});
		me.svg = d3.select('#' + me.body.id + '-SVG');
		me.inner = d3.select('.inner');
		render(me.inner, g);
		/*-------end of skeleton points----------*/
		/*---skin--*/
		me.nodeStyle(g,isUpdate);
		/*---end skin--*/

		if(isUpdate){
			//applying zoom and fit graph
			me.scaleGraph(me.svg, me.inner, g, me.graphBound(me.nodes), me.getWidth(), me.getHeight());
		}
		
	},

	graphBound: function (nodes) {
		//property represents the negative Infinity value.
		var me = this,
			x = Number.POSITIVE_INFINITY,
			X = Number.NEGATIVE_INFINITY,
			y = Number.POSITIVE_INFINITY,
			Y = Number.NEGATIVE_INFINITY;

		nodes.forEach(function (v) {
			x = Math.min(x, v.x - (v.width + me.NODEPADDING) / 2);
			X = Math.max(X, v.x + (v.width + me.NODEPADDING) / 2);
			y = Math.min(y, v.y - (v.height + me.NODEPADDING) / 2);
			Y = Math.max(Y, v.y + (v.height + me.NODEPADDING) / 2);
		});
		return {
			x: x,
			X: X,
			y: y,
			Y: Y
		};
	},
	getCoords: function (elem) {
		var bbox = elem.getBBox();
		var matrix = elem.ownerSVGElement.getScreenCTM()
			.inverse()
			.multiply(elem.getScreenCTM())
			.translate(bbox.width / 2, bbox.height / 2);
		return {
			x: matrix.e,
			y: matrix.f
		};
	},
	alertNode: function (g, node, x, y) {
		var me = this;
		x = x + 12;
		y = y + 12;
		if (!Ext.isEmpty(interval)) {

			delete interval;
			interval = null;
			node.select('.blink').remove();

		}

		var interval = d3.interval(function () {
			node.filter(function (d) {
					return g.node(d).state == 'HIGH'
				}).append('circle').attr('transform',
					function (d) {
						//console.log('>>', d)
						return 'translate(' + x + ',' + y + ')scale(1)'
					}).attr('opacity', '1').attr('stroke', 'red').attr('stroke-width',
					'0px').attr('r', '12')
				.attr('fill', 'red')
				.transition().duration(800).attr('transform',
					function (d) {
						return 'translate(' + x + ',' + y + ')scale(2.1)'
					}).attr('opacity', '0.1').attr(
					'stroke-width',
					'0px').on('end', function () {
					interval.stop();

					d3.select(this).remove();
				}).attr('class', 'blink');


			node.filter(function (d) {
					return g.node(d).state == 'HIGH'
				}).append('circle')
				.attr('transform', function (d) {
					return 'translate(' + x + ',' + y + ')scale(1)'
				})
				.attr('stroke-opacity', '0.3').attr('stroke', 'red')
				.attr('stroke-width', '0px').attr('r', '12')
				.attr(
					'fill',
					'none').transition().duration(800).attr('transform',
					function (d) {
						return 'translate(' + x + ',' + y + ')scale(2)'
					}).attr('stroke-opacity', '1').attr(
					'stroke-width', '.8px').transition()
				.duration(900)
				.attr('transform', function (d) {
					return 'translate(' + x + ',' + y + ')scale(2.3)'
				}).attr('stroke-opacity', '0').attr(
					'stroke-width', '0px').on('end',
					function () {
						interval.stop();

						d3.select(this).remove();
					}).attr('class', 'blink');
		}, 1500);

	},
	nodeStyle: function (g,isUpdate) {
		var me = this;
		me.nodes = [];
		if(!isUpdate)
		{
			if (!Ext.isEmpty(setIntervalID)) {
				for(var t=0;t<setIntervalID.length;t++)
				{
					clearInterval(setIntervalID[t]);
				}
				setIntervalID = [];
			}
		}
		g.nodes().forEach(function (v, i) {
			var node = g.node(v),
				svgNode = d3.select(node.elem);
			me.nodes.push(g.node(v));

			//append before remove all elements
			svgNode.selectAll('*').remove();

			//Root node
			var RECT_WIDTH = 150,
				RECT_HEIGHT = 150;
			if (node.id == "esx") 
			{
				/*--hosted on--*/
				svgNode.append("line")
					.attr("x1", -75)
					.attr("y1", -(RECT_HEIGHT / 2) - 20)
					.attr("x2", 75)
					.attr("y2", -(RECT_HEIGHT / 2) - 20)
					.attr("stroke-width", 1)
					.attr("stroke", "#d5d5d5");

				
				var hostedOn = "Hosted on",
					tm = new Ext.util.TextMetrics(),
					formattedWidth = tm.getWidth(hostedOn) * 1.4;
				svgNode.append('rect').attr(
						'height', 20)
					.attr('width', formattedWidth)
					.attr('class', 'bg')
					.attr('rx', '10px')
					.attr('x', -(formattedWidth) / 2)
					.attr('y', (-RECT_HEIGHT / 2) - 30).attr('class', 'rootNode');

				var hostedTxt = svgNode.append('text').attr('text-anchor', 'middle')
					.attr('data-qtip', function () {
						return hostedOn;
					}).text(function (d) {
						return hostedOn;
					}).style('font-size', 13)
					.style('font-weight', 400)
					.attr('class', 'grpFont').attr('fill', '#000')
					.attr('y', -(RECT_HEIGHT / 2) - 16);

					/*--end hosted on--*/

				svgNode.append('rect').attr(
						'height', RECT_WIDTH)
					.attr('width', RECT_HEIGHT)
					.attr('class', 'rootNode')
					.attr('rx', '10px')
					.attr('x', -RECT_WIDTH / 2)
					.attr('y', -RECT_HEIGHT / 2)
			}

			//Component icon
			var ICON_WIDTH = 54,
				ICON_HEIGHT = 54;
			ICON_X = -ICON_HEIGHT / 2;
			ICON_Y = -ICON_HEIGHT / 2;
			svgNode.append('image')
				.attr("xlink:href", function (d, i) {
					return "/final/monitor/eg_scripts/VMDataStoreTopology/images/" + node.icon + ".svg";
				}).attr('width', ICON_WIDTH).attr('height', ICON_HEIGHT)
				.attr('y', function () {
					return ICON_X;
				}).attr('x', function () {
					return ICON_Y;
				})
				.style('cursor',function(d,i){
					var clickUrl = node.detailURL;
					if(!Ext.isEmpty(clickUrl))
						return 'pointer';
					else
						return 'default';
				})
				.on('click',function(d,i){
					var clickUrl = node.detailURL;
					if(Ext.isEmpty(clickUrl))
						return;

					clickUrl = clickUrl+"&fromePage=DSTopology";
					window.location = clickUrl;
				});

			//State icon
			var STATE_ICON_WIDTH = 24,
				STATE_ICON_HEIGHT = 24,
				STATE_ICON_X = (STATE_ICON_WIDTH / 2),
				STATE_ICON_Y = -(STATE_ICON_HEIGHT - (STATE_ICON_HEIGHT));
			var stateIcon = svgNode.filter(function () {
					return node.state != null
				}).append('image')
				.attr("xlink:href", function (d, i) {
					return "/final/monitor/eg_scripts/VMDataStoreTopology/images/state_" + node.state + ".svg";
				}).attr('width', STATE_ICON_WIDTH)
				.attr('height', STATE_ICON_HEIGHT)
				.attr('y', function () {
					return STATE_ICON_Y;
				})
				.attr('x', function () {
					return STATE_ICON_X;
				}).style('cursor',function(d,i){
					var clickUrl = node.detailURL;
					if(!Ext.isEmpty(clickUrl))
						return 'pointer';
					else
						return 'default';
				})
				.on('click',function(d,i){
					var clickUrl = node.detailURL;
					if(Ext.isEmpty(clickUrl))
						return;

					clickUrl = clickUrl+"&fromePage=DSTopology";
					window.location = clickUrl;
				});

			//alert node
			var setIntevalNum = setInterval(function () {
				me.alertNode(g, svgNode, STATE_ICON_X, STATE_ICON_Y);
			}, 3000);
			setIntervalID.push(setIntevalNum);

			//label AND MEASURES
			var GRPTEXTGAP =45,
				GRP_TEXT_PADDING = 0,
				lineHeight = 15,
				CENTER_PART = 80,
				GRPTEXTGAP_FROM = GRPTEXTGAP + 20,
				M_STATE_ICON_SIZE = 11,
				grp = svgNode.append('g').attr('class', 'textGrp');
			/*.attr('transform',
					function (d, i) {
						node.grpX = (ICON_X + ICON_WIDTH) / 2;
						node.grpY = (ICON_Y + ICON_HEIGHT + GRPTEXTGAP);
						return 'translate(' + node.grpX + ',' + node.grpY + ') ';
					});*/

			var textElement = grp.append('text').attr('text-anchor', 'middle')
			.attr('data-qtip',function()
			{
				//var nodeQ = node.nodeLabel.replace("|","<br/>");
				return "";
			})
			.on("mouseover", function(d) {		
				var nodeQ = node.nodeLabel.replace("|","<br/>");
				textElement.attr('data-qtip',nodeQ);
			})					
			.on("mouseout", function(d) {		
				textElement.attr('data-qtip',"");		
			})
			.text(function (d) {
				if(node.nodeLabel.indexOf("|") > -1)
				{
					var nodeL = node.nodeLabel;
					nodeL = nodeL.substring(0,nodeL.indexOf("|"));
					return me.trim(nodeL, 18);
				}
				return me.trim(node.nodeLabel, 18);
			}).style('font-size', 13).style('font-weight', 500).attr('class','grpFont').attr('y',GRPTEXTGAP)
			.style('cursor',function(d,i){
				var clickUrl = node.detailURL;
				if(!Ext.isEmpty(clickUrl))
					return 'pointer';
				else
					return 'default';
			})
			.on('click',function(d,i){
				var clickUrl = node.detailURL;
				if(Ext.isEmpty(clickUrl))
					return;

				clickUrl = clickUrl+"&fromePage=DSTopology";
				window.location = clickUrl;
			});			
			//component measure lanel 

			if(node.nodeLabel.indexOf("|") > -1)
			{
				var textElement1 = grp.append('text').attr('text-anchor', 'middle')
				.attr('data-qtip',function()
				{
					//var nodeQ = node.nodeLabel.replace("|","<br/>");
					return "";
				})
				.on("mouseover", function(d) {		
					var nodeQ = node.nodeLabel.replace("|","<br/>");
					textElement1.attr('data-qtip',nodeQ);
				})					
				.on("mouseout", function(d) {		
					textElement1.attr('data-qtip',"");		
				})
				.text(function (d) {
					if(node.nodeLabel.indexOf("|") > -1)
					{
						var nodeL = node.nodeLabel;
						nodeL = nodeL.substring(nodeL.indexOf("|")+1);
						return me.trim(nodeL, 18);
					}
					return me.trim(node.nodeLabel, 18);
				}).style('font-size', 13).style('font-weight', 500).attr('class','grpFont').attr('y',GRPTEXTGAP+18)
				.style('cursor',function(d,i){
					var clickUrl = node.detailURL;
					if(!Ext.isEmpty(clickUrl))
						return 'pointer';
					else
						return 'default';
				})
				.on('click',function(d,i){
					var clickUrl = node.detailURL;
					if(Ext.isEmpty(clickUrl))
						return;

					clickUrl = clickUrl+"&fromePage=DSTopology";
					window.location = clickUrl;
				});		
			}
				var measureG = grp.append('g')
							.attr('font-size', '12px')
							.attr('transform',function(d,k){
								return 'translate(0,'+(GRPTEXTGAP_FROM)+')'
							})
							.attr('class', 'measureFont').style('cursor', 'pointer');

		

			if (!Ext.isEmpty(node.measures)) {
				for (var i = 0; i < node.measures.length; i++) {
					var tspan = measureG.append('text').attr('y', function(d,k){
									if (i == 0) {
												return 0;
											} else {

												return i* lineHeight;
											}
								})
					.attr('x', -(CENTER_PART / 2));
					
					tspan.append('tspan').text(node.measures[i].name + " ");
					tspan.append('tspan').text(node.measures[i].value);
					tspan.append('tspan').text(node.measures[i].unit);
					//measure state
					measureG.append('image')
						.attr("xlink:href", function (d) {
							return "/final/monitor/eg_scripts/VMDataStoreTopology/images/small_state_" + node.measures[i].state +
								".svg";
						}).attr('width', M_STATE_ICON_SIZE)
						.attr('height', M_STATE_ICON_SIZE)
						.attr('y',function (d, index) {
											if(i == 0) {
												return (0 - (M_STATE_ICON_SIZE-2));
											}else {
												return (i* lineHeight) - (M_STATE_ICON_SIZE -2);
											}
										})
						.attr('x', function () {
							//console.log("dsfsdf=-=-=-=-=->",((-(CENTER_PART / 2)) * i) - 16);
							return (-(CENTER_PART / 2)) - 16;
							//if (i == 0) {
								//return (-(CENTER_PART / 2)) - 16
							//} else {
								//return ((-(CENTER_PART / 2)) * i) - 16
							//}

						});

						tspan.on('click',function(d,i){
							var clickUrl = node.measures[i].detailURL;
							if(Ext.isEmpty(clickUrl))
								return;

							clickUrl = clickUrl+"&fromePage=DSTopology";
							window.location = clickUrl;
						});
				}
			}

		});
	}
});





