<%
/*******************************************************************************
*	File name		: egDashDDData
*	Purpose			: To display detailed measures
*	Version			: eG 4.3
*	Creation Date	: 20/03/2009
*	Authtor			: Rajesh
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgAgentInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgTestInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgFormatInfo"%>
<%@ page session = "true" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public String findAndReplaceString(String s,String s_search,String s_replace)
	{
		StringBuffer sb_tmp = new StringBuffer();
		while(s.indexOf(s_search) > -1)
		{
			sb_tmp.append(s.substring(0,s.indexOf(s_search)) + s_replace);
			s = s.substring(s.indexOf(s_search) + s_search.length(),s.length());
		}
		if(s.length() > 0)
		{
			sb_tmp.append(s);
		}
		return sb_tmp.toString();
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%

try
{
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />

<%
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	String thisLanguage = ui.getDefaultLanguage();

	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	List listData = new LinkedList();
	listData.add(mappingInfo.getTextDescription("monitor.csv.Detailed Diagnosis"));
	listData.add(" ");
	
	EgDateInfo dateInfo = new EgDateInfo();
	java.util.Date local_date = new java.util.Date(dateInfo.egetUTCDate());
	Calendar cal = Calendar.getInstance();
	
	cal.setTime(local_date);
	cal.setTimeZone(dateInfo.getRealTimeZone());

	Vector vec_Tabletitle = new Vector();
	Hashtable sen=new Hashtable();
	List lst_DispData = new LinkedList();
	String title="";
	int tokCount = 0;
	
	String s_status = "";
	String s_format = "";
	String s_desc = "";
	String s_strTok = "";
	String s_site,
			s_host,
			s_port,
			s_test,
			s_info,
			s_msmt_host,
			s_mes,
			s_st_time,
			s_st_hr,
			s_en_time,
			s_en_hr,
			s_st_min,
			s_end_min,
			s_first_time,
			s_from,
			s_flag;

	String s_detl_meas = "";
	String s_measure = "";
	String s_firstInfo = "";
	String s_secondInfo = "";

	boolean proceed = false;

	Vector v_measures = new Vector();

	ArrayList a_results = new ArrayList();
	ArrayList a_temp = new ArrayList();
	ArrayList ar_det_measures = new ArrayList();
	ArrayList al_cols = new ArrayList();
	ArrayList al_header = new ArrayList();
	ArrayList al = new ArrayList();

	StringTokenizer st = null;
	ResultSet rs = null;

	EgTesterInfo testInfo = new EgTesterInfo("manager");
	EgTestInfo tokInfo = new EgTestInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgDateInfo edi = new EgDateInfo();

	Vector dddTestList=new Vector();

	String formatFile = "eg_format.ini";
	String format_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";

	IniFile formatIniFile = new IniFile(format_iniFile_dir + formatFile);

	String[] dddTest=formatIniFile.getVariables("DDTests_DDD_udmeasure");

	if(dddTest!=null && dddTest.length>0)
	{
		for(int x=0;x<dddTest.length;x++)
		{
			dddTestList.add(dddTest[x]);
		}
	}

	String oldColSeparator = EgConstants.SEMICOLON;
	String colSeparator = testInfo.getDDSeparator1(); // default is ";"

	if (StringUtils.isNull(colSeparator))
	{
		colSeparator = oldColSeparator;
	}

	String separateCols = null;
	String separateRows = null;

	s_site = request.getParameter("site");
	s_host = request.getParameter("host");
	s_port = request.getParameter("port");
	s_test = request.getParameter("test");
	String fromDashboardOverview=request.getParameter("fromDashboardOverview");
	boolean isFromDashBoardOverview=(fromDashboardOverview!=null && fromDashboardOverview.equalsIgnoreCase("true"));

	s_info = ui.getReverseLookedupString(request.getParameter("info"));

	if(s_info!=null)
	{
		s_info=com.egurkha.util.StringUtils.replace(s_info,"|plus|","+");
		s_info=com.egurkha.util.StringUtils.replace(s_info,"|amp|","&");
		s_info=com.egurkha.util.StringUtils.replace(s_info,"|pct|","%");
	}

	s_msmt_host = request.getParameter("msmt_host");
	s_mes = request.getParameter("measure");
	s_st_time = request.getParameter("starttime");
	s_en_time = request.getParameter("endtime");
	s_st_hr = request.getParameter("starthr");
	s_en_hr = request.getParameter("endhr");
	s_st_min =request.getParameter("startmin");
	s_end_min =request.getParameter("endmin");
	s_first_time = request.getParameter("firsttime");
	s_from = request.getParameter("from");
	s_flag = request.getParameter("flag");

	String fromReport = request.getParameter("inidate");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";

	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);

	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String dispDate = null;
	String comFormat = null;

	if(s_st_time == null || s_en_time == null)
	{
		s_st_time = "";
		s_en_time = "";
	}

	if(s_st_hr == null || s_en_hr == null)
	{
		s_st_hr = "0";
		s_en_hr = "0";
	}

	if (s_st_min==null || s_st_min.equals(""))
		s_st_min = "0";

	if (s_end_min==null || s_end_min.equals(""))
		s_end_min = "0";

	String endDateTime ="";
	String startDateTime ="";

	if((s_st_time!=null && s_st_time.equals("")) || (s_en_time!=null && s_en_time.equals("")))
	{
		String tempp = currentDateFormat +" HH:mm";

		SimpleDateFormat sdf = new SimpleDateFormat(tempp);
		java.util.Date tmpday = new java.util.Date();
		endDateTime = sdf.format(tmpday);

		int timeLine2 = 3600;//For one hour default measures

		java.util.Date startDate2 = new java.util.Date();
		startDate2.setTime(tmpday.getTime() - (timeLine2 * 1000));
		startDateTime = sdf.format(startDate2);

		s_st_time = startDateTime.substring(0,startDateTime.lastIndexOf(" "));

		s_en_time = endDateTime.substring(0,endDateTime.lastIndexOf(" "));

		s_st_hr = startDateTime.substring(startDateTime.lastIndexOf(" ")+1,startDateTime.indexOf(":"));
		s_en_hr = endDateTime.substring(endDateTime.lastIndexOf(" ")+1,endDateTime.indexOf(":"));

		s_st_min = startDateTime.substring(startDateTime.indexOf(":")+1);
		s_end_min = endDateTime.substring(endDateTime.indexOf(":")+1);
	}

	String sess_st_time = (String) session.getAttribute("dd_sttime");
	String sess_end_time = (String) session.getAttribute("dd_entime");
	String startDate="";

	try
	{
		java.text.SimpleDateFormat sdf=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
		startDate =sdf.format(new java.util.Date());
	}
	catch(Exception ee)
	{
		System.out.println("Exception in DateFormat");
		ee.printStackTrace();
	}

	String today =startDate.substring(0,startDate.indexOf(" "));
	String startHour =startDate.substring(startDate.indexOf(" "),startDate.lastIndexOf(""));

	startHour = startHour.substring(0,3);

	if (sess_st_time == null || sess_st_time.equalsIgnoreCase("null"))
	{
		sess_st_time = today;
	}

	if(sess_end_time == null || sess_end_time.equalsIgnoreCase("null"))
	{
		sess_end_time=today;
	}

	s_st_hr = request.getParameter("starthr");
	s_en_hr = request.getParameter("endhr");

	if(s_st_time == null || s_en_time == null)
	{
		s_st_time = "";
		s_en_time = "";
	}

	if(s_st_hr == null || s_en_hr == null || s_st_hr.equals("null"))
	{
		int hour = Integer.parseInt(startHour.trim());
		s_en_hr = hour+"";
		hour--;
		s_st_hr = hour+"";
	}

	String timeLine="";

	ErUtils erUtils = new ErUtils();
	timeLine = request.getParameter("timeline");

	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours","15 hours", "18 hours","21 hours","24 hours", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};

	Vector time_line=new Vector();
	time_line.addAll(Arrays.asList(options));

	if (timeLine==null)
	{
		String selectedTimeline = egUI.getValue("GRAPHS","DD_DISPLAY");

		if(selectedTimeline.equals("1"))
			timeLine =selectedTimeline+" "+"hour";
		else
			timeLine =selectedTimeline+" "+"hours";
	}

	String disabled ="";

	if(timeLine!=null && timeLine.equals("Any"))
	{

		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(new java.util.Date());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}

		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));

		shour = shour.substring(0,3);

		if (s_st_time== null || s_st_time.equalsIgnoreCase("null"))
		{
			s_st_time= SDate;
		}

		if(s_en_time == null || s_en_time.equalsIgnoreCase("null"))
		{
			s_en_time=SDate;
		}

		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}

		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}

		sess_st_time = s_st_time;
		sess_end_time = s_en_time;
	}
	else
	{
		disabled = "disabled";
		startDateTime="";
		endDateTime="";

		int blankSpaceIndex = timeLine.indexOf(DateTimeTokenizer.BLANK_SPACE);

		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date tmpday = edi.egetRealDate();
			endDateTime = sdf.format(tmpday);

			int value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));

			String unit = timeLine.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *=(30 * 24 * 3600);
				value *=(ErUtils.getMaxDaysInMonth()) * 24 * 3600;
			}

			long value2=value;
			java.util.Date start = new java.util.Date();
			start.setTime((tmpday.getTime() - (value2 * 1000)));
			startDateTime = sdf.format(start);
		}

		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));

			int st_min=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(":")+1));

			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));

			int en_min=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(":")+1));

			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);

			s_st_min = String.valueOf(st_min);
			s_end_min = String.valueOf(en_min);
		}

		sess_st_time = s_st_time;
		sess_end_time = s_en_time;

		//modified by stalin on 17/12/07---
		if(!DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = currentDateFormat;
			s_st_time = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",comFormat);
		}
		if(!DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = currentDateFormat;
			s_en_time = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",comFormat);
		}
	}

	trans.createFile("eg_format.ini");

	String strValue=trans. getStrValue("DDD_TESTS", s_test);
	String dateFormat =trans.getStrValue("DDD_DATE", s_test+":EvtDate");
	String [] colNames = dbInfo.getColumnNamesForTest(s_test+"_DDD");
	String colNamesForQuery = "";

	if (!strValue.equals(""))
	{
		if(colNames != null && colNames.length > 0)
		{
			for(int r=0; r<colNames.length; r++)
			{
				colNamesForQuery +=colNames[r] + ",";
			}
			if(colNamesForQuery.endsWith(","))
			{
				colNamesForQuery = colNamesForQuery.substring(0, (colNamesForQuery.length()-1));
			}
		}
	}

	boolean fake = true;

	String temp = "";
	String dummyTest = "";
	String dummyMeas = "";

	String[] Desc = dd.getDescription(s_test,s_mes);

	if (s_test!=null && s_mes!=null && !s_mes.equals("") && !s_test.equals("")&& !s_mes.equals("null") && !s_test.equals("null"))
	{
		Desc = dd.getDescription(s_test,s_mes);
		if (Desc != null && Desc.length>1)
		{
			s_format=Desc[0];
			s_desc=Desc[1];
		}
	}

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean portRelevantForTest=true;
	if(s_test != null && !s_test.equals(""))
	{
		portRelevantForTest = specsInfo.isPortRelevantForTest(s_test);
	}

	if(s_first_time != null && !s_first_time.equals("") && s_first_time.equals("true"))
	{
		s_first_time = "false";

		if(s_info.length() == 1)
		{
			s_info = "NONE";
		}

		if(s_test != null && !s_test.equals(""))
		{
			v_measures=dd.populateMeasures(s_test);
			if(v_measures!=null)
				session.putValue("measures",v_measures);
		}//CLOSING IF
	}

	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}

	String ss_st_time = s_st_time;

	if(fromReport!=null && fromReport!="" && fromReport.trim().length()>0)
	{
		s_st_time = DateUtil.changeDateFormat(s_st_time,fromReport,"MM/dd/yyyy");
		ss_st_time=s_st_time;
	}

	if(!DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
	{
		ss_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
	}

	if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}

	String se_en_time = s_en_time;
	if(fromReport!=null && fromReport!="")
	{
		s_en_time = DateUtil.changeDateFormat(s_en_time,fromReport,"MM/dd/yyyy");
		se_en_time=s_en_time;
	}

	if(!DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
	{
		se_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");
	}

	if(s_info!=null && s_info.indexOf("*")>-1)
	{
		if(s_info.length()==2 && s_info.substring(s_info.indexOf("*")+1).equals("+"))
		{
			a_results=dd.getDiagnosisData(s_host,s_port,s_site, s_test, s_mes, s_info.substring(s_info.indexOf("*")+1), ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,colNamesForQuery,s_msmt_host);

			if(dddTestList.contains(s_test))
			{
				a_results=dd.getDiagnosisData(s_host,s_port,s_site, s_test, s_mes, s_info.substring(s_info.indexOf("*")+1), ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,"",s_msmt_host);
			}
		}
		else
		{
			a_results=dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_mes, s_info, ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,colNamesForQuery,s_msmt_host);
			if(dddTestList.contains(s_test))
			{
				a_results=dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_mes, s_info, ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,"",s_msmt_host);
			}
		}
	}
	else
	{
		a_results=dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_mes, s_info, ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,colNamesForQuery,s_msmt_host);
		if(dddTestList.contains(s_test))
		{
			a_results=dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_mes, s_info, ss_st_time, se_en_time, s_st_hr, s_en_hr,s_st_min,s_end_min,s_flag,"",s_msmt_host);
		}
	}

%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>&nbsp;<egui:intnl text='monitor.detaileddiagnosis.Detailed Diagnosis for'/> '<egui:intnl measure='<%=s_test+":"+s_mes%>' />' &nbsp; - &nbsp; <egui:intnl text='monitor.common.eG Manager'/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<%
	long refreshFrequency = 60;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency = Long.valueOf(refFreq).longValue();
	}
	if(s_st_time.equals(""))
	{
%>
		<META HTTP-EQUIV="refresh" CONTENT="<%=refreshFrequency%>;url=egDashDDData.jsp?<%=request.getQueryString()%>">
<%
	}
%>
<meta name="Author" content="John Williams" />
<egui:skin ui="monitor"/>
<script src="eg_scripts/eg_date.js"></script>
<script language="JavaScript1.2" src="eg_scripts/eg_validate.js"></script>

<script language="javascript1.2">
	var	printdataObj=null;
	function timeLineChange()
	{
		var thisForm = document.dd;
		var measures = thisForm.measurelist;
		var s_mes = "";
		var qrstring = "";
		var flag = "";
		var comeFrom=thisForm.cFrom.value;
		if (measures.options.length <= 0)
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.No detailed measures available"/>');
			return;
		}

		if (thisForm.starttime.value == "" && thisForm.endtime.value == "")
		{
			var s_hr = thisForm.starthr.options[thisForm.starthr.selectedIndex].value;
			var e_hr = thisForm.endhr.options[thisForm.endhr.selectedIndex].value;

			if (s_hr != '0' || e_hr != '0')
			{
				alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose Start Date and End Date before choosing Time!"/>');
				return;
			}
			else
			{
				//No start date and end date
				flag = "0";
			}
		}
		else if (thisForm.starttime.value == "")
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose a Start Date!"/>');
			return;
			flag = "0";
		}
		else if (thisForm.endtime.value == "")
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose an End Date!"/>');
			return;
			flag = "0";
		}
		else
		{
			flag = "1";
		}

		for (var i = 0; i < measures.options.length; i++)
		{
			if (measures.options[i].selected == true)
			{
				if (s_mes.length == 0)
				{
					s_mes = measures.options[i].value;
				}
			}
		}
		var timeline= thisForm.timeline;

		var timstart = thisForm.starttime;
		var timend = thisForm.endtime;
		var startHr = thisForm.starthr.options[thisForm.starthr.selectedIndex];
		var endHr = thisForm.endhr.options[thisForm.endhr.selectedIndex];
		var startMin = thisForm.startmin.options[thisForm.startmin.selectedIndex];
		var endMin = thisForm.endmin.options[thisForm.endmin.selectedIndex];
		var ssdate = formatDate(new Date(getDateFromFormat(timstart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var eedate = formatDate(new Date(getDateFromFormat(timend.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		if (! checkTime(ssdate, eedate, startHr, endHr, startMin, endMin) && flag == "1" && timeline=='Any')
		{
			alert('<egui:intnl text="monitor.common.Start date should be lesser than end date"/>');
			return;
		}
		else
		{
			qrstring += "site=" + thisForm.site.value;
			qrstring += "&host=" + encodeURI(thisForm.host.value);
			qrstring += "&port=" + thisForm.port.value;
			qrstring += "&test=" + thisForm.test.value;
			var temp_info=thisForm.info.value;

			if (temp_info.indexOf("&")>-1)
				temp_info=temp_info.replace('&','|amp|');
			if (temp_info.indexOf("+")>-1)
				temp_info=temp_info.replace('+','|plus|');
			if (temp_info.indexOf("%")>-1)
				temp_info=temp_info.replace('%','|pct|');

			qrstring += "&info=" + encodeURI(temp_info);
			qrstring += "&msmt_host=" + encodeURI(thisForm.msmt_host.value);
			qrstring += "&starttime=" + ssdate;
			qrstring += "&endtime=" + eedate + "&starthr=" + startHr.value;
			qrstring += "&endhr=" + endHr.value;
			qrstring += "&startmin=" + startMin.value + "&endmin=" + endMin.value;
			qrstring += "&from=0&flag=" + flag + "&measure=" + s_mes;
			qrstring +="&fromPage=current";
			qrstring +="&newWindow=false";
			qrstring +="&comeFrom="+comeFrom;
			qrstring = "EgDiagnosis.jsp?" + qrstring+'&clicked=dd'+"&timeline="+timeline.value;

			window.location.href = (qrstring);
		}
	}

	var datefv='';
	var screenname='';
	var ev='';
	var def='';

	function checkwindow3(datef,event,sname)
	{
		event=event?event:window.event;
		datefv = formatDate(new Date(getDateFromFormat(datef.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		screenname=sname;
		ev=event;
		def=datef;

		try
		{
			setTimeout("callcalendar4(def,datefv,ev,screenname)",0);
		}
		catch(e)
		{
			alert("error="+e);
		}
	}

	function display()
	{
		var thisForm = document.dd;
		var measures = thisForm.measurelist;
		var s_mes = "";
		var qrstring = "";
		var flag = "";

		if(measures.options.length <= 0)
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.No detailed measures available"/>');
			return;
		}

		if(thisForm.starttime.value == "" && thisForm.endtime.value == "")
		{
			var s_hr = thisForm.starthr.options[thisForm.starthr.selectedIndex].value;
			var e_hr = thisForm.endhr.options[thisForm.endhr.selectedIndex].value;
			if(s_hr != '0' || e_hr != '0')
			{
				alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose Start Date and End Date before choosing Time!"/>');
				return;
			}
			else
			{
				//No start date and end date
				flag = "0";
			}
		}
		else if(thisForm.starttime.value == "")
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose a Start Date!"/>');
			return;
			flag = "0";
		}
		else if(thisForm.endtime.value == "")
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.Please choose an End Date!"/>');
			return;
			flag = "0";
		}
		else
		{
			flag = "1";
		}

		for(var i=0; i<measures.options.length ;i++)
		{
			if(measures.options[i].selected == true)
			{
				if(s_mes.length == 0)
				{
					s_mes = measures.options[i].value;
				}
			}
		}

		var timeline= thisForm.timeline;
		var timstart = thisForm.starttime;
		var timend = thisForm.endtime;
		var startHr = thisForm.starthr.options[thisForm.starthr.selectedIndex];
		var endHr = thisForm.endhr.options[thisForm.endhr.selectedIndex];
		var startMin =thisForm.startmin.options[thisForm.startmin.selectedIndex];
		var endMin =thisForm.endmin.options[thisForm.endmin.selectedIndex];
		var ssdate = formatDate(new Date(getDateFromFormat(timstart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var eedate = formatDate(new Date(getDateFromFormat(timend.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

		var  s_yr = <%=cal.get(cal.YEAR)%>;
		var s_mon = <%=cal.get(cal.MONTH)%>;
		var s_day = <%=cal.get(cal.DAY_OF_MONTH)%>;
		var s_hr = <%=cal.get(cal.HOUR_OF_DAY)%>;
		var s_min = <%=cal.get(cal.MINUTE)%>;
		var comeFrom=thisForm.cFrom.value;
		s_mon=s_mon+1;

		if(checkCurrentTimeMin(s_mon+"/"+s_day+"/"+s_yr,ssdate,eedate,s_hr,startHr,endHr,s_min,startMin,endMin,"DD") && timeline.value=='Any')
		{
			alert('<egui:intnl text="monitor.common.From and To Date should be lesser than Current date"/>');
			return false;
		}

		if(!checkTime(ssdate,eedate,startHr,endHr,startMin,endMin) && flag == "1")
		{
			alert('<egui:intnl text="monitor.common.Start date should be lesser than end date"/>');
			return false;
		}
		else if(!checkTime(ssdate, eedate, startHr, endHr, startMin, endMin) && timeline.value=='Any')
		{
			alert('<egui:intnl text="monitor.common.From date should be lesser than To date"/>');
			return false;
		}
		else
		{

			qrstring += "site=" + thisForm.site.value;
			qrstring += "&host=" + thisForm.host.value;
			qrstring += "&port=" + thisForm.port.value;
			qrstring += "&test=" + thisForm.test.value;
			qrstring += "&info=" + thisForm.info.value;
			qrstring += "&msmt_host=" + thisForm.msmt_host.value;

			qrstring += "&starttime=" + ssdate;
			qrstring += "&endtime=" + eedate + "&starthr=" + startHr.value;
			qrstring += "&endhr=" + endHr.value;
			qrstring += "&startmin=" + startMin.value + "&endmin="+endMin.value;
			qrstring += "&from=0&flag=" + flag + "&measure=" + s_mes;
			qrstring += "&fromPage=current";//-----modified on 20/09/07--------------------------
			qrstring += "&newWindow=false";
			qrstring +="&comeFrom="+comeFrom;
			qrstring = "egDashDDData.jsp?" +qrstring+"&timeline="+timeline.value;
			thisForm.Go.value = "<egui:intnl text='monitor.common.Loading'/>...";
			thisForm.Go.disabled = true;
			window.location.href = encodeURI(qrstring);
		}
	}

	function saveCSVFormat()
	{
		window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
	}

	function printin()
	{
		var strValue=document.dd.strValue.value;
		var proceed=document.dd.proceed.value;
		var measurelist=document.dd.s_desc.value;
		var s_host=document.dd.host.value;
		var s_port=document.dd.port.value;
		var s_mes=document.dd.measurelist.value;
		var s_site=document.dd.site.value;
		var s_info=document.dd.info.value;
		var s_test=document.dd.test.value;
		var msmt_host=document.dd.msmt_host.value;
		var layer=document.dd.layer.value;
		var s_st_time=document.dd.s_st_time.value;
		var s_en_time=document.dd.s_en_time.value;
		var enable=document.dd.enable.value;
		var s_end_min=document.dd.s_end_min.value;
		var s_st_min=document.dd.s_st_min.value;
		var s_st_hr=document.dd.s_st_hr.value;
		var s_en_hr=document.dd.s_en_hr.value;

		if(enable=='false')
		{
			alert('<egui:intnl text="monitor.detaileddiagnosis.No detailed measures available for this combination of parameters"/>');
			return;
		}

		var qstr="&s_host="+s_host+"&s_port="+s_port+"&s_mes="+s_mes+"&s_site="+s_site+"&s_info="+s_info+"&s_test="+s_test+"&messwills_val="+measurelist+"&messwills=1"+"&strValue="+strValue+"&proceed="+proceed+"&msmt_host="+msmt_host+"&layer="+layer+"&s_end_min="+s_end_min+"&s_st_min="+s_st_min+"&s_st_hr="+s_st_hr+"&s_en_hr="+s_en_hr;

		if(printdataObj==null)
		{
			printdataObj=window.open("Egprintdata.jsp?isDDdata=yes"+encodeURI(qstr),+"PrintWin","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
		}
		else
		{
			if(printdataObj!=null)printdataObj.close();
				printdataObj=null;

			printdataObj=window.open("Egprintdata.jsp?isDDdata=yes"+encodeURI(qstr),+"PrintWin","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
		}
	}

	function closePopupWindow()
	{
		if(printdataObj!=null)
		{
			printdataObj.close();
			printdataObj=null;
		}
	}

</script>
</head>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" id="inner_bg" style="overflow:hidden" scroll="no" scrolling="no" onUnLoad="closePopupWindow()">
<input type="hidden" name="hidCurrentDateTime" id="hidCurrentDateTime" value="<%=(cal.get(cal.MONTH)+1)+"/"+cal.get(cal.DAY_OF_MONTH)+"/"+cal.get(cal.YEAR)%>">
<input type="hidden" name="hidCurrentDateHour" id="hidCurrentDateHour" value="<%=cal.get(cal.HOUR_OF_DAY)%>">
<input type="hidden" name="hidCurrentDateMin" id="hidCurrentDateMin" value="<%=cal.get(cal.MINUTE)%>">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  bordercolor="green" valign="top" height="100%">

<%
	String newWindow = request.getParameter("newWindow");//---modified on 20/09/07-----------------
	String fromPage = request.getParameter("fromPage");
	boolean eventHistoryHead = (newWindow != null && fromPage!=null && newWindow.equals("false") && fromPage.equals("eveHist"));
	String Title=request.getParameter("ddTitle");
%>

	<tr>
		<td valign='top'>
			<table border='0' cellpadding='0' cellspacing='0' width='100%'>
<%
	if(!isFromDashBoardOverview)
	{
%>
				<tr>
					<td colspan='3' width='100%' onmousedown='javascript:startDrag(event);' >
						<table border='0'  cellpadding='0' cellspacing='0' width='100%'>
							<tr>
								<td width="13" height="18" class="popupHeadleft"><img src="/final/monitor/eg_images/spacer.gif" width="13" height="18" border="0"></td>
								<td class='popupHeadbg eg_75bold whitefont' width="90%" height='18px' ><%=Title%></td>
								<td align='left' class='popupHeadbg'  style="width:50px"> <img src='/final/monitor/eg_images/icon_bar.gif' border='0' class='mouse' title='close'  onclick='javascript:showBigGraphFromDDData();'>
								</td>
								<td align='right' class='popupHeadbg' style="width:30px"> <img src='/final/monitor/eg_images/<%=monitor_Skin%>/popupClose.gif' border='0' class='mouse' title='close' vspace='2' onclick='javascript:hideBigGraph();'>
								</td>
								<td width="13" height="18" class="popupHeadright"><img src="/final/monitor/eg_images/spacer.gif" width="13" height="18" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
	if(s_desc!=null&&s_desc.indexOf(".")>-1)
	{
		s_desc=StringUtils.replace(s_desc,".","&#46");
	}

	boolean show = false;

	if(a_results.size() > 0 && s_from.equals("0"))
	{
		show = true;
	}
%>
				<tr>
<%	if(!isFromDashBoardOverview)
	{
%>
					<td class="popupInnerbg"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="7"></td>
					<td class="popupInnerbg popupBodyBorder" width="100%">
<%
	}
	else
	{
%>
					
					<td width="100%">
<%
	}
%>
						
						<table class="eg_whitebg" border="0" bordercolor="red" cellspacing="0" cellpadding="0" width="100%">
<%
	if(show)
	{
%>
							<tr>
								<td align="center" valign="top" style="padding:0px">
<%
	String dwidth="100%";
	String dheight="446px";
	if(isFromDashBoardOverview)
	{
		dheight="270px";
	}
	if(isMSIE7 || isMSIE6)
	{
		if((request.getParameter("fromDDGraphs")!=null && request.getParameter("fromDDGraphs").equals("true")))
		{
			dwidth="900px";
		}
		else
		{
			dwidth="965px";
		}
%>
								<div class="div_scroll" style="overflow-x:auto;overflow-y:auto;position:relative;border:0px solid #ff0000;height:<%=dheight%>;width:<%=dwidth%>;padding:0px;padding-right:0px;vertical-align:top;">
<%
		}
		else
		{
%>

								<div class="div_scroll" style="moz-vertical-overflow:auto;moz-horizontal-overflow:auto;position:relative;border:0px solid #ff0000;height:<%=dheight%>;width:100%;padding-left:0px;padding-right:0px;vertical-align:top;">
<%
		}

		s_format = s_format.substring(s_format.indexOf(":")+1);
		st = new StringTokenizer(s_format);
		tokCount = st.countTokens();

		// Table Starts Here
		if (isMSIE7 || isMSIE6)
		{
%>

									<table cellspacing="0" cellpadding="4" align="center" border="0" width="100%" valign="top" style="table-layout:auto">
<%
		}
		else
		{
%>
									<table cellspacing="0" cellpadding="4" align="center" border="0" width="100%" valign="top" style="table-layout:auto">
<%
		}

		al_header = tokInfo.egTokenizer(s_format, " ");

		// for remove column name have only space, Modified on 28-8-2008
		if(al_header!=null && al_header.size()>0)
		{
			for(int z=0;z<al_header.size();z++)
			{
				String columnName=(String)al_header.get(z);
				if(columnName!=null && columnName.trim().length()==0)
				{
					al_header.remove(z);
				}
			}
		}
		//----End---

		String measure=request.getParameter("measure");

		if (measure!=null && measure.equals("New_logins"))
			al_header.remove(2);
		//new change
		boolean commonDateLayout = true;
		int singleRowSize = 0;
		int totalRows = 0;

		if(al_header.size() <= 4)
		{
			commonDateLayout = false;
		}

		for(int a=0; a<a_results.size(); a=a+2)
		{
			a_temp = null;
			a_temp = (ArrayList)a_results.get(a+1);
			totalRows = totalRows + a_temp.size();
			if(a_temp != null && a_temp.size() == 1){
				singleRowSize++;
			}
			else
				commonDateLayout=true;
		}

		al_header.add(0,"Time");

		int cellwidth = 100/(int)al_header.size();
%>
										<tr>
<%
		vec_Tabletitle.add(" ");

		for(int k=0;k<al_header.size();k++)
		{
%>
											<td valign="top" align="left" id="table_header" wrap width="<%=cellwidth%>%" style="padding:3px"><egui:intnl text='<%="monitor.detaileddiagnosis."+al_header.get(k)%>'/></td>
<%
			vec_Tabletitle.add(al_header.get(k));
		}
		vec_Tabletitle.add("\n");
%>
										</tr>
<%
		// loop to display records
		for(int a=0; a<a_results.size(); a=a+2)
		{
			String sdate = DateUtil.changeDateFormat((String)a_results.get(a),"MM/dd/yyyy HH:mm:ss",currentDateFormat + " HH:mm:ss");

			if(commonDateLayout)
			{
				vec_Tabletitle.add(sdate);
				vec_Tabletitle.add("\n");
%>
										<tr>
<%
				if(s_test.equalsIgnoreCase("JvmThreadTest"))
				{
					EgAgentInfo agentInfoo = new EgAgentInfo("manager");

					String showMode = agentInfoo.getParamValue(s_test,s_host,s_port,"+",s_msmt_host,"mode");

					if(showMode.equalsIgnoreCase("false"))
					{
						String Url = "/final/monitor/ThreadDetails.jsp?site=" + EgURLEncoder.encode("NULL","UTF-8") + "&host=" +com.eg.EgURLEncoder.encode(s_host,"UTF-8") +"&port=" + s_port + "&test="+s_test+"&msmt_host="+com.eg.EgURLEncoder.encode(s_msmt_host,"UTF-8")+ "&flag=1&firsttime=true&sdate="+com.eg.EgURLEncoder.encode(sdate,"UTF-8")+"&s_measure="+com.eg.EgURLEncoder.encode(s_mes,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(s_st_time,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(s_en_time,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(s_st_hr,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(s_en_hr,"UTF-8")+"&s_st_min="+com.eg.EgURLEncoder.encode(s_st_min,"UTF-8")+"&s_end_min="+com.eg.EgURLEncoder.encode(s_end_min,"UTF-8");

						int divWidth = 787;

						if(isFirefox)
							divWidth = 810;
%>
											<td id="eg_cellbgmedium" align="left"  class="eg_darktextbold"  colspan="<%=al_header.size()-1%>" > &nbsp;<%=sdate%> </td> <td align="left"  class="eg_darktextbold" id="eg_cellbgmedium"><a href="javascript:void(0)" onclick="return show_hide_centered_href('<%=Url%>', '<%=divWidth%>', 387, 'Thread Diagnosis')" class="eg_monlink" id="mouse" style="font-weight:bold">  <egui:intnl text='monitor.layermodel.Stack Trace'/>&nbsp;<img src="/final/monitor/eg_images/stack_trace.gif" border="0"></a></td>
<%
					}
					else
					{
%>
											<td id="eg_cellbgmedium" align="left"  class="eg_darktextbold"  colspan="<%=al_header.size()+1%>" > &nbsp;<%=sdate%> </td>
<%
					}
				}
				else
				{
%>
											<td id="eg_cellbgmedium" align="left"  class="eg_darktextbold"  colspan="<%=al_header.size()+1%>" > &nbsp;<%=sdate%> </td>
<%
				}
%>
										</tr>
<%
			}

			a_temp = null;
			a_temp = (ArrayList)a_results.get(a+1);

			int rows = 0;
			int rows1 = 0;

			String s_strTemp = "";
			StringTokenizer str ;

			if (strValue==null || strValue.equals("")||strValue.equals("null"))
			{
				for(int p=0; p<a_temp.size(); p++)
				{
					s_strTok = (String)a_temp.get(p);

					if(s_strTok!=null && s_strTok.trim().length()==0)
					{
						continue;
					}

					separateCols = colSeparator;

					if(s_strTok.indexOf(separateCols) > -1)
					{
						al_cols = tokInfo.egTokenizer(s_strTok, separateCols);
						proceed = false;

						// Code written to avoid confusion created by seperators  - Starts ....
						if(al_header.size() != al_cols.size())
						{
							for(int zz=0;zz<al_cols.size();zz++)
							{
								s_strTemp = (String)al_cols.get(zz);
								rows = s_strTemp.lastIndexOf("(");
								rows1 = s_strTemp.lastIndexOf(")");
								if((rows > rows1) && (zz != al_cols.size()-1))
								{
									al_cols.set(zz, (String)al_cols.get(zz)+" "+(String)al_cols.get(zz+1));
									al_cols.remove(zz+1);
									zz = zz-1;
									continue;
								}

								al = tokInfo.egTokenizer(s_strTemp,"'");

								if(al!=null)
									rows = al.size()-1;
								else
									rows=0;

								if(rows==1)
									rows=3;

								if(((rows % 2) != 0 && rows!=0)  && (zz != al_cols.size()-1))
								{
									al_cols.set(zz, (String)al_cols.get(zz)+" "+(String)al_cols.get(zz+1));
									al_cols.remove(zz+1);
									zz = zz-1;
								}
							}
						}
						// Code written to avoid confusion created by seperators  - ....Ends
					}
					else
					{
						proceed = true;
					}
%>
										<tr>
<%
					boolean endLine = false;
					boolean dataEmpty=false;

					if(a == (a_results.size()-2) && (p == a_temp.size()-1))
						endLine = false;
					if((p == a_temp.size()-1))
						endLine = true;
					if(a_temp!=null && a_temp.size()>0 && a_temp.size()>(p+1))
					{
						String s_strTok2=(String)a_temp.get(p+1);
						if(s_strTok!=null && s_strTok2.trim().length()==0)
						dataEmpty = true;
					}

					// new change commonDateLayout
					if(!commonDateLayout){
						vec_Tabletitle.add(sdate);
%>
											<td valign="top" align="left"  id="eg_cellbgmedium" class="linebottomright"><%=sdate%></td>
<%
					}
					else // Saravanan.A added the else part on 14-08-2007.
					{
						vec_Tabletitle.add(" ");
						if(endLine)
						{
%>
											<td valign="top" align="left" class="head_padding4" id="cell_border2" style="border-right-width:0px">&nbsp;</td>
<%
						}
						else if(dataEmpty)
						{
%>
											<td valign="top" align="left" class="head_padding4" id="cell_border2" style="border-right-width:0px">&nbsp;</td>
<%
						}
						else
						{
%>
											<td valign="top" align="left" class="head_padding4">&nbsp;</td>
<%
						}
					}

					if(!proceed)
					{
						for(int len=0;len<al_cols.size();len++)
						{
							String idName = "cell_border2";
							if(!commonDateLayout){
								if(len % 2 == 0){
									idName = "cell_border2";
								}else{
									idName = "cell_border2";
								}
							}

							String val1 = (String) al_cols.get(len);
							val1=EgDbInfo.formatValue(val1)	;
							if (val1 != null && val1.trim().equals("") )
								val1="-";
							else if(val1 != null && (val1.trim().equals("-5.0000")|| val1.trim().equals("-5")))
							{
								val1 = "N/A";
							}
							if(val1 != null && !val1.equalsIgnoreCase("!H")){
								// condition to truncate 0 decimals (ex -> 8.00 as 8)
								if(val1 != null && (val1.endsWith(".0") || val1.endsWith(".00") || val1.endsWith(".000") || val1.endsWith(".0000"))){
									val1 = val1.substring(0,val1.lastIndexOf("."));
								}
%>

											<td valign="top" id="<%=idName%>" align="left" class="eg_11" style="border-left-width:1px;border-right-width:0px;" wrap><%=val1.trim()%></td>
<%
								//lst_DispData.add(val1);
								vec_Tabletitle.add(val1.trim());
							}
						}
					}
					else
					{
						// condition to truncate 0 decimals (ex -> 8.00 as 8)
						if(s_strTok != null && (s_strTok.endsWith(".0") || s_strTok.endsWith(".00") || s_strTok.endsWith(".000") || s_strTok.endsWith(".0000")))
						{
							s_strTok = s_strTok.substring(0,s_strTok.lastIndexOf("."));
						}

						//lst_DispData.add(s_strTok);
						vec_Tabletitle.add(s_strTok.trim());
%>
											<td valign="top"  align="left"  colspan="<%=al_header.size()%>" id="cell_border2" style="border-left-width:1px"> <%out.println(s_strTok.trim());%></td>
<%
					}
%>
										</tr>
<%
					vec_Tabletitle.add("\n");
				}
			}
			else
			{
%>
										<tr>
<%
				String al_cols_str="";

				for (int m=0;m<a_temp.size();m++)
				{
					try
					{
						al_cols=(ArrayList)a_temp.get(m);
					}
					catch(Exception ex)
					{
						al_cols_str=(String)a_temp.get(m);
					}

					if (measure!=null && measure.equals("New_logins"))
						al_cols.remove(2);

					// new change commonDateLayout
					if(!commonDateLayout){
						vec_Tabletitle.add(sdate);
%>
											<td valign="top" align="left" class="eg_11" id="cell_border2"><%=sdate%></td>
<%
					}
					else // Saravanan.A added the else part on 14-08-2007.
					{
						vec_Tabletitle.add(" ");

						if(a_temp.size()>1)
						{
%>
											<td valign="top" align="left" class="eg_11" id="cell_border2" style="border-bottom-width:0px">&nbsp;</td>
<%
						}
						else
						{
%>
											<td valign="top" align="left" class="eg_11" id="cell_border2" style="border-bottom-width:1px">&nbsp;</td>
<%
						}
					}

					if(al_cols_str==null || al_cols_str.equals(""))
					{
						for(int len=0;len<al_cols.size();len++)
						{
							String idName = "white_bg";
							if(!commonDateLayout)
							{
								if(len % 2 == 0)
								{
									idName = "eg_lightlight";
								}
								else
								{
									idName = "white_bg";
								}
							}

							String val1 = (String) al_cols.get(len);
							if(dateFormat!=null && !dateFormat.equals(""))
							{
								if(len==1 && val1.indexOf(":")>-1)
								{
									String date = val1.substring(0,val1.indexOf(" "));
									String time = val1.substring(val1.indexOf(" ")+1);
									date = DateUtil.changeDateFormat(date,"yyyy-MM-dd",dateFormat);
									val1 = date+" "+time;
								}
							}

							val1=EgDbInfo.formatValue(val1)	;

							if (val1 != null && val1.trim().equals("") )
								val1="-";
							else if(val1 != null && (val1.trim().equals("-5.0000")|| val1.trim().equals("-5")))
							{
								val1 = "N/A";
							}

							// condition to truncate 0 decimals (ex -> 8.00 as 8)
							if(val1 != null && (val1.endsWith(".0") || val1.endsWith(".00") || val1.endsWith(".000") || val1.endsWith(".0000")))
							{
								val1 = val1.substring(0,val1.lastIndexOf("."));
							}
%>
											<td valign="top" align="left"  id="cell_border2" class="eg_11"><%=val1.trim()%></td>
<%
							//lst_DispData.add(val1);
							vec_Tabletitle.add(val1.trim());
						}
					}
					else
					{
						StringTokenizer stdd=new StringTokenizer(al_cols_str,"~!~");

						while(stdd.hasMoreTokens())
						{
							String val1 = (String) stdd.nextToken();
							val1=EgDbInfo.formatValue(val1)	;
							val1=val1.trim();
							if (val1 != null && val1.trim().equals("") )
								val1="-";
							else if(val1 != null && val1.trim().equals("-5.0000"))
							{
								val1 = "N/A";
							}
							if(val1 != null && !val1.equalsIgnoreCase("!H"))
							{
								// condition to truncate 0 decimals (ex -> 8.00 as 8)
								if(val1.endsWith(".0") || val1.endsWith(".00") || val1.endsWith(".000") || val1.endsWith(".0000"))
								{
									val1 = val1.substring(0,val1.lastIndexOf("."));
								}
%>
											<td valign="top" align="left"  id="cell_border2" class="eg_11"><%=val1%></td>
<%
								vec_Tabletitle.add(val1);
							}
						}
					}
%>
										</tr>
<%
					vec_Tabletitle.add("\n");
				}
			}

			session.setAttribute("a_results",a_results.clone());
			session.setAttribute("al_cols",al_cols);
			session.setAttribute("al_header",al_header);
			vec_Tabletitle.add("\n");
		}

		listData.add(vec_Tabletitle);
%>
									</table>
								</div>
								</td>
							</tr>

<%
		}
		else
		{
			String NoMeasuresHeight="485px";
			if(isFromDashBoardOverview)
			{
				NoMeasuresHeight="270px";
			}
%>
							<tr>
								<td width="100%" height="<%=NoMeasuresHeight%>" nowrap class="eg_whitebg" align="center" id="data_border" valign="middle">
									<table cellspacing="0" cellpadding="2" width="100%" align="center" border="0" >
										<tr>
											<td align="center"  ><img src = "/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif" width="44px" height="40px" border="0"></td>
										</tr>
										<tr>
											<td align="center" id="eg_errorsmall"  height="100%">
<%
		if(s_flag.equals("0"))
		{

			String displayTime = ui.getDDDisplayTime();
			double dTime = 1.0;
			try
			{
				dTime = Double.parseDouble(displayTime);
			}
			catch(Exception e)
			{
				dTime = 1.0;
			}
			if(testInfo.isFrequencySet())
			{
%>
											<egui:intnl text="monitor.detaileddiagnosis.No detailed measures available for the last "/><%=dTime%><egui:intnl text="monitor.detaileddiagnosis.hour(s)"/>
<%
			}
			else
			{
%>
											<egui:intnl text="monitor.detaileddiagnosis.Normal samples/Bad samples are not configured for detailed diagnosis"/>
<%
			}
		}
		else
		{
%>
											<egui:intnl text="monitor.detaileddiagnosis.No detailed measures available for this combination of parameters"/>
<%
		}
%>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<!-- </table> -->
<%
	}
%>

						</table>
					</td>
<%
	if(fromDashboardOverview==null)
	{
%>
					<td class="popupInnerbg"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="7"></td>
				</tr>
				<tr>
					<td class="popupBottleft"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="7"></td>
					<td class="popupInnerbg"><img src="/final/monitor/eg_images/spacer.gif"></td>
					<td class="popupBottright"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="7"></td>
				</tr>
<%
	}
	else
	{
%>
				</tr>
<%
	}
%>
					
				
			</table>
		</td>
	</tr>
</table>

<%
	session.setAttribute("list",listData);
	a_temp =new ArrayList();
	a_results.clear();
	session.setAttribute("curTabQS",request.getQueryString());
}
catch(Exception e)
{
	e.printStackTrace();
}

if((request.getParameter("newWindow")==null || (request.getParameter("newWindow")!=null && !request.getParameter("newWindow").equals("true"))) && request.getParameter("comeFrom")==null  && (request.getParameter("fromHistoricalEvents")==null || !request.getParameter("fromHistoricalEvents").equals("true")) && (request.getParameter("fromDDGraphs")==null || !request.getParameter("fromDDGraphs").equals("true")))
{
	if(request.getQueryString()!=null)
	session.setAttribute("monitorLastSession","/final/monitor/egDashDDData.jsp?"+request.getQueryString());
	else
	session.setAttribute("monitorLastSession","/final/monitor/egDashDDData.jsp?");
}
%>

</body>
</html>