<%
/**
 *	File name		: eGJTMQuery.jsp
 *	Purpose			: This page shows the List of Queries & Exceptions executed at a particular web Request
 *	Version			: eG 5.5
 *	Creation Date	: 10-03-2012
 *	Author			: Mr.R
 *	Design Help 	: Mr.Jaiwin
 */
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import = "java.text.*" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.EgSorter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.monitor.EgJTMHelper"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<egui:skin ui="monitor"/>
<div style="float:left; border:0px solid red;width:100%;height:100%;padding:6px">
<%!
	private DecimalFormat df = new DecimalFormat("#.####");
%>

<%
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	String isTable = isFirefox ? "Auto" : "Fixed";

	String label = request.getParameter("label");
	String key = request.getParameter("key");
	String index = request.getParameter("index");
	String only = request.getParameter("only");
	String measureName = request.getParameter("s_measure");
	String infoName = request.getParameter("info");

	boolean isQuery = false;
	boolean isException = false;
	ArrayList expList = new ArrayList();
	ArrayList fullQuerySortedList = new ArrayList();
	Hashtable fullQryHashTable  = new Hashtable();

	Hashtable jtmDetails = (Hashtable) session.getAttribute("JtmTree");
	ArrayList resultList = (ArrayList) jtmDetails.get(key);

	EgJTMHelper jtmHelper = new EgJTMHelper();
	if(resultList!=null && resultList.size() == 5)	// Should be 5
	{
		String requestedTime = (String)resultList.get(0);
		String requestedURI = (String)resultList.get(1);
		String requestedHost = (String)resultList.get(2);
		String responseTime = (String)resultList.get(3);
		String subCompDetails = (String)resultList.get(4);
		//String nodeDetails = (String)resultList.get(5);
		String nodeDetails = new String();
		Hashtable nodeInfo = (Hashtable) session.getAttribute("NodeInfo");
		if(nodeInfo.containsKey(resultList.toString())){
			nodeDetails = (String) nodeInfo.get(resultList.toString());
		}
		else{
			IniFile UIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
			String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			String resultDateTime  = DateUtil.changeDateFormat(requestedTime , currentDateFormat+ " HH:mm:ss", "MM/dd/yyyy HH:mm:ss");

			nodeDetails = jtmHelper.getNodeDetails(requestedURI , resultDateTime , requestedHost , responseTime , subCompDetails , measureName , infoName);
			nodeInfo.put(resultList.toString() , nodeDetails);
			session.setAttribute("NodeInfo" , nodeInfo);
		}

		Hashtable allDataTable = jtmHelper.getQueryAndException(nodeDetails);

		if(index!=null && index.length() > 0 && allDataTable.containsKey(index))
		{
			fullQuerySortedList  = (ArrayList)allDataTable.get(index);
		}
		else
		{
			if(allDataTable.containsKey("FULLQUERY"))
			{
				fullQryHashTable  = (Hashtable)allDataTable.get("FULLQUERY");
			}
		}

		if(only!=null && !only.equals("sql") && allDataTable.containsKey("FULLEXP"))
		{
			expList = (ArrayList) allDataTable.get("FULLEXP");
		}
	}

	if(fullQryHashTable!=null && fullQryHashTable.size() > 0)
	{
		if(label!=null && label.length() > 0)
		{
			ArrayList myQueryList = new ArrayList();
			if(label.equals("all"))
			{
				Set keys = fullQryHashTable.keySet();
				Iterator itr = keys.iterator();
				while(itr.hasNext())
				{
					String qkey = (String) itr.next();
					ArrayList tmpList = (ArrayList) fullQryHashTable.get(qkey);
					myQueryList.addAll(tmpList);
				}
			}
			else
			{
				myQueryList = (ArrayList) fullQryHashTable.get(label);
			}

			if(myQueryList!=null && myQueryList.size() > 0 )
			{
				// Full Query details sorting
				EgSorter egSort = new EgSorter(myQueryList,2);
				fullQuerySortedList = (ArrayList)egSort.sort(2,"Double","desc");
			}
		}
	}
	
	if(fullQuerySortedList!=null && fullQuerySortedList.size() > 0)
		isQuery = true;
	if(expList!=null && expList.size() > 0)
		isException = true;

	if(isQuery)
	{
%>
	<div class="clr" style="border:0px solid red;">
		<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" >
			<tr>
				<td>
					<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="jtm_Table linesquare" ><colgroup width="120px">
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.URL'/> </td>
							<td align="left" class="tdborder_jvm"><div class="urlWidth" style="word-wrap: break-word;white-space:wrap;width:500px"><%=(String)resultList.get(1)%></div></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.Response Time'/></td>
							<td align="left" class="tdborder_jvm"><%=(String)resultList.get(3)%>&nbsp; <egui:intnl text='monitor.layermodel.Secs'/></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.Requested Time'/></td>
							<td align="left" class="tdborder_jvm"><%=(String)resultList.get(0)%></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.Remote Host'/></td>
							<td align="left" class="tdborder_jvm"><%=(String)resultList.get(2)%></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr><td><img src="/final/images/clear.png" height="6"/></td></tr>
	<!-- <table width="100%" border="0" class="white_bg" cellspacing="0" cellpadding="0"> -->
			<tr>
				<td width="100%" >
				<div class="x-table" >
					<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="x-grid-table x-grid-table-resizer x-table-outer-border" style="table-layout:auto">
						<thead >
							<tr class="x-grid-row  x-grid-row-alt">
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" wrap align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.Serial No'/></td> 
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" wrap align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.Duration (Secs)'/></td> 
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.Query Details'/></td> 
							</tr>
						</thead>
						<tbody>
<%
				int x=1;
				for(int k=0;k<fullQuerySortedList.size();k=k+2)
				{
					String qryString = (String)fullQuerySortedList.get(k);
					String qryTime = (String)fullQuerySortedList.get(k+1);
					double exec_time = Double.parseDouble(qryTime);
					String tempqryString = stringParse(qryString);
%>
							<tr class="x-grid-row  x-grid-row-alt mouse">
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first"><%=x++%></td>
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first"><%=df.format(exec_time)%></td>
								<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" style="text-align:left;padding-left:6px"><div class="urlWidth" style="word-wrap: break-word;white-space:wrap;width:500px"><%=tempqryString%></div></td>
							</tr>
<%
				}
%>
						</tbody>
					</table>
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
	}
	// Exception Details
	if(isException)
	{
		if(isQuery)
		{
%>
			<br/>
<%
		}
%>
	<div class="clr" style="border:0px solid green;">
	<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" style="margin-top:6px" class="jtm_table jtm_DatapanelBody">
		<tr>
			<td class="jtm_DatapanelHeader" align="left" style="padding:0 0 0 10px"><egui:intnl text='monitor.layermodel.StackTrace'/></td> 
		</tr>
<%
		for(int k=0;k<expList.size();k++)
		{
			String expString = (String)expList.get(k);
			ArrayList traceToken = StringUtils.egTokenizer(expString,"?^?");
				String leftSpace = "";
				String boldFont = "eg_75bold";

				for(int y=0;y<traceToken.size();y++)
				{
					String expLine = (String)traceToken.get(y);
					if(expLine!=null && expLine.trim().length()>0)
					{
						if (y > 0)
						{
							leftSpace = "padding-left:20px";
							boldFont = " ";
						}
%>
		<tr>
			<td class="tdborder_jvm <%=boldFont%>" style="<%=leftSpace%>" ><%=expLine%></td>
		</tr>
<%
					}
				}
%>
		<tr>
			<td class="tdborder2_jvm">&nbsp;</td>
		</tr>
<%
		}
%>
	</table>
	</div>
<%
	}

	if(!isQuery && !isException)
	{
%>
	<div class="clr" style="border:0px solid red;height:100%;">
		<table align="left" cellspacing="0" cellpadding="6" height="100%" width="100%" >
			<tr>
				<td>
					<table align="left" cellspacing="0" cellpadding="0" height="100%" width="100%" border="0">
						<tr>
							<td align="center" valign="middle" class="commonErrorMsgText"> 
								<img src="/final/images/clear.png" align="center" border="0" class="iconInformation"/><br>
								<egui:intnl text='monitor.layermodel.No Query Details for this request ! '/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
<%
	}
%>
<%!
	public String stringParse(String in)
	{
		try
		{
			int charAmount = in.length();  
			StringBuffer buffer = new StringBuffer();   
			for (int i=0; i<charAmount; i++)
			{  
				char c = in.charAt(i);  
				switch (c)
				{
					case '<': buffer.append ("&lt;"); break;  
					case '>': buffer.append ("&gt;"); break;  
					case '&': buffer.append ("&amp;"); break;  
					case '"': buffer.append ("&quot;"); break;  
					case '#': buffer.append ("&#35;"); break;  
					case '/': buffer.append ("&#47;"); break;  
					case ';': buffer.append ("&#59;"); break;  
					case '{': buffer.append ("&#123;"); break;  
					case '}': buffer.append ("&#125;"); break;  
					default: buffer.append(c); break;  
				}
			}
			in = buffer.toString();
			return (in);
		}
		catch(Exception e)
		{
			System.err.println ("Error in stringParse(): " + e);  
			return (null);  
		}
	}
%>
</div>
