<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "java.math.*"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "java.text.*" %>
<%@ page import = "java.io.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<html>

<head>
	<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<style>


.highlightFieldsetHtmlDivBox{
  border-style: solid;
  border-width: 1px 1px 1px 1px;
  background:#ffffff;
  border-color:#e7e7e7 #e7e7e7 #e7e7e7 #e7e7e7;
  padding:0px;
  text-align:center;
   -webkit-box-sizing: border-box;
  -moz-box-sizing: border-box;
  box-sizing: border-box;
  display:inline-block;
  position:relative;
}
.highlightFieldsetHtmlDivBoxTitle{
    position: absolute;
    top:-12px;
    left: 20;
    background-color: #fff;
    color: #000000;
    padding: 2px 4px 2px 0px;
    font-size: 16px !important;
    font-family: 'Roboto-Bold';
    font-weight: 400 !important;
}
.appFlowSummaryDiv{
	background-color:#ffffff;
	display:block;
	width:740px;
	margin:0px;
	padding:0px;
	border:1px solid #dedede;
	box-sizing: border-box;
}

.appFlowSummaryTable{
	border-collapse: collapse;
    border-spacing: 0;
	table-layout:fixed;
	border-top:0px solid #b4b5b6;
}

.appFlowSummaryTable tr td{padding:8px 5px 12px 0px;vertical-align:top;line-height:18px}

</style>
</head>


<body leftmargin="20px" topmargin="20px">


<%
JSONObject jsonPDFResult = new JSONObject();
JSONObject jsonResult = new JSONObject();
jsonPDFResult = (JSONObject)session.getAttribute("TopologyData");
jsonResult = (JSONObject)session.getAttribute("jsonResult");

// System.out.println("jsonResult ___________ "+jsonResult);
// System.out.println("jsonPDFResult ___________ "+jsonPDFResult);

String strRequestUrl = (String)jsonPDFResult.get("requestUrl");
String strURLAccessedTime = (String)jsonPDFResult.get("URLAccessedTime");
String strTestName = (String)jsonPDFResult.get("TestName");
String strHighestTimeProcessNodename ="";
String strHighestTimeProcessTierName ="";
JSONObject totalHeaderDataObj =(JSONObject)(((JSONArray)jsonResult.get("headerDetails")).get(0));
JSONObject tabBTMData = (JSONObject)((JSONObject)jsonResult.get("userTooltip")).get("tabBTM");
JSONObject tabData = (JSONObject)tabBTMData.get("tabData");

JSONObject byTier = (JSONObject) tabData.get("byTier");
JSONObject byServer = (JSONObject) tabData.get("byServer");


JSONArray chartSeries = (JSONArray)byTier.get("series");
JSONArray chartSeriesByServer = (JSONArray)byServer.get("series");

JSONObject bytierChartData = (JSONObject)chartSeries.get(0);
JSONArray chartdataByTier = (JSONArray)bytierChartData.get("data");
JSONObject byServerChartData = (JSONObject)chartSeriesByServer.get(0);
JSONArray chartdataByServer = (JSONArray)byServerChartData.get("data");

JSONArray dataSetterByTier = new JSONArray();
double dmax=0;
for(int i=0;i<chartdataByTier.size();i++)
{
	JSONObject resLst = new JSONObject();
	JSONObject jobj = (JSONObject)chartdataByTier.get(i);
	String strName = (String)jobj.get("name");
	String strcolor = (String)jobj.get("color");
	resLst.put("name",strName);
	try{
		double dVal = ((Integer)jobj.get("y")).intValue();
		if(dVal>dmax)
		{
			dmax = dVal;
			strHighestTimeProcessTierName = strName;
		}
	}catch(Exception e){ e.printStackTrace();}
	resLst.put("y",jobj.get("y"));
	resLst.put("color", strcolor);
	resLst.put("enabled", "true");
	dataSetterByTier.add(resLst);
}

JSONObject obj_d = new JSONObject();
JSONArray jarr_d = new JSONArray();
obj_d.put("data", dataSetterByTier);
jarr_d.add(obj_d);

JSONObject donutChartByTier = new JSONObject();
donutChartByTier.put("DataSet", jarr_d);
donutChartByTier.put("borderWidth", "true");
donutChartByTier.put("pieSize", "100%");
donutChartByTier.put("innerSize", "50%");
donutChartByTier.put("chartHeight", "194");
donutChartByTier.put("chartWidth", "194");
donutChartByTier.put("cType", "donut");
donutChartByTier.put("chartType", "donut");
donutChartByTier.put("isDataLabelEnableForDonut", "true");
donutChartByTier.put("formatForLegendOnlyPercentage", "true");


JSONArray dataSetterbyServer = new JSONArray();
double dmax_tier = 0;
for(int i=0;i<chartdataByServer.size();i++)
{
	JSONObject resLst = new JSONObject();
	JSONObject jobj = (JSONObject)chartdataByServer.get(i);
	String strName = (String)jobj.get("name");
	String strcolor = (String)jobj.get("color");
	resLst.put("name",strName);
	resLst.put("y",jobj.get("y"));
	try{
		double dVal = ((Integer)jobj.get("y")).intValue();
		if(dVal>dmax_tier)
		{
			dmax_tier = dVal;
			strHighestTimeProcessNodename = strName;
		}
	}catch(Exception e){}
	resLst.put("color", strcolor);
	resLst.put("enabled", "true");
	dataSetterbyServer.add(resLst);
}
obj_d = new JSONObject();
jarr_d = new JSONArray();
obj_d.put("data", dataSetterbyServer);
jarr_d.add(obj_d);



JSONObject donutChartByServer = new JSONObject();
donutChartByServer.put("DataSet", jarr_d);
donutChartByServer.put("borderWidth", "true");
donutChartByServer.put("pieSize", "100%");
donutChartByServer.put("innerSize", "50%");
donutChartByServer.put("chartHeight", "194");
donutChartByServer.put("chartWidth", "194");
donutChartByServer.put("chartType", "donut");
donutChartByServer.put("isDataLabelEnableForDonut", "true");
donutChartByServer.put("formatForLegendOnlyPercentage", "true");





ByteArrayOutputStream bos = new ByteArrayOutputStream();
ByteArrayOutputStream bosByServer = new ByteArrayOutputStream();
egurkha.reporter.ErHighChartExport exportchart = new egurkha.reporter.ErHighChartExport();
exportchart.getTimeLineImage(donutChartByTier,150,150,bos);
exportchart.getTimeLineImage(donutChartByServer,150,150,bosByServer);
String strSegment = (String)totalHeaderDataObj.get("Request Processing Time");

String strStartJVMNodeName = "";
int totalJVM=0;
JSONArray nodeList = (JSONArray)jsonResult.get("nodes");
EgAPMInfo apm = new EgAPMInfo("manager");
String apmType = apm.getAPMType(strTestName);
String strSearchString = apmType;
if(apmType!=null && apmType.equalsIgnoreCase("DotNet"))
	strSearchString=".Net";


if(nodeList!=null && nodeList.size()>0)
{
	JSONObject jobj_nodeOrder=(JSONObject) nodeList.get(0);
	Iterator itr = jobj_nodeOrder.keys();
	while (itr.hasNext()) 
	{
		String key = (String) itr.next();
		JSONObject jnodeVal = (JSONObject)jobj_nodeOrder.get(key);
		if(key!=null && key.equalsIgnoreCase("1"))
		{
			strStartJVMNodeName = (String)jnodeVal.get("componentName");
		}
		String strNodeText = (String)jnodeVal.get("nodeText");
		if(strNodeText!=null && strNodeText.equalsIgnoreCase(strSearchString))
			totalJVM = totalJVM+1;
	}
}

String strTotalJVM="";
String strJVMDisplayName="";
if(apmType!=null && apmType.equalsIgnoreCase("Java"))
{
	if(totalJVM==1)
		strTotalJVM = totalJVM+" JVM";
	else
		strTotalJVM = totalJVM+" JVMs";
	strJVMDisplayName="JVM";
}else if(apmType!=null && apmType.equalsIgnoreCase("DotNet"))
{
	if(totalJVM==1)
		strTotalJVM = totalJVM+" CLR";
	else
		strTotalJVM = totalJVM+" CLRs";
	strJVMDisplayName="CLR";
}

%>
<h1 style="color:#ffffff;font-size:1px;margin:0px;padding:0px">Executive Summary</h1>

<div><span class="newFont_bold18">Executive Summary </span>
<p class="newFont_normal12">The request with URL "<%=strRequestUrl%>" was received at the entry <%=strJVMDisplayName%>: <%=strStartJVMNodeName%>. In total, this request spanned <%=strTotalJVM%> as outlined below.<br/>
The <%=strJVMDisplayName%> that consumed the maximum processing time was <span style="background-color:#ededed">&nbsp;<%=strHighestTimeProcessNodename%>.&nbsp;</span></p>

<table width="100%" border="0px">
	<tr>
		
		<td align="left" valign="top" width="100%" height="100%">
		<div class="highlightFieldsetHtmlDivBox" style="width:100%;float:left;margin-top:5px">
		<div class="highlightFieldsetHtmlDivBoxTitle" style="width:240px"><span class="newFont_bold15">Server Processing Time Breakup</span></div>

			<table width="100%">
				<tr>
					<td width="50%" align="left">
						<table  border="0px">
							<tr>
								<td style="width:150px">&nbsp;</td>
								<td colspan="2" class="font_bold13">This Request Spanned <span style="background-color:#ededed">&nbsp;<%=strTotalJVM%>&nbsp;</span></td>
							</tr>
<%
				for(int jj=0;jj<dataSetterbyServer.size();jj++)
				{
					JSONObject jobjDataSet = (JSONObject)dataSetterbyServer.get(jj);
%>
							<tr>
								<td style="width:150px">&nbsp;</td>
								<td align="right" width="5%"><img width="auto" height="auto" src="/final/images/Light/right-arrow.png" style="vertical-align:middle"/></td>
<%
									String strNodeName = (String)jobjDataSet.get("name");
									if(strNodeName.equalsIgnoreCase(strStartJVMNodeName))
									{
%>
										<td class="font_normal12"><%=jobjDataSet.get("name")%>&nbsp;(Entry <%=strJVMDisplayName%>)</td>
<%
									}else
									{
%>
									<td class="font_normal12"><%=jobjDataSet.get("name")%></td>
<%
									}
%>
							</tr>
<%
				}
%>
						</table>
					</td>
					<td width="50%">
						<table border="0px" width="100%">
							<tr>
								<td width="50%" valign="middle" style="padding:5px 5px 10px 5px">
								<%=bosByServer%>
								</td>
								<td align="left" width="50%">
									<table width="100%">
<%
				for(int jj=0;jj<dataSetterbyServer.size();jj++)
				{
					JSONObject jobjDataSet = (JSONObject)dataSetterbyServer.get(jj);
%>
										<tr>
											<td class="font_normal11" style="padding:3px">
											<svg width="12px" height="12px" xmlns="http://www.w3.org/2000/svg">
												<g>
													<circle cx="5" cy="8" r="3" fill="<%=jobjDataSet.get("color")%>" stoke-width="0" ></circle>
												</g>
											</svg>
											&nbsp;&nbsp;<%=jobjDataSet.get("name")%>&nbsp;(<%=jobjDataSet.get("y")%> ms)</td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<div style="clear:both;height:20px">&nbsp;</div>

		<p>From a tier breakup perspective, the maximum processing time (across all <%=strJVMDisplayName%>s) was consumed by the <span style="background-color:#ededed">&nbsp;<%=strHighestTimeProcessTierName%> tier.&nbsp;</span></p>

		<div class="highlightFieldsetHtmlDivBox" style="width:100%;float:left;margin-top:10px">
		<div class="highlightFieldsetHtmlDivBoxTitle" style="width:100px"><span class="newFont_bold15">Tier Breakup</span></div>

			<table width="100%">
				<tr>
					<td width="50%" align="left">
						<table  border="0px">
							<tr>
								<td style="width:150px">&nbsp;</td>
								<td colspan="2" class="font_bold13">This request involved the following tiers: </td>
							</tr>
<%
				for(int jj=0;jj<chartdataByTier.size();jj++)
				{
					JSONObject jobjDataSet = (JSONObject)chartdataByTier.get(jj);
%>
							<tr>
								<td style="width:150px">&nbsp;</td>
								<td align="right" width="5%"><img width="auto" height="auto" src="/final/images/Light/right-arrow.png" style="vertical-align:middle"/></td>
								<td class="font_normal12"><%=jobjDataSet.get("name")%></td>
							</tr>
<%
				}
%>
						</table>
					</td>
					<td width="50%">
						<table border="0px" width="100%">
							<tr>
								<td width="50%" valign="middle" style="padding:5px 5px 10px 5px">
								 <%=bos%>
								</td>
								<td align="left" width="50%">
									<table width="100%">
<%
				for(int jj=0;jj<chartdataByTier.size();jj++)
				{
					JSONObject jobjDataSet = (JSONObject)chartdataByTier.get(jj);
%>
										<tr>
											<td class="font_normal11" style="padding:3px">
											<svg width="12px" height="12px" xmlns="http://www.w3.org/2000/svg">
												<g>
													<circle cx="5" cy="8" r="3" fill="<%=jobjDataSet.get("color")%>" stoke-width="0" ></circle>
												</g>
											</svg>
											&nbsp;&nbsp;<%=jobjDataSet.get("name")%>&nbsp;(<%=jobjDataSet.get("y")%> ms)</td>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
</div>
</body>
</html>