<%
/*
 *   File					:	ecDiskCapacity.jsp
 *   Purpose				:	Shows distribution of system by HardDisk capacity
 *   Creation Date			:	08-02-2007
 *   Author					:	Balasigamani
 *   UI Design				:	Krishnamurthi
 *   UI Design Changes		:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.config.*" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String userName = (String)session.getAttribute("sess_auserid");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	EcUtils ecUtils=new EcUtils();
	EcDiskCapacityResult result=(EcDiskCapacityResult)request.getAttribute("Result");
	EcPrintData printData=new EcPrintData();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	String configSkin = user.getConfigSkin();
	Map capacityData=result.getCapacityData();
	Vector capacityLabel=result.getCapacityLabel();
	Vector capacityDisplay=result.getCapacityDisplay();
	String startRange=result.getStartRange();
	String endRange=result.getEndRange();
	String rangeOption=result.getRangeOption();
	Map systemCapacity=(TreeMap)result.getSystemCapacity();
	Map systemOSName=(TreeMap)result.getSystemOSName();
	ArrayList distribution=result.getDistribution();

	String id = request.getParameter("id");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		rangeOption = (String)scheduleDetails.get("rangeOption");
		startRange = (String)scheduleDetails.get("startRange");
		endRange = (String)scheduleDetails.get("endRange");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		submitOrNot = "false";
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
%>

<html>
<head>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>

<script language="JavaScript1.2">
	function showDetails()
	{
		var thisForm = document.DiskCapacity;
		var limitValue= thisForm.limit.value;
		var startRange=parseInt(thisForm.start.value);
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if(limitValue=="BETWEEN")
		{
			var endRange=parseInt(thisForm.end.value);
			if(startRange>=endRange)
			{
				alert('<egui:intnl text="configmgmt.inventory.system.Start size should be less than End size" />');
				return;
			}
			else
			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=DiskCapacity&rangeOption="+limitValue+"&startRange="+startRange+"&endRange="+endRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
		}
		else
		{
			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=DiskCapacity&rangeOption="+limitValue+"&startRange="+startRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
		}
		document.DiskCapacity.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
		document.DiskCapacity.secsubmt.disabled=true;
	}

	function validateforSchedule()
	{
		var thisForm = document.DiskCapacity;
		var limitValue= thisForm.limit.value;
		var startRange=parseInt(thisForm.start.value);
		var tempCriteria = "";
		var tempUserOption = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}
	}

	function printData()
	{
<%
		if(capacityData == null || capacityData.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=HardDisk_Audit");
		printQS.append("&printPageTitle=DISTRIBUTION_REPORT_OF_MANAGED_SYSTEMS_BY_HARD_DISK_CAPACITY");
		printQS.append("&Page=AuditReport");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function show()
	{
		var thisForm = document.DiskCapacity;
		var option = thisForm.limit.value;
		if (option == "LESSTHAN" || option == "GREATERTHAN" || option == "LESSTHAN_OR_EQUAL" || option == "GREATERTHAN_OR_EQUAL")
		{
			document.getElementById("caplbl").style.display = "none";
			document.getElementById("capEnd").style.display = "none";
		}
		else
		{
			document.getElementById("caplbl").style.display = "block";
			document.getElementById("capEnd").style.display = "block";
		}
	}

	function savePdf()
	{
<%
		if(capacityData == null || capacityData.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByHardDiskCapacity");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (capacityData == null || capacityData.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.DiskCapacity;
		var limitValue= thisForm.limit.value;
		var startRange=parseInt(thisForm.start.value);
		var endRange=parseInt(thisForm.end.value);
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					limitValue = "BETWEEN";
				}
			}
			else
			{
				limitValue = "BETWEEN";
			}
		}

		window.location.href = "../servlet/com.eg.EcConfigurationServlet?cmd=DiskCapacity&rangeOption="+limitValue+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
<%
		if (capacityData == null || capacityData.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.DiskCapacity;
<%
		if (systemCapacity == null || systemCapacity.isEmpty())
		{
%>
			alert('<egui:intnl text="configmgmt.common.No components have been managed" />');
			return;
<%
		}
%>
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=FromModify";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=DiskCapacity";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" >
<form name="DiskCapacity" method="POST" style="margin:0px">
<input type="hidden" name="ec_rtype" value="DiskCapacity">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="rangeOption" value="<%=rangeOption%>">
<input type="hidden" name="startRange" value="<%=startRange%>">
<input type="hidden" name="endRange" value="<%=endRange%>">
<input type="hidden" name="isSubmit" value="true">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.inventory.system.DISTRIBUTION OF MANAGED SYSTEMS" />&nbsp; <egui:intnl text="configmgmt.inventory.system.BY" /> &nbsp;<egui:intnl text="configmgmt.inventory.system.HARD DISK CAPACITY" /></b>
					</td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="100"><col width="100"><col width="10"><col width="155"><col width="100"><col width="16"><col width="94"><col width="200">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;
											</td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.system.Hard Disk Capacity" /></td>
											<td align="center">:</td>
											<td>
												<select name="limit" onChange="javascript:show();">
<%
	if("LESSTHAN".equalsIgnoreCase(rangeOption))
	{
%>
							<option value="LESSTHAN" selected><egui:intnl text="configmgmt.inventory.system.Less Than" /></option>
							<option value="LESSTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Less Than Or Equal To" /></option>
							<option value="GREATERTHAN"><egui:intnl text="configmgmt.inventory.system.Greater Than" /></option>
							<option value="GREATERTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Greater Than Or Equal To" /></option>
							<option value="BETWEEN"><egui:intnl text="configmgmt.inventory.system.Between" /></option>
<%
	}
	else if ("LESSTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
	{
%>
							<option value="LESSTHAN"><egui:intnl text="configmgmt.inventory.system.Less Than" /></option>
							<option value="LESSTHAN_OR_EQUAL" selected><egui:intnl text="configmgmt.inventory.system.Less Than Or Equal To" /></option>
							<option value="GREATERTHAN"><egui:intnl text="configmgmt.inventory.system.Greater Than" /></option>
							<option value="GREATERTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Greater Than Or Equal To" /></option>
							<option value="BETWEEN"><egui:intnl text="configmgmt.inventory.system.Between" /></option>
<%
	}
	else if("GREATERTHAN".equalsIgnoreCase(rangeOption))
	{
%>
							<option value="LESSTHAN"><egui:intnl text="configmgmt.inventory.system.Less Than" /></option>
							<option value="LESSTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Less Than Or Equal To" /></option>
							<option value="GREATERTHAN" selected><egui:intnl text="configmgmt.inventory.system.Greater Than" /></option>
							<option value="GREATERTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Greater Than Or Equal To" /></option>
							<option value="BETWEEN"><egui:intnl text="configmgmt.inventory.system.Between" /></option>
<%
	}
	else if ("GREATERTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
	{
%>
							<option value="LESSTHAN"><egui:intnl text="configmgmt.inventory.system.Less Than" /></option>
							<option value="LESSTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Less Than Or Equal To" /></option>
							<option value="GREATERTHAN"><egui:intnl text="configmgmt.inventory.system.Greater Than" /></option>
							<option value="GREATERTHAN_OR_EQUAL" selected><egui:intnl text="configmgmt.inventory.system.Greater Than Or Equal To" /></option>
							<option value="BETWEEN"><egui:intnl text="configmgmt.inventory.system.Between" /></option>
<%
	}
	else
	{
%>
							<option value="LESSTHAN"><egui:intnl text="configmgmt.inventory.system.Less Than" /></option>
							<option value="LESSTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Less Than Or Equal To" /></option>
							<option value="GREATERTHAN"><egui:intnl text="configmgmt.inventory.system.Greater Than" /></option>
							<option value="GREATERTHAN_OR_EQUAL"><egui:intnl text="configmgmt.inventory.system.Greater Than Or Equal To" /></option>
							<option value="BETWEEN" selected><egui:intnl text="configmgmt.inventory.system.Between" /></option>
<%
	}
%>
												</select>
											</td>
											<td align="right" >
												<select name="start">
													<%=ecUtils.fillSelectBox(capacityLabel,capacityDisplay,"",startRange)%>
												</select>
											</td>
											<td align="center" >
<%
	if("BETWEEN".equalsIgnoreCase(rangeOption))
	{
%>
												<span id="caplbl" style="display:block" >-</span>
<%
	}
	else
	{
%>
												<span id="caplbl" style="display:none" >-</span>
<%
	}
%>
											</td>
											<td align="left">
<%
	if("BETWEEN".equalsIgnoreCase(rangeOption))
	{
%>
												<span id="capEnd"  style="display:block">
<%
	}
	else
	{
%>
												<span id="capEnd"  style="display:none">
<%
	}
%>
													<select name="end">
														<%=ecUtils.fillSelectBox(capacityLabel,capacityDisplay,"",endRange)%>
													</select>
												</span>
											</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" >&nbsp;</td>
											<td align="center" colspan="6" valign="middle" height="20">
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
<%
	}
	else
	{
%>
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showDetails()">
<%
	}
%>
											</td>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center" id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (capacityData!=null && capacityData.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();

		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY HARD DISK CAPACITY") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY HARD DISK CAPACITY") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String reportSubTitle = "";
		reportAttributes.setSubTitle(reportSubTitle);

		reportAttributes.setReportName("SystemsByHardDisk");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		printData.setRangeOption(rangeOption);
		printData.setStartRange(startRange);
		printData.setEndRange(endRange);
		printData.setListData(distribution);
		printData.setSystemData(systemCapacity);
		printData.setSystemOsData(systemOSName);
		printData.setMapData(capacityData);
		
		printData.setCapacityLabel(capacityLabel);
		printData.setCapacityDisplay(capacityDisplay);
%>
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
								<!-- <div id="div_scroll" style="width:100%;height:100%;border:0px solid #000000"> -->
									<table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
		if("BETWEEN".equalsIgnoreCase(rangeOption))
		{
			String titleName = "Distribution of Systems By Hard Disk Capacity";
			titleName = mappingInfo.getTextDescription("configmgmt.inventory.system."+titleName);
			String sampleValues="";
			String barLabels="";
			String barLabelAngle="360";
			int maxCount=0;
			int count=0;
			int size=0;
			String yAxisMaxValue = " ";
			ArrayList aListCount = new ArrayList();
			for(int n=0;n<distribution.size();n++)
			{
				String capacityName=(String)distribution.get(n);
				ArrayList systemName=(ArrayList)capacityData.get(capacityName);
				if(systemName==null || systemName.size()==0)
					size=0;
				else
					size=systemName.size();
				
				if (!aListCount.contains(new Integer(size)))
				{
					aListCount.add(new Integer(size));
				}

				if(count==0)
				{
					sampleValues=""+size;
					barLabels=capacityName+" GB";
				}
				else
				{
					sampleValues=sampleValues+","+size;
					barLabels=barLabels+","+capacityName+" GB";
				}
				maxCount=Math.max(size,maxCount);
				count++;
			}
			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Column Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("xAxisName","Hard Disk Capacity");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","1");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("maxColWidth","40");
			mapChartAttributes.put("labelDisplay","ROTATE");
			mapChartAttributes.put("slantLabels","1");
			mapChartAttributes.put("placeValuesInside","1");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("columnLabels",barLabels);
			mapChartData.put("columnValues",sampleValues);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","false");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForColumnChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Column Chart Data ends
			if(distribution.size()>5)
				barLabelAngle="290";

			printData.setBarLabel(barLabels);
			printData.setSampleValue(sampleValues);
			printData.setSampleAxisLabel(barLabelAngle);		//using this method for barLabelAngle
			printData.setMaxRange(String.valueOf(maxCount));

			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
										<tr>
											<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
											</td>
										</tr>
										<tr>
											<td colspan="2" align="center" width="100%">
												<b><%=titleName%></b>
											</td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column3D">
													<param name="movie" value="/final/FusionCharts/swf/Column3D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
													<param name="quality" value="high" />
													<param name="wmode" value="transparent" />
													<embed src="/final/FusionCharts/swf/Column3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="Column3D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartColumnDisk3DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myColumnDisk3DChartId" ) )
															FusionCharts( "myColumnDisk3DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/Column3D.swf","myColumnDisk3DChartId", "90%", "280","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartColumnDisk3DContainer");
												</script>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
											<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
											</td>
										</tr>
										<tr>
											<td colspan="2" align="center" width="100%">
												<b><%=titleName%></b>
											</td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column2D">
													<param name="movie" value="/final/FusionCharts/swf/Column2D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
													<param name="quality" value="high" />
													<embed src="/final/FusionCharts/swf/Column2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="Column2D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartColumnDisk2DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myColumnDisk2DChartId" ) )
															FusionCharts( "myColumnDisk2DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/Column2D.swf","myColumnDisk2DChartId", "90%", "280","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartColumnDisk2DContainer");
												</script>
											</td>
										</tr>
<%
			}

			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
			
			ArrayList aListData = new ArrayList();
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=HARDDISK_CAPACITY_DISTRIBUTION&chartType=bar&height=260&width=550&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(sampleValues)+"&barLabels="+URLEncoder.encode(barLabels)+"&barLabelAngle="+URLEncoder.encode(barLabelAngle)+"&range="+maxCount+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);

			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
%>
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
										<tr align="center" >
											<td width="100%" align="center" valign="top">

<%
		session.setAttribute("DiskCapacityAudit",printData);
		for(int n=0;n<distribution.size();n++)
		{
			//pdf work
			ArrayList aListData = new ArrayList();

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");
			aListColumnNames.add("C4");

			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("OSName");
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTableAttributes.setColumnNames(userColumnNames);

			Hashtable osMap=new Hashtable();
			int n1=capacityLabel.indexOf(startRange);
			int n2 = 0;
			String startLabel = null;
			String endLabel = null;
			StringTokenizer st = null;

			String _capacityName=(String)distribution.get(n);
			ArrayList _systemList=(ArrayList)capacityData.get(_capacityName);

			if(capacityData.get(_capacityName)==null)
				continue;
			if(_systemList==null)
				continue;
			Collections.sort(_systemList);

			if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
				st=new StringTokenizer(_capacityName,"-");
				startLabel=st.nextToken();
				endLabel=st.nextToken();
				n1=capacityLabel.indexOf(startLabel);
				n2=capacityLabel.indexOf(endLabel);
			}

			String title = null;//  variable to display purpose.
			String range = null;
			if("LESSTHAN".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than") + " ";
			}
			else if ("LESSTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Less Than Or Equal To") + " ";
			}
			else if("GREATERTHAN".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than") + " ";
			}
			else if ("GREATERTHAN_OR_EQUAL".equalsIgnoreCase(rangeOption))
			{
				title = mappingInfo.getTextDescription("configmgmt.inventory.system.Greater Than Or Equal To") + " ";
			}
			else if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
				title = "";
				range = " - "+capacityDisplay.get(n2).toString();
			}

			for(int i=0;i<_systemList.size();i++)
			{
				String _systemName = (String)_systemList.get(i);
				String systemOsName=(String)systemOSName.get(_systemName);
				ArrayList tempSystemList=new ArrayList();
				if(osMap!=null && osMap.containsKey(systemOsName))
				{
					tempSystemList=(ArrayList)osMap.get(systemOsName);
					tempSystemList.add(_systemName);
					osMap.put(systemOsName,tempSystemList);
				}
				else
				{
					tempSystemList.add(_systemName);
					osMap.put(systemOsName,tempSystemList);
				}
			}// for loop

			//pdf work
			if(title == null) title = "";
			if(range == null) range = "";

			String tableTitle = title+capacityDisplay.get(n1)+range+" "+mappingInfo.getTextDescription("configmgmt.inventory.system.Hard Disk")+" ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+_systemList.size()+")";
			egTableAttributes.setTitle(tableTitle);

			if("BETWEEN".equalsIgnoreCase(rangeOption))
			{
%>
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
<%
			}
			else
			{
%>
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
<%
			}
%>
													<tr>
														<td colspan="4" id="bgdarkimg" height="20">
															<b>
<%
			if(title != null && !title.equals(""))
			{
%>
																<%=title%>
<%
			}
%>
																<%=capacityDisplay.get(n1)%> <%=range != null ? range : ""%>&nbsp;<egui:intnl text="configmgmt.inventory.system.Hard Disk" /> (<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=_systemList.size()%>)
															</b>
														</td>
													</tr>
					
<%
			Enumeration keySet = osMap.keys();
			int j=0;
			//loop based on OS
			while(keySet.hasMoreElements())
			{
				j++;
				String osName = (String) keySet.nextElement();
				ArrayList systemListByOS = (ArrayList)osMap.get(osName);
				int systemCountByOS = systemListByOS.size();
%>
													<TR>
														<td height="20" width="30%" align="left" class="body_text" id="tdbacklightcolor3" colspan="4">
															<b>&nbsp;<%=osName%>&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" /> : <%=systemCountByOS%>)</b>
														</TD>
													</TR>
<%
				int countColumn = 0;
				int systemSize = _systemList.size();
				for(int s=0;s<systemListByOS.size();s++)
				{
					String _systemName=(String)systemListByOS.get(s);
					if(countColumn == 3) countColumn = 0;
					if(countColumn == 0)
					{
						//pdf work
						aListData.add(osName+" ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+systemCountByOS+")");
%>
													<tr>
<%
					}

					//pdf work
					String sysCapacityPdf = (String)systemCapacity.get(_systemName)+" GB";
					aListData.add(_systemName+" ("+sysCapacityPdf+")");
%>
														<td align="left" height="18" width="20%"  id="cell_border">&nbsp;<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(_systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=_systemName%></a>&nbsp;(<%=(String)systemCapacity.get(_systemName)%>&nbsp;GB) </td>
<%
					if(countColumn == 3)
					{
%>
													</tr>
<%
					}

					countColumn++;
					while(countColumn < 3 && s == systemListByOS.size()-1)
					{
%>
														<td align="left" height="18" width="20%" id="cell_border">&nbsp;</td>
<%
						aListData.add("");
						countColumn++;
					}
				}

				if(j < osMap.size())
				{
%>
													<tr>
														<td height="5" id="blank">&nbsp;</td>
													</tr>
<%
				}
			}
%>
												</table>
												<br>
<%
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);
		}
%>
											</td>
										</tr>
									</table>
								<!-- </div> -->
								</td>
							</tr>
<%
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else
	{
		if (ec_userOption != null && submitOrNot.equals("true") && isDisplay)
		{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
													</tr>
													<tr>
														<td align="center"> <b><egui:intnl text="configmgmt.inventory.system.No result found for the current selection" /></b> </td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
		else if (!submitOrNot.equals("true") || !isDisplay)
		{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
		else
		{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



